/*
 * @file Member ID Definition of Group 3G
 *
 * Moderator: StanleyChu
 * Group ID: 0x001e0000/0x801e0000
 */

#ifndef _CSID_3G_H
#define _CSID_3G_H

#include "csid_gid.h"

#define _CFG_3G(x)		(CSID_GIDC_3G|(x))
#define _STA_3G(x)		(CSID_GIDS_3G|(x))

/* Extra Definitions */

#define CNT_TYPE_3G_ONDEMAND				0x00
#define CNT_TYPE_3G_AUTORECONNECT			0x01
#define CNT_TYPE_3G_MANUAL					0x02

#define CNT_STATUS_3G_DISCONNECT			0x00
#define CNT_STATUS_3G_CONNECTING			0x01
#define CNT_STATUS_3G_CONNECT				0x02
#define CNT_STATUS_3G_DISCONNECTING			0x03
#define CNT_STATUS_3G_WAIT_TRAFFIC			0x05
#define CNT_STATUS_3G_AUTH_FAIL				0x06
#define CNT_STATUS_3G_BACKUP				0x07
#define CNT_STATUS_3G_NOT_INSCHEDULE		0x08

#define HOTPLUG_STATUS_3G_HOLDING     		0x00
#define HOTPLUG_STATUS_3G_ADD     			0x01
#define HOTPLUG_STATUS_3G_REMOVE        	0x02
#define HOTPLUG_STATUS_3G_NONE				0x03

#define ONDEMAND_STATUS_DISCONNECT_NO_IP	0x00
#define ONDEMAND_STATUS_CONNECT_NO_IP		0x01
#define ONDEMAND_STATUS_CONNECT_GET_IP		0x02

#define AUTHTYPE_3G_AUTO					0x00
#define AUTHTYPE_3G_PAP						0x01
#define AUTHTYPE_3G_CHAP					0x02

#define KEEP_ALIVE_3G_DISABLE				0x00
#define KEEP_ALIVE_3G_PING					0x01
#define KEEP_ALIVE_3G_LCP					0x02

#define ERR_CODE_3G_OK						0x00
#define ERR_CODE_3G_PIN_ERR					0x01
#define ERR_CODE_3G_PW_ERR					0x02
#define ERR_CODE_3G_NO_MODEM				0x03
#define ERR_CODE_3G_SETTING_ERR				0x05
#define ERR_CODE_3G_MODEM_NOT_READY			0x06
#define ERR_CODE_3G_NOT_INSCHEDULE			0x07

#define AUTOBAK_STATUS_3G_DISCONNECT		0x00
#define AUTOBAK_STATUS_3G_CONNECTING		0x01
#define AUTOBAK_STATUS_3G_CONNECT			0x02
#define AUTOBAK_STATUS_3G_DISCONNECTING		0x03

#define REG_STATUS_IDLE						0x00
#define REG_STATUS_REGISTERED				0x01
#define REG_STATUS_SEARCH					0x02
#define REG_STATUS_ROAMING					0x05

/* Configuration Items */
#define CSID_C_3G_USER          	_CFG_3G(0x0001)	//T=str, user name
#define CSID_C_3G_PASSWORD      	_CFG_3G(0x0002)	//T=str, user password
#define CSID_C_3G_APN	        	_CFG_3G(0x0003)	//T=str, APN
#define CSID_C_3G_PIN           	_CFG_3G(0x0004)	//T=str, PIN
#define CSID_C_3G_NUMBER        	_CFG_3G(0x0005)	//T=str, Dialed Number
#define CSID_C_3G_IF_IP         	_CFG_3G(0x0006)	//T=ipv4, static interface ip
#define CSID_C_3G_SERVICENAME   	_CFG_3G(0x0007)	//T=str, service name
#define CSID_C_3G_IF_PRIDNS     	_CFG_3G(0x0008)	//T=ipv4, dynamic interface primary DNS
#define CSID_C_3G_IF_SECDNS     	_CFG_3G(0x0009)	//T=ipv4, dynamic interface secondary DNS
#define CSID_C_3G_CNT_TYPE      	_CFG_3G(0x000a)	//T=u16, D=1, connect type, Dial-on-Demand, autoconnect...
#define CSID_C_3G_MTU           	_CFG_3G(0x000b)	//T=u16, D=0, max transmission unit
#define CSID_C_3G_IDLETIME      	_CFG_3G(0x000c)	//T=u16, D=600, max idle time
#define CSID_C_3G_AUTOBAK_ENABLE  	_CFG_3G(0x000d) //T=u16, 3g auto backup enable, 0:disable, 1:enable
#define CSID_C_3G_PING_HOST_IP		_CFG_3G(0x000e)	//T=ipv4, ping host IP for 3g auto backup
#define CSID_C_3G_AUTHTYPE			_CFG_3G(0x000f)	//T=u16, auth type, Auto, PAP, CHAP...
#define CSID_C_3G_KEEP_ALIVE		_CFG_3G(0x0010) //T=u16, 3g keep alive, disable, ping, lcp
#define CSID_C_3G_KA_PING_INTERVAL	_CFG_3G(0x0011)	//T=u16, D=60, ping interval for 3g keep alive
#define CSID_C_3G_KA_PING_IP		_CFG_3G(0x0012)	//T=ipv4, ping IP for 3g keep alive
#define CSID_C_3G_KA_LCP_INTERVAL	_CFG_3G(0x0013)	//T=u16, D=10, lcp interval for 3g keep alive 
#define CSID_C_3G_KA_LCP_TIMES		_CFG_3G(0x0014)	//T=u16, D=3, lcp times for 3g keep alive
#define CSID_C_3G_PREFER_MODE		_CFG_3G(0x0015)	//T=u16, D=0, 0:auto mode, 1:2g only, 2:3g only, 3:2g first, 4:3g first
#define CSID_C_3G_AUTO_APN          _CFG_3G(0x0016) //T=u16, D=1, 0:auto mode 1:Manual
#define CSID_C_3G_NAT_DISABLE		_CFG_3G(0x0017)	//T=u32, 3g wantype NAT disable
#define CSID_C_3G_USSD_RETURN		_CFG_3G(0x0018)	//T=str, ussd return str
#define CSID_C_3G_USSD				_CFG_3G(0x0019)	//T=str, ussd str
#define CSID_C_3G_PREFER_ENABLE		_CFG_3G(0x001a)	//T=u16, D=0, 3G prefer mode, 0:disable, 1:enable
#define CSID_C_3G_BDG_ETH_PORT		_CFG_3G(0x0020) //T=u16, 3g wan type bridge 2 ethernet port enable, 0:disable, 1:enable
#define CSID_C_3G_PROFILE			_CFG_3G(0x0030) //T=u16, for customer
#define CSID_C_3G_USE_RULE_NO		_CFG_3G(0x0040)	//T=u16, D=0,use_rule number
#define CSID_C_3G_SUPPORT_CARD_LIST	_CFG_3G(0x0050)	//T=str, 3g modem support list

#define CSID_C_3G_OP_LOCK_ENABLE	_CFG_3G(0x1000) //T=u16, for Operator Lock enable, 0:disable, 1:enable
#define CSID_C_3G_MCC0				_CFG_3G(0x1001) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC1				_CFG_3G(0x1002) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC2				_CFG_3G(0x1003) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC3				_CFG_3G(0x1004) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC4				_CFG_3G(0x1005) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC5				_CFG_3G(0x1006) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC6				_CFG_3G(0x1007) //T=str, for Mobile Contry Code
#define CSID_C_3G_MCC7				_CFG_3G(0x1008) //T=str, for Mobile Contry Code
#define CSID_C_3G_MNC0				_CFG_3G(0x1101) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC1				_CFG_3G(0x1102) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC2				_CFG_3G(0x1103) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC3				_CFG_3G(0x1104) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC4				_CFG_3G(0x1105) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC5				_CFG_3G(0x1106) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC6				_CFG_3G(0x1107) //T=str, for Mobile Network Code
#define CSID_C_3G_MNC7				_CFG_3G(0x1108) //T=str, for Mobile Network Code

/* Status Items */
#define CSID_S_3G_CNT_TIME        	_STA_3G(0x0100)	//T=u32, connect time
#define CSID_S_3G_IF_IP           	_STA_3G(0x0200)	//T=ipv4, dynamic interface ip
#define CSID_S_3G_IF_NM           	_STA_3G(0x0300)	//T=ipv4, dynamic interface netmask
#define CSID_S_3G_IF_GW           	_STA_3G(0x0400)	//T=ipv4, dynamic interface gateway
#define CSID_S_3G_IF_PRIDNS       	_STA_3G(0x0500)	//T=ipv4, dynamic interface primary DNS
#define CSID_S_3G_IF_SECDNS       	_STA_3G(0x0600)	//T=ipv4, dynamic interface secondary DNS
#define CSID_S_3G_CNT_STATUS      	_STA_3G(0x0700)	//T=u16, connect status
#define CSID_S_3G_PKTIN_NUM       	_STA_3G(0x0800)	//T=u32, number of packet input
#define CSID_S_3G_PKTOUT_NUM      	_STA_3G(0x0900)	//T=u32, number of packet output
#define CSID_S_3G_HOTPLUG_STATUS  	_STA_3G(0x0a00) //T=u16, 3g hotplug status for script so it don't care for UI
#define CSID_S_3G_ONDEMAND_STATUS 	_STA_3G(0x0b00) //T=u16, demend wan type status for script so it don't care for UI
#define CSID_S_3G_ALTERED         	_STA_3G(0x0c00)	//T=u8, ui altered
#define CSID_S_3G_CARD_INFO			_STA_3G(0x0d00)	//T=str, 3G card info
#define CSID_S_3G_SIGNAL_STRENGTH	_STA_3G(0x0e00)	//T=u16, signal strength
#define CSID_S_3G_SIGNAL_QUALITY	_STA_3G(0x0f00)	//T=str, signal quality
#define CSID_S_3G_NETWORK_NAME		_STA_3G(0x1000)	//T=str, network name
#define CSID_S_3G_ERR_CODE			_STA_3G(0x1100) //T=u16, connect fail error code
#define CSID_S_3G_AUTOBAK_STATUS	_STA_3G(0x1200)	//T=u16, 3g failover status
#define CSID_S_3G_SERVICE_TYPE		_STA_3G(0x1300)	//T=u16, 3g service type, 0:2G, 2:3G
#define CSID_S_3G_CARD_VENDORID		_STA_3G(0x1400)	//T=u16, 3G card vendor id
#define CSID_S_3G_CARD_PRODUCTID	_STA_3G(0x1500)	//T=u16, 3G card product id
#define CSID_S_3G_OP_LOCK_STATUS	_STA_3G(0x1600) //T=u16, for Operator Lock status, 0:unlock, 1:lock
#define CSID_S_3G_HOTPLUG_VERSION	_STA_3G(0x1700) //T=str, hotplug version
#define CSID_S_3G_GET_STATUS		_STA_3G(0x1800) //T=u8, get_3g_satatus, 1:running
#define CSID_S_3G_REG_STATUS		_STA_3G(0x1900) //T=u8, register status for 3G network
#define CSID_S_3G_USSD_STATUS		_STA_3G(0x2300) //T=u8, D=0,get_ussd_satatus, 1:readable 0:unreadable
#define CSID_S_3G_USB_PORT          _STA_3G(0x2b00) //T=u32, 1:PCIE 2:USB

/* for 3G Failover ping check */
#define CSID_S_3G_WAN_IP			_STA_3G(0x2000) //T=ipv4, wan ip
#define CSID_S_3G_WAN_GW			_STA_3G(0x2100) //T=ipv4, wan gateway
#define CSID_S_3G_WAN_IF_NAME		_STA_3G(0x2200) //T=str, the interface name of wan, ppp0, eth1, ixp1

//---SMS function added by York 090916
#define CSID_S_3G_SMS_RECEIVED      _STA_3G(0x2300) //T=u8, D=0 ,numbers of reveived messages
#define CSID_S_3G_SMS_NEW           _STA_3G(0x2400) //T=u8, D=0 ,numbers of new messages
#define CSID_S_3G_SMS_CAPACITY      _STA_3G(0x2500) //T=u8, D=0 ,numbers of SIM card messages capacity
#define CSID_S_3G_SMS_TOPHONE       _STA_3G(0x2600) //T=str, phone number of sending
#define CSID_S_3G_SMS_TEXT          _STA_3G(0x2700) //T=str, text content of sending
#define CSID_S_3G_SMS_ERR_MSG       _STA_3G(0x2800) //T=u8,	send error messages 
#define CSID_S_3G_SMS_STATUS        _STA_3G(0x2900) //T=u8, D=0 ,sms status , 0:querying, 1:query finished
#define CSID_S_3G_SMS_QUERY_FLAG    _STA_3G(0x2a00) //T=u8, sms query flay, let commander know 3G connect or not
#endif //ifndef _CSID_3G_H
