/**
 * @file csmprot.h
 *
 * Comman Definitions for CSMan Server and Agent.
 */

#define	DEFAULT_ROOT	"/tmp/csman"
#define AUTO_SAVE_SEC	1
#define AUTO_SAVE_USEC	0

#include "csman.h"	//for CSID_T and MAX_ITEM_SIZE

// MESG is the message that passes between CSMan Agent and Server
// via Unix domain socket. The extra 64-byte is for parameters other 
// than configuration items
#define MAX_MESG_SIZE	(MAX_ITEM_SIZE+64)

// maximum pathname length of unix domain socket is 108.
// we have to reserve at least two byte for "/s"
#define MAX_ROOT_LEN	80

/* func_id is comman field of messages */

typedef struct {
	int	func_id;
	//"id" is not used now ("id.pid" is for future check_dirty feature)
	union {
		pid_t	pid;
		int	fd;
	} id;
} cmhdr_t;

/* int open_csman(const char *config, int flags); */

#define FUNC_ID_OPEN		1

typedef struct {
	cmhdr_t	header;
	int	flags;
	char	config[MAX_ROOT_LEN];
} open_csman_req_t;

typedef struct {
	int	func_id;
	int	rc;
} open_csman_res_t;

/* ssize_t read_csman(int fd, CSID_T csid, void *buf, size_t count, int flags); */

#define FUNC_ID_READ		2

typedef struct {
	cmhdr_t	header;
	CSID_T	csid;
	int	flags;
	size_t	count;
} read_csman_req_t;

typedef struct {
	int	func_id;
	ssize_t	rc;
	char	buf[MAX_ITEM_SIZE];
} read_csman_res_t;

/* ssize_t write_csman(int fd, CSID_T csid, const void *buf, size_t count, int flags); */

#define FUNC_ID_WRITE		3

typedef struct {
	cmhdr_t	header;
	CSID_T	csid;
	int	flags;
	size_t	count;
	char	buf[MAX_ITEM_SIZE];
} write_csman_req_t;

typedef struct {
	int	func_id;
	ssize_t	rc;
} write_csman_res_t;

/* int chkdirty_csman(int fd, CSID_T *pcsid, int flags); */

#define FUNC_ID_CHKDIRTY	4

/* ssize_t dump_csman(int fd, CSID_T *pcsid, void *buf, size_t count); */

#define FUNC_ID_DUMP		5

typedef struct {
	cmhdr_t	header;
	CSID_T	csid;
	size_t	count;
} dump_csman_req_t;

typedef struct {
	int	func_id;
	ssize_t	rc;
	CSID_T	csid;
	char	buf[MAX_ITEM_SIZE];
} dump_csman_res_t;

/* int close_csman(int fd); */

#define FUNC_ID_CLOSE		6

typedef struct {
	cmhdr_t	header;
} close_csman_req_t;

typedef struct {
	int	func_id;
	int	rc;
} close_csman_res_t;

