#if defined(MODVERSIONS)
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#include <linux/version.h>
#include <linux/types.h>
#include <linux/skbuff.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ipt_domain.h>
#include <net/udp.h>


static int match(const struct sk_buff *skb, const struct net_device *in,
			const struct net_device *out,
			const void *matchinfo,
			int offset,
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
			const void *hdr,
			u_int16_t datalen,
#endif
			int *hotdrop)
{
	struct iphdr *iph = skb->nh.iph;
	struct udphdr *udph;
	const struct ipt_domain_info *info = matchinfo;

	if (offset || iph->protocol != IPPROTO_UDP)
		return 0;

	udph = (void *)iph + iph->ihl * 4;

	return ( (ntohs(udph->source) == 53 || ntohs(udph->dest) == 53)
				&& (udph->len >= (8 + 12 + info->len + 5))
				&& !strcmp(info->name,
				(char *)((void *)udph + ntohs(udph->len) - info->len - 5))
		);

}


static int checkentry(const char *tablename, const struct ipt_ip *ip,
			void *matchinfo,
			unsigned int matchsize,
			unsigned int hook_mask)
{
	if (matchsize != IPT_ALIGN(sizeof(struct ipt_domain_info)))
		return 0;

	return 1;
}


static struct ipt_match domain_match = { 
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	{ NULL, NULL },
	"domain",
	&match,
	&checkentry,
	NULL,
	THIS_MODULE
#endif
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
	.name		= "domain",
	.match		= &match,
	.checkentry	= &checkentry,
	.me		= THIS_MODULE,
#endif
};


static int __init init(void)
{
	return ipt_register_match(&domain_match);
}


static void __exit fini(void)
{
	ipt_unregister_match(&domain_match);
}


module_init(init);
module_exit(fini);


MODULE_AUTHOR("Platinum, bbs.chinaunix.net");
MODULE_DESCRIPTION("A module to match DOMAIN. VERSION: 0.0.2");
MODULE_LICENSE("GPL");
