/* This is a module which is used for handing the special application. */
#if defined(MODVERSIONS)
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#include <linux/version.h>
#include <linux/types.h>
#include <linux/skbuff.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/proc_fs.h> //add by jack
#include <net/udp.h>
#include <net/tcp.h>
#include <linux/netfilter_ipv4/ipt_RBYDOM.h>

static struct proc_dir_entry *rbydom_dir,*proc_entry; 
static Info_Que *pInfque;
static unsigned long pid; 

int rbydom_addque(Info_Que **qUe, char *dOmain, unsigned long rOute) {
	
	Info_Que *tempQue;
	
	tempQue=kmalloc(sizeof(Info_Que), GFP_KERNEL);
	if(tempQue==NULL) {
     		printk(KERN_INFO "RBYDOM: kmalloc fail!\n");
		return -1;
	}
	
	strcpy(tempQue->domain, dOmain);
	tempQue->route = rOute;
	
	if(*qUe == NULL) {
		*qUe = tempQue;
		(*qUe)->next = *qUe;
	}
	else {
		tempQue->next = (*qUe)->next;
		(*qUe)->next = tempQue;
		*qUe = tempQue;
	}
	return 0;
}

int rbydom_getque(Info_Que **qUe, char *dOmain, unsigned long *rOute) {
	
	Info_Que *tempQue;
	
	if(*qUe==NULL) {		
		memset(dOmain,0,strlen(dOmain));
		*rOute = 0;
     		//printk(KERN_INFO "RBYROM: info queue is empty!\n");
		return 1;
	}
	else {
		tempQue = (*qUe)->next;
		
		if(tempQue==*qUe) *qUe = NULL;
		else (*qUe)->next = tempQue->next;
	
		strcpy(dOmain, tempQue->domain);
		*rOute = tempQue->route;
		
		kfree(tempQue);	
	}
	return 0;
}

void domain_convert(char* domain)
{
	// 3 cad 4 csie 4 ncku 3 edu 3 tw0 //NƦrഫI
	int i0= 0, offset = 0, data_length = 0;
	char tmp_info[100];
	char *pTmp;
	memset(tmp_info, 0, sizeof(tmp_info));
     	//printk(KERN_INFO "RBYROM: domain1=%s\n",domain);
	while (domain[offset]) {
		i0 = domain[offset];
		domain[offset] = '.';
		offset += i0 + 1; 
		data_length += i0 + 1;
	}
     	//printk(KERN_INFO "RBYROM: domain2=%s\n",domain);
	strcpy(tmp_info, domain);
	pTmp = tmp_info;
	pTmp++;
	strcpy(domain, pTmp);
     	//printk(KERN_INFO "RBYROM: domain3=%s\n",domain);
}

static unsigned int
target(struct sk_buff **pskb,
      
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	unsigned int hooknum,
       const struct net_device *in,
       const struct net_device *out,
#endif       
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
	const struct net_device *in,
       const struct net_device *out,
       unsigned int hooknum,
#endif       
	const void *targinfo,
       void *userinfo)
{
	struct iphdr *iph = (*pskb)->nh.iph;
	struct udphdr *udph;
      	//printk(KERN_INFO "rbydom: port 53 packets in coming\n");
			
	//UDP header
	udph = (void *)iph + iph->ihl * 4;
	//UDP header`@8bytes,ᬰDNSData,U2bytesNXOڭ̤ݭn,ҥH쪺OX.
	char *dns_QR = ((char *)udph + 8 + 2);  //8: udp header, 2: flag: QR 
	if ((*dns_QR & 0x80) == 0) goto CONTINUE; //0: query, 1: reply query
	char *answer_count = ((char *)udph + 8 + 7); //7: ^ƥ,b߰ݰT̥0.
	if (*answer_count == 0) goto CONTINUE;	//answer count must be larger than 0
	//domain			
	char *domain_info = ((char *)udph + 8 + 12); //8: udp header, 12: domain location
	// 3 cad 4 csie 4 ncku 3 edu 3 tw0 //NƦrഫI
	int i0= 0, offset = 0, data_length = 0;
	char convert_info[100];
	memset(convert_info, 0, sizeof(convert_info));
	while (domain_info[offset]) {
		i0 = domain_info[offset];
		//domain_info[offset] = '.';
		offset += i0 + 1; 
		data_length += i0 + 1;
	}
	memcpy(convert_info, domain_info, data_length);
	domain_convert(convert_info);
	data_length--; //1,]̫@ӭȤOdata,q`O0.
	if (data_length <= 0) goto CONTINUE;	//domain string's length must be larger than 0
	//Ĥ@Ӧr,oӦrOdata.
	//domain_info++;	//skip the first dot
	char *question_type = ((char *)udph + 8 + 12 + 1 + data_length + 1 + 1);
	if (*question_type != 1) goto CONTINUE;	//question type must be 0x01

	// 4. get ip value
	int i = *answer_count;
	char *cp = (char *)question_type + 3;
	int found = 0;
	unsigned long data_ip;
	while (i > 0)
	{
		cp = cp + 3;	// answer type
		if (*cp != 1) { //inquired
			i--; 
			cp = cp + 8; 
			cp = cp + *cp + 1;
		} else {
			found = 1; 
			memcpy(&data_ip,cp + 9,4); 
		}
	}
	if (found == 0) goto CONTINUE;	//IP 
		
	//addque(&pInfque, domain_info, data_ip);
	rbydom_addque(&pInfque, convert_info, data_ip);
	kill_proc(pid, SIGUSR1 , 0);
CONTINUE:	
	return IPT_CONTINUE;
}

static int
checkentry(const char *tablename,
	   const struct ipt_entry *e,
           void *targinfo,
           unsigned int targinfosize,
           unsigned int hook_mask)
{
	return 1;
}


ssize_t rbydom_pid_read( char *page, char **start, off_t off,
                   int count, int *eof, void *data )
{
  	ssize_t len=0;
  	if (off > 0) 
 	{
    		*eof = 1;
    		return 0;
 	}
 	len = sprintf(page, "%ld", pid);
 	
	return len;
}


ssize_t rbydom_pid_write( struct file *filp, const char *buff,
                        unsigned long len, void *data )
{
 	char read_buf[len];
	memset(read_buf, 0, sizeof(read_buf));
 	
	if (copy_from_user( read_buf, buff, len )) 
 	{
    		return -EFAULT;
 	}
  	
	pid = simple_strtoul(read_buf,NULL,0);
  	return len;
}

ssize_t rbydom_info_read(char *page, char **start, off_t off,
                int count, int *eof, void *data)
{
  	ssize_t len=0;
	char dOmain[100]; 
	unsigned long rOute;
  	
	if (off > 0) 
 	{
    		*eof = 1;
    		return 0;
 	}
 	
	rbydom_getque(&pInfque, dOmain, &rOute);
	len = sprintf(page, "%s %lx", dOmain, rOute);
	
	return len;
}


static struct ipt_target ipt_rbydom_reg = { 
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	{ NULL, NULL }, "RBYDOM", target, checkentry, NULL, THIS_MODULE 
#endif
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
	.name		= "RBYDOM",
	.target 	= &target,
	.checkentry	= &checkentry,
	.me		= THIS_MODULE
#endif
};

static int __init init(void)
{
 	
	rbydom_dir = proc_mkdir("rbydom", NULL);
        if(rbydom_dir == NULL) {
		return -ENOMEM;
        }

	proc_entry = create_proc_entry( "pid_info", 0644, rbydom_dir );

 	if (proc_entry == NULL) 
 	{
      		printk(KERN_INFO "rbydom: Couldn't create proc entry\n");
		return -ENOMEM;
 	} 
 	else 
 	{
      		proc_entry->read_proc = rbydom_pid_read;
      		proc_entry->write_proc = rbydom_pid_write;
      		proc_entry->owner = THIS_MODULE;
 	}
	
	create_proc_read_entry("pass_info",0, rbydom_dir, rbydom_info_read, NULL);
	
	if (ipt_register_target(&ipt_rbydom_reg))
		return -EINVAL;
      	//printk(KERN_INFO "RBYDOM: Module loaded.\n");

	return 0;
}

static void __exit fini(void)
{
	remove_proc_entry("pid_info", rbydom_dir);
	remove_proc_entry("pass_info", rbydom_dir);
	remove_proc_entry("rbydom", NULL);

	ipt_unregister_target(&ipt_rbydom_reg);
  	//printk(KERN_INFO "RBYDOM: Module unloaded.\n");
}

module_init(init);
module_exit(fini);

MODULE_AUTHOR("Platinum, bbs.chinaunix.net");
MODULE_DESCRIPTION("A module to match DOMAIN. VERSION: 0.0.2");
MODULE_LICENSE("GPL");
