/* MSNP extension for TCP NAT alteration. */
#include <linux/module.h>
#include <linux/netfilter_ipv4.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <net/tcp.h>
#include <linux/netfilter_ipv4/ip_nat.h>
#include <linux/netfilter_ipv4/ip_nat_helper.h>
#include <linux/netfilter_ipv4/ip_nat_rule.h>
#include <linux/netfilter_ipv4/ip_conntrack_sc.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>

#if 0
#define DEBUGP printk
#else
#define DEBUGP(format, args...)
#endif

static struct ip_nat_helper sc;
static char sc_names[7];
#define SC_PORT		6112
static int ports = SC_PORT;

#ifdef MODULE_PARM
//MODULE_PARM(ports, "1-" __MODULE_STRING(MAX_PORTS) "i");
#endif

DECLARE_LOCK_EXTERN(ip_sc_lock);

static unsigned int 
sc_nat_expected(struct sk_buff **pskb,
		  unsigned int hooknum,
		  struct ip_conntrack *ct, 
		  struct ip_nat_info *info) 
{
	struct ip_nat_multi_range mr;
	struct ip_conntrack_expect *exp;
	exp = (struct ip_conntrack_expect *) ct->master;
	u_int32_t newip, srcip;
	u_int16_t newpt;

#if 0
	if ( hooknum == NF_IP_POST_ROUTING ) {
		DEBUGP ("%s %d ---- Enter %s hooknum=%d discard!!\n", __FILE__, __LINE__, __FUNCTION__, hooknum);
		DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_ORIGINAL: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.protonum);

		DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_REPLY: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.protonum);

		return NF_ACCEPT;
	}
#endif
	DEBUGP ("%s %d ---- Enter nat %s hooknum=%d, HOOK2MANIP=%d\n",__FILE__,__LINE__,__FUNCTION__,hooknum,HOOK2MANIP(hooknum));

	DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_ORIGINAL: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.protonum);

	DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_REPLY: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.protonum);

	DEBUGP ("%s %d ---- exp->ct_tuple : %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(exp->ct_tuple.src.ip),
					exp->ct_tuple.src.u.all,
					NIPQUAD(exp->ct_tuple.dst.ip),
					exp->ct_tuple.dst.u.all,
					exp->ct_tuple.dst.protonum);


	srcip = ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip;
	if (HOOK2MANIP(hooknum) == IP_NAT_MANIP_DST)
	{
		DEBUGP ("%s %d ---- HOOK2MANIP=%d\n", __FILE__, __LINE__, HOOK2MANIP(hooknum));

		LOCK_BH(&ip_sc_lock);
		/* modify the conntrack to match WAN client with LAN client */
		newip = exp->ct_tuple.src.ip; // LAN ip
		newpt = exp->ct_tuple.src.u.udp.port;

		mr.rangesize = 1;
		mr.range[0].flags = IP_NAT_MANIP_DST|IP_NAT_RANGE_MAP_IPS|IP_NAT_RANGE_PROTO_SPECIFIED;
		mr.range[0].min_ip = mr.range[0].max_ip = newip;
		mr.range[0].min.all = mr.range[0].max.all = newpt;

		UNLOCK_BH(&ip_sc_lock);

		return ip_nat_setup_info(ct, &mr, hooknum);
	} 
	else if (HOOK2MANIP(hooknum) == IP_NAT_MANIP_SRC) {
		DEBUGP ("%s %d ---- HOOK2MANIP=%d\n", __FILE__, __LINE__, HOOK2MANIP(hooknum));

		if ( !((exp->ct_tuple.src.ip ^ srcip) & 0xFFFFFF00) ) {
			DEBUGP ("%s %d ---- Changed\n", __FILE__, __LINE__);
			LOCK_BH(&ip_sc_lock);

			newip = ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.ip;
			newpt = ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.udp.port;

			mr.rangesize = 1;
			mr.range[0].flags = IP_NAT_MANIP_SRC|IP_NAT_RANGE_MAP_IPS|IP_NAT_RANGE_PROTO_SPECIFIED;
			mr.range[0].min_ip = mr.range[0].max_ip = newip;
			mr.range[0].min.all = mr.range[0].max.all = newpt;
			UNLOCK_BH(&ip_sc_lock);

			return ip_nat_setup_info(ct, &mr, hooknum);
		}
	}

	return NF_ACCEPT;
}

static unsigned int help(struct ip_conntrack *ct,
         		 struct ip_conntrack_expect *exp,
			 struct ip_nat_info *info,
			 enum ip_conntrack_info ctinfo,
			 unsigned int hooknum,
			 struct sk_buff **pskb)
{
#if 0
	DEBUGP ("\n%s %d ---- Enter nat help %s hooknum=%d, HOOK2MANIP=%d\n",__FILE__,__LINE__,__FUNCTION__,hooknum,HOOK2MANIP(hooknum));

	DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_ORIGINAL: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.protonum);

	DEBUGP ("%s %d ---- conntrack_sc IP_CT_DIR_REPLY: %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.src.u.all,
					NIPQUAD(ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.ip),
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.u.all,
					ct->tuplehash[IP_CT_DIR_REPLY].tuple.dst.protonum);

	DEBUGP ("%s %d ---- exp->ct_tuple : %u.%u.%u.%u:%d -> %u.%u.%u.%u:%d (%d)\n", __FILE__, __LINE__,
	       			NIPQUAD(exp->ct_tuple.src.ip),
					exp->ct_tuple.src.u.all,
					NIPQUAD(exp->ct_tuple.dst.ip),
					exp->ct_tuple.dst.u.all,
					exp->ct_tuple.dst.protonum);
#endif

	return NF_ACCEPT;
}


/* Not __exit: called from init() */
static void fini(void) {
	DEBUGP("ip_nat_sc: unregistering port %d\n", ports);
	ip_nat_helper_unregister(&sc);
}

static int __init init(void) {
	int ret;
	char *tmpname;

	memset(&sc, 0, sizeof(struct ip_nat_helper));

	ports = SC_PORT;

	sc.tuple.dst.protonum = IPPROTO_UDP;
	sc.tuple.src.u.udp.port = htons(ports);
	sc.mask.dst.protonum = 0xFFFF;
	sc.mask.src.u.udp.port = 0xFFFF;
	sc.help = help;
	sc.expect = sc_nat_expected;

	tmpname = &sc_names[0];
	sprintf(tmpname, "sc");
	sc.name = tmpname;

	DEBUGP("ip_nat_sc: Trying to register for port %d\n", ports);
	ret = ip_nat_helper_register(&sc);

	if (ret) {
		printk("ip_nat_sc: error registering helper for port %d\n", ports);
		fini();
		return ret;
	}

	return ret;
}

module_init(init);
module_exit(fini);
