#include <linux/module.h>	
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <asm/uaccess.h>
#include <linux/brlock.h>
#include <linux/net.h>
#include <linux/socket.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/raw.h>
#include <net/checksum.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>
#include <net/udp.h>
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
#include <net/tcp.h>//brad
#endif

#define URL_FILTER
#define DOS_FILTER
#define FILTER_UPNP_BR
#ifdef CONFIG_RTL8186_TR
#undef FILTER_UPNP_BR
#endif
#ifdef CONFIG_RTL865X_AC
#undef FILTER_UPNP_BR
#endif
///////////////////////////////////////////////////////////////////////////

#ifdef DOS_FILTER
#define SUCCESS 0
#define FAILED 1
#define TCP_FIN 1
#define TCP_SYN 2
#define HashSize 256
#define TableSize 1024
#define HighSensitivity 10
#define LowSensitivity 200
#define SmartHighThres 4000
#define SmartLowThres  500

#define control_message 0x8000
#define connect_control 0xc
#define stop_control 0x4

#define NONE_DOS_PKT_THRES 3000 //david
#ifdef CONFIG_RTL8186_KB
	#undef URL_FILTER
#endif

struct s_dos_pkt {
	char use;
	int syn_cnt;
	int fin_cnt;
	int udp_cnt;
	int icmp_cnt;
	int  scan_cnt;
	u_int32_t ip;
	u_int16_t id;
	u_int16_t offset;
	u_int16_t dest;
};
enum {
	EnableDosSet=0x1,
	WholeSynFloodSet=0x2,
	WholeFinFloodSet=0x4,
	WholeUdpFloodSet=0x8,
	WholeIcmpFloodSet=0x10,
	PerSynFloodSet=0x20,
	PerFinFloodSet=0x40,
	PerUdpFloodSet=0x80,
	PerIcmpFloodSet=0x100,
	TcpUdpPortScanSet=0x200,
	IcmpSmurfSet=0x400,
	IpLandSet=0x800,
	IpSpoofSet=0x1000,
	TearDropSet=0x2000,
	PingOfDeathSet=0x4000,
	TcpScanSet=0x8000,
	TcpSynWithDataSet=0x10000,
	UdpBombSet=0x20000,
	UdpEchoChargenSet=0x40000,
	IpBlockSet=0x400000,
	SensitivitySet=0x800000
};

enum {
	PerSynFlood=1,
	PerFinFlood,
	PerUdpFlood,
	PerIcmpFlood,
	TcpUdpPortScan,
	IcmpSmurf,
	IpLand,
	IpSpoof,
	TearDrop,
	PingOfDeath,
	TcpScan,
	TcpSynWithData,
	UdpBomb,
	UdpEchoChargen
};
#endif // DOS_FILTER

#if (defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_AC)) && defined(URL_FILTER)
#define URL_FILTER_BLOCK_PAGE_MESSAGE \
	"HTTP/1.1 401 The web site is blocked by administrator\r\nServer: Embedded HTTP Server 2.00\r\nConnection: close\r\n\r\n"\
	"<HTML><HEAD><TITLE>401 The web site is blocked by administrator</TITLE></HEAD>"\
	"\n<BODY BGCOLOR=\"#ffffff\"><H4>401 The web site is blocked by administrator</H4></BODY></HTML>\n"

struct filter_trace
{
	__u16 ip_id;
	__u32 wanside_ip;
	__u32 lanside_ip;
	__u16 tcp_window;                  
	__u8 ip_ttl;         
	__u8 isSent401;      
	__u8 isSentFinAck;
};
static struct filter_trace url_cache={0,0,0,0,0,0};
#endif // CONFIG_RTL8186_TR || CONFIG_RTL8186_EC
#ifdef FILTER_UPNP_BR
struct proc_dir_entry *res9=NULL;
int upnp_br_enabled=0;
static unsigned int upnp_br_wanip=0, upnp_br_port=0;
static struct net_device *upnp_lan_dev=NULL;
#endif

#if defined(CONFIG_RTL865X_SC) && defined(URL_FILTER)
#define URL_FILTER_BLOCK_PAGE_MESSAGE \
	"HTTP/1.1 401 The web site is blocked by administrator\r\nServer: Embedded HTTP Server 2.00\r\nConnection: close\r\n\r\n"\
	"<HTML><HEAD><TITLE>401 The web site is blocked by administrator</TITLE></HEAD>"\
	"\n<BODY BGCOLOR=\"#ffffff\"><H4>401 The web site is blocked by administrator</H4></BODY></HTML>\n"

struct filter_trace
{
	__u16 ip_id;
	__u32 wanside_ip;
	__u32 lanside_ip;
	__u16 tcp_window;                  
	__u8 ip_ttl;         
	__u8 isSent401;      
	__u8 isSentFinAck;
};
static struct filter_trace url_cache={0,0,0,0,0,0};
#endif // CONFIG_RTL865X_SC

#ifdef DOS_FILTER
static u_int32_t LogFlag,ConnectedIp[HashSize];
static struct s_dos_pkt dos_pkt[TableSize], *cur_p_pkt;
static struct timer_list dos_timer;

static char _tcpDosScanBitmap[64],op_mode;

static int whole_syn_threshold;
static int whole_fin_threshold;
static int whole_udp_threshold;
static int whole_icmp_threshold;
static int per_syn_threshold;
static int per_fin_threshold;
static int per_udp_threshold;
static int per_icmp_threshold;
static int block=0,block_time=0,block_count=0;

static u_int32_t item=0;
static u_int32_t lan_addr,lan_mask;
static u_int32_t attack_saddr[14],attack_daddr[14];
//static u_int32_t pre_saddr,pre_daddr;
//static u_int16_t pre_tot_len;
static char dos_flag[80];
static u_int32_t none_dos_drop_pkt_cnt=0; // david
static u_int32_t item_backup=0; // david
static struct net_device *wan_dev,*wan_ppp_dev;
#endif // DOS_FILTER

#ifdef URL_FILTER
static char url_count=0;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
static char url_mode=0;
#endif
static char url_flag[1024];
static char url_tbl[20][40];
unsigned long url_addr;
unsigned char url_range;
#endif
//static char flag='1';

extern int scrlog_printk(const char * fmt, ...);

///////////////////////////////////////////////////////////////////////////
#ifdef FILTER_UPNP_BR
int filter_upnp_and_fw(struct sk_buff *skb)
{
	struct iphdr *iph;
	struct tcphdr *tcph=NULL;
	struct udphdr *udph=NULL;
	int found=0, data_len;
	
	skb->h.raw = skb->nh.raw = skb->data;	
	iph = skb->nh.iph;
	if (iph->daddr == upnp_br_wanip) {		
		if (upnp_br_enabled == 1 && iph->protocol == IPPROTO_TCP && 
				skb->len >= (sizeof(*iph)+sizeof(*tcph))) {
			tcph = (struct tcphdr *)(((unsigned char *)iph) + iph->ihl*4);
			if (tcph->dest == upnp_br_port) 
				found = 1;			
		}
		else if (upnp_br_enabled == 2 && iph->protocol == IPPROTO_UDP && 
				skb->len >= (sizeof(*iph)+sizeof(*udph))) {
			udph = (struct udphdr *)(((unsigned char *)iph) + iph->ihl*4);
			if (udph->dest == upnp_br_port)
				found = 2;
		}		
	}
	if (found) {	
    	iph->daddr = 0xffffffff;
       	iph->check = 0;
    	iph->check = ip_fast_csum((unsigned char *)iph, iph->ihl);		

		if (found == 1) {
			data_len = skb->len - sizeof(*iph);
     		tcph->check = 0;
        	tcph->check = csum_tcpudp_magic(iph->saddr, iph->daddr,
     										data_len, IPPROTO_TCP,
											csum_partial((char *)tcph,
												data_len, 0));	
		}
		else {
			data_len = skb->len - sizeof(*iph);
     		udph->check = 0;
        	udph->check = csum_tcpudp_magic(iph->saddr, iph->daddr,
     										data_len, IPPROTO_UDP,
											csum_partial((char *)udph,
												data_len, 0));
		}
			
		if (upnp_lan_dev == NULL)
			upnp_lan_dev =__dev_get_by_name("br0");

		skb_push(skb, ETH_HLEN);		
		memcpy(skb->data, "\xff\xff\xff\xff\xff\xff", 6);	
		memcpy(skb->data+6, upnp_lan_dev->dev_addr, 6);
		
 		skb->dev = upnp_lan_dev; 	
    	dev_queue_xmit(skb);			
	}	

	return found;  	
}
#endif // FILTER_UPNP_BR


#ifdef URL_FILTER
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
//Brad add
static int  GenerateTCPENDACK(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
	unsigned int tcplen;
	u_int32_t tmp_seq;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	
	lan_dev =__dev_get_by_name("br0");	
	iph=(void *) skb->nh.iph;
	oiph= (void *) skb->nh.iph;
	otcph = (struct tcphdr *)((u_int32_t*)skb->nh.iph + skb->nh.iph->ihl);
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}         	
	
	nskb=alloc_skb(sizeof(struct iphdr)+sizeof(struct tcphdr)+14,GFP_ATOMIC );
	if (!nskb) {
		printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	skb_reserve(nskb, 16);
	skb_put(nskb, 40);
	nskb->dev=lan_dev;
	
	
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh); 
      
       		
      
       	nskb->nfct = NULL;
	nskb->nfcache = 0;
	nskb->nfmark = 0;
       tcph=&ntcph;
	
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq+1;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->fin =0;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(skb->nh.iph->saddr, skb->nh.iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb->data + ETH_HLEN+20, tcph, sizeof(ntcph)); 
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	skb->nh.iph->saddr;
    	niph.saddr		=	skb->nh.iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	skb->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	
    	memcpy(nskb->data + ETH_HLEN, &niph, sizeof(niph)); 
		
	url_cache.isSentFinAck=0;
//	printk("Sent FINACK already\n");	
	dev_queue_xmit(nskb); //send tcp fin ack;
	return 0;
}

static int  GenerateTCPFINACK(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
	unsigned int tcplen;
	u_int32_t tmp_seq;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	
	lan_dev =__dev_get_by_name("br0");	
	iph=(void *) skb->nh.iph;
	oiph= (void *) skb->nh.iph;
	otcph = (struct tcphdr *)((u_int32_t*)skb->nh.iph + skb->nh.iph->ihl);
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}         	
	
	nskb=alloc_skb(sizeof(struct iphdr)+sizeof(struct tcphdr)+14,GFP_ATOMIC );
	if (!nskb) {
		printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	skb_reserve(nskb, 16);
	skb_put(nskb, 40);
	nskb->dev=lan_dev;
	
	
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh); 
      
       		
      
       	nskb->nfct = NULL;
	nskb->nfcache = 0;
	nskb->nfmark = 0;
       tcph=&ntcph;
	
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->fin =1;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(skb->nh.iph->saddr, skb->nh.iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb->data + ETH_HLEN+20, tcph, sizeof(ntcph)); 
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	skb->nh.iph->saddr;
    	niph.saddr		=	skb->nh.iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	skb->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	
    	memcpy(nskb->data + ETH_HLEN, &niph, sizeof(niph)); 
		
	url_cache.isSent401=0;		
	url_cache.isSentFinAck=1;
//	printk("Sent FINACK already\n");	
	dev_queue_xmit(nskb); //send tcp fin ack;
	return 0;
}


static int  GenerateHTTP401(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct sk_buff *nskb1=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
        unsigned char *data;
	unsigned int tcplen;
	u_int16_t tmp_port;
	u_int32_t tmp_seq;
	u_int32_t tmp_addr;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	
	lan_dev =__dev_get_by_name("br0");	
	
	iph=(void *) skb->nh.iph;
	oiph= (void *) skb->nh.iph;
	otcph = (struct tcphdr *)((u_int32_t*)skb->nh.iph + skb->nh.iph->ihl);
	//get lan host ip address by arp table	
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}
	 
	nskb1=alloc_skb(sizeof(struct iphdr)+sizeof(struct tcphdr)+14,GFP_ATOMIC );
	if (!nskb1) {
		printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	skb_reserve(nskb1, 16);
	skb_put(nskb1, 40);
	nskb1->dev=lan_dev;
        	
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb1->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb1, hh->hh_len);
       	//neigh_release(neigh); 
       	
       	
       	nskb1->nfct = NULL;
	nskb1->nfcache = 0;
	nskb1->nfmark = 0;
	
       tcph=&ntcph;
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq+skb->len-40;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->psh =0;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb1->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(skb->nh.iph->saddr, skb->nh.iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb1->data + ETH_HLEN+20, tcph, sizeof(ntcph)); 
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	skb->nh.iph->saddr;
    	niph.saddr		=	skb->nh.iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	//nskb1->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	
    	memcpy(nskb1->data + ETH_HLEN, &niph, sizeof(niph)); 
				
	dev_queue_xmit(nskb1); //send tcp ack;
       	
       	nskb = skb_copy_expand(skb, 16, strlen(URL_FILTER_BLOCK_PAGE_MESSAGE), GFP_ATOMIC);
	if (!nskb) {
		printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	
	
	skb_trim(nskb, nskb->nh.iph->ihl*4 + sizeof(struct tcphdr));
	skb_put(nskb,strlen(URL_FILTER_BLOCK_PAGE_MESSAGE));
	
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh); 
       	
	nskb->nfct = NULL;
	nskb->nfcache = 0;
	nskb->nfmark = 0;
	
	tmp_addr = nskb->nh.iph->saddr;
	nskb->nh.iph->saddr = nskb->nh.iph->daddr;
	nskb->nh.iph->daddr = tmp_addr;
	tcph = (struct tcphdr *)((u_int32_t*)nskb->nh.iph + nskb->nh.iph->ihl);
	data = (void *)tcph + tcph->doff*4;
	tmp_port = tcph->source;
	tcph->source = tcph->dest;
	tcph->dest = tmp_port;
	memcpy(data, URL_FILTER_BLOCK_PAGE_MESSAGE, strlen(URL_FILTER_BLOCK_PAGE_MESSAGE));
	
	
	tmp_seq= tcph->seq;
	tcph->seq = tcph->ack_seq;
	tcph->ack_seq= tmp_seq+skb->len-40;
	tcph->window = url_cache.tcp_window;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->psh =1;
	tcph->fin =0;
	tcph->urg_ptr = 0;

	tcplen = nskb->len - nskb->nh.iph->ihl*4-14;
     	tcph->check = 0;
	tcph->check = csum_tcpudp_magic(nskb->nh.iph->saddr, nskb->nh.iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
	
	nskb->nh.iph->tot_len = htons(nskb->len-14);
	nskb->nh.iph->ttl = url_cache.ip_ttl;                 
	nskb->nh.iph->frag_off = 0;
	nskb->nh.iph->id = url_cache.ip_id+2;

	nskb->nh.iph->check = 0;
	nskb->nh.iph->check = ip_fast_csum((unsigned char *)nskb->nh.iph, nskb->nh.iph->ihl);
	url_cache.isSent401=1;			
	dev_queue_xmit(nskb);
	return 0;
}

//Brad add end
#endif

static int find_pattern(const char *data, size_t dlen, const char *pattern, size_t plen, char term, unsigned int *numoff, unsigned int *numlen)
{
	size_t i,j,k;
	int state =0;
	*numoff = *numlen=0;
	for(i=0; i <= (dlen -plen);i++)
	{
	      if (*(data + i) == '\r')
	      {
            	  if (!(state % 2)) state++;  /* forwarding move */
              	  else state = 0;             /* reset */
              }
	      else if (*(data + i) == '\n')
	      {
	          if (state % 2) state++;
	          else state = 0;
              }
              else state = 0;

	      if (state >= 4)
	           break;
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      *numoff=i + plen;
	      for (j = *numoff, k = 0; data[j] != term; j++, k++)
	        if (j > dlen) return 0 ;   /* no terminal char */
	      *numlen = k;
	      return 1;
		      
	}
 return 0;

}

static int find_url(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{
	int i;

	if(plen > dlen)
	  return 0;
	for(i=0; data[i] !=term ;i++)
	{
	      //michael
	      if(strnicmp(data + i, pattern, plen)!=0)
		      continue;
	      else
		return 1;
	}
  return 0;
}
	

static int  FilterWeb(struct sk_buff *skb)
{
	struct iphdr *iph;
 	struct tcphdr *tcph;
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, offset,hostlen,pathlen, http_found;
	int datalen,i;
	char http_str[2048], *str;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	struct net_device *if_check;
#endif	
//Brad add
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;
//---------------------	



        if (url_addr != 0 && (iph->saddr & 0xFFFFFF00)==(url_addr & 0xFFFFFF00)
			 && (iph->saddr & 0xFF) >= (url_addr & 0xFF)
			 && (iph->saddr & 0xFF) < ((url_addr & 0xFF)+url_range))
	          return 0;

#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	if_check = skb->dev;
	if((!strcmp(if_check->name, "eth1") || !strcmp(if_check->name, "ppp0")) && tcph->source ==80 && tcph->syn==1 && tcph->ack==1){
		url_cache.ip_id = iph->id;
		url_cache.tcp_window = tcph->window;                  
		url_cache.ip_ttl = iph->ttl;     
		url_cache.wanside_ip=iph->saddr;
	}
	//if(!strcmp(if_check->name, "br0")  && tcph->dest ==80 && tcph->fin==1 && tcph->ack==1 && iph->daddr== url_cache.wanside_ip){
	//	url_cache.lanside_ip=iph->saddr;
	//}
	
#endif	


	datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return 0;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return 0;
	//michael
	str = http_str + 7; //reserve for "http://"
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;

	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
		return 0;
//Brad add 	
      	
      	if ((landev = __dev_get_by_name("br0")) != NULL){
      		ifa =NULL;
		if ((in_dev=__in_dev_get(landev)) != NULL) {
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
				if (strcmp("br0", ifa->ifa_label) == 0){
					break; 
				}
			}
		//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL){
				if(iph->daddr == ifa->ifa_address){
					return 0;
				}
			}
		}
	}
	
	if ((wandev = __dev_get_by_name("ppp0")) != NULL){
      		ifa =NULL;
		if ((in_dev=__in_dev_get(wandev)) != NULL) {
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
				if (strcmp("ppp0", ifa->ifa_label) == 0){
					break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL){
				if(iph->daddr == ifa->ifa_local){
					return 0;
				}
			}
		}
	}
	if ((wandev = __dev_get_by_name("eth1")) != NULL){
			ifa =NULL;
			if ((in_dev=__in_dev_get(wandev)) != NULL) {
				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("eth1", ifa->ifa_label) == 0){
						break; 
					}
				}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL){
				if(iph->daddr == ifa->ifa_address){
					return 0;
				}
			}
		}
	}
//#ifndef CONFIG_RTL8186_TR	
#if !(defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_AC))
	 if ((wandev = __dev_get_by_name("wlan0")) != NULL){
			ifa =NULL;
      			if ((in_dev=__in_dev_get(wandev)) != NULL) {
      				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("wlan0", ifa->ifa_label) == 0){
						break; 
					}
				}
				//accept the http packet if the dest ip is our wan ip, always
				if(ifa !=NULL){
					if(iph->daddr == ifa->ifa_address){
						return 0;
					}
				}
		}
	}
#endif	
//---------------------------------------------------------------	



	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';

	for(i=0; i< url_count ;i++) {
        //michael
        http_found = 0;
        str = strstr(url_tbl[i], "://");
        if (str != NULL) {
            str -= 4;
            if (url_tbl[i] <= str) {
                if (strnicmp(str, "http://", 7) == 0)
                    http_found = 1;
            }
        }
        if (http_found == 1) {
            memcpy(http_str, "http://", 7);
            str = http_str;
        }
        else {
            str = http_str + 7;
        }

        found = find_url(str,strlen(str),url_tbl[i],strlen(url_tbl[i]),'\0');
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL865X_SC) && !defined(CONFIG_RTL865X_AC)
	   if(found){
            scrlog_printk("URL: Filter URL=%s  Source=%u.%u.%u.%u\n",url_tbl[i], NIPQUAD(iph->saddr));
	      	return 1;
        }
#else
        if(found){
            break;
		}
#endif
    }
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
		if(url_mode==1){
				if(found){
					scrlog_printk("URLDROPlog_num:13;msg:Blocked to access web site;src:%u.%u.%u.%u;note:%s;\n", NIPQUAD(iph->saddr), url_tbl[i]);
	      				return 1;
	      			}else
	      				return 0;
      		}else if(url_mode==2) {
		      		if(found){
		      			return 0;
		      		}else{
		      			scrlog_printk("URLDROPlog_num:13;msg:Blocked to access web site;src:%u.%u.%u.%u;note:%s;\n", NIPQUAD(iph->saddr), url_tbl[i]);
	      				return 1;
	      			}
	      	}else{
	      		return 0;
	   	}
#endif
	return 0;
}

static int url_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%s\n", url_flag);


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
unsigned long str2hexnum(unsigned char *p)
{
  unsigned long val=0;
  unsigned long c=0;
  for(val=0;*p!='\0';val=(val<< 4 ) + c, p++)
  {
     c=*p;
     if(c >= '0' && c <='9')
	   c=c-'0';
     else if(c >='a' && c <='f')
	   c=c-'a'+10;
     else
	   break;
  }
  return val;

}

static int url_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      char tmpbuf[1024];
      char *tokptr, *strptr=tmpbuf;

      u_int8_t idx=0;

      if (count < 2)
	    return -EFAULT;

      if (buffer && !copy_from_user(&url_flag, buffer, count)) {
	      strncpy(tmpbuf,url_flag,count);
	      	tmpbuf[strlen(url_flag)]='\0';
	      tokptr = strtok(strptr," ");
              strptr=NULL;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
             	url_mode=simple_strtol(tokptr,NULL,0);
             	//printk("url mode=%d\n", url_mode);
             	tokptr = strtok(strptr," ");
#endif             	
              url_count=simple_strtol(tokptr,NULL,0);
              	//printk("url count=%d\n", url_count);
	      while (idx< url_count)
	      {
	      	if((tokptr = strtok(strptr," "))==NULL)
	        	break;
              	strptr=NULL;
	      	strcpy(&url_tbl[idx][0],tokptr);
	      	idx++;
	      }
	      if(*(tokptr+strlen(tokptr)+1)=='\n')
		      return count;

              strptr=NULL;
	      if((tokptr = strtok(strptr," "))!=NULL)
	      {
              strptr=NULL;
	      url_addr=str2hexnum(tokptr);
	      tokptr = strtok(strptr," ");
              url_range=simple_strtol(tokptr,NULL,0);
	      }
	    return count;
      }
      return -EFAULT;
}
#endif //URL_FILTER

#ifdef DOS_FILTER
static void dos_pkt_init(void)
{
	struct s_dos_pkt *p_pkt;
	int idx;
	p_pkt=&dos_pkt[0];
	for(idx=0; idx< TableSize;idx++)
	{
        	p_pkt->use=0;
        	p_pkt->ip=0;
        	p_pkt->syn_cnt=0;
          	p_pkt->fin_cnt=0;
          	p_pkt->udp_cnt=0;
          	p_pkt->icmp_cnt=0;
          	p_pkt->scan_cnt=0;
		p_pkt++;
	} 
}      
static void dos_whole_flood(void)
{
	struct s_dos_pkt *p_pkt;
	int whole_syn_pkt=0;
	int whole_fin_pkt=0;
	int whole_udp_pkt=0;
	int whole_icmp_pkt=0;
	int idx;
	if(item & ( WholeSynFloodSet | WholeFinFloodSet | WholeUdpFloodSet | WholeIcmpFloodSet))
	{
		for(idx=0,p_pkt=&dos_pkt[0]; idx< TableSize;idx++,p_pkt++)
		{
			if(p_pkt->use ==1 && (item &  WholeSynFloodSet)==WholeSynFloodSet && p_pkt->syn_cnt >0)
				whole_syn_pkt+=p_pkt->syn_cnt;		
			if(p_pkt->use ==1 && (item &  WholeFinFloodSet)==WholeFinFloodSet && p_pkt->fin_cnt >0)
				whole_fin_pkt+=p_pkt->fin_cnt;
			if(p_pkt->use ==1 && (item &  WholeUdpFloodSet)==WholeUdpFloodSet && p_pkt->udp_cnt >0)
				whole_udp_pkt+=p_pkt->udp_cnt;
			if(p_pkt->use ==1 && (item &  WholeIcmpFloodSet)==WholeIcmpFloodSet && p_pkt->icmp_cnt >0)
				whole_icmp_pkt+=p_pkt->icmp_cnt;
		}
	
		
		if(whole_syn_pkt > whole_syn_threshold && (item & WholeSynFloodSet)==WholeSynFloodSet && whole_syn_threshold > 0) 
			LogFlag |=WholeSynFloodSet;		
		if(whole_fin_pkt > whole_fin_threshold && (item & WholeFinFloodSet)==WholeFinFloodSet && whole_fin_threshold > 0)
			LogFlag |=WholeFinFloodSet;
		if(whole_udp_pkt > whole_udp_threshold && (item & WholeUdpFloodSet)==WholeUdpFloodSet && whole_udp_threshold > 0)
			LogFlag |=WholeUdpFloodSet;
		if(whole_icmp_pkt > whole_icmp_threshold && (item & WholeIcmpFloodSet)==WholeIcmpFloodSet && whole_icmp_threshold >0)
			LogFlag |=WholeIcmpFloodSet;
	}


}
static int dos_pkt_syn_flood(u_int32_t item,struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	
	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)==TCP_SYN)
	{
	        if(block==1 && attack_saddr[PerSynFlood]==iph->saddr)	
			return FAILED;
      		(p_pkt->syn_cnt)++;
			
		if(p_pkt->syn_cnt > per_syn_threshold && (item & PerSynFloodSet)==PerSynFloodSet && per_syn_threshold > 0)
		{
		 	attack_saddr[PerSynFlood]=iph->saddr;
			attack_daddr[PerSynFlood]=iph->daddr;
			block=1;
			LogFlag |=PerSynFloodSet;
		}
	}
	return SUCCESS;

}

static int dos_pkt_fin_flood(u_int32_t item,struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)==TCP_FIN )
	{
	        if(block==1 && attack_saddr[PerFinFlood]==iph->saddr)	
			return FAILED;
       		(p_pkt->fin_cnt)++;
		if(p_pkt->fin_cnt > per_fin_threshold && (item & PerFinFloodSet)==PerFinFloodSet && per_fin_threshold > 0)
		{
		 	attack_saddr[PerFinFlood]=iph->saddr;
			attack_daddr[PerFinFlood]=iph->daddr;
			block=1;
			LogFlag |=PerFinFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_udp_flood(u_int32_t item,struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_UDP)
	{
	        if(block==1 && attack_saddr[PerUdpFlood]==iph->saddr)	
			return FAILED;
      		(p_pkt->udp_cnt)++;
		if(p_pkt->udp_cnt > per_udp_threshold && (item & PerUdpFloodSet)==PerUdpFloodSet && per_udp_threshold > 0)
		{
		 	attack_saddr[PerUdpFlood]=iph->saddr;
			attack_daddr[PerUdpFlood]=iph->daddr;
			block=1;
			LogFlag |=PerUdpFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_icmp_flood(u_int32_t item,struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_ICMP)
	{
	        if(block==1 && attack_saddr[PerIcmpFlood]==iph->saddr)	
			return FAILED;
       		(p_pkt->icmp_cnt)++;
		if(p_pkt->icmp_cnt > per_icmp_threshold && (item & PerIcmpFloodSet)==PerIcmpFloodSet && per_icmp_threshold >0)
		{
		 	attack_saddr[PerIcmpFlood]=iph->saddr;
			attack_daddr[PerIcmpFlood]=iph->daddr;
			block=1;
			LogFlag |=PerIcmpFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_locate(struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
	int16_t idx=0;
        idx=iph->saddr % TableSize;	
	p_pkt=&dos_pkt[idx];
	if(iph->saddr == ConnectedIp[iph->saddr % HashSize] && p_pkt->ip==iph->saddr)
	{
		p_pkt->use=0;
		return 0;
	}
	if(p_pkt->ip!=iph->saddr && p_pkt->use ==0)
	{
		p_pkt->ip=iph->saddr;
		p_pkt->use=1;
 		cur_p_pkt=p_pkt;
		return 1;
	}
	else if(p_pkt->ip==iph->saddr && p_pkt->use ==1)
	{
 		cur_p_pkt=p_pkt;		
		return 1;
	}
	else
		return 0;
}

static int _IpSpoof(struct iphdr *iph)
{
	
	if((iph->saddr & lan_mask)==(lan_addr & lan_mask) && iph->protocol!=IPPROTO_ICMP)
	{
		LogFlag |=IpSpoofSet;
		attack_saddr[IpSpoof]=iph->saddr;
		attack_daddr[IpSpoof]=iph->daddr;
		return FAILED;
	}
	return SUCCESS;
}
		
static int _IcmpSmurf(struct iphdr *iph)
{
	struct icmphdr *icmph;
	icmph=(void *) iph + iph->ihl*4;
	if(iph->protocol==IPPROTO_ICMP && icmph->type == ICMP_ECHO)
	{	
		if((iph->saddr & lan_mask)==(lan_addr & lan_mask))
		{
	   	LogFlag |=IcmpSmurfSet;
		attack_saddr[IcmpSmurf]=iph->saddr;
		attack_daddr[IcmpSmurf]=iph->daddr;
		return FAILED;
		}
	}
	return SUCCESS;
		
}
static int _IpLand(struct iphdr *iph)
{
	if(iph->saddr==iph->daddr)
	{
        	LogFlag |=IpLandSet;
		attack_saddr[IpLand]=iph->saddr;
		attack_daddr[IpLand]=iph->daddr;
		return FAILED;
	}
	
	return SUCCESS;
		   
}
static int _UdpBomb(struct iphdr *iph, struct udphdr *udph)
{
	int ipPayLoadLength;

	if(iph->protocol==IPPROTO_UDP)
	{	
        	if (!(iph->frag_off & (IP_OFFSET|IP_MF)))
		{
	        	ipPayLoadLength = ntohs(iph->tot_len) - ((iph->ihl) << 2);
	       		if (ipPayLoadLength > ntohs(udph->len))
			{
	       	      		LogFlag |=UdpBombSet;
				attack_saddr[UdpBomb]=iph->saddr;
				attack_daddr[UdpBomb]=iph->daddr;
				return FAILED;
			}	
		}
	}
	return SUCCESS;
}

static int _TcpSynWithData(struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)== TCP_SYN)
	{
		unsigned long datalen= ntohs(iph->tot_len)-((iph->ihl)<<2)- (tcph->doff<<2);
		if(datalen>0)            
	       		{
	       	      	LogFlag |=TcpSynWithDataSet;
			attack_saddr[TcpSynWithData]=iph->saddr;
			attack_daddr[TcpSynWithData]=iph->daddr;
			return FAILED;
			}
		if(htons(iph->frag_off) & IP_MF)   
		     	{
	       	      	LogFlag |=TcpSynWithDataSet;
			attack_saddr[TcpSynWithData]=iph->saddr;
			attack_daddr[TcpSynWithData]=iph->daddr;
			return FAILED;
			}
				
											}
	return SUCCESS;
}

static int _PingOfDeath(struct iphdr *iph)
{
	unsigned short iph_off = ntohs(iph->frag_off);
	unsigned long  val;

        if((iph_off & IP_MF) == 0 && (iph_off & IP_OFFSET))
        {
        iph_off &= IP_OFFSET;
        val = (iph_off << 3) + ntohs(iph->tot_len) -((iph->ihl) << 2);
        if(val > 65535)
		{
	      	LogFlag |=PingOfDeathSet;
		attack_saddr[PingOfDeath]=iph->saddr;
		attack_daddr[PingOfDeath]=iph->daddr;
		return FAILED;
	      	}
        }
	return SUCCESS;
}
static int _UdpEchoChargen(struct iphdr *iph, struct udphdr *udph) 
{
	if(iph->protocol==IPPROTO_UDP)
	{
        	if((udph->dest==htons(7)||udph->dest==htons(17)||udph->dest==htons(19)) || (udph->source==htons(7)||udph->source==htons(17)||udph->source==htons(19)))
		{
			LogFlag |=UdpEchoChargenSet;
			attack_saddr[UdpEchoChargen]=iph->saddr;
			attack_daddr[UdpEchoChargen]=iph->daddr;
			return FAILED;
		}
	}
	return SUCCESS;
}
static int _TcpScan(struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	if(iph->protocol==IPPROTO_TCP)
	{	
		if(_tcpDosScanBitmap[*tflag & 0x3f])
		{
		LogFlag |=TcpScanSet;
		attack_saddr[TcpScan]=iph->saddr;
		attack_daddr[TcpScan]=iph->daddr;
		return FAILED;
		}
	}
	return SUCCESS;
}
static int _TearDrop(struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
	if(dos_pkt_locate(iph))
         	p_pkt=cur_p_pkt;	
        else	
		return SUCCESS;
	if(ntohs(iph->id)!=p_pkt->id && ntohs(p_pkt->id) !=0)
		return SUCCESS;
	
	if((ntohs(iph->frag_off)) & (IP_MF | IP_OFFSET))
	{
        	if(((ntohs(iph->frag_off) & IP_OFFSET) << 3) >= p_pkt->offset)
			{
			if(!(ntohs(iph->frag_off) & IP_MF))
			        {
                        	p_pkt->id=0;
                        	p_pkt->offset=0;
				}
			else  
			    	{
				p_pkt->id=ntohs(iph->id);
				p_pkt->offset=p_pkt->offset + ntohs(iph->tot_len)-((iph->ihl) << 2);
				}
			}
		else  
			{			
	       	      	LogFlag |=TearDropSet;
			attack_saddr[TearDrop]=iph->saddr;
			attack_daddr[TearDrop]=iph->daddr;
			return FAILED;
			}
			
	}
	return SUCCESS;
}
static int _TcpUdpPortScan(struct iphdr *iph, struct tcphdr *tcph,struct udphdr *udph) 
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	
	if(iph->protocol==IPPROTO_TCP)
	{
		
		if(p_pkt->dest != 0 && p_pkt->dest!=tcph->dest)  
			(p_pkt->scan_cnt)++;
		if(p_pkt->dest == 0)  
			p_pkt->dest=tcph->dest;
	}
	if(iph->protocol==IPPROTO_UDP)
	{
		if(p_pkt->dest != 0 && p_pkt->dest!=udph->dest)  
			(p_pkt->scan_cnt)++;
		if(p_pkt->dest == 0)  
			p_pkt->dest=udph->dest;
	}
	       
	if((item & SensitivitySet)==SensitivitySet && p_pkt->scan_cnt > HighSensitivity)
	{
	       	LogFlag |=TcpUdpPortScanSet;
		attack_saddr[TcpUdpPortScan]=iph->saddr;
		attack_daddr[TcpUdpPortScan]=iph->daddr;
	}
	if((item & SensitivitySet)!=SensitivitySet && p_pkt->scan_cnt > LowSensitivity)
	{
	       	LogFlag |=TcpUdpPortScanSet;
		attack_saddr[TcpUdpPortScan]=iph->saddr;
		attack_daddr[TcpUdpPortScan]=iph->daddr;
	}
	  
	return SUCCESS;
}
static void ShowLog(u_int32_t flag)
{
	if(flag & WholeSynFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
	  	scrlog_printk("$DoS: Whole System SYN Flood Attack\n");
#endif

	if(flag & WholeFinFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
		scrlog_printk("$DoS: Whole System FIN Flood Attack\n");
#endif

	if(flag & WholeUdpFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else	
		scrlog_printk("$DoS: Whole System UDP Flood Attack\n");
#endif

	if(flag & WholeIcmpFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
	scrlog_printk("$DoS: Whole System ICMP Flood Attack\n");
#endif
		
	if(flag & PerSynFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerSynFlood]),NIPQUAD(attack_daddr[PerSynFlood]));
		scrlog_printk("$DoSATTACKlog_num:13;msg: Per-source SYN Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerSynFlood]),  NIPQUAD(attack_daddr[PerSynFlood]));
	}
#else	
		scrlog_printk("$DoS: Per-source SYN Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerSynFlood]),NIPQUAD(attack_daddr[PerSynFlood]));
#endif

	if(flag & PerFinFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerFinFlood]),NIPQUAD(attack_daddr[PerFinFlood]));
		scrlog_printk("$DoSATTACKlog_num:13;msg: Per-source FIN Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerFinFlood]),  NIPQUAD(attack_daddr[PerFinFlood]));
		
	}
#else	
		scrlog_printk("$DoS: Per-source FIN Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerFinFlood]),NIPQUAD(attack_daddr[PerFinFlood]));
#endif

	if(flag & PerUdpFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerUdpFlood]),NIPQUAD(attack_daddr[PerUdpFlood]));
		scrlog_printk("$DoSATTACKlog_num:13;msg: Per-source UDP Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerUdpFlood]),  NIPQUAD(attack_daddr[PerUdpFlood]));
	}
#else
		scrlog_printk("$DoS: Per-source UDP Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerUdpFlood]),NIPQUAD(attack_daddr[PerUdpFlood]));
#endif

	if(flag & PerIcmpFloodSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerIcmpFlood]),NIPQUAD(attack_daddr[PerIcmpFlood]));
		scrlog_printk("$DoSATTACKlog_num:13;msg: Per-source ICMP Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerIcmpFlood]),  NIPQUAD(attack_daddr[PerIcmpFlood]));
	}
#else
		scrlog_printk("$DoS: Per-source ICMP Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerIcmpFlood]),NIPQUAD(attack_daddr[PerIcmpFlood]));
#endif	

	if(flag & TcpUdpPortScanSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),NIPQUAD(attack_daddr[TcpUdpPortScan]));
		scrlog_printk("$DoSATTACKlog_num:13;msg: Port Scan Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),  NIPQUAD(attack_daddr[TcpUdpPortScan]));
		
	}
#else
		scrlog_printk("$DoS: Port Scan Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),NIPQUAD(attack_daddr[TcpUdpPortScan]));
#endif

	if(flag & TcpScanSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpScan]),NIPQUAD(attack_daddr[TcpScan]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:Tcp Scan Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpScan]),  NIPQUAD(attack_daddr[TcpScan]));
	}
#else
	scrlog_printk("$DoS: Tcp Scan Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpScan]),NIPQUAD(attack_daddr[TcpScan]));
#endif	
		
	if(flag & TcpSynWithDataSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpSynWithData]),NIPQUAD(attack_daddr[TcpSynWithData]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:Tcp SYN With Data Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpSynWithData]),  NIPQUAD(attack_daddr[TcpSynWithData]));
	}
#else
		scrlog_printk("$DoS: Tcp SYN With Data Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpSynWithData]),NIPQUAD(attack_daddr[TcpSynWithData]));
#endif

	if(flag & IpLandSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IpLand]),NIPQUAD(attack_daddr[IpLand]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:IpLand Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IpLand]),  NIPQUAD(attack_daddr[IpLand]));
	}
#else	
		scrlog_printk("$DoS: IP Land Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IpLand]),NIPQUAD(attack_daddr[IpLand]));
#endif

	if(flag & UdpEchoChargenSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[UdpEchoChargen]),NIPQUAD(attack_daddr[UdpEchoChargen]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:UdpEchoChargen Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[UdpEchoChargen]),  NIPQUAD(attack_daddr[UdpEchoChargen]));
	}
#else
		scrlog_printk("$DoS: UdpEchoChargen Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[UdpEchoChargen]),NIPQUAD(attack_daddr[UdpEchoChargen]));
#endif

	if(flag & UdpBombSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[UdpBomb]),NIPQUAD(attack_daddr[UdpBomb]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:UdpBomb Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[UdpBomb]),  NIPQUAD(attack_daddr[UdpBomb]));
	}
#else
	scrlog_printk("$DoS: UdpBomb Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[UdpBomb]),NIPQUAD(attack_daddr[UdpBomb]));
#endif	
		
	if(flag & PingOfDeathSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PingOfDeath]),NIPQUAD(attack_daddr[PingOfDeath]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:PingOfDeath Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PingOfDeath]),  NIPQUAD(attack_daddr[PingOfDeath]));
	
	}
#else
	scrlog_printk("$DoS: PingOfDeath Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PingOfDeath]),NIPQUAD(attack_daddr[PingOfDeath]));
#endif	
		
	if(flag & IcmpSmurfSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{  
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IcmpSmurf]),NIPQUAD(attack_daddr[IcmpSmurf]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:IcmpSmurf Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IcmpSmurf]),  NIPQUAD(attack_daddr[IcmpSmurf]));
	}	
#else	
		scrlog_printk("$DoS: IcmpSmurf Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IcmpSmurf]),NIPQUAD(attack_daddr[IcmpSmurf]));
#endif

	if(flag & IpSpoofSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{  
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IpSpoof]),NIPQUAD(attack_daddr[IpSpoof]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:IpSpoof Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IpSpoof]),  NIPQUAD(attack_daddr[IpSpoof]));
	}
#else
	scrlog_printk("$DoS: IpSpoof Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IpSpoof]),NIPQUAD(attack_daddr[IpSpoof]));
#endif	
		
	if(flag & TearDropSet)
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	{  
		scrlog_printk("$DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TearDrop]),  NIPQUAD(attack_daddr[TearDrop]));
		scrlog_printk("$DoSATTACKlog_num:13;msg:TearDrop Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TearDrop]),  NIPQUAD(attack_daddr[TearDrop]));
	}
#else
		scrlog_printk("$DoS: TearDrop Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TearDrop]),NIPQUAD(attack_daddr[TearDrop]));
#endif	 	
		
        LogFlag=0;	
}

static void dos_timer_fn(unsigned long arg)
{	
        if (item) {       
		if(block_count >=block_time) {		
			block=0;
			block_count=0;
		}
		if(block == 1)
			block_count++;
				
 		dos_whole_flood();
		ShowLog(LogFlag);
        	dos_pkt_init();

	}
		
// david --------------------------------------
	if (none_dos_drop_pkt_cnt > NONE_DOS_PKT_THRES) {
		if (item) {		
			item_backup = item;
			item = 0;
			//printk("disable DoS\n");			
		}
	}	
	else {		
		if (item_backup) {
			item = item_backup;
			item_backup = 0;
			//printk("enable DoS\n");						
		}
	}
	if (none_dos_drop_pkt_cnt > 0)
		none_dos_drop_pkt_cnt=0;
//-------------------------------------------
	
      	mod_timer(&dos_timer, jiffies + 100);
}

static int  filter_dos(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;	
	struct udphdr *udph;
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	udph=(void *) iph + iph->ihl*4;
	int ret=0;	

// david		  
      	wan_ppp_dev=__dev_get_by_name("ppp0"); //brad modify
     	wan_dev=__dev_get_by_name("eth1");		  //brad modify     		     
	if(skb->dev && (skb->dev == wan_dev || skb->dev == wan_ppp_dev)) //brad modify
	//if (skb->dev && !memcmp(skb->dev->name, "eth1", 4))	
	{
		if(item & (WholeSynFloodSet | WholeFinFloodSet | WholeUdpFloodSet  | WholeIcmpFloodSet | PerSynFloodSet | PerFinFloodSet | PerUdpFloodSet | PerIcmpFloodSet | TcpUdpPortScanSet))
                {	              
			if(dos_pkt_locate(iph))
		  	{
		  	if(item & (WholeSynFloodSet | PerSynFloodSet)) 
				ret|=dos_pkt_syn_flood(item,iph,tcph);		  	
		  	if(item & (WholeFinFloodSet | PerFinFloodSet))
				ret|=dos_pkt_fin_flood(item,iph,tcph);
		  	if(item & (WholeUdpFloodSet | PerUdpFloodSet))
				ret|=dos_pkt_udp_flood(item,iph);
		  	if(item & (WholeIcmpFloodSet | PerIcmpFloodSet))
				ret|=dos_pkt_icmp_flood(item,iph);
		  	if(item & TcpUdpPortScanSet)
				ret|=_TcpUdpPortScan(iph,tcph,udph); 
			if(!(item & IpBlockSet))
				ret=SUCCESS; 
		  	}
		}  		
		if(item & TcpScanSet)
			ret|=_TcpScan(iph,tcph);		
		if(item & TcpSynWithDataSet)
			ret|=_TcpSynWithData(iph,tcph);		
		if(item & IpLandSet)
			ret|=_IpLand(iph);		
		if(item & UdpEchoChargenSet)
			ret|=_UdpEchoChargen(iph, udph); 		
		if(item & UdpBombSet)
	        	ret|=_UdpBomb(iph, udph);	        
		if(item & PingOfDeathSet)
			ret|=_PingOfDeath(iph);		
		if(item & IcmpSmurfSet)
	 		ret|=_IcmpSmurf(iph);	 	
		if(item & IpSpoofSet)
      			ret|=_IpSpoof(iph);       		
		if(item & TearDropSet)
			ret|=_TearDrop(iph);		
	}
	if(ret)
	  return FAILED;
	else  	  
	  return SUCCESS;
}

static int dos_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%s\n", dos_flag);


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}

static int dos_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      char tmpbuf[80];
      char *tokptr, *strptr=tmpbuf; 
      u_int8_t idx=1;
      u_int32_t val;
      
      if (count < 2) 
	    return -EFAULT;
      
      if (buffer && !copy_from_user(&dos_flag, buffer, 80)) {
	      strncpy(tmpbuf,dos_flag,80);
	      
	      while ((tokptr = strtok(strptr," ")) !=NULL)
	      {
              	strptr=NULL;
              	val=simple_strtol(tokptr,NULL,0);
		switch(idx)
		  {	
                  case 1: 
			op_mode=val;
			break;
                  case 2:
              	        val=simple_strtol(tokptr,NULL,16);
			lan_addr=val;
			break;
                  case 3: 
              	        val=simple_strtol(tokptr,NULL,16);
			lan_mask=val;
			break;
			
                  case 4: 
			item=val;
			item_backup = 0; // david			
			break;
	          case 5:
		        whole_syn_threshold=val;				
			break;
	          case 6:
		        whole_fin_threshold=val;
			break;
	          case 7:
		        whole_udp_threshold=val;
			break;
	          case 8:
		        whole_icmp_threshold=val;
			break;
	          case 9:
		        per_syn_threshold=val;
			break;
	          case 10:
		        per_fin_threshold=val;
			break;
	          case 11:
		        per_udp_threshold=val;
			break;
	          case 12:
		        per_icmp_threshold=val;
			break;
	          case 13:
		        block_time=val;
			break;
		  default:
			break;	
		  }
	          idx++;
			
              }	      
	    return count;
      }
      return -EFAULT;
}
#endif

void filter_addconnect(__u32 ipaddr)
{
//	if (item & EnableDosSet) 
		 ConnectedIp[((__u32)ipaddr) % HashSize]=(__u32)ipaddr;
}

void filter_delconnect(__u32 ipaddr)
{
//	if (item & EnableDosSet) 
		 ConnectedIp[((__u32)ipaddr) % HashSize]=0;
}

		  
int filter_enter(struct sk_buff *skb)
{
//	struct iphdr* iph;

#ifdef DOS_FILTER
	if (!item 
#ifdef URL_FILTER
		&& !url_count
#endif		
		) {
		none_dos_drop_pkt_cnt++;	  
	      return NF_ACCEPT;		
	}
#endif		

      if (skb->pkt_type != PACKET_HOST ) return NF_REPEAT;
      if (skb->protocol != htons(ETH_P_IP) ) return NF_REPEAT;  
     
#ifdef URL_FILTER
      if(url_count)
      {
	        if(FilterWeb(skb)){
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
	        	GenerateHTTP401(skb);
#endif	        	
		      	return NF_DROP;
		    }
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC)
		     else if(url_cache.isSent401==1){
				GenerateTCPFINACK(skb);
				return NF_DROP;
			}else{
				if(url_cache.isSentFinAck==1){
		 			GenerateTCPENDACK(skb);
	      				return NF_DROP;
		 		}
		 	}
#endif		 	
      }		
	    	
#endif      
     
#ifdef DOS_FILTER
      if (item & EnableDosSet) {    
	      	if (filter_dos(skb))  
			return NF_DROP;		
      } 	
#endif         	     

      if (skb->nh.iph->protocol == IPPROTO_ICMP ) return NF_REPEAT;
      // here may add the ip_MISMATCH check

      if (skb->nh.iph->frag_off & htons(IP_MF|IP_OFFSET)) return NF_REPEAT;
#if 0
	if (skb->nh.iph->frag_off & htons(IP_MF|IP_OFFSET)) {
		skb = ip_ct_gather_frags(skb);
		if (skb == NULL)
			return NF_STOLEN;		
		*pskb = skb;			
		return NF_ACCEPT;
    	}
#endif		

// david
#if 0
      // ipsec pass through
      if ((skb->nh.iph->protocol == 50 || skb->nh.iph->protocol == 51)) return NF_REPEAT;
      // here may add the dst mtu check

      // check ip headers now -------------------------------------------
      if ((skb = skb_share_check(skb, GFP_ATOMIC)) == NULL)
	    goto out;

      if (!pskb_may_pull(skb, sizeof(struct iphdr)))
	    goto inhdr_error;
      iph = skb->nh.iph;
      if (iph->ihl < 5 || iph->version != 4)
	    goto inhdr_error; 
      if (!pskb_may_pull(skb, iph->ihl*4))
	    goto inhdr_error;
      iph = skb->nh.iph;

      // we move the ip_rcv_finish check at here
      // we don't want to play with ip option
      if (iph->ihl > 5) 
	    return NF_REPEAT;
      // we move the ip_forward check at here
      if (iph->ttl<=1)
	    return NF_REPEAT;
      if (skb->ip_summed == CHECKSUM_NONE)
	    if (ip_fast_csum((u8 *)iph, iph->ihl) != 0)
		  goto inhdr_error;
      {
	    __u32 len = ntohs(iph->tot_len); 
	    if (skb->len < len || len < (iph->ihl<<2))
		  goto inhdr_error;
	      
	    /* Our transport medium may have padded the buffer out. Now we know it
	     * is IP we can trim to the true length of the frame.
	     * Note this now means skb->len holds ntohs(iph->tot_len).
	     */
	    if (skb->len > len) {
		  __pskb_trim(skb, len);
		  if (skb->ip_summed == CHECKSUM_HW)
			skb->ip_summed = CHECKSUM_NONE;
	    }
      }
      if (skb_is_nonlinear(skb) && skb_linearize(skb, GFP_ATOMIC) != 0) {
	    printk("Skb is nonlinear!\n");
	    return NF_DROP;
      }
#endif

#ifdef DOS_FILTER
	none_dos_drop_pkt_cnt++;	  
#endif         	     

      return NF_ACCEPT;
// inhdr_error:
//      IP_INC_STATS_BH(IpInHdrErrors);
// out:
//      return NF_DROP;
}

#if 0
static int read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%c\n", flag);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{      
      if (count < 2) 
	    return -EFAULT;
      
      if (buffer && !copy_from_user(&flag, buffer, 1))       	
	    return count;     
      return -EFAULT;
}
#endif


#if defined(CONFIG_PROC_FS)
//static struct proc_dir_entry *res1=NULL;
#ifdef URL_FILTER
static struct proc_dir_entry *res2=NULL;
#endif
#ifdef DOS_FILTER
static struct proc_dir_entry *res3=NULL;
#endif
#ifdef FILTER_UPNP_BR
static int upnp_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[100];
	unsigned int a1, a2, a3, a4;

	if (buffer && !copy_from_user(tmpbuf, buffer, count)) {
		if (tmpbuf[0] == '0') {
			upnp_br_enabled = 0;      		
			return count;
		}
		sscanf(tmpbuf, "%d %u.%u.%u.%u %u", &upnp_br_enabled,&a1,&a2,&a3,&a4,&upnp_br_port);
		upnp_br_wanip = (a1 << 24 | a2 << 16 | a3 << 8 | a4);
		return count;
 	}
	return -EFAULT;
}

static int upnp_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;

	  len = sprintf(page, "enabled=%d, wan_ip=%u.%u.%u.%u, port=%d\n",
      		upnp_br_enabled, NIPQUAD(upnp_br_wanip), (int)upnp_br_port);
 
      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
     
      return len;
}
#endif // FILTER_UPNP_BR

#endif

int __init filter_init(void)
{
#if defined(CONFIG_PROC_FS)
#if 0
	res1=create_proc_entry("fast_nat",0,NULL);
	if (res1) {
	    res1->read_proc=read_proc;
	    res1->write_proc=write_proc;
	}
#endif	

#ifdef URL_FILTER       
	res2 = create_proc_entry("url_filter", 0, NULL);
	if (res2) {
	    res2->read_proc = url_read_proc;
	    res2->write_proc = url_write_proc;
      }
#endif
      
#ifdef DOS_FILTER      
      res3 = create_proc_entry("enable_dos", 0, NULL);
      if (res3) {
	    res3->read_proc = dos_read_proc;
	    res3->write_proc = dos_write_proc;
      }      
      init_timer(&dos_timer);
      dos_timer.expires  = jiffies + 100;
      dos_timer.data     = 0L;
      dos_timer.function = dos_timer_fn;
      mod_timer(&dos_timer, jiffies + 100);
      
      memset(&_tcpDosScanBitmap[0], 0, sizeof(_tcpDosScanBitmap));
      _tcpDosScanBitmap[0]=_tcpDosScanBitmap[3]=_tcpDosScanBitmap[8]=_tcpDosScanBitmap[9]= _tcpDosScanBitmap[32]=_tcpDosScanBitmap[33]=_tcpDosScanBitmap[40]=_tcpDosScanBitmap[41]= _tcpDosScanBitmap[58]=_tcpDosScanBitmap[63]=1;
#endif
#ifdef FILTER_UPNP_BR
	res9 = create_proc_entry("filter_upnp_br", 0, NULL);
	if (res9) {
		res9->read_proc = upnp_read_proc;
		res9->write_proc = upnp_write_proc;
	}
#endif 	
#endif // CONFIG_PROC_FS
	return 0;
}

void __exit filter_exit(void)
{
#if defined(CONFIG_PROC_FS)
#if 0
	if (res1) {
		remove_proc_entry("fast_nat", res1);		
		res1 = NULL;
	}
#endif	
#ifdef URL_FILTER		
	if (res2) {
		remove_proc_entry("url_filter", res2);				
		res2 = NULL;
	}
#endif		
#ifdef DOS_FILTER 
	if (res3) {
		remove_proc_entry("enable_dos", res3);	
		res3 = NULL;
	}
	del_timer_sync(&dos_timer);		
#endif		
#ifdef  FILTER_UPNP_BR
      if (res9) {
		remove_proc_entry("filter_upnp_br", res9);
		res9 = NULL;
      }
#endif
#endif // CONFIG_PROC_FS
}


