/*
Linux Kernel Hacking:
	net/core/neighbour.c						// ARP
	net/ipv4/fib_hash.c						// ROUTE
	net/ipv4/netfilter/ip_conntrack_core.c				// NAPT (PATH*2)
	net/ipv4/netfilter/ip_nat_core.c				// NAPT (PATH*2)
	net/ipv4/ip_input.c						// FastPath_Enter()
	net/ipv4/ip_output.c						// FastPath_Track()
*/
/*skb->h.raw = skb->nh.raw = skb->data*/

#include "fastpath_core.h"

#ifdef CONFIG_NET_QOS
#include <linux/netfilter_ipv4/ip_tables.h>
extern int gQosEnabled;
#endif

#define	MODULE_NAME		"Realtek FastPath"
#define	MODULE_VERSION	"v1.06"

#if 0
#define DEBUGP_API printk
#else
#define DEBUGP_API(format, args...)
#endif

#if 0
#define DEBUGP_PKT printk
#else
#define DEBUGP_PKT(format, args...)
#endif

#if 0
#define DEBUGP_SYS printk
#else
#define DEBUGP_SYS(format, args...)
#endif

//#define	DEBUG_PROCFILE	/* Create ProcFile for debug */

#define DOS_FILTER
#define FAST_PPTP
#define FAST_L2TP
//#define DEL_NAPT_TBL
#define INVALID_PATH_BY_FIN
#define NO_ARP_USED	// 2008.01.09, Forrest Lin. Use kernel route cache already.
#ifdef CONFIG_PROC_FS
	#define PROC_MAX_CONNECTION_CTRL // 2008.02.26, Forrest Lin. Use /proc/fast_max to control NAPT_TABLE_ENTRY_MAX and PATH_TABLE_ENTRY_MAX
#endif

#define FILTER_UPNP_BR
#ifdef CONFIG_RTL8186_TR
#undef FILTER_UPNP_BR
#endif
#ifdef CONFIG_RTL865X_AC
#undef FILTER_UPNP_BR
#endif
#ifdef CONFIG_RTL8186_KB
	#undef FAST_L2TP
	#undef FAST_PPTP
	#include <net/ip.h> 
#endif

#if defined (FAST_PPTP) || defined(FAST_L2TP)
	#include <net/ip.h> 
#endif

#ifdef FILTER_UPNP_BR
extern int filter_upnp_and_fw(struct sk_buff *skb);
extern int upnp_br_enabled;
#endif

#ifdef DOS_FILTER
	extern int filter_enter(struct sk_buff *skb);
	extern int __init filter_init(void);
	extern void __exit filter_exit(void);
	extern void filter_addconnect(ipaddr_t ipaddr);
	extern void filter_delconnect(ipaddr_t ipaddr);
#endif

#ifdef FAST_PPTP
	extern void fast_pptp_filter(struct sk_buff *skb);
	extern void fast_pptp_sync_rx_seq(struct sk_buff *skb);
	extern int __init fast_pptp_init(void);
	extern void __exit fast_pptp_exit(void);
	extern int fast_pptp_to_lan(struct sk_buff **pskb);
	extern int fast_pptp_fw;
#endif

#ifdef FAST_L2TP
	extern int __init fast_l2tp_init(void);
	extern void __exit fast_l2tp_exit(void);
	extern int fast_l2tp_to_wan(struct sk_buff *skb);
	extern void fast_l2tp_rx(struct sk_buff *skb);
	extern void l2tp_tx_id(struct sk_buff *skb);	
	extern int fast_l2tp_fw;
#endif

static int fast_nat_fw = 1;
static int  flush_table = 0;
//Brad disable 
#if 0
static void flush_all_table(void);
#endif 

#ifdef PROC_MAX_CONNECTION_CTRL
static int napt_table_entry_max = NAPT_TABLE_ENTRY_MAX;
static int path_table_entry_max = PATH_TABLE_ENTRY_MAX;
#endif

/* =========================
=========================================================================== */
//static uint8 fastpath_forward_flag = 1;		/* default: On */

#ifndef NO_ARP_USED
/* --- ARP Table Structures --- */
struct Arp_List_Entry
{
	uint8 vaild;
	ipaddr_t ip;
	ether_addr_t mac;
	enum ARP_FLAGS flags;
	CTAILQ_ENTRY(Arp_List_Entry) arp_link;
	CTAILQ_ENTRY(Arp_List_Entry) tqe_link;
};

struct Arp_Table
{
	CTAILQ_HEAD(Arp_list_entry_head, Arp_List_Entry) list[ARP_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Arp_list_inuse_head, Arp_List_Entry) arp_list_inuse;
CTAILQ_HEAD(Arp_list_free_head, Arp_List_Entry) arp_list_free;

struct Arp_Table *table_arp;
#endif

/* --- Route Table Structures --- */
struct Route_List_Entry
{
	uint8 vaild;
	ipaddr_t ip;
	ipaddr_t mask;
	ipaddr_t gateway;
	uint8 ifname[IFNAME_LEN_MAX];
	enum RT_FLAGS flags;
	CTAILQ_ENTRY(Route_List_Entry) route_link;
	CTAILQ_ENTRY(Route_List_Entry) tqe_link;
};

struct Route_Table
{
	//ROUTE_TABLE_LIST_MAX == 16
	CTAILQ_HEAD(Route_list_entry_head, Route_List_Entry) list[ROUTE_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Route_list_inuse_head, Route_List_Entry) route_list_inuse;
CTAILQ_HEAD(Route_list_free_head, Route_List_Entry) route_list_free;

struct Route_Table *table_route;

#ifndef DEL_NAPT_TBL
/* --- NAPT Table Structures --- */
struct Napt_List_Entry
{
	uint8 vaild;
	enum NP_PROTOCOL protocol;
	ipaddr_t	intIp;
	uint32		intPort;
	ipaddr_t	extIp;
	uint32		extPort;
	ipaddr_t	remIp;
	uint32		remPort;
	enum NP_FLAGS 	flags;
	CTAILQ_ENTRY(Napt_List_Entry) napt_link;
	CTAILQ_ENTRY(Napt_List_Entry) tqe_link;
};

struct Napt_Table
{
	CTAILQ_HEAD(Napt_list_entry_head, Napt_List_Entry) list[NAPT_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Napt_list_inuse_head, Napt_List_Entry) napt_list_inuse;
#ifdef PROC_MAX_CONNECTION_CTRL
CTAILQ_HEAD(Napt_list_free_head, Napt_List_Entry) napt_list_free, napt_list_tmp;
#else
CTAILQ_HEAD(Napt_list_free_head, Napt_List_Entry) napt_list_free;
#endif

struct Napt_Table *table_napt;
#endif // DEL_NAPT_TBL

/* --- PATH Table Structures --- */
struct Path_List_Entry
{
	uint8			vaild;	
	
	/*diff with sd2 port1 start*/
	enum NP_PROTOCOL	protocol;
	ipaddr_t		in_sIp;
	uint32			in_sPort;
	ipaddr_t		in_dIp;
	uint32			in_dPort;
	ipaddr_t		out_sIp;
	uint32			out_sPort;
	ipaddr_t		out_dIp;
	uint32			out_dPort;
	/*diff with sd2 port1 end*/
	uint32			last_used;
	uint8			*out_ifname;
#ifndef NO_ARP_USED
	struct Arp_List_Entry	*arp_entry;		/* for Out-dMac */
#endif
	uint8			course;			/* 1:In-Bonud 2:Out-Bound */
	struct dst_entry 	*dst;
	uint8			type;	
		
	CTAILQ_ENTRY(Path_List_Entry) path_link;
	CTAILQ_ENTRY(Path_List_Entry) tqe_link;
};
//============================================================================
#if 0
#define CTAILQ_HEAD(name, type)						\
struct name {\
	struct type *tqh_first;	/* first element */			\
	struct type **tqh_last;	/* addr of last next element */		\
	int tqh_count;\
}
#endif
//============================================================================
struct Path_Table
{
	//PATH_TABLE_LIST_MAX 1024,list OPath_Table
	CTAILQ_HEAD(Path_list_entry_head, Path_List_Entry) list[PATH_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Path_list_inuse_head, Path_List_Entry) path_list_inuse;
#ifdef PROC_MAX_CONNECTION_CTRL
CTAILQ_HEAD(Path_list_free_head, Path_List_Entry) path_list_free, path_list_tmp;
#else
CTAILQ_HEAD(Path_list_free_head, Path_List_Entry) path_list_free;
#endif

struct Path_Table *table_path;

#if 0
/* --- InterFace Table Structures --- */
struct If_List_Entry
{
	uint8			vaild;
	uint8			ifname[IFNAME_LEN_MAX];
	ipaddr_t		ipAddr;
	ether_addr_t	mac;
	uint32			mtu;
	enum IF_FLAGS	flags;
	CTAILQ_ENTRY(If_List_Entry) if_link;
	CTAILQ_ENTRY(If_List_Entry) tqe_link;
};

CTAILQ_HEAD(If_list_inuse_head, If_List_Entry) if_list_inuse;
CTAILQ_HEAD(If_list_free_head, If_List_Entry) if_list_free;
#endif

/* ==================================================================================================== */

#ifndef NO_ARP_USED
static uint32 FastPath_Hash_ARP_Entry(ipaddr_t ip)
{
	return (ip % 16);
}
#endif

static uint32
FastPath_Hash_ROUTE_Entry(ipaddr_t ip, ipaddr_t mask)
{
	int i;
	ipaddr_t tmp = (ip & mask);
	
	for(i=0; i<32; i++) {
		if (tmp & 0x00000001) {
			return (tmp + (uint32)i) % ROUTE_TABLE_LIST_MAX;
		}
		tmp = tmp >> 1;
	}
	
	return 0;
}

// david
#if 0
static uint32
FastPath_Hash_NAPT_Entry(ipaddr_t intIp,uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, int protoocal)
{
	uint32 hash;

	hash = (0xff000000 & intIp) >> 24;
	hash ^= (0x00ff0000 & intIp) >> 16;
	hash ^= (0x0000ff00 & intIp) >> 8;
	hash ^= (0x000000ff & intIp);
	hash ^= (0x0000ff00 & intPort) >> 8;
	hash ^= (0x000000ff & intPort);
	
	hash ^= (0xff000000 & extIp) >> 24;
	hash ^= (0x00ff0000 & extIp) >> 16;
	hash ^= (0x0000ff00 & extIp) >> 8;
	hash ^= (0x000000ff & extIp);
	hash ^= (0x0000ff00 & extPort) >> 8;
	hash ^= (0x000000ff & extPort);

	hash ^= (0xff000000 & remIp) >> 24;
	hash ^= (0x00ff0000 & remIp) >> 16;
	hash ^= (0x0000ff00 & remIp) >> 8;
	hash ^= (0x000000ff & remIp);
	hash ^= (0x0000ff00 & remPort) >> 8;
	hash ^= (0x000000ff & remPort);
	
	return 0x000003ff & (hash ^ (hash >> 12));
}
#endif

#ifndef DEL_NAPT_TBL
static uint32
FastPath_Hash_NAPT_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol)
{
	register uint32 hash;	
	
	hash = ((sip>>16)^sip);	
	hash ^= ((dip>>16)^dip);	
	hash ^= sport;	
	hash ^= dport;	
	hash ^= protocol;
	return ((NAPT_TABLE_LIST_MAX - 1) & (hash ^ (hash >> 12)));
}
#endif

__IRAM_GEN inline static uint32
FastPath_Hash_PATH_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol)
{
	register uint32 hash;

// david ------------------------------	
#if 0
	hash = ((sip>>16)^sip);
	hash ^= ((dip>>16)^dip);
	hash ^= sport;
	hash ^= dport;	
	return 0x000003ff & (hash ^ (hash >> 12));
#endif
	hash = ((sip>>8)^sip);
	hash ^= ((dip>>16)^dip);
	hash ^= sport>>4;
	hash ^= dport;	
	hash ^= protocol;
	return (PATH_TABLE_LIST_MAX-1) & (hash ^ (hash >> 12));
//-------------------------------------

}


/* ====================================================================== */

#if 0
enum LR_RESULT
rtk_addFdbEntry(uint32 vid,
		uint32 fid,
		ether_addr_t* mac,
		uint32 portmask,
		enum FDB_FLAGS flags)
{
	DEBUGP_API("addFdbEntry: vid=%u fid=%u mac=%p portmask=0x%08X flasg=0x%08X \n", vid, fid, mac, portmask, flags);
	
	return LR_SUCCESS;
}

enum LR_RESULT
rtk_delFdbEntry(uint32 vid,
		uint32 fid,
		ether_addr_t* mac)
{
	DEBUGP_API("delFdbEntry: vid=%u fid=%u mac=%p \n", vid, fid, mac);
	
	return LR_SUCCESS;
}
#endif
/*======================================================================= */
enum LR_RESULT
rtk_addArp(ipaddr_t ip,
		ether_addr_t* mac,
		enum ARP_FLAGS flags)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("addArp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X Hash=%u \n", ip, MAC2STR(*mac), flags, hash);
	
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
		//	DEBUGP_SYS("addArp: ERROR - arp(ip=0x%08X) already exist! \n", ip);
			return LR_EXIST;
		}
	}
	
	/* Create */
	if(!CTAILQ_EMPTY(&arp_list_free)) {
		struct Arp_List_Entry *entry_arp;
		entry_arp = CTAILQ_FIRST(&arp_list_free);
		entry_arp->ip = ip;
		entry_arp->mac = *mac;
		entry_arp->flags = flags;
		entry_arp->vaild = 0xff;
		CTAILQ_REMOVE(&arp_list_free, entry_arp, tqe_link);
		CTAILQ_INSERT_TAIL(&arp_list_inuse, entry_arp, tqe_link);
		CTAILQ_INSERT_TAIL(&table_arp->list[hash], entry_arp, arp_link);
	} else {
		DEBUGP_SYS("addArp: ERROR - arp_list_free is empty! \n");
		return LR_FAILED;
	}
#endif	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_modifyArp(ipaddr_t ip,
		ether_addr_t* mac,
		enum ARP_FLAGS flags)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("modifyArp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X \n", ip, MAC2STR(*mac), flags);
	
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
			ep->mac = *mac;
			ep->flags = flags;
			
			return LR_SUCCESS;
		}
	}
#endif
	return LR_SUCCESS;
}
/*======================================================================= */
/*
	delArp() - Delete an entry of Arp Table.
*/
enum LR_RESULT
rtk_delArp(ipaddr_t ip)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("delArp: ip=0x%08X \n", ip);
	
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
			ep->vaild = 0x00;
			CTAILQ_REMOVE(&table_arp->list[hash], ep, arp_link);
			CTAILQ_REMOVE(&arp_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&arp_list_free, ep, tqe_link);
			
			return LR_SUCCESS;
		}
	}
#endif
	return LR_NONEXIST;
}
/*======================================================================= */
enum LR_RESULT
rtk_addRoute(ipaddr_t ip,
		ipaddr_t mask,
		ipaddr_t gateway,
		uint8* ifname,
		enum RT_FLAGS flags)
{
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	
	DEBUGP_API("addRoute: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%s flags=0x%08X Hash=%u \n", 
		ip, mask, gateway, ifname, flags, hash);
	
	if(!CTAILQ_EMPTY(&route_list_free)) {
		struct Route_List_Entry *entry_route;
		entry_route = CTAILQ_FIRST(&route_list_free);
		entry_route->ip = ip;
		entry_route->mask = mask;
		entry_route->gateway = gateway;
		memcpy(&entry_route->ifname, ifname, IFNAME_LEN_MAX - 1);
		entry_route->flags = flags;
		entry_route->vaild = 0xff;
		CTAILQ_REMOVE(&route_list_free, entry_route, tqe_link);
		CTAILQ_INSERT_TAIL(&route_list_inuse, entry_route, tqe_link);
		CTAILQ_INSERT_TAIL(&table_route->list[hash], entry_route, route_link);
	} else {
		DEBUGP_SYS("addRoute: ERROR - Route_list_free is empty! \n");		
		return LR_FAILED;
	}
	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_modifyRoute(ipaddr_t ip,
		ipaddr_t mask,
		ipaddr_t gateway,
		uint8* ifname,
		enum RT_FLAGS flags)
{
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	struct Route_List_Entry *ep;
	
	DEBUGP_API("modifyRoute: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%s flags=0x%08X \n", 
		ip, mask, gateway, ifname, flags);
		
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_route->list[hash], route_link) {
		if (ep->ip == ip && ep->mask == mask) {
			ep->gateway = gateway;
			memcpy(&ep->ifname, ifname, IFNAME_LEN_MAX - 1);
			ep->flags = flags;
			CTAILQ_REMOVE(&table_route->list[hash], ep, route_link);
			CTAILQ_REMOVE(&route_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&route_list_free, ep, tqe_link);
			
			return LR_SUCCESS;
		}
	}
	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_delRoute(ipaddr_t ip, ipaddr_t mask)
{
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	struct Route_List_Entry *ep;
	
	DEBUGP_API("delRoute: ip=0x%08X mask=0x%08X \n", ip, mask);
	
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_route->list[hash], route_link) {
		if (ep->ip == ip && ep->mask == mask) {
			ep->vaild = 0x00;
			CTAILQ_REMOVE(&table_route->list[hash], ep, route_link);
			CTAILQ_REMOVE(&route_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&route_list_free, ep, tqe_link);
			
			return LR_SUCCESS;
		}
	}
	
	return LR_NONEXIST;
}
/*======================================================================= */
enum LR_RESULT
rtk_addSession(uint8* ifname,
		enum SE_TYPE seType,
		uint32 sessionId,
		enum SE_FLAGS flags )
{
	return LR_SUCCESS;
}

enum LR_RESULT
rtk_delSession(uint8* ifname)
{
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT 
rtk_addNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort,		
		enum NP_FLAGS flags)
{
// david
//	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, extIp, extPort, remIp, remPort);
#ifndef DEL_NAPT_TBL
	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, remIp, remPort, (uint16)protocol);
	struct Napt_List_Entry *ep;
#endif	
	uint16 ipprotocol;
	
#if 0	/* FastPath DONT check */
	if (intIp == exitIp && intPort == extPort && !LocalPublicIP_CHECK(intIp))
		return LR_FAILED;
#endif

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;
	
	DEBUGP_API("addNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u F=%d (Ha=%u, Hb=%u)\n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort, flags, 
		FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol), FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort,ipprotocol));

#ifdef DOS_FILTER
	filter_addconnect(remIp);
#endif

#ifndef DEL_NAPT_TBL
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_napt->list[hash], napt_link) {
		if ((ep->protocol == protocol) &&
			(ep->intIp == intIp) &&
			(ep->intPort == intPort) &&
			(ep->extIp == extIp) &&
			(ep->extPort == extPort) &&
			(ep->remIp == remIp) &&
			(ep->remPort == remPort)) {
			//DEBUGP_SYS("addNaptConnection: ERROR - the entry already exist! \n");			
			return LR_SUCCESS;
		}
	}

	if(!CTAILQ_EMPTY(&napt_list_free)) {
		
		struct Napt_List_Entry *entry_napt;
		entry_napt = CTAILQ_FIRST(&napt_list_free);
		entry_napt->protocol = protocol;
		entry_napt->intIp = intIp;
		entry_napt->intPort = intPort;
		entry_napt->extIp = extIp;
		entry_napt->extPort = extPort;
		entry_napt->remIp = remIp;
		entry_napt->remPort = remPort;
		entry_napt->flags = flags;
		entry_napt->vaild = 0xff;
		CTAILQ_REMOVE(&napt_list_free, entry_napt, tqe_link);
		CTAILQ_INSERT_TAIL(&napt_list_inuse, entry_napt, tqe_link);
		CTAILQ_INSERT_TAIL(&table_napt->list[hash], entry_napt, napt_link);
#else
	if (1) {
#endif
		
		/*===================add Path Table Entry=====================*/
		uint32	hash;
		struct Path_List_Entry *entry_path;
		
		/* course = 1 (Outbound) */
		hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
		
		if(!CTAILQ_EMPTY(&path_list_free)) {    //brad modify 2007-11-27
			
		entry_path = CTAILQ_FIRST(&path_list_free);
		
		entry_path->protocol	= protocol;
		entry_path->in_sIp	= intIp;
		entry_path->in_sPort	= intPort;
		entry_path->in_dIp	= remIp;
		entry_path->in_dPort	= remPort;
		entry_path->out_sIp	= extIp;
		entry_path->out_sPort	= extPort;
		entry_path->out_dIp	= remIp;
		entry_path->out_dPort	= remPort;
		
		entry_path->out_ifname	= FastPath_Route(entry_path->out_dIp);
#ifndef NO_ARP_USED
		entry_path->arp_entry	= NULL;
#endif
		entry_path->course		= 1;
		entry_path->vaild		= 0xff;
		entry_path->dst			= NULL;		
		entry_path->type		= 0;	/* Init: Normal (Only Routing) */				
		if (entry_path->in_sIp != entry_path->out_sIp) {
			entry_path->type |= 1;	// SNAT 
		}
		if (entry_path->in_sPort != entry_path->out_sPort) {
			entry_path->type |= 2;	// SNPT 
		}		
		
		CTAILQ_REMOVE(&path_list_free, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&path_list_inuse, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&table_path->list[hash], entry_path, path_link);
		}//else{
		//	printk("<<<----DEBUG course 1 got NULL ---->>>>>>\n");
		//}
		/* course = 2 (Inbound) */
		hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
		
		if(!CTAILQ_EMPTY(&path_list_free)) {    //brad modify 2007-11-27
		entry_path = CTAILQ_FIRST(&path_list_free);
		entry_path->protocol	= protocol;
		entry_path->in_sIp	= remIp;
		entry_path->in_sPort	= remPort;
		entry_path->in_dIp	= extIp;
		entry_path->in_dPort	= extPort;
		entry_path->out_sIp	= remIp;
		entry_path->out_sPort	= remPort;
		entry_path->out_dIp	= intIp;
		entry_path->out_dPort	= intPort;
		
		entry_path->out_ifname	= FastPath_Route(entry_path->out_dIp);
#ifndef NO_ARP_USED
		entry_path->arp_entry	= NULL;
#endif
		entry_path->course	= 2;
		entry_path->vaild	= 0xff;
		entry_path->dst		= NULL;
				
		entry_path->type	= 0;	/* Init: Normal (Only Routing) */				
		if (entry_path->in_dIp != entry_path->out_dIp) {
			entry_path->type |= 4;	// DNAT 
		}
		if (entry_path->in_dPort != entry_path->out_dPort) {
			entry_path->type |= 8;	// DNPT
		}		
		
		CTAILQ_REMOVE(&path_list_free, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&path_list_inuse, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&table_path->list[hash], entry_path, path_link);
		}//else{
		//	printk("<<<----DEBUG course 2 got NULL ---->>>>>>\n");
		//}
		/*===================add Path Table Entry=====================*/	
		
	} else {
		DEBUGP_SYS("addNaptConnection: ERROR - Napt_list_free is empty! \n");		
		return LR_FAILED;
	}
	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT 
rtk_delNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort)
{
// david
//	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, extIp, extPort, remIp, remPort);
#ifndef DEL_NAPT_TBL
	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, remIp, remPort, (uint16)protocol);
	struct Napt_List_Entry *ep;
#endif	
	uint16 ipprotocol;
	
	DEBUGP_API("delNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u \n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort);

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;

#ifdef DOS_FILTER
	filter_delconnect(remIp);
#endif

#ifndef DEL_NAPT_TBL
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_napt->list[hash], napt_link) {
		if ((ep->protocol == protocol) &&
			(ep->intIp == intIp) &&
			(ep->intPort == intPort) &&
			(ep->extIp == extIp) &&
			(ep->extPort == extPort) &&
			(ep->remIp == remIp) &&
			(ep->remPort == remPort)) {
			ep->vaild = 0x00;
			CTAILQ_REMOVE(&table_napt->list[hash], ep, napt_link);
			CTAILQ_REMOVE(&napt_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&napt_list_free, ep, tqe_link);
#else
	if (1) { {		
#endif		
			/* del Path Table Entry */

			uint32	hash;
			struct Path_List_Entry *entry_path;
		
			/* course = 1 (Outbound) */
			hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
			CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {

// Remove entry only when ip/port are matched ---------------------
//				if ((entry_path->protocol == ep->protocol) && (entry_path->course == 1)){
				if ((entry_path->protocol == protocol) &&
					(entry_path->course == 1)	&&		
					(entry_path->in_sIp == intIp) &&
					(entry_path->in_sPort == intPort) &&
					(entry_path->out_sIp == extIp) &&
					(entry_path->out_sPort == extPort) &&
					(entry_path->in_dIp == remIp) &&
					(entry_path->in_dPort == remPort)) {

					if (entry_path->dst) {
						//dst_release(entry_path->dst);	 //brad debug					
						entry_path->dst->dst_cache = NULL;				
						entry_path->dst = NULL;	
					}					
//-------------------------------------------- david+2007-05-28

					entry_path->vaild = 0x00;
					CTAILQ_REMOVE(&table_path->list[hash], entry_path, path_link);
					CTAILQ_REMOVE(&path_list_inuse, entry_path, tqe_link);
					CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
					break;
				}
			}
		
			/* course = 2 (Inbound) */
			hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
			CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {

// Remove entry only when ip/port are matched ---------------------
//				if ((entry_path->protocol == ep->protocol) && (entry_path->course == 2)){
				if ((entry_path->protocol == protocol) &&
					(entry_path->course == 2)	&&		
					(entry_path->in_dIp == extIp) &&
					(entry_path->in_dPort == extPort) &&
					(entry_path->out_sIp == remIp)  &&
					(entry_path->out_sPort	== remPort) &&
					(entry_path->out_dIp== intIp) &&
					(entry_path->out_dPort	== intPort)) {		
					
					if (entry_path->dst) {
						//dst_release(entry_path->dst);		 //brad debug		
						entry_path->dst->dst_cache = NULL; 
						entry_path->dst = NULL;
					}
//-------------------------------------------- david+2007-05-28
					entry_path->vaild = 0x00;
					CTAILQ_REMOVE(&table_path->list[hash], entry_path, path_link);
					CTAILQ_REMOVE(&path_list_inuse, entry_path, tqe_link);
					CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
					break;
				}
			}			
			
			return LR_SUCCESS;
		}
	}
	
	return LR_NONEXIST;
}

enum LR_RESULT
rtk_idleNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort,
		uint32 interval)
{
	uint16 ipprotocol;
	uint32 hash, now, last_used;
	struct Path_List_Entry *entry_path;
	
	now = jiffies;
	DEBUGP_API("rtk_idleNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u \n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort);

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;

	/* course = 1 (Outbound) */
	hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
		if ((entry_path->protocol == protocol) &&
			(entry_path->course == 1)	&&		
			(entry_path->in_sIp == intIp) &&
			(entry_path->in_sPort == intPort) &&
			(entry_path->out_sIp == extIp) &&
			(entry_path->out_sPort == extPort) &&
			(entry_path->in_dIp == remIp) &&
			(entry_path->in_dPort == remPort)) {
			last_used = entry_path->last_used;
			if (time_before((now - interval), last_used))
				return LR_FAILED;
			break;
		}
	}
	
	/* course = 2 (Inbound) */
	hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
		if ((entry_path->protocol == protocol) &&
			(entry_path->course == 2)	&&		
			(entry_path->in_dIp == extIp) &&
			(entry_path->in_dPort == extPort) &&
			(entry_path->out_sIp == remIp)  &&
			(entry_path->out_sPort	== remPort) &&
			(entry_path->out_dIp== intIp) &&
			(entry_path->out_dPort	== intPort)) {		
			last_used = entry_path->last_used;
			if (time_before((now - interval), last_used))
				return LR_FAILED;
			break;
		}
	}			
	
	return LR_SUCCESS;
}

/* ==================================================================================================== */
uint8 *
FastPath_Route(ipaddr_t dIp)
{
	uint8 *ifname = NULL;
	uint32 mask_max = 0x0;
	struct Route_List_Entry *ep;
	
	/* Lookup */
	CTAILQ_FOREACH(ep, &route_list_inuse, tqe_link) {
		if ((ep->mask >= mask_max) && ((dIp & ep->mask) == ep->ip)) {
			ifname = &ep->ifname[0];
			mask_max = ep->mask;
		}
	}
	
	return ifname;
}


/* ==================================================================================================== */
#ifdef INVALID_PATH_BY_FIN
static void mark_path_invalid(uint32 sIp, uint16 sPort, uint32 dIp, uint16 dPort, uint16 iphProtocol)
{
	struct Path_List_Entry *entry_path;
	uint32 hash;
	uint32 extIp=0;
	uint16 extPort=0;

	hash = FastPath_Hash_PATH_Entry(sIp, sPort, dIp, dPort, iphProtocol);	

	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {					
		if ((entry_path->in_sPort == sPort) && 
				(entry_path->in_dPort == dPort) && 
				(entry_path->in_sIp == sIp) &&
				(entry_path->in_dIp == dIp) &&
				(entry_path->vaild == 0xff)) {				
			entry_path->vaild = 0x00;
			if (entry_path->course == 1) {
				extIp = entry_path->out_sIp;
				extPort = entry_path->out_sPort;			
			}
			else {
				extIp = entry_path->out_dIp;
				extPort = entry_path->out_dPort;	
			}	
			break;
		}
	}
	if (extIp == 0)
		return;

	if (entry_path->course == 1)
		hash = FastPath_Hash_PATH_Entry(dIp, dPort, extIp, extPort, iphProtocol);
	else
		hash = FastPath_Hash_PATH_Entry(extIp, extPort, sIp, sPort, iphProtocol);
	
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {		
		if ((entry_path->out_sIp == dIp) &&
				(entry_path->out_sPort == dPort) &&		
				(entry_path->out_dIp == sIp) &&
				(entry_path->out_dPort == sPort) &&
				(entry_path->vaild == 0xff)) 				
			entry_path->vaild = 0x00;					
	}
}
#endif // INVALID_PATH_BY_FIN

/* ==================================================================================================== */
        /* cached hardware header; allow for machine alignment needs.        */
#define HH_DATA_MOD     16
#define HH_DATA_ALIGN(__len) \
        (((__len)+(HH_DATA_MOD-1))&~(HH_DATA_MOD - 1))

static inline int ip_finish_output3(struct sk_buff *skb)
{
	struct dst_entry *dst = skb->dst;
	struct hh_cache *hh = dst->hh;

#ifdef CONFIG_NET_QOS
    if (gQosEnabled) {
        extern struct ipt_table packet_mangler;
		u_short proto = ntohs(skb->protocol);
		if(proto == ETH_P_IP){
			(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
				ipt_do_table(&skb, NF_IP_POST_ROUTING, skb->dev, NULL, \
				&packet_mangler, NULL);	
		}
    }        
#endif	

	if (hh) {
// ------------------------------------------------
#if 0		
		int hh_alen;
		
		read_lock_bh(&hh->hh_lock);
		hh_alen = HH_DATA_ALIGN(hh->hh_len);
  		memcpy(skb->data - hh_alen, hh->hh_data, hh_alen);
		read_unlock_bh(&hh->hh_lock);
	        skb_push(skb, hh->hh_len);
		return hh->hh_output(skb);
#endif
		memcpy(skb->data - 16, hh->hh_data, 16);
		skb_push(skb, hh->hh_len);

#ifdef FAST_L2TP		
		if (fast_l2tp_fw)
			l2tp_tx_id(skb);
#endif		

		if (skb->dev->flags & IFF_UP) {
#ifdef CONFIG_NET_QOS
			if (gQosEnabled) {
				// call dev_queue_xmit() instead of hard_start_xmit(), because I want the packets be sent through Traffic Control module
				dev_queue_xmit(skb);
				return 0;	
			} else            
#endif            
			{
			if (!skb->dev->hard_start_xmit(skb,skb->dev))
				return 0;	
			}            
		}
//------------------------------- david+2007-05-25

	} else if (dst->neighbour) {
		return dst->neighbour->output(skb);
	}
	
	if (net_ratelimit())
		printk(KERN_DEBUG "ip_finish_output3: No header cache and no neighbour!\n");
	kfree_skb(skb);
	return -EINVAL;
}


__IRAM_GEN static int
enter_fast_path(struct sk_buff *skb)	/* Ethertype = 0x0800 (IP Packet) */
{
	
	struct iphdr *iph;	
	uint32 sIp,dIp;
	uint32 hash;
	struct tcphdr *tcphupuh;  //just keep one , don't care tcp or udp //
	struct Path_List_Entry *entry_path;
	uint16 sPort=0,dPort=0, iphProtocol;
	int has_inc_dst_ref_cnt=0; // david
//brad add for l2tp 2008/01/21
	struct net_device *l2tprx_dev=NULL;
	struct in_device *skbIn_dev=NULL;
	struct net_device *skbNetDevice=NULL;
	//--------------------------------------------

// check if skb len and protocol type in advance --
	if (skb->len < sizeof(struct iphdr)+ sizeof(struct tcphdr))	
		return 0;
	u8 protocol = *(((unsigned char *)skb->nh.iph) + (int)(&((struct iphdr *)0)->protocol));
	if (protocol != IPPROTO_TCP && protocol != IPPROTO_UDP)
		return 0;				
//--------------------------------- david+2007-08-25
//brad add for l2tp 2008/01/21
	if(fast_l2tp_fw){
		l2tprx_dev = skb->dev;
		skbIn_dev = (struct in_device *)skb->dev->ip_ptr;
		if(skbIn_dev == NULL){
			if ((skbNetDevice = __dev_get_by_name(l2tprx_dev->name)) != NULL){
				if((skbIn_dev=__in_dev_get(skbNetDevice)) != NULL) 
					skb->dev->ip_ptr = (void *)skbIn_dev;
			}
		}
	}
//------------------------------------
	iph = skb->nh.iph;
	sIp = iph->saddr;
	dIp = iph->daddr;	
	iphProtocol = iph->protocol;	

#ifdef CONFIG_NET_QOS
    if (gQosEnabled) {
        extern struct ipt_table packet_mangler;
		u_short proto = ntohs(skb->protocol);
		if(proto == ETH_P_IP){
			(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
				ipt_do_table(&skb, NF_IP_PRE_ROUTING, skb->dev, NULL, \
				&packet_mangler, NULL);	
		}
    }
#endif
	//====			
	tcphupuh = (struct tcphdr*)((__u32 *)iph + iph->ihl);
	sPort = tcphupuh->source;
	dPort = tcphupuh->dest;	
	//====
	switch (iph->protocol) {
		case IPPROTO_TCP: {		
			
			DEBUGP_PKT("==>> [%08X, %08X] SIP: %u.%u.%u.%u:%u  (%s) -> DIP: %u.%u.%u.%u:%u \n", 
				skb->csum, tcphupuh->check,
				NIPQUAD(iph->saddr), tcphupuh->source, skb->dev->name,
				NIPQUAD(iph->daddr), tcphupuh->dest);
			
			/* DONT care now! */
			if (!strcmp(skb->dev->name, "lo")) return 0;
#ifdef INVALID_PATH_BY_FIN
				if (tcphupuh->fin) {
					mark_path_invalid(sIp, sPort, dIp, dPort, iphProtocol);
					return 0;	
			}
#endif	
			if (tcphupuh->fin || tcphupuh->rst || tcphupuh->syn) return 0;		
			break;
		}
		case IPPROTO_UDP: {					
			DEBUGP_PKT("==>> [%08X, %08X] SIP: %u.%u.%u.%u:%u  (%s) -> DIP: %u.%u.%u.%u:%u <UDP> #0x%x\n", 
				skb->csum, tcphupuh->check,
				NIPQUAD(iph->saddr), tcphupuh->source, skb->dev->name,
				NIPQUAD(iph->daddr), tcphupuh->dest, iph->frag_off);
			
			/* DONT care now! */
			if (!strcmp(skb->dev->name, "lo")) return 0;
			if (iph->frag_off & 0x3fff) return 0;	/* Ignore fragment */		
			break;
		}
		default: {		
			return 0;
		}
	}
	//================
	
	hash = FastPath_Hash_PATH_Entry(sIp, sPort, dIp, dPort, iphProtocol);
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
			
		if ((entry_path->in_sPort == sPort) && 
			(entry_path->in_dPort == dPort) && 
			(entry_path->in_sIp == sIp) &&
			(entry_path->in_dIp == dIp) &&
			(entry_path->vaild == 0xff) && //david
			((entry_path->protocol == NP_TCP)||(entry_path->protocol == NP_UDP)))
		{
			uint16	*l4Check;
#ifndef NO_ARP_USED
			/* ARP Cache check */			
#ifndef FAST_L2TP
			if (entry_path->arp_entry && entry_path->arp_entry->vaild &&
				 (entry_path->arp_entry->ip == entry_path->out_dIp)) 
#else		
			int to_ppp0 = 0;
			if (fast_l2tp_fw && skb->dev && !memcmp(skb->dev->name, "br0", 3)) {				
				if (entry_path->dst == NULL) {
					if (ip_route_input(skb, entry_path->out_dIp, iph->saddr, iph->tos, skb->dev))
						return 0;					
					entry_path->dst = skb->dst;
					has_inc_dst_ref_cnt = 1;					
				}
				if (entry_path->dst->input != &ip_local_deliver)
					to_ppp0 = 1;	
			}				
			if (to_ppp0 ||
				(entry_path->arp_entry && entry_path->arp_entry->vaild &&
					 (entry_path->arp_entry->ip == entry_path->out_dIp)))

#endif	
#endif
			{				
				/* ARP Cache valid */
				if (entry_path->dst == NULL) {
					if(ip_route_input(skb, entry_path->out_dIp, iph->saddr, iph->tos, skb->dev))
						return 0;
					entry_path->dst = skb->dst;
					//dst_hold(skb->dst);  //brad denug
					skb->dst->dst_cache = &entry_path->dst; //brad for debug
					
					has_inc_dst_ref_cnt = 1;					
				} else 
					skb->dst = entry_path->dst;				
				
// check if dst output is ok ----------------------------------------
				if ( !(skb->dst->hh || skb->dst->neighbour)  ||
							skb->len > skb->dst->pmtu)  {	
					//if (has_inc_dst_ref_cnt) //brad debug
					//	dst_release(skb->dst);	//brad debug			
					
					entry_path->dst = NULL;
					skb->dst = NULL;					
					return 0;				
				}				

				if (!has_inc_dst_ref_cnt) {
					//dst_hold(skb->dst);		//brad debug 	
					skb->dst->lastuse = jiffies;					
				}
//---------------------------------------------- david+2007-05-18				
	
				if (entry_path->protocol == NP_TCP)
				{
					/* tcp */
					l4Check = &(((struct tcphdr *)tcphupuh)->check);
				} 
				else
				{
					/* udp */
					l4Check = &(((struct udphdr *)tcphupuh)->check);
				}
				DEBUGP_PKT("Type[%d] FORWARD to [%s] [%s]\n", entry_path->type, entry_path->out_ifname, skb->dst->dev->name);
				switch(entry_path->type) {
				case 0:	{	/* Only Routing */
					break;
				}
				case 1:	{	/* SNAT */
									
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, skb->nh.iph->saddr, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, skb->nh.iph->saddr, *l4Check);
					skb->nh.iph->saddr = entry_path->out_sIp;
					break;
				}
				case 2:	/* SNPT */
				case 3:	{	/* SNAPT */
// Modify by Cathy suggestion,  david+2007-07-17								
//				FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, skb->nh.iph->saddr, entry_path->out_sPort, tcphupuh->source, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, skb->nh.iph->saddr, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, skb->nh.iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
					skb->nh.iph->saddr	= entry_path->out_sIp;
					tcphupuh->source		= entry_path->out_sPort;
					break;
				}
				case 4: {	/* DNAT */
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, skb->nh.iph->daddr, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, skb->nh.iph->daddr, *l4Check);
					skb->nh.iph->daddr	= entry_path->out_dIp;
					break;
				}
				case 8: /* DNPT */
				case 12: {	/* DNAPT */
// Modify by Cathy suggestion,  david+2007-07-17	
//				FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, skb->nh.iph->daddr, entry_path->out_dPort, tcphupuh->dest, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, skb->nh.iph->daddr, iph->check);				
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, skb->nh.iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);
					skb->nh.iph->daddr	= entry_path->out_dIp;
					tcphupuh->dest		= entry_path->out_dPort;
					break;
				}
				default: {
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, skb->nh.iph->saddr, entry_path->out_sPort, tcphupuh->source, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, skb->nh.iph->daddr, entry_path->out_dPort, tcphupuh->dest, iph->check);
																	
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, skb->nh.iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, skb->nh.iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);						
					
					skb->nh.iph->saddr	= entry_path->out_sIp;
					tcphupuh->source	= entry_path->out_sPort;
					skb->nh.iph->daddr	= entry_path->out_dIp;
					tcphupuh->dest		= entry_path->out_dPort;
					break;
				}
				}								
				skb->ip_summed = 0x0;				
				skb->dev = skb->dst->dev;			
				entry_path->last_used = jiffies;
#ifdef FAST_L2TP
				if (fast_l2tp_fw && skb->dev && !memcmp(skb->dev->name, "ppp0", 4) ) {
					if (fast_l2tp_to_wan(skb)) // success
						return NET_RX_DROP; 				
				}
#endif				
				ip_finish_output3(skb);
				return NET_RX_DROP;
			}
#ifndef NO_ARP_USED
			else {
				/* Arp Cache update */
				struct Arp_List_Entry *ep;
				uint32 hash = FastPath_Hash_ARP_Entry(entry_path->out_dIp);				
				CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) 
				{
					if (ep->ip == entry_path->out_dIp) {
						entry_path->arp_entry = ep;
						return 0;
					}
				}
			}
#endif
			break;
		}
	}			
	//===============================================================================	
	//===============================================================================
	return 0;
}


int FastPath_Enter(struct sk_buff **pskb)
{
	int ret;
	struct sk_buff *skb=*pskb;

	if (!fast_nat_fw)
		return 0;

	skb->h.raw = skb->nh.raw = skb->data;
#ifdef FILTER_UPNP_BR
		if (upnp_br_enabled && skb->dev && !memcmp(skb->dev->name, "eth1", 4) && filter_upnp_and_fw(skb)){
			printk("broadcast UDP\n");
			return 1;  	
		}
#endif

#if defined (DOS_FILTER) || defined (URL_FILTER) 
	ret = filter_enter(skb);
	if (ret == NF_DROP) {
		kfree_skb(skb);
		return 1;
	}
	if (ret != NF_ACCEPT)
		return 0;
#endif

#ifdef FAST_PPTP	
	if (fast_pptp_fw) {
		fast_pptp_filter(skb);
		ret = fast_pptp_to_lan(&skb);
		if (ret < 0)	// error, skb has been free
			return 1;	
		*pskb=skb;
	}	
#endif

#ifdef FAST_L2TP
	if (fast_l2tp_fw) 
		fast_l2tp_rx(skb);
#endif
//Brad disable
#if 0
	if (flush_table) {
		flush_all_table();
		flush_table = 0;
	}
#endif				
	ret = enter_fast_path(skb);

#ifdef FAST_PPTP
	if (fast_pptp_fw && ret == 0 && skb->nh.iph->protocol == IPPROTO_GRE && skb->len > sizeof(struct iphdr)) 
		fast_pptp_sync_rx_seq(skb);
#endif

	return ret;
}


int
FastPath_Track(struct sk_buff *skb)
{
#if 0
	struct iphdr *iph;
	__u32 sip,dip;
	__u16 sport=0,dport=0;
	
	if (skb->nh.iph) {
		iph = skb->nh.iph;
		sip = iph->saddr;
		dip = iph->daddr;
		
		switch (iph->protocol) {
		case IPPROTO_TCP: { /* TCP */
			struct tcphdr *tcph;
			tcph = (struct tcphdr*)((__u32 *)iph + iph->ihl);
			sport = tcph->source;
			dport = tcph->dest;
			DEBUGP_PKT("<<== [%08X, %08X] SIP: %u.%u.%u.%u:%u -> DIP: %u.%u.%u.%u:%u (%s) \n", 
				skb->csum, tcph->check,
				NIPQUAD(sip), tcph->source,
				NIPQUAD(dip), tcph->dest, skb->dst->dev->name);
			break;
		}
		case IPPROTO_UDP: { /* UDP */
			struct udphdr *udph;
			udph = (struct udphdr*)((__u32 *)iph + iph->ihl);
			sport = udph->source;
			dport = udph->dest;
			DEBUGP_PKT("<<== [%08X, %08X] SIP: %u.%u.%u.%u:%u -> DIP: %u.%u.%u.%u:%u (%s) \n", 
				skb->csum, udph->check,
				NIPQUAD(sip), udph->source,
				NIPQUAD(dip), udph->dest, skb->dst->dev->name);
			break;
		}
		default:
			break;
		}
		
	}
#endif	
	return 0;
}

#ifdef	DEBUG_PROCFILE
/*
static int fastpath_forward_proc(char *buffer, char **start, off_t offset, int length)
{
	int len=0;
	len += sprnitf(buffer + len, "%d\n", fastpath_forward_flag);
	return len;
}
*/

#ifndef NO_ARP_USED
static int fastpath_table_arp(char *buffer, char **start, off_t offset, int length)
{
	struct Arp_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &arp_list_inuse, tqe_link) {
		len += sprintf(buffer + len, "~Arp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X \n", ep->ip, MAC2STR(ep->mac), ep->flags);
	}
	
	return len;
}
#endif

static int fastpath_table_route(char *buffer, char **start, off_t offset, int length)
{
	struct Route_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &route_list_inuse, tqe_link) {
		len += sprintf(buffer + len, "~Route: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%-5s flags=0x%08X \n", 
			ep->ip, ep->mask, ep->gateway, ep->ifname, ep->flags);
	}
	
	return len;
}

#ifndef DEL_NAPT_TBL
static int fastpath_table_napt(char *buffer, char **start, off_t offset, int length)
{
	struct Napt_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &napt_list_inuse, tqe_link) {
		len += sprintf(buffer + len, "~Napt: [%s] int=0x%08X:%-5u ext=0x%08X:%-5u rem=0x%08X:%-5u flags=0x%08X \n", 
			ep->protocol == NP_TCP ? "TCP" : "UDP",
			ep->intIp, ep->intPort, ep->extIp, ep->extPort, ep->remIp, ep->remPort,
			ep->flags);
	}
	
	return len;
}
#endif

static int fastpath_table_path(char *buffer, char **start, off_t offset, int length)
{
	struct Path_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &path_list_inuse, tqe_link) {
		len += sprintf(buffer + len, "~Path: [%s] in-S=0x%08X:%-5u in-D=0x%08X:%-5u out-S=0x%08X:%-5u out-D=0x%08X:%-5u out-ifname=%-5s <%u> {%d}\n", 
			ep->protocol == NP_TCP ? "TCP" : "UDP",
			ep->in_sIp, ep->in_sPort, ep->in_dIp, ep->in_dPort,
			ep->out_sIp, ep->out_sPort, ep->out_dIp, ep->out_dPort,
			ep->out_ifname, ep->course, ep->type);
	}
	
	return len;
}

static int fastpath_hash_path(char *buffer, char **start, off_t offset, int length)
{
	int i, len=0;
	
	for (i=0; i<PATH_TABLE_LIST_MAX; i++) {
		len += sprintf(buffer + len, "%5d ", CTAILQ_TOTAL(&table_path->list[i]));
		if (i%12 == 11) len += sprintf(buffer + len, "\n");
	}
	len += sprintf(buffer + len, "\n");	
	
	return len;
}

#endif	/* DEBUG_PROCFILE */

//======================================
// Flush napt and path table when re-init, david+2007-05-28
//((struct Path_List_Entry *)en)->dst->dst_cache = NULL;	\   //brad move here for debug
#define FLUSH_TBL(type, list_inuse, list_free, tbl, link, max, is_path) { \
	int i; \
	struct type *en;	\
	for (i=0; i<max; i++) { \
		CTAILQ_FOREACH(en, &tbl->list[i], link) { \
			if (is_path) { \
				if (((struct Path_List_Entry *)en)->dst) { \
					((struct Path_List_Entry *)en)->dst->dst_cache = NULL;	\
					((struct Path_List_Entry *)en)->dst = NULL; \
				} \
				((struct Path_List_Entry *)en)->vaild = 0x00; \
			} \
			CTAILQ_REMOVE(&tbl->list[i], en, link); \
			CTAILQ_REMOVE(&list_inuse, en, tqe_link); \
			CTAILQ_INSERT_TAIL(&list_free, en, tqe_link); \
		} \
	} \
}

//Brad disable 
#if 0
static void flush_all_table(void)
{
	unsigned long flags;

	save_flags(flags); cli();	

#ifndef DEL_NAPT_TBL
	FLUSH_TBL(Napt_List_Entry, napt_list_inuse, napt_list_free, table_napt, napt_link, NAPT_TABLE_LIST_MAX, 0);
#endif
	FLUSH_TBL(Path_List_Entry, path_list_inuse, path_list_free, table_path, path_link, PATH_TABLE_LIST_MAX, 1);
	
  	restore_flags(flags);	
}
#endif
//======================================
#ifdef CONFIG_PROC_FS
static struct proc_dir_entry *res1=NULL;
static int read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;

      len = sprintf(page, "%d\n", fast_nat_fw+10);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{      
	unsigned char tmpbuf[80];
	
	if (count < 2) 
		return -EFAULT;
	
	if (buffer && !copy_from_user(tmpbuf, buffer, 80))  {
		if (tmpbuf[0] == '2'){ 
      			extern void rtk_clear_conntracks(void);
			flush_table = 1;	
						
			rtk_clear_conntracks();		//clean conntrack table		
		}else	 {
			sscanf(tmpbuf, "%d", &fast_nat_fw);		
			if (fast_nat_fw == 1)
				flush_table = 1;				
		}
		return count;     
	}
	  
	return -EFAULT;
}
#ifdef PROC_MAX_CONNECTION_CTRL
static struct proc_dir_entry *fast_max = NULL;
static int read_fast_max(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;

      len = sprintf(page, "%d\n", napt_table_entry_max);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int write_fast_max(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	int i, max, extra;      
	unsigned long flags;
	unsigned char tmpbuf[80];
	struct Napt_List_Entry *entry_napt;
	struct Path_List_Entry *entry_path;
		
	if (count < 2) 
		return -EFAULT;
	
	if (buffer && !copy_from_user(tmpbuf, buffer, 80))  {
		sscanf(tmpbuf, "%d", &max);
		if (max <= napt_table_entry_max)
			return -EINVAL;
	
	    save_flags(flags); cli();

		CTAILQ_INIT(&napt_list_tmp);
		CTAILQ_INIT(&path_list_tmp);
		extra = max - napt_table_entry_max;
		
		for (i = 0; i < extra; i++) {
			entry_napt = (struct Napt_List_Entry *)kmalloc(sizeof(struct Napt_List_Entry), GFP_ATOMIC);
			if (entry_napt == NULL) {
				DEBUGP_SYS("MALLOC Failed! (Extra Napt Table Entry) \n");
				goto nomem;
			}
			CTAILQ_INSERT_TAIL(&napt_list_tmp, entry_napt, tqe_link);
		}
		
		extra = (max * 2) - path_table_entry_max;
		for (i = 0; i < extra; i++) {
			entry_path = (struct Path_List_Entry *)kmalloc(sizeof(struct Path_List_Entry), GFP_ATOMIC);
			if (entry_path == NULL) {
				DEBUGP_SYS("MALLOC Failed! (Extra Path Table Entry) \n");
				goto nomem;
			}
			CTAILQ_INSERT_TAIL(&path_list_tmp, entry_path, tqe_link);
		}
		
		while (!CTAILQ_EMPTY(&napt_list_tmp)) {
			entry_napt = CTAILQ_FIRST(&napt_list_tmp);
			CTAILQ_REMOVE(&napt_list_tmp, entry_napt, tqe_link);
			CTAILQ_INSERT_TAIL(&napt_list_free, entry_napt, tqe_link);
		}

		while (!CTAILQ_EMPTY(&path_list_tmp)) {
			entry_path = CTAILQ_FIRST(&path_list_tmp);
			CTAILQ_REMOVE(&path_list_tmp, entry_path, tqe_link);
			CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
		}
		
		napt_table_entry_max = max;
		path_table_entry_max = (napt_table_entry_max * 2);
		
		restore_flags(flags);
		
		return count;     
	}
	  
	return -EFAULT;

nomem:
	while (!CTAILQ_EMPTY(&napt_list_tmp)) {
		entry_napt = CTAILQ_FIRST(&napt_list_tmp);
		CTAILQ_REMOVE(&napt_list_tmp, entry_napt, tqe_link);
		kfree(entry_napt);
	}

	while (!CTAILQ_EMPTY(&path_list_tmp)) {
		entry_path = CTAILQ_FIRST(&path_list_tmp);
		CTAILQ_REMOVE(&path_list_tmp, entry_path, tqe_link);
		kfree(entry_path);
	}
	restore_flags(flags);
	
	return -ENOMEM;		
}
#endif /* PROC_MAX_CONNECTION_CTRL */
#endif /* CONFIG_PROC_FS */

//======================================
static int __init fastpath_init(void)
{
	int i;
	
#ifdef	DEBUG_PROCFILE
	/* proc file for debug */
#ifndef NO_ARP_USED	
	proc_net_create("fp_arp", 0, fastpath_table_arp);
#endif
	proc_net_create("fp_route", 0, fastpath_table_route);
#ifndef DEL_NAPT_TBL	
	proc_net_create("fp_napt", 0, fastpath_table_napt);
#endif
	proc_net_create("fp_path", 0, fastpath_table_path);
	proc_net_create("fp_hash_path", 0, fastpath_hash_path);
#endif	/* DEBUG_PROCFILE */
	
#ifndef NO_ARP_USED
	/* Arp-Table Init */
	table_arp = (struct Arp_Table *)kmalloc(sizeof(struct Arp_Table), GFP_ATOMIC);
	if (table_arp == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Arp Table) \n");
		return -1;
	}
	CTAILQ_INIT(&arp_list_inuse);
	CTAILQ_INIT(&arp_list_free);
	for (i=0; i<ARP_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_arp->list[i]);
	}
	/* Arp-List Init */
	for (i=0; i<ARP_TABLE_ENTRY_MAX; i++) {
		struct Arp_List_Entry *entry_arp = (struct Arp_List_Entry *)kmalloc(sizeof(struct Arp_List_Entry), GFP_ATOMIC);
		if (entry_arp == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Arp Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&arp_list_free, entry_arp, tqe_link);
	}
#endif
	
	/* Route-Table Init */
	table_route = (struct Route_Table *)kmalloc(sizeof(struct Route_Table), GFP_ATOMIC);
	if (table_route == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Route Table) \n");
		return -1;
	}
	CTAILQ_INIT(&route_list_inuse);
	CTAILQ_INIT(&route_list_free);
	for (i=0; i<ROUTE_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_route->list[i]);
	}
	/* Route-List Init */
	for (i=0; i<ROUTE_TABLE_ENTRY_MAX; i++) {
		struct Route_List_Entry *entry_route = (struct Route_List_Entry *)kmalloc(sizeof(struct Route_List_Entry), GFP_ATOMIC);
		if (entry_route == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Route Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&route_list_free, entry_route, tqe_link);
	}

#ifndef DEL_NAPT_TBL
	/* Napt-Table Init */
	table_napt = (struct Napt_Table *)kmalloc(sizeof(struct Napt_Table), GFP_ATOMIC);
	if (table_napt == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Napt Table) \n");
		return -1;
	}
	CTAILQ_INIT(&napt_list_inuse);
	CTAILQ_INIT(&napt_list_free);
	for (i=0; i<NAPT_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_napt->list[i]);
	}
	/* Napt-List Init */
	#ifdef PROC_MAX_CONNECTION_CTRL
	for (i=0; i<napt_table_entry_max; i++) {
		struct Napt_List_Entry *entry_napt = \
			(struct Napt_List_Entry *)kmalloc(sizeof(struct Napt_List_Entry), GFP_ATOMIC);
		if (entry_napt == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Napt Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&napt_list_free, entry_napt, tqe_link);
	}
	#else
	for (i=0; i<NAPT_TABLE_ENTRY_MAX; i++) {
		struct Napt_List_Entry *entry_napt = \
			(struct Napt_List_Entry *)kmalloc(sizeof(struct Napt_List_Entry), GFP_ATOMIC);
		if (entry_napt == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Napt Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&napt_list_free, entry_napt, tqe_link);
	}
	#endif /* PROC_MAX_CONNECTION_CTRL */
#endif
	
	/* Path-Table Init */
	table_path = (struct Path_Table *)kmalloc(sizeof(struct Path_Table), GFP_ATOMIC);
	if (table_path == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Path Table) \n");
		return -1;
	}
	CTAILQ_INIT(&path_list_inuse);
	CTAILQ_INIT(&path_list_free);
	for (i=0; i<PATH_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_path->list[i]);
	}
	/* Path-List Init */
	#ifdef PROC_MAX_CONNECTION_CTRL
	for (i=0; i<path_table_entry_max; i++) {
		struct Path_List_Entry *entry_path = (struct Path_List_Entry *)kmalloc(sizeof(struct Path_List_Entry), GFP_ATOMIC);
		if (entry_path == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Path Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
	}
	#else
	for (i=0; i<PATH_TABLE_ENTRY_MAX; i++) {
		struct Path_List_Entry *entry_path = (struct Path_List_Entry *)kmalloc(sizeof(struct Path_List_Entry), GFP_ATOMIC);
		if (entry_path == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Path Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
	}
	#endif /* PROC_MAX_CONNECTION_CTRL */

#if defined (DOS_FILTER) || defined (URL_FILTER) 
	filter_init();
#endif

#ifdef FAST_PPTP
	fast_pptp_init();
#endif

#ifdef FAST_L2TP
	fast_l2tp_init();
#endif

#ifdef CONFIG_PROC_FS
	res1=create_proc_entry("fast_nat",0,NULL);
	if (res1) {
	    res1->read_proc=read_proc;
	    res1->write_proc=write_proc;
	}
	#ifdef PROC_MAX_CONNECTION_CTRL
	fast_max = create_proc_entry("fast_max", 0, NULL);
	if (fast_max) {
	    fast_max->read_proc = read_fast_max;
	    fast_max->write_proc = write_fast_max;
	}
	#endif
#endif

	printk("%s %s\n",MODULE_NAME, MODULE_VERSION);
	
	return 0;
}

static void __exit fastpath_exit(void)
{
#ifdef DOS_FILTER
	filter_exit();
#endif

#ifdef FAST_PPTP
	fast_pptp_exit();
#endif

#ifdef CONFIG_PROC_FS
	if (res1) {
		remove_proc_entry("fast_nat", res1);		
		res1 = NULL;
	}
	#ifdef PROC_MAX_CONNECTION_CTRL
	if (fast_max) {
		remove_proc_entry("fast_max", fast_max);		
		fast_max = NULL;
	}
	#endif
#endif

	printk("%s %s removed!\n", MODULE_NAME, MODULE_VERSION);
}

module_init(fastpath_init);
module_exit(fastpath_exit);
MODULE_LICENSE("GPL");

/*
2006-08/29:
	! Ignore TCP packet with FIN/RST/SYN flag (OR).
	! Ignore fragment of UDP packet.
2006-08/28:
	! NAT/NAPT bug fixed(RNAT/RNAPT NOT Working).
*/

