#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <asm/uaccess.h>
#include <linux/brlock.h>
#include <linux/net.h>
#include <linux/socket.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/raw.h>
#include <net/checksum.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>

#include <linux/in.h>
#include <linux/netfilter_ipv4/ip_conntrack_pptp.h>
#include <linux/if_tunnel.h>
#include <linux/if_ether.h>
#include <asm-mips/atomic.h>


#define FAST_PPTP

#ifdef CONFIG_RTL8186_KB
	#undef FAST_PPTP
#endif
#if 0
	#define FAST_PPTP_PRINT	printk
#else
	#define FAST_PPTP_PRINT(fmt, args...) {}
#endif

struct pptp_info {
	struct net_device *wan_dev;
	unsigned int tx_seqno;
	unsigned int rx_seqno;
	__u32 saddr;
	__u32 daddr;
	__u16 callID;
	__u16 tx_ipID;
	__u16 ipID;
	struct net_device *ppp0_dev;
	struct net_device *lan_dev;
	unsigned char mac_header[ETH_HLEN];
	unsigned int tx_seqno_daemon;
	unsigned int rx_seqno_daemon;
	int ppp_hdr_len;
	unsigned char ppp_hdr[4];
};

static struct pptp_info pptpInfo={NULL};
int fast_pptp_fw=0;


/* following define are imported from kerenl */
#define SC_COMP_RUN     0x00001000      /* compressor has been inited */
enum NPmode {
     NPMODE_PASS,                /* pass the packet through */
     NPMODE_DROP,                /* silently drop the packet */
     NPMODE_ERROR,               /* return an error */
     NPMODE_QUEUE                /* save it up for later. */
};

#define NUM_NP	4		/* Number of NPs. */
struct ppp_file {
	enum {
		INTERFACE=1, CHANNEL
	}		kind;
	struct sk_buff_head xq;		/* pppd transmit queue */
	struct sk_buff_head rq;		/* receive queue for pppd */
	wait_queue_head_t rwait;	/* for poll on reading /dev/ppp */
	atomic_t	refcnt;		/* # refs (incl /dev/ppp attached) */
	int		hdrlen;		/* space to leave for headers */
	struct list_head list;		/* link in all_* list */
	int		index;		/* interface unit / channel number */
};

#ifdef ABOCOM
struct ppp {
	struct ppp_file	file;		/* stuff for read/write/poll */
	struct list_head channels;	/* list of attached channels */
	int		n_channels;	/* how many channels are attached */
	spinlock_t	rlock;		/* lock for receive side */
	spinlock_t	wlock;		/* lock for transmit side */
	int		mru;		/* max receive unit */
	int		mru_alloc;	/* MAX(1500,MRU) for dev_alloc_skb() */
	unsigned int	flags;		/* control bits */
	unsigned int	xstate;		/* transmit state bits */
	unsigned int	rstate;		/* receive state bits */
	int		debug;		/* debug flags */
	struct slcompress *vj;		/* state for VJ header compression */
	enum NPmode	npmode[NUM_NP];	/* what to do with each net proto */
	struct sk_buff	*xmit_pending;	/* a packet ready to go out */
	struct compressor *xcomp;	/* transmit packet compressor */
	void		*xc_state;	/* its internal state */
	struct compressor *rcomp;	/* receive decompressor */
	void		*rc_state;	/* its internal state */
	unsigned long	last_xmit;	/* jiffies when last pkt sent */
	unsigned long	last_recv;	/* jiffies when last pkt rcvd */
	struct net_device *dev;		/* network interface device */
#ifdef CONFIG_PPP_MULTILINK
	int		nxchan;		/* next channel to send something on */
	u32		nxseq;		/* next sequence number to send */
	int		mrru;		/* MP: max reconst. receive unit */
	u32		nextseq;	/* MP: seq no of next packet */
	u32		minseq;		/* MP: min of most recent seqnos */
	struct sk_buff_head mrq;	/* MP: receive reconstruction queue */
#endif /* CONFIG_PPP_MULTILINK */
	struct net_device_stats stats;	/* statistics */
#ifdef CONFIG_PPP_FILTER
	struct sock_fprog pass_filter;	/* filter for packets to pass */
	struct sock_fprog active_filter;/* filter for pkts to reset idle */
#endif /* CONFIG_PPP_FILTER */
	int		xpad;		/* ECP or CCP (MPPE) transmit padding */
};

#else
struct ppp {
	struct ppp_file	file;		/* stuff for read/write/poll */
	struct list_head channels;	/* list of attached channels */
	int		n_channels;	/* how many channels are attached */
	spinlock_t	rlock;		/* lock for receive side */
	spinlock_t	wlock;		/* lock for transmit side */
	int		mru;		/* max receive unit */
	unsigned int	flags;		/* control bits */
	unsigned int	xstate;		/* transmit state bits */
	unsigned int	rstate;		/* receive state bits */
	int		debug;		/* debug flags */
	struct slcompress *vj;		/* state for VJ header compression */
	enum NPmode	npmode[NUM_NP];	/* what to do with each net proto */
	struct sk_buff	*xmit_pending;	/* a packet ready to go out */
	struct compressor *xcomp;	/* transmit packet compressor */
	void		*xc_state;	/* its internal state */
	struct compressor *rcomp;	/* receive decompressor */
	void		*rc_state;	/* its internal state */
	unsigned long	last_xmit;	/* jiffies when last pkt sent */
	unsigned long	last_recv;	/* jiffies when last pkt rcvd */
	struct net_device *dev;		/* network interface device */
#ifdef CONFIG_PPP_MULTILINK
	int		nxchan;		/* next channel to send something on */
	u32		nxseq;		/* next sequence number to send */
	int		mrru;		/* MP: max reconst. receive unit */
	u32		nextseq;	/* MP: seq no of next packet */
	u32		minseq;		/* MP: min of most recent seqnos */
	struct sk_buff_head mrq;	/* MP: receive reconstruction queue */
#endif /* CONFIG_PPP_MULTILINK */
	struct net_device_stats stats;	/* statistics */
#ifdef CONFIG_PPP_FILTER
	struct sock_fprog pass_filter;	/* filter for packets to pass */
	struct sock_fprog active_filter;/* filter for pkts to reset idle */
#endif /* CONFIG_PPP_FILTER */
};
#endif

extern void (*sync_tx_pptp_gre_seqno_hook)(struct sk_buff *skb);

static inline void bcopy(unsigned char *dst, unsigned char *src, int len)
{	int i;
	for (i=0; i<len; i++)
		dst[i] = src[i];
}

// Filter PPTP Outgoing-Call-Reply to log IP and call id
void fast_pptp_filter(struct sk_buff *skb)
{
   	struct pptp_pkt_hdr		*pptph;
   	struct PptpControlHeader	*ctlh;		
   	struct PptpOutCallReply	*ocack;
   	
	if (skb->len >= (sizeof(struct iphdr)+sizeof(struct tcphdr)+sizeof(*pptph)+sizeof(*ctlh)+ sizeof(*ocack))) {
   		struct tcphdr *th = (struct tcphdr *)(((char *)skb->nh.iph) + skb->nh.iph->ihl*4);  				
    	
   		if (skb->nh.iph->protocol == IPPROTO_TCP && th->source == PPTP_TCP_PORT) {
	    		pptph = (struct pptp_pkt_hdr *)(((char *)th)+sizeof(struct tcphdr)+(th->doff-5)*4);
    			ctlh = (struct PptpControlHeader *)(((char *)pptph) + sizeof(struct pptp_pkt_hdr));
	    		ocack = (struct PptpOutCallReply *)(((char*)ctlh) + sizeof(struct PptpControlHeader));
    			
	   		if (ntohs(pptph->packetType) == PPTP_CONTROL_PACKET &&    				
   					ntohs(ctlh->messageType) == PPTP_OUT_CALL_REPLY &&
   					ocack->resultCode == PPTP_OUTCALL_CONNECT) {
				    						
				FAST_PPTP_PRINT("Rx PPTP Call-reply, from:%s, callid=0x%x\n", skb->dev->name, ocack->callID);
    	
	    			memset(&pptpInfo, 0, sizeof(pptpInfo));    	
    				pptpInfo.callID = ocack->callID;
	    			pptpInfo.saddr = skb->nh.iph->daddr;
	    			pptpInfo.daddr = skb->nh.iph->saddr;	
    				pptpInfo.tx_seqno = 1;    				
    				pptpInfo.wan_dev = skb->dev;    				
				pptpInfo.lan_dev =__dev_get_by_name("br0");				 				
    				
    				memcpy(&pptpInfo.mac_header[0], skb->data-ETH_HLEN+ETH_ALEN, ETH_ALEN); // da of tx pkt
				memcpy(&pptpInfo.mac_header[ETH_ALEN], skb->data-ETH_HLEN, ETH_ALEN); // sa of tx pkt   									
    				memcpy(&pptpInfo.mac_header[ETH_ALEN*2], skb->data-2, 2); // type    				    										
    			}		
	    	}
	}			
}

#ifdef FAST_PPTP
extern int isCovered;
#endif
// Packet come from WAN, and it is GRE data
//	  delete IP+GRE+PPP header 
int fast_pptp_to_lan(struct sk_buff **pskb)
{		
	struct iphdr *iph;
	struct pptp_gre_hdr *greh;					
	unsigned char ppp_type=0;
	struct ppp *ppp;    
	struct sk_buff *skb = *pskb;
	int pull_offset=0;
//Brad add ---------	
	int check_stats=0;
//Brad add end-------	
	extern struct sk_buff *ppp_receive_nonmp_frame(struct ppp *ppp, struct sk_buff *skb, int is_fast_fw);

	if (skb->dev != pptpInfo.wan_dev || skb->nh.iph->protocol != IPPROTO_GRE || skb->len < sizeof(struct iphdr))
		return 0;
	
	iph = skb->nh.iph;	
	greh = (struct pptp_gre_hdr *)(skb->data + iph->ihl*4);
			
	if ((greh->version&7) == PPTP_GRE_VERSION &&
						ntohs(greh->protocol) == PPTP_GRE_PROTOCOL) {
		unsigned char *ppp_data;	
		int offset = sizeof(*greh) - 8;	// delete seq and ack no
		int ppp_offset=0;
				
		if (PPTP_GRE_IS_S(greh->flags)) {	
			pptpInfo.rx_seqno = ntohl(greh->seq);						
			offset += 4;
		}	
			
#ifdef CONFIG_RTL865X_HW_PPTPL2TP
		if (PPTP_GRE_IS_A(greh->version)) {
			/* Others go head !? */
			unsigned int ack = ntohl(greh->ack);
			if (time_after(ack, pptpInfo.tx_seqno)) {
				pptpInfo.tx_seqno = ack + 1;	
			}
			offset += 4;
		}
#else			
		if (PPTP_GRE_IS_A(greh->version))
			offset += 4;
#endif
					
		ppp_data = ((char *)greh) + offset;				

		ppp_offset = 0;				
		if (greh->payload_len > 0) {	
			// check PPP IP protocol
			if (*ppp_data == 0) {
				ppp_offset = 1;
				ppp_data++;
			}
			else if (*ppp_data == 0xff && *(ppp_data+1) == 0x03) {									
				ppp_offset = 2;
				ppp_data += 2;
				if (*ppp_data == 0) {
					ppp_offset++;
					ppp_data++;
				}
			}											
			if (*ppp_data == 0x21 || *ppp_data == 0xfd) {
				ppp_offset++;					
				ppp_type = *ppp_data;
			}
			else
				ppp_offset = 0;		
		}	

		if (ppp_offset ==  0) 
			return 0;

		offset = iph->ihl*4 + offset + ppp_offset;	// tunnel IP offset	
		
		if (ppp_type != 0x21) {	// !PPP_IP					
			if (!pptpInfo.ppp0_dev || !pptpInfo.ppp0_dev->priv)
				return 0;	
					
			skb_pull(skb, offset-2);
			skb->data[0] = 0;				
			skb->data[1] = ppp_type;
			ppp = (struct ppp *)pptpInfo.ppp0_dev->priv;
			
			skb = ppp_receive_nonmp_frame(ppp, skb, 1);					
			if (skb == NULL) {
			#ifdef FAST_PPTP	
				if(isCovered == 0){
					printk("%s: ppp_receive_nonmp_frame() return error!\n", __FUNCTION__);
				}
			#else
				printk("%s: ppp_receive_nonmp_frame() return error!\n", __FUNCTION__);
			#endif	
				return -2;	// discard
			}			
			*pskb = skb;	
//Brad add ----------			
			check_stats = 1;				
//Brad add end-------			
		}
		else {	
			skb_pull(skb, offset);					
			pull_offset = offset;
		}
			
		FAST_PPTP_PRINT("delete GRE + PPTP header\n");

		// fix unalignment issue
		offset = ((unsigned long)skb->data) % 4;
		if (offset) {
			if (skb_headroom(skb) >= offset) {
				memmove(skb->data-offset, skb->data, skb->len);
				skb->data -= offset;				
			}
		}   
		
		skb->h.raw = skb->nh.raw = skb->data;										
		if (pptpInfo.ppp0_dev == NULL)
			pptpInfo.ppp0_dev =__dev_get_by_name("ppp0");

		if (pptpInfo.ppp0_dev) {
//Brad add --------	
		if(check_stats ==0){		  	
			if(pptpInfo.ppp0_dev->priv){
				ppp = (struct ppp *)pptpInfo.ppp0_dev->priv;
				++ppp->stats.rx_packets;
				ppp->stats.rx_bytes += skb->len - 2;
			}//else{
			//		printk("ppp0_dev priv==NULL\n");
			//	}
		}		
//Brad add end--------		
			skb->dev = pptpInfo.ppp0_dev;

#ifdef CONFIG_RTL865X_HW_PPTPL2TP
		/*
		 * ppp_receive_nonmp_frame() will not be called in this function because ppp_type = 0x21
		 *	(see the code above)
		 *
		 * so I move the code which calling rtl865x_pppAcceleratePptpL2tpToLAN() from 
		 *	ppp_receive_nonmp_frame()
		 *
		 * if return value >= 0, this packet has been sent to extension port, return -2 to let the caller
		 *		FastPath_Enter() known
		 * else (return value < 0), return 1 to let the caller to continue the process of skb,
		 *		i.e. execute enter_fast_path() to do the fastpath NAT
		 */

		/* TODO: check TCP/UDP packets if we can */
		{
		extern int gHwNatEnabled;

		if ((gHwNatEnabled == 1) && (skb->protocol == ETH_P_IP)) {
			extern int rtl865x_pppAcceleratePptpL2tpToLAN(struct sk_buff *skb, struct net_device *pppDev);
			if (rtl865x_pppAcceleratePptpL2tpToLAN(skb, pptpInfo.ppp0_dev) >= 0)
				return -2;	// discard
		}
		}
#endif

			return 1;
		}
		
		FAST_PPTP_PRINT("pass up\n");				
		if (pull_offset) {
			skb_push(skb, pull_offset);
			skb->h.raw = skb->nh.raw = skb->data;				
		}

	}
	return 0;		
}

// Packet come from LAN and dst dev is ppp0, 
// add IP+GRE+PPTP header
 int fast_pptp_to_wan(struct sk_buff *skb)
{
	int	header_len;
	struct iphdr *iph_new, iph_newone;
	struct pptp_gre_hdr	*greh, grehone;	
	unsigned char tos;
	unsigned short frag_off;
	int ppp_hdr_len=0;		

	if (pptpInfo.ppp0_dev == NULL)
		pptpInfo.ppp0_dev =__dev_get_by_name("ppp0");  					

	if (pptpInfo.ppp0_dev && pptpInfo.ppp0_dev->priv) {
		extern int ppp_start_xmit(struct sk_buff *skb, struct net_device *dev);
		struct ppp *ppp = (struct ppp *)pptpInfo.ppp0_dev->priv;

		// if VJ compressed/uncompressed and !MPPE, not forward
		if (ppp->vj && !((ppp->xstate & SC_COMP_RUN) && ppp->xc_state)) {
			FAST_PPTP_PRINT("vj is used, skip fast forwarding.\n");
			return 0;			
		}
		
		tos = skb->nh.iph->tos;
		frag_off = skb->nh.iph->frag_off;
				
		if (ppp->xmit_pending) {
			printk("%s: ppp->xmit_pending\n", __FUNCTION__);
			return 0;
		}		
		memcpy(skb->cb, "RTL", 3);						
		ppp_start_xmit(skb, pptpInfo.ppp0_dev);				
		if (!ppp->xmit_pending) {
			printk("%s: ppp_start_xmit() drop skb!", __FUNCTION__);
			return 1;
		}
		
		skb = ppp->xmit_pending;			
		
		ppp->xmit_pending = NULL;
		
		header_len = ETH_HLEN + sizeof(*iph_new) + sizeof(*greh); // mac-header+ip+gre	
		if (skb_headroom(skb) < header_len || skb_cloned(skb) || skb_shared(skb)) {	
			struct sk_buff *new_skb = skb_realloc_headroom(skb, header_len);				
			if (!new_skb) {				
				printk("%s: skb_realloc_headroom failed!\n", __FUNCTION__);	
				return 0;
			}									
			dev_kfree_skb(skb);
			skb = new_skb;
		}			
	
		// build mac header						
		memcpy(skb_push(skb, header_len), pptpInfo.mac_header, ETH_HLEN);
					
		// build ip header							
		iph_new = &iph_newone;	
		iph_new->version	=	4;
		iph_new->ihl		=	sizeof(struct iphdr) >> 2;
		iph_new->frag_off	=	frag_off;			
		iph_new->protocol	=	IPPROTO_GRE;
		iph_new->tos		=	tos;
		iph_new->daddr	=	pptpInfo.daddr;
		iph_new->saddr	=	pptpInfo.saddr;
		iph_new->ttl 		=	IPDEFTTL;   
		skb->ip_summed	=	CHECKSUM_NONE;			
		iph_new->tot_len	=	htons(skb->len - ETH_HLEN);		
		iph_new->id		=	htons(++pptpInfo.tx_ipID);
     			
	    	iph_new->check	=	0;
	    	iph_new->check	=	ip_fast_csum((unsigned char *)iph_new, iph_new->ihl);	
	    	pptpInfo.ipID	=	iph_new->id; // save id to check in sync_pptp_gre_seqno()
	    	memcpy(skb->data + ETH_HLEN, &iph_newone, sizeof(iph_newone)); 					
   						
    		// build gre header
	    	greh 			= &grehone;
	    	greh->flags		= PPTP_GRE_FLAG_K | PPTP_GRE_FLAG_S;
	    	greh->version	= PPTP_GRE_VERSION | PPTP_GRE_FLAG_A;
	    	greh->protocol	= htons(PPTP_GRE_PROTOCOL);
    			
	    	greh->payload_len	= htons(skb->len - header_len + ppp_hdr_len);    	
	    	greh->call_id		= pptpInfo.callID;			
	    	greh->seq 		= htonl(pptpInfo.tx_seqno++);		
    		greh->ack		= htonl(pptpInfo.rx_seqno);		
	    	memcpy(skb->data+ETH_HLEN+sizeof(struct iphdr), &grehone, sizeof(grehone));

    		FAST_PPTP_PRINT("add GRE header, id=%d, gre-len=%d!\n", iph_new->id, skb->len-header_len);	         			
 		
	    	skb->dev = pptpInfo.wan_dev;
    		dev_queue_xmit(skb);
	    	return 1;						
	}
	else {
		if (pptpInfo.ppp0_dev == NULL)
			printk("pptpInfo.ppp0_dev == NULL\n");
		else if (pptpInfo.ppp0_dev->priv == NULL)
			printk("pptpInfo.ppp0_dev->priv == NULL\n");
	}
	
	return 0;	
}		

// Sync Rx GRE seq no to daemon.
//		Replace tx-seq and ack-seq.
void fast_pptp_sync_rx_seq(struct sk_buff *skb)
{
	struct pptp_gre_hdr *greh;			
	unsigned char *iph = (unsigned char *)skb->nh.iph;

	greh = (struct pptp_gre_hdr *)(iph + sizeof(struct iphdr));
		
	if ((greh->version&7) == PPTP_GRE_VERSION &&
						ntohs(greh->protocol) == PPTP_GRE_PROTOCOL) {			
		
		FAST_PPTP_PRINT("replace GRE seqno to daemon:");							
							
		// pass-up, replace seq and ack no                		
		if (PPTP_GRE_IS_S(greh->flags)) {
			FAST_PPTP_PRINT("tx-seqno=%d ", pptpInfo.rx_seqno_daemon);
			greh->seq = htonl(pptpInfo.rx_seqno_daemon++);
		}
		if (PPTP_GRE_IS_A(greh->version)) {
			FAST_PPTP_PRINT("ackno=%d ", pptpInfo.tx_seqno_daemon);							
			greh->ack = htonl(pptpInfo.tx_seqno_daemon); 
		}
		FAST_PPTP_PRINT("\n");
	}	
}


// Sync tx GRE seq no. 
//   replace gre tx seq, and ack number if packet is not sent from upper layer
void sync_tx_pptp_gre_seqno(struct sk_buff *skb)
{
	struct iphdr *iph = (struct iphdr *)(skb->data+ETH_HLEN);
	unsigned long x;

	if (!fast_pptp_fw)
		return;
	
	save_and_cli(x);

	if (iph->protocol == IPPROTO_GRE && skb->len > (sizeof(struct iphdr)+ETH_HLEN)) {
		struct pptp_gre_hdr *greh;			
		int is_forward = 0;	
		unsigned int lv;
		unsigned short protocol;
	
		greh = (struct pptp_gre_hdr *)(skb->data + ETH_HLEN + iph->ihl*4);
		bcopy((unsigned char *)&protocol, (unsigned char *)&greh->protocol, 2);
			
		if ((greh->version&7) == PPTP_GRE_VERSION &&
						ntohs(protocol) == PPTP_GRE_PROTOCOL) {					
			if (PPTP_GRE_IS_S(greh->flags)) {	
				if (iph->id != pptpInfo.ipID) { // not fast_pptp forward
					lv = ntohl(greh->seq);				
					bcopy((unsigned char *)&pptpInfo.tx_seqno_daemon, (unsigned char *)&lv, 4);
					lv = htonl(pptpInfo.tx_seqno++);
					bcopy((unsigned char *)&greh->seq,  (unsigned char *)&lv, 4);
				}
				else
					is_forward = 1;					
			}			
			if (PPTP_GRE_IS_A(greh->version)) {
				lv = htonl(pptpInfo.rx_seqno);	
				bcopy((unsigned char *)&greh->ack, (unsigned char *)&lv, 4);	
			}

			if (!is_forward) {				
				iph->id = htons(++pptpInfo.tx_ipID);
				iph->check = 0;
				iph->check  = ip_fast_csum((unsigned char *)iph, iph->ihl);					
			}		
			
		}
	}			

	restore_flags(x);	
}

int ppfw_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;

      len = sprintf(page, "%d\n", fast_pptp_fw);
      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}

static unsigned long atoi_dec(char *s)
{
	unsigned long k = 0;

	k = 0;
	while (*s != '\0' && *s >= '0' && *s <= '9') {
		k = 10 * k + (*s - '0');
		s++;
	}
	return k;
}

int ppfw_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[200];	
	
	if (count < 2) 
		return -EFAULT;
      
	if (buffer && !copy_from_user(tmpbuf, buffer, count)) {
		fast_pptp_fw = atoi_dec(tmpbuf);

 		if (fast_pptp_fw)
			sync_tx_pptp_gre_seqno_hook = sync_tx_pptp_gre_seqno;
		else 
			sync_tx_pptp_gre_seqno_hook = NULL; 			
		return count;
	}
	return -EFAULT;				
}		

#if defined(CONFIG_PROC_FS)
static struct proc_dir_entry *res1=NULL;
#endif

int __init fast_pptp_init(void)
{
#if defined(CONFIG_PROC_FS)
	res1 = create_proc_entry("fast_pptp", 0, NULL);
	if (res1) {
		res1->read_proc = ppfw_read_proc;
		res1->write_proc = ppfw_write_proc;
	}
#endif	
	return 0;
}

void __exit fast_pptp_exit(void)
{
#if defined(CONFIG_PROC_FS)
	if (res1) {
		remove_proc_entry("fast_pptp", res1);		
		res1 = NULL;
	}
#endif
}


