#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <asm/uaccess.h>
#include <linux/brlock.h>
#include <linux/net.h>
#include <linux/socket.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/raw.h>
#include <net/checksum.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>

#include <linux/in.h>
#include <linux/udp.h>
#include <linux/if_tunnel.h>
#include <linux/if_ether.h>
#include <asm-mips/atomic.h>

#if 0
	#define DEBUGP	printk
#else
	#define DEBUGP(fmt, args...) {}
#endif


#define control_message 0x8000
#define connect_control 0xc
#define stop_control 0x4
#define call_reply 0xb

struct l2tp_info
{
	struct net_device *wan_dev;
	struct net_device *ppp0_dev;	
	__u32 daddr;
	__u32 saddr;
	__u16 tid;                   /* Tunnel ID */
	__u16 cid;                   /* Caller ID */
        unsigned char mac_header[ETH_HLEN];

};

struct l2tp_ext_hdr
{
	__u16 source;
	__u16 dest;
	__u16 len;
	__u16 checksum;
	__u16 type;
	__u16 tid;
	__u16 cid;
	__u16 addr_control;
	__u16 protocol;
};

struct avp_info
{
	__u16 length;
        __u16 vendorid;
	__u16 attr;
	__u16 mss_type;
};

struct l2tp_header
{
	__u16 ver;                   /* Version and friends */
	__u16 length;                /* Optional Length */
	__u16 tid;                   /* Tunnel ID */
	__u16 cid;                   /* Caller ID */
	__u16 Ns;                    /* Optional next sent */
	__u16 Nr;                    /* Optional next received */
};

static struct l2tp_info l2tpInfo={NULL};
int fast_l2tp_fw=0;

extern void (*l2tp_tx_id_hook)(struct sk_buff *skb);

void l2tp_tx_id(struct sk_buff *skb)
{
        __u16 *p_id;
        __u16 MessageType;
	struct iphdr *iph;

	iph = skb->nh.iph;
        struct udphdr *hdr = (struct udphdr *)((u_int32_t *)iph + iph->ihl);
        struct l2tp_header *l2tp_ptr = (struct l2tp_header *)((u_int8_t *)hdr+8);
        if(hdr->source==1701 && hdr->dest==1701 && (l2tp_ptr->ver & 0x8000)==control_message)
          {
	  	if((l2tp_ptr->ver & 0x4000)==0)
	    		p_id=(__u16 *)((u_int8_t *)(&l2tp_ptr->ver)+2);
	  	else
	    		p_id=&l2tp_ptr->tid;

          	MessageType=*(p_id+7);

          	if(MessageType==stop_control && l2tpInfo.tid==*p_id)
	  	{
	  		memset(&l2tpInfo, '\0', sizeof(l2tpInfo));			
	  	}

          	if(MessageType==call_reply)
	  	{				
			l2tpInfo.wan_dev = skb->dev;
	      		memcpy(&l2tpInfo.mac_header[0], skb->data-ETH_HLEN+ETH_ALEN, ETH_ALEN); // da of tx pkt
			memcpy(&l2tpInfo.mac_header[ETH_ALEN], skb->data-ETH_HLEN, ETH_ALEN); // sa of tx pkt
			memcpy(&l2tpInfo.mac_header[ETH_ALEN*2], skb->data-2, 2); // type
			DEBUGP("FAST-L2TP: call-reply, dev->name=%s\n", skb->dev->name);
	    	}
			
          	if(MessageType==connect_control && *(p_id+1)!= 0)
	  	{	
			extern void filter_addconnect(__u32 ipaddr);
	  	
	    		l2tpInfo.tid=*p_id;
	    		l2tpInfo.cid=*(p_id+1);
      	    		l2tpInfo.saddr = skb->nh.iph->saddr;
      	    		l2tpInfo.daddr = skb->nh.iph->daddr;

			 filter_addconnect(l2tpInfo.daddr);

			DEBUGP("FAST-L2TP: connected\n");
	    	}
	  }
	return;		
}

void fast_l2tp_rx(struct sk_buff *skb)
{
	struct iphdr *iph=skb->nh.iph;
	struct udphdr *hdr= (struct udphdr *)(((unsigned char *)iph) + iph->ihl*4);
	
	if(skb->len < 40)
		return;

	if (hdr->source==1701 && hdr->dest==1701) {
		if (l2tpInfo.wan_dev == NULL) 
			l2tp_tx_id(skb);	

		if (l2tpInfo.tid!=0 && l2tpInfo.cid!=0 && skb->data[38]==0 && skb->data[39]==0x21 &&
			l2tpInfo.wan_dev && l2tpInfo.saddr==skb->nh.iph->daddr &&
				l2tpInfo.daddr== skb->nh.iph->saddr) {  	
#if 0				
	      		memcpy(&l2tpInfo.mac_header[0], skb->data-ETH_HLEN+ETH_ALEN, ETH_ALEN); // da of tx pkt
			memcpy(&l2tpInfo.mac_header[ETH_ALEN], skb->data-ETH_HLEN, ETH_ALEN); // sa of tx pkt
			memcpy(&l2tpInfo.mac_header[ETH_ALEN*2], skb->data-2, 2); // type
#endif
			if (l2tpInfo.ppp0_dev == NULL)
				l2tpInfo.ppp0_dev =__dev_get_by_name("ppp0");  	

			if (l2tpInfo.ppp0_dev) {
				if (((struct iphdr *)(&skb->data[40]))->protocol == IPPROTO_TCP ||
					((struct iphdr *)(&skb->data[40]))->protocol == IPPROTO_UDP) {				
					skb->dev = l2tpInfo.ppp0_dev;
					skb_pull(skb,40);
					skb->h.raw = skb->nh.raw = skb->data;
					DEBUGP("FAST-L2TP: delete l2tp header!\n");			
				}
			}
		}
	  }
}

 int fast_l2tp_to_wan(struct sk_buff *skb)
{	
	int	header_len;
	struct iphdr *iph,*iph_new, iph_newone;
	struct l2tp_ext_hdr	*l2tph, l2tphone;
	unsigned char tos;
	unsigned short frag_off;

	if(!fast_l2tp_fw || l2tpInfo.tid==0 || l2tpInfo.cid==0 || !l2tpInfo.wan_dev)
		return 0;
	
	iph = skb->nh.iph;
	__u16 old_len = ntohs(iph->tot_len); 
	header_len = ETH_HLEN + sizeof(struct iphdr) +18 ;
	if (skb_headroom(skb) < header_len || skb_cloned(skb) || skb_shared(skb)) 
	{
		struct sk_buff *new_skb = skb_realloc_headroom(skb, header_len);				
		if (!new_skb) {
			printk("%s: skb_realloc_headroom failed!\n", __FUNCTION__);
			return 0;
		}
		dev_kfree_skb(skb);
		skb = new_skb;
	}
	tos = skb->nh.iph->tos;
	frag_off = skb->nh.iph->frag_off;

	// build mac header
	memcpy(skb_push(skb, header_len), l2tpInfo.mac_header, ETH_HLEN);

	// build ip header
	iph_new = &iph_newone;
	iph_new->version	=	4;
	iph_new->ihl		=	sizeof(struct iphdr) >> 2;
	iph_new->frag_off	=	frag_off;
	iph_new->protocol	=	IPPROTO_UDP;
	iph_new->tos		=	tos;
    	iph_new->daddr	=	l2tpInfo.daddr;
    	iph_new->saddr	=	l2tpInfo.saddr;
    	iph_new->ttl 		=	IPDEFTTL;
    	skb->ip_summed	=	CHECKSUM_NONE;
    	iph_new->tot_len	=	htons(skb->len - ETH_HLEN);
    	iph_new->id		=	0;

    	iph_new->check	=	0;
    	iph_new->check	=	ip_fast_csum((unsigned char *)iph_new, iph_new->ihl);	
    	memcpy(skb->data + ETH_HLEN, &iph_newone, sizeof(iph_newone));
    	l2tph = &l2tphone;
    	l2tph->source	=1701;
    	l2tph->dest	=1701;
	l2tph->len	=old_len+18;
	l2tph->checksum=0;
	l2tph->type	=0x0002;
	l2tph->tid	=l2tpInfo.tid;
	l2tph->cid	=l2tpInfo.cid;
	l2tph->addr_control= 0xff03;
	l2tph->protocol	=0x0021;
    	memcpy(skb->data+ETH_HLEN+sizeof(struct iphdr), &l2tphone, sizeof(struct l2tp_ext_hdr));

	skb->dev=l2tpInfo.wan_dev;
	DEBUGP("FAST-L2TP: fw to WAN!\n");
	
	dev_queue_xmit(skb);	
	return 1;
}

static int l2tp_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;

      len = sprintf(page, "%c\n", fast_l2tp_fw + '0');

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}

static int l2tp_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      char l2tp_tmp;

      if (count < 2)
	    return -EFAULT;

      if (buffer && !copy_from_user(&l2tp_tmp, buffer, 1)) {
	    	fast_l2tp_fw = l2tp_tmp - '0';
      		if(fast_l2tp_fw) {
		      l2tp_tx_id_hook=l2tp_tx_id;
			memset(&l2tpInfo, '\0', sizeof(l2tpInfo));
      		}
	      	else
		{
		      l2tp_tx_id_hook=NULL;
		      l2tpInfo.tid=0;
		}
		return count;
      }
      return -EFAULT;
}


#if defined(CONFIG_PROC_FS)
static struct proc_dir_entry *res1=NULL;
#endif

int __init fast_l2tp_init(void)
{
#if defined(CONFIG_PROC_FS)
	res1 = create_proc_entry("fast_l2tp", 0, NULL);
	if (res1) {
		res1->read_proc = l2tp_read_proc;
		res1->write_proc = l2tp_write_proc;
	}
#endif	
	return 0;
}

void __exit fast_l2tp_exit(void)
{
#if defined(CONFIG_PROC_FS)
	if (res1) {
		remove_proc_entry("fast_l2tp", res1);		
		res1 = NULL;
	}
#endif
}

