/* vi: set sw=4 ts=4: */

/* Definition of Ring Log data structure */

#define RLOG_HEADER_MAGIC		0x4C52 //'RL' for little endian, 'LR' for big endian
#define RLOG_HEADER_VERSION		0x01

typedef struct {
	uint16_t magic;				//signature of file type
	uint8_t  version;			//version of file format
	uint8_t  reserved_03;
	uint16_t entry_count;		//how many entries available for log
	uint16_t log_count;			//how many logs in the files (used entries)

	uint32_t lid_base;			//base of log id pointed by log_begin
	uint16_t log_begin;			//first log in the ring 
	uint16_t log_end;			//the entry after last log in the ring (add new log here)

	uint32_t mb_end;			//the end of message buffer (add new message here)
	uint32_t mb_size;			//total size of current messages
	uint32_t reserved_24;
	uint32_t reserved_28;
} RLOG_INDEX_HEADER;

typedef struct {
	uint32_t time_stamp;
	uint8_t  pri_facility;
	uint8_t  pri_severity;
	uint16_t buf_used;
	uint32_t msg_offset;
} RLOG_INDEX_ENTRY;

/* Configurable properties */

#define RLOG_CONF_MAX_LOG_COUNT		1000
#define RLOG_CONF_ENTRY_COUNT		(RLOG_CONF_MAX_LOG_COUNT + 2)
#define RLOG_CONF_MSG_BUFFER_SIZE	(50*1024)
#define RLOG_CONF_MAX_BUFFER_USED	(RLOG_CONF_MSG_BUFFER_SIZE - 1024)
