// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _QUEUE_HEAD_H_
#define _QUEUE_HEAD_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	head_mpdu_index[13:0], reserved_0a[15:14], mpdu_cnt[29:16], reserved_0b[31:30]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_QUEUE_HEAD 1

struct queue_head {
    volatile uint32_t head_mpdu_index                 : 14, //[13:0]
                      reserved_0a                     :  2, //[15:14]
                      mpdu_cnt                        : 14, //[29:16]
                      reserved_0b                     :  2; //[31:30]
};

/*

head_mpdu_index
			
			The index of the MPDU frame that is at the head of the
			queue. 
			
			Being head of the queue means that this frame will be
			transmitted first.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0  represents the NULL pointer, and is used
			when the queue is empty.

reserved_0a
			
			<legal 0>

mpdu_cnt
			
			MPDU count: The number of MPDUs linked in this queue.
			When the destination STA is in  power save mode, the PDG
			uses this info to determine if all frames from this queue
			will be transmitted in the upcoming PPDU. If not, PDG will
			
			 <legal all>

reserved_0b
			
			<legal 0>
*/


/* Description		QUEUE_HEAD_0_HEAD_MPDU_INDEX
			
			The index of the MPDU frame that is at the head of the
			queue. 
			
			Being head of the queue means that this frame will be
			transmitted first.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0  represents the NULL pointer, and is used
			when the queue is empty.
*/
#define QUEUE_HEAD_0_HEAD_MPDU_INDEX_OFFSET                          0x00000000
#define QUEUE_HEAD_0_HEAD_MPDU_INDEX_LSB                             0
#define QUEUE_HEAD_0_HEAD_MPDU_INDEX_MASK                            0x00003fff

/* Description		QUEUE_HEAD_0_RESERVED_0A
			
			<legal 0>
*/
#define QUEUE_HEAD_0_RESERVED_0A_OFFSET                              0x00000000
#define QUEUE_HEAD_0_RESERVED_0A_LSB                                 14
#define QUEUE_HEAD_0_RESERVED_0A_MASK                                0x0000c000

/* Description		QUEUE_HEAD_0_MPDU_CNT
			
			MPDU count: The number of MPDUs linked in this queue.
			When the destination STA is in  power save mode, the PDG
			uses this info to determine if all frames from this queue
			will be transmitted in the upcoming PPDU. If not, PDG will
			
			 <legal all>
*/
#define QUEUE_HEAD_0_MPDU_CNT_OFFSET                                 0x00000000
#define QUEUE_HEAD_0_MPDU_CNT_LSB                                    16
#define QUEUE_HEAD_0_MPDU_CNT_MASK                                   0x3fff0000

/* Description		QUEUE_HEAD_0_RESERVED_0B
			
			<legal 0>
*/
#define QUEUE_HEAD_0_RESERVED_0B_OFFSET                              0x00000000
#define QUEUE_HEAD_0_RESERVED_0B_LSB                                 30
#define QUEUE_HEAD_0_RESERVED_0B_MASK                                0xc0000000


#endif // _QUEUE_HEAD_H_
