#ifndef _MEMORY_MAP_VRH_
#define _MEMORY_MAP_VRH_
#define KBYTE 1024
#define MBYTE (KBYTE*KBYTE)
/*wlan cpu*/
#define WLAN_CPU_DPORT_BASE 0x400000 
#define WLAN_CPU_IPORT_BASE 0x900000

#define WLAN_CPU_DRAM_BASE  0x400000
#define WLAN_CPU_DRAM_BLOCK_SIZE (32*KBYTE)
#define WLAN_CPU_DRAM_BLOCK_NUM 10 
#define WLAN_CPU_DRAM_SIZE  (WLAN_CPU_DRAM_BLOCK_SIZE*WLAN_CPU_DRAM_BLOCK_NUM)

#define WLAN_CPU_IRAM_BASE  0x980000
#define WLAN_CPU_IRAM_BLOCK_SIZE (32*KBYTE)
#define WLAN_CPU_IRAM_BLOCK_NUM 7
#define WLAN_CPU_IRAM_SIZE  (WLAN_CPU_IRAM_BLOCK_SIZE*WLAN_CPU_IRAM_BLOCK_NUM)

#define WLAN_CPU_IROM_BASE  0x940000
#define WLAN_CPU_IROM_BLOCK_SIZE (64*KBYTE) //tricky
#define WLAN_CPU_IROM_BLOCK_NUM 4 
#define WLAN_CPU_IROM_SIZE  (WLAN_CPU_IROM_BLOCK_SIZE*WLAN_CPU_IROM_BLOCK_NUM)
#define WLAN_CPU_ROM_SIZE  (256*KBYTE)

//non-pcie mode
#define WLAN_INTF_RAM_NON_PCIE_BASE 0xA0000
#define WLAN_INTF_RAM_NON_PCIE_SIZE (128*KBYTE)
//pcie mode ram1
#define WLAN_INTF_RAM1_PCIE_BASE (96*KBYTE)
#define WLAN_INTF_RAM1_PCIE_SIZE (96*KBYTE)
//pcie mode ram2
#define WLAN_INTF_RAM2_PCIE_BASE 0x468000
#define WLAN_INTF_RAM2_PCIE_SIZE (32*KBYTE)
//for shared memory
#define IRAM_DRAM 1
#define INTF_DRAM 2
#define SHARED_A_RAM_BLOCKS_NUM 3
#define SHARED_B_RAM_BLOCKS_NUM 4
#define SHARED_A_RAM_BLOCK_SIZE (32*KBYTE)
#define SHARED_B_RAM_BLOCK_SIZE (32*KBYTE)
#define SHARED_A_RAM_SRC_BASE 0x9b8000  //end of iram
#define SHARED_A_RAM_DST_BASE 0x450000  //end of dram
#define SHARED_B_RAM_SRC_BASE 0xA0000   //start of intf mem
#define SHARED_B_RAM_DST_BASE 0x468000  //start of the shared intf mem in dram space




/*bt cpu*/
#define BT_CPU_DPORT_BASE 0x6000_0000 
#define BT_CPU_DPORT_BASE1 0x0
#define BT_CPU_IPORT_BASE 0x0
#define BT_CPU_IPORT_BASE1 0x1000_0000
#define BT_CPU_DRAM_BLOCK_SIZE (32*KBYTE)
#define BT_CPU_DRAM_BLOCK_NUM 7
#define BT_CPU_DRAM_SIZE    (BT_CPU_DRAM_BLOCK_NUM*BT_CPU_DRAM_BLOCK_SIZE)
#define BT_CPU_IROM_BLOCK_SIZE (64*KBYTE)
#define BT_CPU_IROM_BLOCK_NUM 10 
#define BT_CPU_IROM_SIZE    (BT_CPU_IROM_BLOCK_NUM*BT_CPU_IROM_BLOCK_SIZE)



/*axi bus matrix*/
#define SLV1_BASE 0x000000
#define SLV1_SIZE 0x2000000
#define SLV2_BASE 0x2000000
#define SLV2_SIZE 0x2000000

/*wifi ahb map*/
#define WIFI_CPU_PIF_IN_IRAM_BASE 0xa00000
#define WIFI_CPU_PIF_IN_IRAM_SIZE 0x40000
#define WIFI_CPU_PIF_IN_IROM_BASE 0x900000
#define WIFI_CPU_PIF_IN_IROM_SIZE 0xa0000
#define WIFI_CPU_PIF_IN_DRAM0_BASE 0x400000
#define WIFI_CPU_PIF_IN_DRAM0_SIZE 0x40000
#define WIFI_CPU_PIF_IN_DRAM1_BASE 0x440000
#define WIFI_CPU_PIF_IN_DRAM1_SIZE 0x10000
#define WIFI_AHB_BRIDGE_2_BT_BASE 0x1000000
#define WIFI_AHB_BRIDGE_2_BT_SIZE 0x1000000
#define WIFI_USB_BASE 0x84000
#define WIFI_USB_SIZE 0x4000
#define WIFI_PCIE_BASE 0x100000
#define WIFI_PCIE_SIZE 0x4000


#define WAITI 0x7100
#endif
