/*
 * Copyright (c) 2010, Atheros Communications Inc. 
 * All Rights Reserved.
 * 
 * Copyright (c) 2011 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 * 
 */

#ifndef _IEEE80211_VI_DBG_H_
#define _IEEE80211_VI_DBG_H_

#ifndef UMAC_SUPPORT_VI_DBG
#define UMAC_SUPPORT_VI_DBG 0
#endif

#define  VI_MAX_NUM_MARKERS  4
#define  VI_MAX_NUM_STREAMS  4

/* Structure to hold marker information
 */
struct marker_info {
    u_int16_t  offset;     /* Marker offset in bytes wrt start of the wbuf     */
	u_int16_t  num_bytes;  /* Width of the marker field in bytes - max 4 bytes */
    u_int32_t  match;      /* Marker pattern match value- used as packet filter. Match patterns:
                              For 4 byte match -> byte0 << 24 + byte1 << 16 + byte2 << 8 + byte3
                              For 3 byte match -> byte0 << 16 + byte1 << 8  + byte2
                              For 2 byte match -> byte0 << 8  + byte1
                              For 1 byte match -> byte0
                              where 
                              */ 
};

/* Video debug structure 
 * Used to hold marker, rx sequence number & timestamp information from the iwpriv
 * parameters 
 */ 
struct ieee80211_vi_dbg {
	/* Marker information per stream */                       
    struct     marker_info markers[VI_MAX_NUM_STREAMS][VI_MAX_NUM_MARKERS];
	u_int16_t  rxseq_offset;    /* Pkt seq number offset in bytes wrt wbuf start        */
	u_int16_t  rxseq_num_bytes; /* Number of bytes that make up the pkt seq num field   */
	u_int16_t  time_offset;     /* Pkt timestamp offset in bytes wrt wbuf start         */   
	u_int16_t  time_num_bytes;	/* Number of bytes that make up the pkt timestamp field */
};

/* Video debug parameters - set uing iwpriv
 * These parameters are used to provide the user with an interface to set markers for filtering
 * received packets & finding the locations of the rxsequence numbers/timestamps within the wbuf
 * The markers can be used to look for signatures of pkts generated by standard test tools like
 * chariot/iperf. These marker fields can be extracted from the wbuf by looking at the offset wrt
 * the start of the wbuf & extracting the number of bytes that correspond to this marker. The
 * extracted marker can then be compared with a matching pattern & filtered appropriately.
 * The rx sequence number & timetamp can also be extracted from the wbuf by looking at the offset 
 * wrt the start of the wbuf & extracting the number of bytes that correspond to the rx seq num &
 * timestamp respectively. These can be used to detect pkt losses and for jitter measurements
 */ 
struct ieee80211_vi_dbg_params {
	u_int32_t vi_dbg_cfg;            /* Video debug configuration - Bit0- enable dbg, Bit1 - enable stats log */
	u_int8_t  vi_num_streams;        /* Number of streams */
	u_int8_t  vi_stream_num;         /* the stream number whose markers are being set */
    u_int8_t  vi_num_markers;        /* total number of markers used to filter pkts */   
    u_int8_t  vi_marker_num;         /* the marker number whose parameters (offset, size & match) are being set */
    u_int32_t vi_marker_offset_size; /* byte offset from skb start (upper 16 bits) & size in bytes(lower 16 bits) */
    u_int32_t vi_marker_match;       /* marker pattern match used in filtering */
    u_int32_t vi_rxseq_offset_size;  /* Rx Seq num offset skb start (upper 16 bits) & size in bytes(lower 16 bits) */
	u_int32_t vi_rx_seq_rshift;      /* right-shift value in case field is not word aligned */
	u_int32_t vi_rx_seq_max;         /* Max Rx seq number */ 
	u_int32_t vi_rx_seq_drop;        /* Indicator to the debug app that a particular seq num has been dropped */ 
	u_int32_t vi_time_offset_size;   /* Timestamp offset skb start (upper 16 bits) & size in bytes(lower 16 bits) */
    u_int32_t vi_dbg_restart;        /* set to 1 to re-initialize counters/parameters */   
};


#if UMAC_SUPPORT_VI_DBG
int  ieee80211_vi_dbg_attach(struct ieee80211com *ic);
int  ieee80211_vi_dbg_detach(struct ieee80211com *ic);
void ieee80211_vi_dbg_input(struct ieee80211vap *vap, wbuf_t wbuf);
void ieee80211_vi_dbg_get_marker(struct ieee80211vap *vap);
void ieee80211_vi_dbg_set_param(wlan_if_t vaphandle, ieee80211_param param, u_int32_t val);
u_int32_t ieee80211_vi_dbg_get_param(wlan_if_t vaphandle, ieee80211_param param);
#else
#define ieee80211_vi_dbg_attach(icp) 0
#define ieee80211_vi_dbg_detach(icp) 0
#define ieee80211_vi_dbg_input(vap, wbuf) /**/
#define ieee80211_vi_dbg_get_marker(vap)  /**/
#define ieee80211_vi_dbg_set_param(vaphandle, param, val) /**/
#define ieee80211_vi_dbg_get_param(vaphandle, param) 0 /**/
#endif

#endif


