// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FRAME_INFO_H_
#define _TX_FRAME_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	tx_ad2_31_0[31:0]
//	1	tx_ad2_47_32[15:0], reserved_0[31:16]
//	2	ts_rs_real_ant[23:0], reserved_1[31:24]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FRAME_INFO 3

struct tx_frame_info {
    volatile uint32_t tx_ad2_31_0                     : 32; //[31:0]
    volatile uint32_t tx_ad2_47_32                    : 16, //[15:0]
                      reserved_0                      : 16; //[31:16]
    volatile uint32_t ts_rs_real_ant                  : 24, //[23:0]
                      reserved_1                      :  8; //[31:24]
};

/*

tx_ad2_31_0
			
			Lower 32 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.

tx_ad2_47_32
			
			Upper 16 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.

reserved_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>

ts_rs_real_ant
			
			Antenna information which is updated on every transmit
			packet, or whenever the medium is cleared and default
			antenna has changed. 
			
			Used to update the default antenna information in the
			PPDU End Status in RXPCU.
			
			Antenna is parked on the default antenna once the medium
			clears by shifting the antenna information from TXPCU.

reserved_1
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/


/* Description		TX_FRAME_INFO_0_TX_AD2_31_0
			
			Lower 32 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.
*/
#define TX_FRAME_INFO_0_TX_AD2_31_0_OFFSET                           0x00000000
#define TX_FRAME_INFO_0_TX_AD2_31_0_LSB                              0
#define TX_FRAME_INFO_0_TX_AD2_31_0_MASK                             0xffffffff

/* Description		TX_FRAME_INFO_1_TX_AD2_47_32
			
			Upper 16 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.
*/
#define TX_FRAME_INFO_1_TX_AD2_47_32_OFFSET                          0x00000004
#define TX_FRAME_INFO_1_TX_AD2_47_32_LSB                             0
#define TX_FRAME_INFO_1_TX_AD2_47_32_MASK                            0x0000ffff

/* Description		TX_FRAME_INFO_1_RESERVED_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_FRAME_INFO_1_RESERVED_0_OFFSET                            0x00000004
#define TX_FRAME_INFO_1_RESERVED_0_LSB                               16
#define TX_FRAME_INFO_1_RESERVED_0_MASK                              0xffff0000

/* Description		TX_FRAME_INFO_2_TS_RS_REAL_ANT
			
			Antenna information which is updated on every transmit
			packet, or whenever the medium is cleared and default
			antenna has changed. 
			
			Used to update the default antenna information in the
			PPDU End Status in RXPCU.
			
			Antenna is parked on the default antenna once the medium
			clears by shifting the antenna information from TXPCU.
*/
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_OFFSET                        0x00000008
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_LSB                           0
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_MASK                          0x00ffffff

/* Description		TX_FRAME_INFO_2_RESERVED_1
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_FRAME_INFO_2_RESERVED_1_OFFSET                            0x00000008
#define TX_FRAME_INFO_2_RESERVED_1_LSB                               24
#define TX_FRAME_INFO_2_RESERVED_1_MASK                              0xff000000


#endif // _TX_FRAME_INFO_H_
