// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PCU_BUF_STATUS_H_
#define _PCU_BUF_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	user0_avail_buf_bytes[13:0], user0_fetched_data_cnt[31:14]
//	1	user1_avail_buf_bytes[13:0], user1_fetched_data_cnt[31:14]
//	2	user2_avail_buf_bytes[13:0], user2_fetched_data_cnt[31:14]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PCU_BUF_STATUS 3

struct pcu_buf_status {
    volatile uint32_t user0_avail_buf_bytes           : 14, //[13:0]
                      user0_fetched_data_cnt          : 18; //[31:14]
    volatile uint32_t user1_avail_buf_bytes           : 14, //[13:0]
                      user1_fetched_data_cnt          : 18; //[31:14]
    volatile uint32_t user2_avail_buf_bytes           : 14, //[13:0]
                      user2_fetched_data_cnt          : 18; //[31:14]
};

/*

user0_avail_buf_bytes
			
			Number of bytes  available in the user 0 buffer
			
			<legal all>

user0_fetched_data_cnt
			
			The number of data words removed from the PCU buffer for
			user 0 since the previous PCU_BUF_STATUS TLV was generated.
			
			<legal all>

user1_avail_buf_bytes
			
			Number of bytes  available in the user 1 buffer
			
			<legal all>

user1_fetched_data_cnt
			
			The number of data words removed from the PCU buffer for
			user 1 since the previous PCU_BUF_STATUS TLV was generated
			
			<legal all>

user2_avail_buf_bytes
			
			Number of bytes  available in the user 2 buffer
			
			<legal all>

user2_fetched_data_cnt
			
			The number of data words removed from the PCU buffer for
			user 2 since the previous PCU_BUF_STATUS TLV was generated
			
			<legal all>
*/


/* Description		PCU_BUF_STATUS_0_USER0_AVAIL_BUF_BYTES
			
			Number of bytes  available in the user 0 buffer
			
			<legal all>
*/
#define PCU_BUF_STATUS_0_USER0_AVAIL_BUF_BYTES_OFFSET                0x00000000
#define PCU_BUF_STATUS_0_USER0_AVAIL_BUF_BYTES_LSB                   0
#define PCU_BUF_STATUS_0_USER0_AVAIL_BUF_BYTES_MASK                  0x00003fff

/* Description		PCU_BUF_STATUS_0_USER0_FETCHED_DATA_CNT
			
			The number of data words removed from the PCU buffer for
			user 0 since the previous PCU_BUF_STATUS TLV was generated.
			
			<legal all>
*/
#define PCU_BUF_STATUS_0_USER0_FETCHED_DATA_CNT_OFFSET               0x00000000
#define PCU_BUF_STATUS_0_USER0_FETCHED_DATA_CNT_LSB                  14
#define PCU_BUF_STATUS_0_USER0_FETCHED_DATA_CNT_MASK                 0xffffc000

/* Description		PCU_BUF_STATUS_1_USER1_AVAIL_BUF_BYTES
			
			Number of bytes  available in the user 1 buffer
			
			<legal all>
*/
#define PCU_BUF_STATUS_1_USER1_AVAIL_BUF_BYTES_OFFSET                0x00000004
#define PCU_BUF_STATUS_1_USER1_AVAIL_BUF_BYTES_LSB                   0
#define PCU_BUF_STATUS_1_USER1_AVAIL_BUF_BYTES_MASK                  0x00003fff

/* Description		PCU_BUF_STATUS_1_USER1_FETCHED_DATA_CNT
			
			The number of data words removed from the PCU buffer for
			user 1 since the previous PCU_BUF_STATUS TLV was generated
			
			<legal all>
*/
#define PCU_BUF_STATUS_1_USER1_FETCHED_DATA_CNT_OFFSET               0x00000004
#define PCU_BUF_STATUS_1_USER1_FETCHED_DATA_CNT_LSB                  14
#define PCU_BUF_STATUS_1_USER1_FETCHED_DATA_CNT_MASK                 0xffffc000

/* Description		PCU_BUF_STATUS_2_USER2_AVAIL_BUF_BYTES
			
			Number of bytes  available in the user 2 buffer
			
			<legal all>
*/
#define PCU_BUF_STATUS_2_USER2_AVAIL_BUF_BYTES_OFFSET                0x00000008
#define PCU_BUF_STATUS_2_USER2_AVAIL_BUF_BYTES_LSB                   0
#define PCU_BUF_STATUS_2_USER2_AVAIL_BUF_BYTES_MASK                  0x00003fff

/* Description		PCU_BUF_STATUS_2_USER2_FETCHED_DATA_CNT
			
			The number of data words removed from the PCU buffer for
			user 2 since the previous PCU_BUF_STATUS TLV was generated
			
			<legal all>
*/
#define PCU_BUF_STATUS_2_USER2_FETCHED_DATA_CNT_OFFSET               0x00000008
#define PCU_BUF_STATUS_2_USER2_FETCHED_DATA_CNT_LSB                  14
#define PCU_BUF_STATUS_2_USER2_FETCHED_DATA_CNT_MASK                 0xffffc000


#endif // _PCU_BUF_STATUS_H_
