/*
 *  u-boot/include/linux/mtd/nand_ids.h
 *
 *  Copyright (c) 2000 David Woodhouse <dwmw2@mvhi.com>
 *                     Steven J. Hill <sjhill@cotw.com>
 *
 * $Id: nand_ids.h,v 1.1 2000/10/13 16:16:26 mdeans Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Info:
 *   Contains standard defines and IDs for NAND flash devices
 *
 *  Changelog:
 *   01-31-2000 DMW      Created
 *   09-18-2000 SJH     Moved structure out of the Disk-On-Chip drivers
 *			so it can be used by other NAND flash device
 *			drivers. I also changed the copyright since none
 *			of the original contents of this file are specific
 *			to DoC devices. David can whack me with a baseball
 *			bat later if I did something naughty.
 *   10-11-2000 SJH     Added private NAND flash structure for driver
 *   2000-10-13 BE      Moved out of 'nand.h' - avoids duplication.
 */

#ifndef __LINUX_MTD_NAND_IDS_H
#define __LINUX_MTD_NAND_IDS_H
/*saito*/
#define Hynix_MANUF		0xAD	/* ID code */
#define ST_MANUF		0x20	/* ID code */
#define HY27US08561A	0x75
#define NAND02GW3B2		0xda
/* SAMSUNG NFLASH device codes */
#define K9F5608Q0C 0x35
#define K9F5608D0C 0x75
#define K9F5608U0C 0x75
#define K9F5616Q0C 0x45	/* Two upper bytes are don't care */
#define K9F5616D0C 0x55	/* Two upper bytes are don't care */
#define K9F5616U0C 0x55	/* Two upper bytes are don't care */

static struct nand_flash_dev nand_flash_ids[] = {
	{"Hynix HY27US08561A",    Hynix_MANUF, HY27US08561A, 25, 0, 2, 0x4000, 0},
	{"Samsung           ",    NAND_MFR_SAMSUNG, HY27US08561A, 25, 0, 2, 0x4000, 0},
	{  "ST 2Gbit NAND02G",       ST_MANUF, NAND02GW3B2, 28, 2, 3, 0x20000, 0},
	{"Toshiba TH58100FT",     NAND_MFR_TOSHIBA, 0x79, 27, 0, 3, 0x4000, 0},
	{"Samsung unknown 64Mb",  NAND_MFR_SAMSUNG, 0x76, 26, 0, 3, 0x4000, 0},
	{"Samsung KM29W32000",    NAND_MFR_SAMSUNG, 0xe3, 22, 0, 2, 0x2000, 0},
	{"Samsung KM29U64000",    NAND_MFR_SAMSUNG, 0xe6, 23, 0, 2, 0x2000, 0},
	{"Samsung KM29W16000",    NAND_MFR_SAMSUNG, 0xea, 21, 1, 2, 0x1000, 0},
	{"Samsung K9F5616Q0C",    NAND_MFR_SAMSUNG, 0x45, 25, 0, 2, 0x4000, 1},
	{"Samsung K9K1216Q0C",    NAND_MFR_SAMSUNG, 0x46, 26, 0, 3, 0x4000, 1},
	{NULL,}
};

#endif /* __LINUX_MTD_NAND_IDS_H */
