/*
 * Boot support
 */
#include <common.h>
#include <watchdog.h>
#include <command.h>
#include <image.h>
#include <malloc.h>
#include <zlib.h>
#include <bzlib.h>
#include <environment.h>
#include <asm/byteorder.h>


#if (CONFIG_COMMANDS & CFG_CMD_BOOTD)
int do_bootf (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int rcode = 0;
#ifndef CFG_HUSH_PARSER
	if (run_command (getenv ("bootfcmd"), flag) < 0) rcode = 1;
#else
	if (parse_string_outer(getenv("bootfcmd"),
		FLAG_PARSE_SEMICOLON | FLAG_EXIT_FROM_LOOP) != 0 ) rcode = 1;
#endif
	return rcode;
}

int do_altbootf (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int rcode = 0;
#ifndef CFG_HUSH_PARSER
	if (run_command (getenv ("altbootfcmd"), flag) < 0) rcode = 1;
#else
	if (parse_string_outer(getenv("altbootfcmd"),
		FLAG_PARSE_SEMICOLON | FLAG_EXIT_FROM_LOOP) != 0 ) rcode = 1;
#endif
	return rcode;
}

U_BOOT_CMD(
 	bootf,	1,	1,	do_bootf,
 	"bootf   - boot from flash, i.e., run 'bootfcmd'\n",
	NULL
);

U_BOOT_CMD(
 	altbootf,	1,	1,	do_altbootf,
 	"altbootf   - boot from backup flash partition, i.e., run 'altbootfcmd'\n",
	NULL
);

#endif

