# This flags will be used only by the Marvell arch files compilation.
include $(TOPDIR)/config.mk
include $(TOPDIR)/include/config.mk


# General definitions
CPU_ARCH    = ARM
CHIP        = 88FXX81
VENDOR      = Marvell
ENDIAN      = LE
LD_ENDIAN   = -EL

ifeq ($(BIG_ENDIAN),y)
ENDIAN      = BE
LD_ENDIAN   = -EB
endif


# Main directory structure
SRC_PATH           = $(TOPDIR)/board/mv88fxx81
BOARD_DIR          = $(SRC_PATH)/Board
COMMON_DIR         = $(SRC_PATH)/Common
SOC_DIR            = $(SRC_PATH)/Soc
OSSERVICES_DIR     = $(SRC_PATH)/osServices
USP_DIR            = $(SRC_PATH)/USP
PLATFORM_DIR       = $(SRC_PATH)/  # make it nicer here!
UNIMAC		   = $(SRC_PATH)/USP/uniMAC/

# Board components
BOARD_ENV_DIR      = $(BOARD_DIR)/boardEnv
BOARD_ENV_PLAT_DIR = $(BOARD_DIR)/boardEnv/DB_$(CHIP)
BOARD_DRAM_DIR     = $(BOARD_DIR)/dram
BOARD_ETHPHY_DIR   = $(BOARD_DIR)/ethPhy
BOARD_FLASH_DIR    = $(BOARD_DIR)/flash
BOARD_PCI_DIR      = $(BOARD_DIR)/pci
BOARD_RTC_DIR      = $(BOARD_DIR)/rtc

SATA_CORE_DIR      = $(BOARD_DIR)/SATA/CoreDriver/

# Soc components

SOC_CPU_DIR        = $(SOC_DIR)/cpu
SOC_CPU_PLAT_DIR   = $(SOC_DIR)/cpu/MV_$(CHIP)
SOC_AHB_TO_MBUS_DIR       = $(SOC_DIR)/ahbtombus
SOC_CNTMR_DIR      = $(SOC_DIR)/cntmr
SOC_CPU_IF_DIR     = $(SOC_DIR)/cpuIf
CTRL_ENV_DIR       = $(SOC_DIR)/ctrlEnv
CTRL_ENV_CHIP_DIR  = $(CTRL_ENV_DIR)/MV_$(CHIP)
SOC_DEVICE_DIR     = $(SOC_DIR)/device
SOC_DRAM_DIR       = $(SOC_DIR)/dram
SOC_DRAM_ARCH_DIR  = $(SOC_DRAM_DIR)/Arch$(CPU_ARCH)
SOC_GPP_DIR        = $(SOC_DIR)/gpp
SOC_IDMA_DIR       = $(SOC_DIR)/idma
SOC_PCI_DIR        = $(SOC_DIR)/pci
SOC_PEX_DIR        = $(SOC_DIR)/pex
SOC_TWSI_DIR       = $(SOC_DIR)/twsi
SOC_TWSI_ARCH_DIR  = $(SOC_TWSI_DIR)/Arch$(CPU_ARCH)
SOC_ETH_DIR        = $(SOC_DIR)/eth
SOC_UART_DIR       = $(SOC_DIR)/uart
SOC_PCIIF_DIR      = $(SOC_DIR)/pciIf
SOC_XOR_DIR         = $(SOC_DIR)/xor
SOC_USB_DIR        = $(SOC_DIR)/usb
SOC_USB_API_DIR    = $(SOC_USB_DIR)/api
SOC_USB_EXM_DIR    = $(SOC_USB_DIR)/examples

SOC_USB_REST_DIR    = $(SOC_DIR)/usb_restricted

SOC_USB_COM_DIR    = $(SOC_USB_REST_DIR)/common
SOC_USB_DEV_DIR    = $(SOC_USB_REST_DIR)/device
SOC_USB_HOST_DIR   = $(SOC_USB_REST_DIR)/host
SOC_USB_REST_EXM_DIR	= $(SOC_USB_REST_DIR)/examples
SOC_USB_REST_CLASS_DIR	= $(SOC_USB_REST_DIR)/classes

SOC_SATA_DIR        = $(SOC_DIR)/sata

# OS services
OSSERV_UBOOT       = $(OSSERVICES_DIR)/uboot
OSSERV_ARCH_DIR    = $(OSSERVICES_DIR)/uboot/Arch$(CPU_ARCH)

# Internal definitions
MV_DEFINE = -DMV_UBOOT -DMV_CPU_$(ENDIAN) -DMV_$(CPU_ARCH)

# Internal include path
BOARD_PATH         = -I$(BOARD_DIR) -I$(BOARD_ENV_DIR)           \
                     -I$(BOARD_DRAM_DIR) -I$(BOARD_ETHPHY_DIR) -I$(BOARD_FLASH_DIR) \
                     -I$(BOARD_PCI_DIR) -I$(BOARD_RTC_DIR) -I$(BOARD_ENV_PLAT_DIR) \
		     -I$(SATA_CORE_DIR)
                     
COMMON_PATH        = -I$(COMMON_DIR) 
SOC_PATH    = -I$(SOC_DIR) -I$(SOC_UART_DIR) -I$(SOC_CNTMR_DIR)     \
                     -I$(SOC_CPU_IF_DIR) -I$(CTRL_ENV_DIR) -I$(SOC_DEVICE_DIR)       \
                     -I$(SOC_DRAM_DIR) -I$(SOC_DRAM_ARCH_DIR) -I$(SOC_GPP_DIR)   \
                     -I$(SOC_IDMA_DIR) -I$(SOC_PCI_DIR) -I$(CTRL_ENV_CHIP_DIR)    \
                     -I$(SOC_ETH_DIR) -I$(SOC_TWSI_DIR) -I$(SOC_AHB_TO_MBUS_DIR)        \
                     -I$(SOC_TWSI_ARCH_DIR) -I$(SOC_PEX_DIR) -I$(SOC_PCIIF_DIR) \
                     -I$(SOC_CPU_DIR) -I$(SOC_CPU_PLAT_DIR) -I$(SOC_USB_DIR) \
		     -I$(SOC_XOR_DIR)
                     
OSSERVICES_PATH    = -I$(OSSERVICES_DIR) -I$(OSSERV_UBOOT) -I$(OSSERV_ARCH_DIR) 
USP_PATH           = -I$(USP_DIR) -I$(UNIMAC) -I$(UNIMAC)/ethDrv/
PLATFORM_PATH      = -I$(PLATFORM_DIR)

CFLAGS   += $(MV_DEFINE) $(OSSERVICES_PATH) $(BOARD_PATH) $(COMMON_PATH) $(SOC_PATH)  \
            $(USP_PATH) $(PLATFORM_PATH)

AFLAGS  += $(MV_DEFINE) $(OSSERVICES_PATH) $(BOARD_PATH) $(COMMON_PATH) $(SOC_PATH)  \
           $(USP_PATH) $(PLATFORM_PATH)

