/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

This software file (the "File") is owned and distributed by Marvell 
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the two
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.
********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File under the following licensing terms. 
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    *   Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer. 

    *   Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution. 

    *   Neither the name of Marvell nor the names of its contributors may be 
        used to endorse or promote products derived from this software without 
        specific prior written permission. 
    
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/
/********************************************************************************
* ethernetRegs.h - Header File for : Marvell Fast Ethernet Controller registers 
*
* DESCRIPTION:
*       This header file contains macros typedefs and function declaration for
*       the Marvell Fast Ethernet Controller registers. 
*
* DEPENDENCIES:
*       None.
*
*******************************************************************************/

#ifndef __INCethRegsh
#define __INCethRegsh

#define ETH_PORTS_GAP              0x0 
/* Ethernet port register offsets from port base address */
#define PORT_CONFIG_REG(ethPortNum)         (ETH_PORTS_GAP*(ethPortNum) + 0x78400)
#define PORT_CONFIG_EXTEND_REG(ethPortNum)  (ETH_PORTS_GAP*(ethPortNum) + 0x78408)
#define PORT_COMMAND_REGISTER(ethPortNum)   (ETH_PORTS_GAP*(ethPortNum) + 0x78410)
#define PORT_STATUS_REGISTER(ethPortNum)    (ETH_PORTS_GAP*(ethPortNum) + 0x78418)
#define HASH_TABLE_BASE_ADDR(ethPortNum)    (ETH_PORTS_GAP*(ethPortNum) + 0x78428)
#define SDMA_CONFIG_REGISTER(ethPortNum)    (ETH_PORTS_GAP*(ethPortNum) + 0x78440)
#define SDMA_COMMAND_REGISTER(ethPortNum)   (ETH_PORTS_GAP*(ethPortNum) + 0x78448)
#define ETH_CAUSE_REG(ethPortNum)           (ETH_PORTS_GAP*(ethPortNum) + 0x78450)
#define ETH_RESET_SELECT_REG(ethPortNum)    (ETH_PORTS_GAP*(ethPortNum) + 0x78454)
#define ETH_MASK_REG(ethPortNum)            (ETH_PORTS_GAP*(ethPortNum) + 0x78458)
#define FIRST_RX_DESC_PTR0(ethPortNum)      (ETH_PORTS_GAP*(ethPortNum) + 0x78480)
#define FIRST_RX_DESC_PTR1(ethPortNum)      (ETH_PORTS_GAP*(ethPortNum) + 0x78484)
#define FIRST_RX_DESC_PTR2(ethPortNum)      (ETH_PORTS_GAP*(ethPortNum) + 0x78488)
#define FIRST_RX_DESC_PTR3(ethPortNum)      (ETH_PORTS_GAP*(ethPortNum) + 0x7848c)

#define CURR_RX_DESC_PTR0(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784a0)
#define CURR_RX_DESC_PTR1(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784a4)
#define CURR_RX_DESC_PTR2(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784a8)
#define CURR_RX_DESC_PTR3(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784ac)

#define CURR_TX_DESC_PTR0(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784e0)
#define CURR_TX_DESC_PTR1(ethPortNum)       (ETH_PORTS_GAP*(ethPortNum) + 0x784e4)

#define ETH_WIN_BASE_REG(win)               (0x74034 + ((win)<<4))
#define ETH_WIN_SIZE_REG(win)               (0x74030 + ((win)<<4))


#define FIRST_RX_DESC_PTR(ethPort, rxQueue)             \
            (ETH_PORTS_GAP*(ethPort) + 4*(rxQueue) + 0x480)
#define CURR_RX_DESC_PTR(ethPort, rxQueue)              \
            (ETH_PORTS_GAP*(ethPort) + 4*(rxQueue) + 0x4a0)
#define CURR_TX_DESC_PTR(ethPort, txQueue)              \
            (ETH_PORTS_GAP*(ethPort) + 4*(txQueue) + 0x4e0)


/* Port status register bits offset in register */
/* #define LINK_UP_BIT     (1<<3) */

/* this macros are used to enable access to SDMA_CONFIGURATION */
/* #define SINGLE_FRAME_MODE               (1<<1) */
/* #define RECEIVE_FIFO_THRESHOLD          1 */
#define BURST_SIZE                      (3<<12)


/* These macros describes the Ethernet Port Configuration Register bits		*/
#define	ETH_PROMISCUOUS_MODE		(1<<0 ) /* Enable promiscuous mode 	*/
#define REJECT_BROADCAST		(1<<1 ) /* Reject Broadcast Mode 	*/
/* #define PASS_BAD_FRAMES		(1<<2 )  Pass Bad Frames 		*/ 
#define PORT_ENABLE			(1<<7 ) /* Port enable 			*/
/* #define FORCE_COLLISION		(1<<10)  Force Collision  	  	*/
#define ETH_HASH_SIZE_500		(1<<12) /* Hash table size 0 - 8K, 1 - 0.5k   	*/
#define ETH_HASH_FUNCTION_1		(1<<13) /* Hash function 1 or function 0 	*/
#define ETH_HASH_PASS_ADDRS_NOT_FOUND 	(1<<14) /* Hash function operation mode 	*/
/* #define DUPLEX_MODE_FULL    		(1<<15)  Valid when duplex auto-neg disabled	*/
/* #define ACCS				(1<<31)  Accelerate Slot Time 	  		*/
#define PCR_RES				((1<<15)|(0x2<<20)|(0x1<<24)|(0x1<<27))

/* These macros describes the Ethernet Port Configuration Extend Register bits		*/
#define IGMP_ENABLE			(1<<0 ) /* IGMP Packets Capture Enable 		*/
#define SPAN_ENABLE			(1<<1 ) /* Spanning Tree Packets Capture Enable */
/* #define PARTITION_ENABLE		(1<<2 )  Enable partition 			*/
#define RX_PRIO_OVERRIDE		(1<<8 ) /* Override Priority Rx on this Port  	*/
/* #define AUTO_NEG_DUPLEX_DIS		(1<<9 )  Auto-negotiation for Duplex Mode 	*/
/* #define AUTO_NEG_FLOW_DIS		(1<<10)  Auto-neg for 802.3x Flow-control 	*/
/* #define FORCE_LINK_NO		(1<<11)  Force Link Pass 			*/
#define FLOW_CTRL_DISABLE		(1<<12)  /* Enable Flow-Control Mode 		*/
/* #define MFL_1518_BYTES		(0<<14)  Maximum packet allowed for reception   */
/* #define MFL_1536_BYTES		(1<<14)  Maximum packet allowed for reception */
/* #define MFL_2048_BYTES		(2<<14)  Maximum packet allowed for reception   */
/* #define MFL_64K_BYTES		(3<<14)  Maximum packet allowed for reception   */
/* #define MIB_CLEAR_MODE		(1<<16)  MIB Counters Clear Mode 		*/
/* #define PORT_SPEED_100		(1<<18)  Port Speed 				*/
/* #define AUTO_NEG_SPEED_DIS		(1<<19)  Enable Auto-negotiation for Speed 	*/
/* #define RMII_ENABLE			(1<<20)  RMII enable 				*/
#define DSCP_ENABLE			(1<<21) /* DSCP enable 				*/
#define HEADER_ENABLE       		(1<<22) /* enable header mode 			*/
#define PCER_RES			((3<<9) | (1 <<14) | (1<<18) | (1<<19))

/* SDMA Configuration Register (SDCR) */
#define SDCR_BLMR_LITTLE    (1<<6)
#define SDCR_BLMT_LITTLE    (1<<7)
/* #define SDCR_POVR        (1<<8)  Enable PCI Override */
#define SDCR_RIFB           (1<<9)  /* Receive Interrupt on Frame Boundaries  */ 
#define SDCR_BSZ_1x64       (0<<12) /* maximum burst size of SDMA transactions*/
#define SDCR_BSZ_2x64       (1<<12) /* maximum burst size of SDMA transactions*/
#define SDCR_BSZ_4x64       (2<<12) /* maximum burst size of SDMA transactions*/
#define SDCR_BSZ_8x64       (3<<12) /* maximum burst size of SDMA transactions*/

/* Describes Ethernet SDMA Command register options. used in SetCommand()     */
#define ETH_ENABLE_RX_DMA   (1<<7 )
#define ETH_ABORT_RECEIVE   (1<<15)
#define ETH_STOP_TX_HIGH    (1<<16)
#define ETH_STOP_TX_LOW     (1<<17)
#define ETH_START_TX_HIGH   (1<<23)
#define ETH_START_TX_LOW    (1<<24)
#define ETH_ABORT_TRANSMIT  (1<<31) 


/* SDMA command status fields macros */
#define ETH_ERROR_SUMMARY                (1<<15)
#define ETH_LAST_DESC                    (1<<16)
#define ETH_FIRST_DESC                   (1<<17)
#define ETH_ZERO_PADDING	         (1<<18)
#define ETH_GEN_CRC                      (1<<22)
#define ETH_ENABLE_INTERRUPT             (1<<23)
#define ETH_BUFFER_OWNED_BY_DMA          (1<<31)


/* Ethernet Base Address Register bits */
#define ETH_MAX_DECODE_WIN              4

/* Ethernet Port Access Protect (EPAP) register */
#define ETH_WIN_TARGET_OFFS 	4 /* The target associated with this window*/
#define ETH_WIN_TARGET_MASK 	(0xf << ETH_WIN_TARGET_OFFS)
#define ETH_WIN_ATTR_OFFS   	8 /* The target attributes Associated with window */
#define ETH_WIN_ATTR_MASK   	(0xff << ETH_WIN_ATTR_OFFS)
#define ETH_WIN_ENABLE	    	(1<<0)

#endif /* __INCethRegsh */

