/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

This software file (the "File") is owned and distributed by Marvell 
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the two
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.
********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File under the following licensing terms. 
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    *   Redistributions of source code must retain the above copyright notice,
	    this list of conditions and the following disclaimer. 

    *   Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution. 

    *   Neither the name of Marvell nor the names of its contributors may be 
        used to endorse or promote products derived from this software without 
        specific prior written permission. 
    
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/


/* includes */
#define MV_ASMLANGUAGE
#include "mvOsAsm.h"
#include "mvTwsiSpec.h"
#include "mvSysHwConfig.h"


/* defines */
/* defines  */


        .data
        .global _i2cInit
        .global _i2cRead
        .global _i2cWrite
        .global _PanelRead
        .global _PanelWrite
        .text

/*******************************************************************************
* _i2cInit - Initialize TWSI interface
*
* DESCRIPTION:
*       The function performs TWSI interface initialization. It resets the 
*       TWSI state machine and initialize its clock to 100KHz assuming Tclock
*       of 133MHz.
*
* INPUT:
*       None.
*
* OUTPUT:
*       None.
*
* RETURN:
*       None.
*
*******************************************************************************/
_i2cInit:        
        mov     r9, LR     /* Save link register */
        /* Reset the i2c Mechanism first */
        mov     r0, #0     /* Make sure r0 is zero */        
        MV_REG_WRITE_ASM (r0, r1, TWSI_SOFT_RESET_REG)
        /*MV_REG_WRITE_ASM (r0, r1, TWSI_CONTROL_REG)*/

        bl      _twsiDelay        
        bl      _twsiDelay              

        /* Initializing the I2C mechanism. Assuming Tclock frequency          */
        /* of 166MHz. The I2C frequency in that case will be 100KHz.          */
        /* For this settings, M = 9 and N = 3. Set the baud-rate with the     */
        /* value of 0x2b (freq of ==> 100KHz                                  */
        /* see spec for more details about the calculation of this value)     */
        mov     r6, #(9 << 3 | 3)
        MV_REG_WRITE_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
        
        /* Enable the I2C master */
        mov     r6, #0x44
        MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
        
        /* Let the slow TWSI machine get used to the idea that it is enabled  */
        bl      _twsiDelay
        
        
        mov     PC, r9         /* r9 is saved link register */

/*******************************************************************************
* _twsiDelay - Perform delay.
*
* DESCRIPTION:
*       The function performs a delay to enable TWSI logic to stable.
*
* INPUT:
*       None.
*
* OUTPUT:
*       None.
*
* RETURN:
*       None.
*
*******************************************************************************/
_twsiDelay:
        mov     r10, #0x500 
    
_twsiDelayLoop:
        subs    r10, r10, #1
        bne     _twsiDelayLoop
        
        mov     PC, LR

/*******************************************************************************
* _i2cRead - Read byte from I2C EEPROM device.
*
* DESCRIPTION:
*       The function returns a byte from I2C EEPROM device. 
*       The EEPROM device is 7-bit address type. 
*
* INPUT:
*       r4 has the DIMM0 base address with shift 1 bit to the left
*       r7 has the EEPROM offset
*
* OUTPUT:
*       None.
*
* RETURN:
*       r4 returns '0' if address can not be read.
*       r7 has byte value in case read is successful.
*
*******************************************************************************/
_i2cRead:
  mov     r9, LR     /* Save link register */

  /* Transmit the device address and desired offset within the EEPROM. */

   /*========================================================================*/
  /* Generate Start Bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  /* Wait for the start bit to be reset by HW */
  mov     r10, #0x50000 
loop_1:
  subs    r10, r10, #1
  beq     loop_1_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     loop_1

loop_1_timeout:

  /* Wait for the interrupt flag (bit3) to be set  */
  mov     r10, #0x50000
loop_2:
  subs    r10, r10, #1
  beq     loop_2_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_2
loop_2_timeout:

/* Wait for the status TWSI_START_CONDITION_TRA = 0x8 */
  mov     r10, #0x50000
loop_3:
  subs    r10, r10, #1
  beq     loop_3_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x08
  bne     loop_3
loop_3_timeout:

   /*========================================================================*/
  /* writing the address of (DIMM0/1 << 1) with write indication */
  mov     r6, r4, LSL #1 /* Write operation address bit 0 must be 0 */
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

  /* Waiting for the interrupt flag to be set which means that the
     address has been transmitted                                  */
loop_4:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_4       /* if tst = 0, then the bit is not set yet */

  /* Wait for status TWSI_ADDR_PLUS_WRITE_BIT_TRA_ACK_REC = 0x18 */
  mov     r10, #0x50000         /* Set r10 to 0x50000 =~ 328,000 */
loop_5:
  subs    r10, r10, #1          /* timeout count down         */
  bne     testStatus
  mov     r4, #0                /* r4 = 0 -> operation failed */  
  b       exit_i2cRead          /* Exit if timeout (No DIMM)  */
testStatus:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x18
  bne     loop_5


  /* check if the offset is bigger than 256 byte*/
  tst     r7, #0x80000000
  bne     great_than_256
  b after_offset


  /*========================================================================*/
  /* Write the offset to be read from the DIMM EEPROM */
  /*MV_REG_WRITE_ASM (r7, r1, TWSI_DATA_REG)*/

great_than_256:
  mov     r10, r7, LSR #8
  and     r10, r10, #0xff
  /* Write the offset0 to be read from the  EEPROM */
  MV_REG_WRITE_ASM (r10, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
     be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
loop_6_1:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_6_1

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
loop_7_1:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     loop_7_1


  /*========================================================================*/
  /* Write the offset1 to be read from the  EEPROM */
after_offset:
  mov     r10, r7
  and     r10, r10, #0xff

  MV_REG_WRITE_ASM (r10, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
     be transmited                                                    */

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
loop_6:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_6

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
loop_7:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     loop_7


  /* Retransmit the device address with read indication to get the data */
  /*========================================================================*/
  /* generate a repeated start bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)


  /* Clear the interrupt flag ==> the start bit will be transmitted. */ 
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

  /* Wait for the start bit to be reset by HW */
loop_8:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     loop_8

  /* Wait for the interrupt flag (bit3) to be set */
loop_9:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_9

  /* Wait for status TWSI_REPEATED_START_CONDITION_TRA = 0x10 */
loop_10:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x10
  bne     loop_10

  /*========================================================================*/
  /* Writing the address of (DIMM0<<1) with read indication (bit0 is 1) */
  mov     r6, r4, LSL #1
  orr     r6, r6, #1     /* Read operation address bit 0 must be 1 */
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> the address will be transmitted */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt flag (bit3) to be set as a result of
     transmitting the address.                                     */
loop_11:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_11

  /* Wait for status TWSI_ADDR_PLUS_READ_BIT_TRA_ACK_REC = 0x40 */
loop_12:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x40
  bne     loop_12

  /* Clear the interrupt flag and signal no-acknowledge  */
loop_13:
  /* First, wait for the interrupt flag (bit3) to be set */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_13

  /* assaf 1 */
  /* Clear the interrupt flag and the Acknoledge bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #(TWSI_CONTROL_INT_FLAG_SET | TWSI_CONTROL_ACK)
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay


  /*========================================================================*/
  /* Wait for the interrupt flag (bit3) to be set */
loop_14:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     loop_14

  /* Wait for status TWSI_MAS_REC_READ_DATA_ACK_NOT_TRA = 0x58 */
loop_15:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x58
  bne     loop_15

  /* Store the data in r7. */
  MV_REG_READ_ASM (r7, r1, TWSI_DATA_REG)

  /*========================================================================*/
  /* Generate stop bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_STOP_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)


  /* Clear the interrupt flag  */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the stop bit to be reset by HW */
loop_16:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_INT_FLAG_SET
  bne     loop_16

exit_i2cRead:
  mov     PC, r9         /* r9 is saved link register */

/*******************************************************************************
* _i2cWrite - Write byte to I2C EEPROM device.
*
* DESCRIPTION:
*
* INPUT:
*       r4 has the Subaddress with shift 1 bit to the left
*       r7 has the EEPROM offset+Data1+Data2
*
*
* OUTPUT:
*       None.
*
* RETURN:
*       r4 returns '0' if address can not be read.
*       r7 has byte value in case read is successful.
*
*******************************************************************************/
_i2cWrite:
  mov     r9, LR     /* Save link register */

  /*========================================================================*/
  /* Transmit the device address and desired offset within the EEPROM. */
  /* Generate Start Bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  /* Wait for the start bit to be reset by HW */
  mov     r10, #0x50000 
wloop_1:
  subs    r10, r10, #1
  beq     wloop_1_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     wloop_1
wloop_1_timeout:

  /* Wait for the interrupt flag (bit3) to be set  */
  mov     r10, #0x50000        
wloop_2:
  subs    r10, r10, #1
  beq     wloop_2_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     wloop_2
wloop_2_timeout:

  /* Wait for the status TWSI_START_CONDITION_TRA = 0x8 */
  mov     r10, #0x50000
wloop_3:
  subs    r10, r10, #1
  beq     wloop_3_timeout
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x08
  bne     wloop_3
wloop_3_timeout:

  /*========================================================================*/
  /* writing the address of (DIMM0/1 << 1) with write indication */
  mov     r6, r4, LSL #1 /* Write operation address bit 0 must be 0 */
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay
  /* Waiting for the interrupt flag to be set which means that the
     address has been transmitted                                  */
wloop_4:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     wloop_4       /* if tst = 0, then the bit is not set yet */

  /* Wait for status TWSI_ADDR_PLUS_WRITE_BIT_TRA_ACK_REC = 0x18 */
  mov     r10, #0x50000         /* Set r10 to 0x50000 =~ 328,000 */
wloop_5:
  subs    r10, r10, #1          /* timeout count down         */
  bne     wtestStatus1
  mov     r4, #0                /* r4 = 0 -> operation failed */  
  b       exit_i2cWrite          /* Exit if timeout (No DIMM)  */
wtestStatus1:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x18
  bne     wloop_5

  /*========================================================================*/
  /* Write the offset to be read from the DIMM EEPROM */
  mov     r6, r7, LSR #16 /* Write operation address bit 0 must be 0 */
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
     be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
wloop_6:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     wloop_6

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
wloop_7:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     wloop_7

  /*========================================================================*/
  /* Write the Data1 */
  mov     r6, r7, LSR #8 /* Write Data1*/
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
           be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
wloop_8:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     wloop_8

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
wloop_9:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     wloop_9


  /*========================================================================*/
  /* Write the Data2 */
  mov     r6, r7 /* Write Data2*/
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
           be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
wloop_10:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     wloop_10

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
wloop_11:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     wloop_11

  /*========================================================================*/
  /* Generate stop bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_STOP_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  /* Clear the interrupt flag  */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay
  bl      _twsiDelay

  /* Wait for the stop bit to be reset by HW */
/*
wloop_12:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_INT_FLAG_SET
  bne     wloop_12
*/


exit_i2cWrite:
  bl      _twsiDelay
  mov     PC, r9         /* r9 is saved link register */
/*******************************************************************************
* _PanelRead - Read byte from I2C Panel device.
*
* DESCRIPTION:
*
* INPUT:
*       r7 has the DATA offset
*
* OUTPUT:
*       None.
*
* RETURN:
*       r4 returns '0' if address can not be read.
*       r7 has WORD value in case read is successful.
*
*******************************************************************************/
_PanelRead:
  mov     r9, LR     /* Save link register */

  /* Transmit the device address and desired offset within the EEPROM. */

  /*=========================================================================*/
  /* Generate Start Bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)


  mov     r10, #0x50000          /* Wait for the start bit to be reset by HW */
pRL1:
  subs    r10, r10, #1
  beq     pRL2
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     pRL1
pRL2:

  mov     r10, #0x50000         /* Wait for the interrupt flag (bit3) to be set  */
pRL3:
  subs    r10, r10, #1
  beq     pRL4
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL3
pRL4:

  mov     r10, #0x50000         /* Wait for the status TWSI_START_CONDITION_TRA = 0x8 */
pRL5:
  subs    r10, r10, #1
  beq     pRL6
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x08
  bne     pRL5
pRL6:

  /*=========================================================================*/
  /* writing the address  */
  mov      r6,#0x70
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)     /* Clear the interrupt flag */
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Waiting for the interrupt flag to be set which means that the
     address has been transmitted                                  */
pRL7:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)  /* Waiting for the interrupt flag to be set*/
  and     r6, r6, #0x08                       /*which means that the address has been transmitted */
  tst     r6, #0x08
  beq     pRL7       /* if tst = 0, then the bit is not set yet */

                                 /* Wait for status TWSI_ADDR_PLUS_WRITE_BIT_TRA_ACK_REC = 0x18 */
  mov     r10, #0x50000          /* Set r10 to 0x50000 =~ 328,000 */
pRL8:
  subs    r10, r10, #1           /* timeout count down         */
  bne     pRL9
  mov     r4, #0                 /* r4 = 0 -> operation failed */
  b       exit_PanelRead         /* Exit if timeout (No DIMM)  */
pRL9:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x18
  bne     pRL8

  /*=========================================================================*/
  /* Write the offset to be read from the  Panel */
  mov     r10, r7
  and     r10, r10, #0xff
  MV_REG_WRITE_ASM (r10, r1, TWSI_DATA_REG)

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)  /* Clear the interrupt flag*/
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

pRL10:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG) /* Wait for the interrupt to be set */
  and     r6, r6, #0x08                      /* ==> address has transmited */
  tst     r6, #0x08
  beq     pRL10

pRL11:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
  cmp     r6, #0x28
  bne     pRL11


  /* Retransmit the device address with read indication to get the data */
  /*=========================================================================*/
  /* generate a repeated start bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG) /* Clear the interrupt flag */
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

pRL12:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)   /* Wait for the start bit to be reset by HW */
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     pRL12

pRL13:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)    /* Wait for the interrupt flag (bit3) to be set */
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL13

pRL14:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG) /* Wait for status TWSI_REPEATED_START_CONDITION_TRA = 0x10 */
  cmp     r6, #0x10
  bne     pRL14

  /*=========================================================================*/
  /* Writing the address of Ranel with read indication (bit0 is 1) */
  mov     r6,#0x71
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)    /* Clear the interrupt flag */
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

pRL15:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL15

pRL16:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)    /* Wait for status TWSI_ADDR_PLUS_READ_BIT_TRA_ACK_REC = 0x40 */
  cmp     r6, #0x40
  bne     pRL16

pRL16_1:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL16_1


  /*=========================================================================*/
  /* assaf 1 */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)         /* Clear the interrupt flag  bit */
  bic     r6,r6,#TWSI_CONTROL_INT_FLAG_SET
  orr     r6, r6,#TWSI_CONTROL_ACK
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

pRL17:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)    /* Wait for the interrupt flag (bit3) to be set */
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL17

pRL18:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)   /* Wait for status TWSI_MAS_REC_READ_DATA_ACK TRA = 0x50 */
  cmp     r6, #0x50
  bne     pRL18

  /* Store the data in r7. */
  MV_REG_READ_ASM (r7, r1, TWSI_DATA_REG)
  and     r7, r7, #0xff
  mov     r5, r7, LSL #8 


  /*========================================================================*/
  /* assaf 2 */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)        /* Clear the interrupt flag and signal no-acknowledge  */
  bic     r6, r6, #(TWSI_CONTROL_INT_FLAG_SET | TWSI_CONTROL_ACK) 
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

pRL19:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)     /* Wait for the interrupt flag (bit3) to be set */
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pRL19

pRL20:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)   /* Wait for status TWSI_MAS_REC_READ_DATA_ACK_NOT_TRA = 0x58 */
  cmp     r6, #0x58
  bne     pRL20

  /* Store the data in r7. */
  MV_REG_READ_ASM (r7, r1, TWSI_DATA_REG)
  and     r7, r7, #0xff
  orr     r7, r7, r5

  /*========================================================================*/
  /* Generate stop bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_STOP_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)    /* Clear the interrupt flag  */
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

pRL21:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)   /* Wait for the stop bit to be reset by HW */
  tst     r6, #TWSI_CONTROL_INT_FLAG_SET
  bne     pRL21

  mov     r4,#1
exit_PanelRead:
  mov     PC, r9         /* r9 is saved link register */

/*******************************************************************************
* _PanelWrite - Write byte to I2C Panel device.
*
* DESCRIPTION:
*
* INPUT:
*   r7 has the EEPROM offset+Data1+Data2
*
*
* OUTPUT:
*       None.
*
* RETURN:
*       r4 returns '0' if address can not be read.
*
*******************************************************************************/
_PanelWrite:
  mov     r9, LR     /* Save link register */

  /*========================================================================*/
  /* Transmit the device address and desired offset within the EEPROM. */
  /* Generate Start Bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_START_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  /* Wait for the start bit to be reset by HW */
  mov     r10, #0x50000 
pWL1:
  subs    r10, r10, #1
  beq     pWL2
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_START_BIT
  bne     pWL1
pWL2:

  mov     r10, #0x50000                                /* Wait for the interrupt flag (bit3) to be set  */
pWL3:
  subs    r10, r10, #1
  beq     pWL4
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pWL3
pWL4:

  mov     r10, #0x50000                                /* Wait for the status TWSI_START_CONDITION_TRA = 0x8 */
pWL5:
  subs    r10, r10, #1
  beq     pWL6
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x08
  bne     pWL5
pWL6:

  /*========================================================================*/
  /* writing the address */
  mov     r6,#0x70
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay
  /* Waiting for the interrupt flag to be set which means that the
     address has been transmitted                                  */
pWL7:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pWL7       /* if tst = 0, then the bit is not set yet */

  /* Wait for status TWSI_ADDR_PLUS_WRITE_BIT_TRA_ACK_REC = 0x18 */
  mov     r10, #0x50000         /* Set r10 to 0x50000 =~ 328,000 */
pWL8:
  subs    r10, r10, #1          /* timeout count down         */
  bne     pWL9
  mov     r4, #0                /* r4 = 0 -> operation failed */  
  b       exit__PanelWrite          /* Exit if timeout (No DIMM)  */
pWL9:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x18
  bne     pWL8

  /*========================================================================*/
  /* Write the offset */
  mov     r6, r7, LSR #16 /* Write operation address bit 0 must be 0 */
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
     be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
pWL10:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pWL10

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
pWL11:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     pWL11

  /*========================================================================*/
  /* Write the Data1 */
  mov     r6, r7, LSR #8 /* Write Data1*/
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
           be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)
  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
pWL12:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pWL12

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
pWL13:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     pWL13


  /*========================================================================*/
  /* Write the Data2 */
  mov     r6, r7 /* Write Data2*/
  and     r6, r6, #0xff
  MV_REG_WRITE_ASM (r6, r1, TWSI_DATA_REG)

  /* Clear the interrupt flag ==> signaling that the address can now
           be transmited                                                    */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay

  /* Wait for the interrupt to be set again ==> address has transmited */
pWL14:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  and     r6, r6, #0x08
  tst     r6, #0x08
  beq     pWL14

  /* Wait for status TWSI_MAS_TRAN_DATA_BYTE_ACK_REC = 0x28 */
pWL15:
  MV_REG_READ_ASM (r6, r1, TWSI_STATUS_BAUDE_RATE_REG)
  cmp     r6, #0x28
  bne     wloop_11

  /*========================================================================*/
  /* Generate stop bit */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  orr     r6, r6, #TWSI_CONTROL_STOP_BIT
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  /* Clear the interrupt flag  */
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  bic     r6, r6, #TWSI_CONTROL_INT_FLAG_SET
  MV_REG_WRITE_ASM (r6, r1, TWSI_CONTROL_REG)

  bl      _twsiDelay
  bl      _twsiDelay

  /* Wait for the stop bit to be reset by HW */

pWL16:
  MV_REG_READ_ASM (r6, r1, TWSI_CONTROL_REG)
  tst     r6, #TWSI_CONTROL_INT_FLAG_SET
  bne     pWL16


  mov     r4, #1       
exit__PanelWrite:
  bl      _twsiDelay
  mov     PC, r9         /* r9 is saved link register */

