/*
 * DHCP client information
 *
 * Mic-Aug27
 */


#include "dhcpclinfo.h"


/*
 * Load DHCP client information
 */
static int dhcpcli_load ( st_dhcpcli_info *cli_info )
{
    FILE *f = fopen ( DHCP_CLINET_INFO_FILE, "rb" );
    int idx = 0;

    if ( f == NULL  )
        return -1; //----->

    for ( idx = 0; idx < DHCP_CLINET_INFO_NUM; idx++ )
    {
        if ( fread ( &cli_info[idx], sizeof ( st_dhcpcli_info ), 1, f ) < 1 )
            break;
    }

    fclose ( f );

    return 0; //----->
}


/*
 * Save DHCP client information
 */
static int dhcpcli_save ( st_dhcpcli_info *cli_info )
{
    FILE *f = fopen ( DHCP_CLINET_INFO_FILE, "wb" );
    int idx = 0;

    if ( f == NULL  )
        return -1; //----->

    for ( idx = 0; idx < DHCP_CLINET_INFO_NUM; idx++ )
    {
        if ( cli_info[idx].dci_ip == 0 )
            continue;

        if ( fwrite ( &cli_info[idx], sizeof ( st_dhcpcli_info ), 1, f ) < 1 )
            break;
    }

    fclose ( f );

    return 0; //----->
}


/*
 * Update DHCP client information
 */
int dhcpcli_touch ( unsigned char *chaddr, unsigned char *sname, unsigned int yiaddr )
{
    st_dhcpcli_info cli_info[DHCP_CLINET_INFO_NUM];
    int idx = 0;

    if ( cli_info == NULL )
        return -1; //----->

    memset ( cli_info, 0, sizeof ( st_dhcpcli_info ) * DHCP_CLINET_INFO_NUM );

    // Load information
    dhcpcli_load ( cli_info );

    // Update information
    for ( idx = 0; idx < DHCP_CLINET_INFO_NUM; idx++ )
    {
        if ( memcmp ( cli_info[idx].dci_mac, chaddr, 16 ) == 0 )
        {
            memcpy ( cli_info[idx].dci_name, sname, 64 );
            cli_info[idx].dci_ip = yiaddr;
            cli_info[idx].dci_time = time ( NULL );

            break;
        }

        if ( cli_info[idx].dci_ip == 0 )
        {
            memcpy ( cli_info[idx].dci_mac, chaddr, 16 );
            memcpy ( cli_info[idx].dci_name, sname, 64 );
            cli_info[idx].dci_ip = yiaddr;
            cli_info[idx].dci_time = time ( NULL );
            
            break;
        }
    }

    // Delete timeout information
    for ( idx = 0; idx < DHCP_CLINET_INFO_NUM; idx++ )
    {
        if ( cli_info[idx].dci_ip == 0 )
            break;

        if ( time ( NULL ) - cli_info[idx].dci_time > DHCP_CLINET_INFO_TIMEOUT )
        {
            memset ( &cli_info[idx], 0, sizeof ( st_dhcpcli_info ));
        } 
    }

    // Save information
    dhcpcli_save ( cli_info );

    return 0; //-----> 
}

