/* NOTE: variables and functions begining with (scdl||SCDL) are our own and global. 
 * author: kylin, date: 2005.12.09, mail: Kylin_Kang@sdc.sercomm.com.
 * 
 */

#include <config.h>
#include <common.h>
#include <command.h>
#include <net.h>
#include <arm926ejs.h>

#define TIMEOUT					5	/* Seconds to timeout for a lost pkt	*/
#ifndef __FLASH_16M__
#define SCDL_FLASH_BASE  		0xff800000	/* our flash base addr */
#define FLASH_SIZE			0x800000
#else
#define SCDL_FLASH_BASE                 0xff000000      /* our flash base addr */
#define FLASH_SIZE                      0x1000000
#endif
#define UPGRADE_START_OFFSET   	0
#define UPGRADE_END_OFFSET	   	FLASH_SIZE-_256K
#define CFG_DIRECT_FLASH_SCDL	/* direct write to flash, do not write to memory */	
#define PID_OFFSET	(FLASH_SIZE - 0x47)
#define REMEMBER_MAC
#define SAMSUNG_K8Q2815UQB 	0xec257e
static int eall_flag = 0;
static ulong mem_load_addr =0x1100000; 
static ulong total_xfer_size = 0;
extern flash_info_t flash_info[];	/* info for FLASH chips */

static void ScdlTimeout(void);
static void ScdlHandler(uchar *, unsigned, unsigned, unsigned);
static int FlashDriver(unsigned long ,char *,unsigned long ,unsigned long );
static int 	k_flash_write(uchar *, ulong, ulong);
static	void Scdl_assign_mac_handler(uchar *, unsigned, unsigned, unsigned);

typedef struct {
	uchar		sd_dest[6];	/* Destination node		*/
	uchar		sd_src[6];	/* Source node			*/
	ushort		sd_id;	/* Protocol or length		*/
	ushort		sd_cmd;	/* 802 DSAP			*/
	ushort		sd_seq;	/* 802 SSAP			*/
	ushort		sd_off;		/* 802 control			*/
	ushort		sd_seg;	/* SNAP				*/
	ushort		sd_len;
	uchar		sd_data[512];
} Scdl_t;

#define UPGRADE_HW_ETHER 		0x8888

#define  GET_VERSION_INFO 		0x0000
#define  DOWN_REQUEST     		0x0001
#define  DOWN_DATA        		0x0002
#define  DOWN_RESET       		0x0003
#define  DOWN_VERIFY      		0x0004   
#define  DOWN_EALL        		0x0005   

typedef struct {
  ushort     wcmd;
  ushort     wsequence;
  ushort     woffset;
  ushort     wsegment;
  ushort     wLen;
  uchar      bData[600];
} DLC;

#define  VCI_LEN         56 //sizeof(VCI_TABLE)-14
typedef struct  VCI  {
    unsigned char     Prifix[7];
    unsigned short    VerControl;
    unsigned short    DownControl;
    unsigned char     Hid[32];
    unsigned short    Hver;
    unsigned short    ProdID;
    unsigned short    ProdIDmask;
    unsigned short    ProtID;
    unsigned short    ProtIDmask;
    unsigned short    FuncID;
    unsigned short    FuncIDmask;
    unsigned short    Fver;
    unsigned short    Cseg;
    unsigned short    Csize;
    unsigned char     Postfix[7];
}   VCI_TABLE;

typedef  struct  dcb_type {
    ushort   sequn;
    ushort   dest_seg;
    ushort   dest_off;
    ushort   src_seg;
    ushort   src_off;
    ushort   count;
    unsigned         erase;
    unsigned         no;
    ushort   tme_of_day;
    unsigned long    state;
#define  IDLE            		0x00
#define  PROG            		0x01
#define  PROGERR         		0x02
#define  COM_SEQ_ERR     		0x05
#define  SEQ_NUM_ERR     		0x06
#define  PROG_ERR        		0x07
#define  VERIFY_ERR      		0x09
}   DCB_BUF;

DCB_BUF dcb;
unsigned long ulAddress = 0;
unsigned long ulAddress2 = 0;
int download_flag=0;
ushort xchg1(ushort);

/*************************** Function ************************************/
#ifdef REMEMBER_MAC
static unsigned char FlashNodeAddress[6];
#endif   
void
ScdlStart(void)
{

	printf("[DownLoad] starting ...\n\n");
	download_flag=1;
#ifdef REMEMBER_MAC  
	memcpy(FlashNodeAddress, 0xffffff00, 6);
#endif
	NetSetTimeout (TIMEOUT*CFG_HZ, ScdlTimeout);
	NetSetHandler (ScdlHandler);
	return;
}

void
Scdl_assign_mac_start(void)
{
	printf("[Assign MAC] starting ...\n");
	download_flag=1;
	NetSetTimeout (TIMEOUT*CFG_HZ, ScdlTimeout);
	NetSetHandler (Scdl_assign_mac_handler);
	return;
}

static void 
ScdlTimeout(void) 
{
   	return;
}
int download_process=0;
#define NODE_ADDRESS           		0xffffff00
static void 
ScdlHandler(uchar * pkt, unsigned dest, unsigned src, unsigned len)
{
	Scdl_t *rp, *sp;
	volatile uchar *p;
	static struct eth_device *eth_current;
	unsigned long i;
	unsigned long ulCount;
	VCI_TABLE 	vci;
	uchar *psPID;
	uchar *ptr;

	rp = (Scdl_t *)pkt;
	p = NetTxPacket;
	sp = (Scdl_t *)p;	
	eth_current = eth_get_dev();
	DLC *psDLCHead = (DLC *)(&sp->sd_cmd);


	if (memcmp(&rp->sd_id, "\x00\x15", 2)
		&& memcmp(&rp->sd_id, "\x88\x88", 2))
	return;

	if (!memcmp(&rp->sd_id, "\x88\x88", 2)) {
		if (!memcmp(&rp->sd_dest, "\xff\xff\xff\xff\xff\xff", 6)
				&& memcmp(&rp->sd_cmd, "\x00\x00", 2))
		return;
	}

	/* Now begin to do with the received packet */

	memcpy(sp, rp, sizeof(Scdl_t));
	memcpy(sp->sd_dest, rp->sd_src, 6);
	memcpy(sp->sd_src, eth_current->enetaddr, 6);

	switch ( xchg1(rp->sd_cmd)) {
case GET_VERSION_INFO:
	printf("[GET_VERSION_INFO]\n");
	psPID = (uchar *)(PID_OFFSET+SCDL_FLASH_BASE);
	memcpy ((uchar *)&vci, psPID, sizeof(VCI_TABLE));
	psDLCHead->wLen = xchg1(VCI_LEN);
	memset ((uchar *)psDLCHead->bData, '\0', 512);
	memcpy( (uchar *)psDLCHead->bData, (uchar *)&vci.VerControl, VCI_LEN);
	
	(void)eth_send(NetTxPacket, sizeof(Scdl_t));
	break;
case DOWN_REQUEST:
	download_process=1;
	printf("[DOWN_REQUEST normal]\n");
	dcb.state = PROG;
	dcb.sequn = ((xchg1(psDLCHead->wsequence)+1) & 0xffff);
	dcb.erase = 4;
	dcb.no = 0;
	psDLCHead->wLen = xchg1(2);

	(void)eth_send(NetTxPacket, sizeof(Scdl_t));
	break;
case DOWN_EALL:
	download_process=1;
	printf("[DOWN_EALL all]\n");
	dcb.state = PROG;
	dcb.sequn = ((xchg1(psDLCHead->wsequence)+1) & 0xffff);
	dcb.erase = 3;
	dcb.no = 0;
	psDLCHead->wLen = xchg1(2);

	(void)eth_send(NetTxPacket, sizeof(Scdl_t));

	break;
case DOWN_DATA:
	download_process=1;
	switch (dcb.state) {
		case PROG:
			if (dcb.sequn == xchg1(psDLCHead->wsequence)){	/** Yes, it's the expected packet **/

				ulAddress = (xchg1(psDLCHead->wsegment)<<4) + xchg1(psDLCHead->woffset);
				if (ulAddress == 0)
				   	dcb.no++;
				ulAddress += (0x100000*(dcb.no-1));
				ulCount = (ulong)(xchg1(psDLCHead->wLen));
#ifdef REMEMBER_MAC
	   				if ( ulAddress <= (NODE_ADDRESS-SCDL_FLASH_BASE) && ulAddress + ulCount >( NODE_ADDRESS-SCDL_FLASH_BASE)) {
	       				unsigned long tempOffset;
						
	       				if ((memcmp(FlashNodeAddress, "\x00\x00\x00\x00\x00\x00", 6) != 0) &&
							(memcmp(FlashNodeAddress, "\xFF\xFF\xFF\xFF\xFF\xFF", 6) != 0)) {
		 					tempOffset = NODE_ADDRESS -SCDL_FLASH_BASE- ulAddress;
		 					memcpy ((unsigned char *)&psDLCHead->bData[tempOffset],FlashNodeAddress,6);
					
	       				}    
	     				}                          
#endif				
				if ( FlashDriver(ulAddress, (uchar *)psDLCHead->bData,ulCount,dcb.erase) == 0 ) {	/* write to flash directly OK (perhaps erase) */
					dcb.erase = 0;
					dcb.sequn += 1;
					* ((ushort *)&psDLCHead->bData[0])=0;
				} else {																		/* write to flash wrong */
					dcb.state = PROGERR;
					*((ushort *)&psDLCHead->bData[0]) = xchg1(PROG_ERR);
				}

				psDLCHead->wLen = xchg1(2);

			} else {																/** No, not the expected packet **/
				if (dcb.sequn >= xchg1(psDLCHead->wsequence)) {
					*((ushort *)&psDLCHead->bData[0]) = 0;
				} else {
					*((ushort *)&psDLCHead->bData[0]) = xchg1(SEQ_NUM_ERR);
				}
			}

			(void)eth_send(NetTxPacket, sizeof(Scdl_t));
			break;
		case IDLE:
			psDLCHead->wLen=xchg1(2);
			(void)eth_send(NetTxPacket, sizeof(Scdl_t));
			break;
	}
	break;
case DOWN_RESET:
	printf("\n[DOWN_RESET]\n");
	*((ushort *)&psDLCHead->bData[0]) = 0;
	(void)eth_send(NetTxPacket, sizeof(Scdl_t));
	NetState = NETLOOP_FAIL;
	printf("reset cpu ...\n");
	{
		extern void reset_cpu (ulong addr);
		disable_interrupts ();
		reset_cpu (0);
		/*NOTREACHED*/
		return;
	}
	break;
case DOWN_VERIFY:
	++dcb.sequn;
	*((ushort *)&psDLCHead->bData[0]) = 0;
	psDLCHead->wLen=xchg1(2);
	(void)eth_send(NetTxPacket, sizeof(Scdl_t));
	break;
default :
	printf("[UNKNOWN COMMAND] %x\n",rp->sd_cmd);
	break;
	} /* end switch ( xchg1(rp->sd_cmd)) */

	return;
}

unsigned short
xchg1(ushort w) 
{
	return w;
}

int
FlashDriver(unsigned long offset,char *mem_addr,unsigned long length,unsigned long dlFlag)
{

	int i=0;
	if (offset >= FLASH_SIZE || (eall_flag != 0 && eall_flag != 1) ) 
	   return 1;
       	if (eall_flag == 0 && offset >= FLASH_SIZE - _256K )  /* upgrade, Ignore U-BOOT  */
	   return 0;
	offset+=SCDL_FLASH_BASE;
   	switch (dlFlag) {
   	case 0:
		return flash_write ((uchar *)mem_addr,offset, length);
		break;
   	case 3: 			/* erase all */
		eall_flag = 1;
		flash_protect(FLAG_PROTECT_CLEAR,SCDL_FLASH_BASE,0xffffffff,&flash_info[0]);
		flash_erase(&flash_info[0], 0, flash_info[0].sector_count-1);
		if(flash_info[0].flash_id==SAMSUNG_K8Q2815UQB){
			flash_protect(FLAG_PROTECT_CLEAR,0xff800000,0xffffffff,&flash_info[1]);
			flash_erase(&flash_info[1], 0, flash_info[1].sector_count-1);
		}
		return flash_write ((uchar *)mem_addr,offset, length);
   	case 4:			/* normal erase */
		eall_flag = 0;
		if(flash_info[0].flash_id==SAMSUNG_K8Q2815UQB){
			flash_protect(FLAG_PROTECT_CLEAR,SCDL_FLASH_BASE,0xffffffff,&flash_info[0]);
			flash_protect(FLAG_PROTECT_CLEAR,0xff800000,0xffffffff,&flash_info[1]);
			flash_erase(&flash_info[0], 0, flash_info[0].sector_count-1);
			flash_erase(&flash_info[1], 0, flash_info[1].sector_count-12);
			return flash_write ((uchar *)mem_addr,offset, length);
		}

		flash_protect(FLAG_PROTECT_CLEAR,SCDL_FLASH_BASE,0xffffffff,&flash_info[0]);
		i=flash_info[0].sector_count-1;
		while(flash_info[0].start[i]!=0xfffc0000) i--;	
		flash_erase(&flash_info[0], 0, i-1);
		return flash_write ((uchar *)mem_addr,offset, length);
   	case 5:
		 return flash_write ((uchar *)mem_addr,offset, length);
	default:
		 break;
   	}
	return 0; 
}
static void 
Scdl_assign_mac_handler(uchar * pkt, unsigned dest, unsigned src, unsigned len)
{
	Scdl_t *rp, *sp;
	rp = (Scdl_t *)pkt;
	uchar 	mac[6];
	static int assign_state = 0;
	volatile uchar *p;
	static struct eth_device *eth_current;
	unsigned int sect_start=0,sect_size=0;
	rp = (Scdl_t *)pkt;
	p = NetTxPacket;
	sp = (Scdl_t *)p;	
	eth_current = eth_get_dev();

	memcpy(sp, rp, sizeof(Scdl_t));
	memcpy(sp->sd_dest, rp->sd_src, 6);
	memcpy(sp->sd_src, eth_current->enetaddr, 6);

	if (memcmp(&rp->sd_id, "\x00\x15", 2))
		return;
	else {
		if (assign_state == 1)	/* in process */
			return;
		assign_state = 1;		/* first assign packet */
	}

	/* now deal with the packet */
	memcpy(mac, (uchar *)&rp->sd_cmd, 6); /*dst_mac + src_mac + id */

	printf("New MAC -> %02x.%02x.%02x.%02x.%02x.%02x\n",
			mac[0], mac[1], mac[2],  mac[3], mac[4], mac[5]);
	if(flash_info[0].flash_id==SAMSUNG_K8Q2815UQB){
		memcpy(0x400000,0xffffe000,0x2000);
		memcpy(0x400000+0x2000-0x100,mac,0x6);
		flash_erase(&flash_info[1],141,141);
		flash_write(0x400000,0xffffe000,0x2000);	
		printf("done.Reset cpu...\n");	
		disable_interrupts ();
		reset_cpu (0);
		return ;

	}
	sect_start=flash_info[0].start[flash_info[0].sector_count-1];
	sect_size=0xffffffff-sect_start+1;
	memcpy(0x400000,sect_start,sect_size);
	memcpy(0x400000+sect_size-0x100,mac,0x6);
	flash_erase(&flash_info[0], flash_info[0].sector_count-1,flash_info[0].sector_count-1 );
	printf("write mac to flash.\n");
	flash_write(0x400000,sect_start,sect_size);
	printf("done.Reset cpu...\n");	
	disable_interrupts ();
	reset_cpu (0);
	return;
}

