/*
 * (C) Copyright 2003
 * Texas Instruments.
 * Kshitij Gupta <kshitij@ti.com>
 * Configuation settings for the TI OMAP Innovator board.
 *
 * (C) Copyright 2004
 * ARM Ltd.
 * Philippe Robin, <philippe.robin@arm.com>
 * Configuration for Integrator AP board.
 *.
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#ifndef  MV_88F1181
#define MV_88F1181
#endif
#include "../../board/mv88fxx81/mvSysHwConfig.h"
/************/
/* VERSIONS */
/************/
#define CONFIG_IDENT_STRING	" Marvell version: 1.1.10"

/* version number passing when loading Kernel */
#define VER_NUM 0x01010A00           /* 1.1.10 */

/********************/
/* MV DEV SUPPORTS  */
/********************/	
#define CONFIG_PCI           /* pci support               */
#undef CONFIG_PCI_1         /* sec pci interface support */

/**********************************/
/* Marvell Monitor Extension      */
/**********************************/
#define enaMonExt()( /*(!getenv("enaMonExt")) ||\*/\
		     ( getenv("enaMonExt") && \
                       ((!strcmp(getenv("enaMonExt"),"yes")) ||\
		       (!strcmp(getenv("enaMonExt"),"Yes"))) \
		     )\
		    )

/********/
/* CLKs */
/********/
#ifndef __ASSEMBLY__
extern unsigned int mvSysClkGet(void);
extern unsigned int mvTclkGet(void);
extern unsigned int mvCntmrClkFreqGet(unsigned int);
#define UBOOT_CNTR		0		/* counter to use for uboot timer */

#define CFG_HZ			mvCntmrClkFreqGet(UBOOT_CNTR)		
#define CFG_TCLK                mvTclkGet()
#define CFG_BUS_HZ              mvSysClkGet()
#define CFG_BUS_CLK             CFG_BUS_HZ
#endif

/********************/
/* Dink PT settings */
/********************/
#define CFG_MV_PT

#ifdef CFG_MV_PT
#define CFG_PT_BASE  (CFG_MALLOC_BASE - 0x80000)
#endif /* #ifdef CFG_MV_PT */


/*************************************/
/* High Level Configuration Options  */
/* (easy to change)		     */
/*************************************/



#define CONFIG_MARVELL	1
#define CONFIG_DB88FXX81	1	/* this is an DB88F1181	board*/
#define CONFIG_DB88F1181        1
#define CONFIG_ARM926EJS	1		/* CPU */

/* #define CONFIG_ARCH_CINTEGRATOR 1*/	/* Specifically, a CP		*/

/* commands */

#define CONFIG_BOOTP_MASK	(CONFIG_BOOTP_DEFAULT | \
				 CONFIG_BOOTP_BOOTFILESIZE)

#define CONFIG_COMMANDS	((CONFIG_CMD_DFL \
			 | CFG_CMD_I2C \
			 | CFG_CMD_EEPROM \
			 | CFG_CMD_PCI \
			 | CFG_CMD_NET \
			 | CFG_CMD_PING \
                         | CFG_CMD_JFFS2 \
			 | CFG_CMD_DATE \
			 | CFG_CMD_BSP ) & ~CFG_CMD_CACHE )



/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define	CFG_MAXARGS	16		/* max number of command args	*/

/* which initialization functions to call for this board */
#define CONFIG_MISC_INIT_R	1      /* after relloc initialization*/
#undef CONFIG_DISPLAY_MEMMAP    /* at the end of the bootprocess show the memory map*/

#define CONFIG_ENV_OVERWRITE    /* allow to change env parameters */

#undef	CONFIG_WATCHDOG		/* watchdog disabled		*/

/* Cache */
#define CFG_CACHELINE_SIZE	32	


/* global definetions. */
#define	CFG_SDRAM_BASE		0x00000000
#define CFG_FLASH_BASE		BOOTDEV_CS_BASE


#define CFG_RESET_ADDRESS	0xffff0000
#define	CFG_MONITOR_LEN		(384 << 10)	/* Reserve 384 kB for Monitor */
#define CFG_MONITOR_BASE	(CFG_FLASH_BASE + 0x10000)
#define CFG_MALLOC_BASE		(16 << 20) /* 16M */

/*
 * When locking data in cache you should point the CFG_INIT_RAM_ADDRESS
 * To an unused memory region. The stack will remain in cache until RAM
 * is initialized 
*/
#define	CFG_MALLOC_LEN		(4 << 20)	/* (default) Reserve 4MB for malloc*/

#define CFG_GBL_DATA_SIZE	128  /* size in bytes reserved for init data */

#define CONFIG_INIT_CRITICAL		/* critical code in start.S */


/********/
/* DRAM */
/********/

#define CFG_DRAM_BANKS		4

/* this defines whether we want to use the lowest CAL or the highest CAL available,*/
/* we also check for the env parameter CASset.					  */
#define MV_MIN_CAL

#define CFG_MEMTEST_START     0x00400000
#define CFG_MEMTEST_END       0x00C00000

/********/
/* RTC  */
/********/
#if (CONFIG_COMMANDS & CFG_CMD_DATE)
#define CFG_NVRAM_SIZE  0x00 /* dummy */
#define CFG_NVRAM_BASE_ADDR DEVICE_CS1_BASE /* dummy */
#define CONFIG_RTC_DS1339 
#endif /* #if (CONFIG_COMMANDS & CFG_CMD_DATE) */

/********************/
/* Serial + parser  */
/********************/
/*
 * The following defines let you select what serial you want to use
 * for your console driver.
 */

#define CONFIG_BAUDRATE         115200   /* console baudrate = 115000    */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200, 230400 }
 
#define CFG_DUART_IO		DEVICE_CS2_BASE
#define CFG_DUART_CHAN		0		/* channel to use for console */
#define CFG_INIT_CHAN1
#define CFG_INIT_CHAN2

#define CONFIG_LOADS_ECHO       0       /* echo off for serial download */
#define CFG_LOADS_BAUD_CHANGE           /* allow baudrate changes       */

#define CFG_CONSOLE_INFO_QUIET  /* don't print In/Out/Err console assignment. */

/* parser */
/* don't chang the parser if you want to load Linux(if you cahnge it to HUSH the cmdline will
	not pass to the kernel correctlly???) */
/*#define CFG_HUSH_PARSER */
#undef CFG_HUSH_PARSER 
#define CONFIG_AUTO_COMPLETE

#define CFG_PROMPT_HUSH_PS2	"> "

#define	CFG_LONGHELP			/* undef to save memory		*/
#define	CFG_PROMPT	"Marvell>> "	/* Monitor Command Prompt	*/
#define	CFG_CBSIZE	256		/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */

/* temp no ethernet in ferocion */
/************/
/* ETHERNET */
/************/
/* to change the default ethernet port, use this define (options: 0, 1, 2) */
#define CONFIG_NET_MULTI

#define ETHADDR          	"64:00:00:00:00:00"
#define ETH1ADDR		"64:00:00:00:00:01"
#define ETH2ADDR		"64:00:00:00:00:02"

#define CONFIG_IPADDR		10.4.50.135

#define CONFIG_SERVERIP		10.4.50.31

/***************************************/
/* LINUX BOOT and other ENV PARAMETERS */
/***************************************/
#define CFG_BOOTARGS_END ":::DB88FXX81:eth0:none"

#define CONFIG_ZERO_BOOTDELAY_CHECK

#define	CFG_LOAD_ADDR		0x00400000	/* default load address	*/

#undef	CONFIG_BOOTARGS

/* auto boot*/
#define CONFIG_BOOTDELAY	3 		/* by default no autoboot */

#if (CONFIG_BOOTDELAY >= 0)
#define CONFIG_BOOTCOMMAND      "tftpboot 0x400000 $(image_name);\
 setenv bootargs $(bootargs) $(bootargs_root) nfsroot=$(serverip):$(rootpath) \
 ip=$(ipaddr):$(serverip)$(bootargs_end);  bootm 0x400000; "
                                                                                                             
#define CONFIG_BOOTARGS "console=ttyS0,115200"

#define CONFIG_ROOTPATH	/mnt/ARMFS/
#endif /* #if (CONFIG_BOOTDELAY >= 0) */

#define CFG_BARGSIZE	CFG_CBSIZE	/* Boot Argument Buffer Size	*/

/*
 * For booting Linux, the board info and command line data
 * have to be in the first 8 MB of memory, since this is
 * the maximum mapped by the Linux kernel during initialization.
 */
#define	CFG_BOOTMAPSZ		(8<<20)	/* Initial Memory map for Linux */

#define BRIDGE_REG_BASE_BOOTM 0xfbe00000 /* this paramaters are used when booting the linux kernel */ 


#define CONFIG_CMDLINE_TAG      	1       /* enable passing of ATAGs  */
#define CONFIG_SETUP_MEMORY_TAGS        1
#define CONFIG_MARVELL_TAG		1
#define ATAG_MARVELL			0x41000403

/********/
/* I2C  */
/********/
#define CFG_I2C_EEPROM_ADDR_LEN 1
#define CFG_I2C_MULTI_EEPROMS
#define CFG_I2C_SPEED   400000		/* I2C speed default */

/* I2C addresses for the two DIMM SPD chips */
#define DIMM0_I2C_ADDR	0x56
#define DIMM1_I2C_ADDR	0x54

/* CPU I2C settings */
#define CPU_I2C  
#define I2C_CPU0_EEPROM_ADDR    0x51


/********/
/* PCI  */
/********/
#ifdef CONFIG_PCI
 #define CONFIG_PCI_HOST PCI_HOST_FORCE /* select pci host function     */
 #define CONFIG_PCI_PNP          	/* do pci plug-and-play         */
 #define CONFIG_EEPRO100		/* Support for Intel 82557/82559/82559ER chips */
 #define CONFIG_SK98			/* yukon */
#endif /* #ifdef CONFIG_PCI */

#define PCI_HOST_ADAPTER 0              /* configure ar pci adapter     */
#define PCI_HOST_FORCE   1              /* configure as pci host        */
#define PCI_HOST_AUTO    2              /* detected via arbiter enable  */

/* for Yukon */
#define __mem_pci(x) x
#define __io_pci(x) x
#define __arch_getw(a)			(*(volatile unsigned short *)(a))
#define __arch_putw(v,a)		(*(volatile unsigned short *)(a) = (v))


/***********************/
/* FLASH organization  */
/***********************/
#define CFG_MAX_FLASH_BANKS	2	/* max number of memory banks	*/
#define CFG_MAX_FLASH_SECT	128	/* max number of sectors on one chip */
#define CFG_FLASH_PROTECTION  	1

#define CFG_EXTRA_FLASH_DEVICE	DEVICE3	/* extra flash at device 3 */
#define CFG_EXTRA_FLASH_WIDTH	4	/* 32 bit */
#define CFG_BOOT_FLASH_WIDTH	1	/* 8 bit */

#define CFG_FLASH_ERASE_TOUT	120000/1000	/* 120000 - Timeout for Flash Erase (in ms) */
#define CFG_FLASH_WRITE_TOUT	500	/* 500 - Timeout for Flash Write (in ms) */
#define CFG_FLASH_LOCK_TOUT	500	/* 500- Timeout for Flash Lock (in ms) */
#define CFG_FLASH_CFI		1

#define	CFG_ENV_IS_IN_FLASH	1
#define	CFG_ENV_SIZE		0x8000	/* Total Size of Environment Sector */
#define CFG_ENV_SECT_SIZE	0x10000
#define CFG_ENV_ADDR    	(CFG_FLASH_BASE) 

#if (CONFIG_COMMANDS & CFG_CMD_JFFS2)
 /* Flash banks JFFS2 should use */
 #define CFG_JFFS2_FIRST_BANK    1
 #define CFG_JFFS2_NUM_BANKS     1
#endif /* #if (CONFIG_COMMANDS & CFG_CMD_JFFS2) */


/*****************/
/* others        */
/*****************/
#define CFG_DFL_MV_REGS		0xd0000000 	/* boot time MV_REGS */
#define CFG_MV_REGS		INTER_REGS_BASE /* MV Registers will be mapped here */

#undef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE	(4 << 20)	/* regular stack - up to 4M (in case of exception)*/
#define CONFIG_NR_DRAM_BANKS 	4 

#endif							/* __CONFIG_H */
