/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#define MV_ASMLANGUAGE
#include "mvOsAsm.h"
#include <config.h>
#include <version.h>
#include "mvBoardEnvSpec.h"
#include "mvCtrlEnvSpec.h"
#include "mvCpuIfConfig.h"
#include "mvPexRegs.h"
#include "mvDramIfRegs.h"

#define MAGIC_BYTE0	((MV_BOARD_I2C_MAGIC >> 24 )& 0xff)
#define MAGIC_BYTE1	((MV_BOARD_I2C_MAGIC >> 16 )& 0xff)
#define MAGIC_BYTE2	((MV_BOARD_I2C_MAGIC >> 8)& 0xff)
#define MAGIC_BYTE3	((MV_BOARD_I2C_MAGIC >> 0)& 0xff)
 
                  
/*
  get_board_id - get board id from twsi eeprom
  input : r5 - board id data start offset in the eeprom
        
*/
.globl platformsetup

/************************************************/
/*              platformsetup                   *
/************************************************/

platformsetup:

         /* if we are DDRI board then we
         should open the CS2 for only 1 MB 
         to turn the 7segement and not to overlap with the
         internal registers and we will do it always
         */
	ldr	r4, =0x000f1b11
        MV_DV_REG_WRITE_ASM(r4, r1, 0x20060)
	/* change reg base to 0xf1000000 */
	ldr     r4, =CFG_MV_REGS
        MV_DV_REG_WRITE_ASM(r4, r1, 0x20080)


        /* save Link Registers */
	mov	r2, lr

	bl      _i2cInit


        /* Initialize BUS-L to DDR configuration parameters     */
        /* Must be done prior to DDR operation                  */
        bl      _mvCpuIfPreInit



#if defined(MV_88F5181) 


#if defined(RD_88F5182) 
     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5182_3)

	/* init MPP */
	ldr	r6, =RD_88F5182_2XSATA3_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5182_2XSATA3_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5182_2XSATA3_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFCF0EF8
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
         MV_REG_READ_ASM (r6, r1, 0x10100)
         orr   r6, r6, #1
	MV_REG_WRITE_ASM (r6, r1, 0x10100)     
         

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88W8660)

	/* init MPP */
	ldr	r6, =RD_88W8660_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88W8660_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFF1C 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0xa0	
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88W8660_AP82S)

	/* init MPP */
	ldr	r6, =RD_88W8660_AP82S_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88W8660_AP82S_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	
	/* init GPP , Out enable */
	ldr	r6, =RD_88W8660_AP82S_MPP_OUT_EN 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

#if 0
	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)
#endif 
	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5181L_FE) 

	/* init MPP */
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0F3C
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 -turn off leds0 0,15 wireless indication-*/
	ldr	r6, =0xE001
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5181L_GE) 

	/* init MPP */
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0330
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 -turn off leds 10 wireless indication-*/
	ldr	r6, =0xC
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(MV_POS_NAS) 

        /* init MPP */
        ldr     r6, =RD_88F5181_POS_NAS_MPP0_7
        MV_REG_WRITE_ASM (r6, r1, 0x10000)
        ldr     r6, =RD_88F5181_POS_NAS_MPP8_15
        MV_REG_WRITE_ASM (r6, r1, 0x10004)
        ldr     r6, =RD_88F5181_POS_NAS_MPP16_23
        MV_REG_WRITE_ASM (r6, r1, 0x10050)
        ldr     r6, =RD_88F5181_POS_NAS_MPP_DEV
        MV_REG_WRITE_ASM (r6, r1, 0x10008)

        /* init GPP , Out enable */
        ldr     r6, =0x00000BDF
        MV_REG_WRITE_ASM (r6, r1, 0x10104)

        /* turn Led to 1 */
        ldr     r6, =0x0000e000
        MV_REG_WRITE_ASM (r6, r1, 0x10100)

        /*DDR SDRAM Initialization Control */
        ldr     r6, =0x00000001
        MV_REG_WRITE_ASM (r6, r1, 0x1480)

        /* PCI ARBITER */
        ldr     r6, =0x80000030
        MV_REG_WRITE_ASM (r6, r1, 0x31d00)

        bl      _mvDramIfStaticInit

        b       done

#elif defined(MV_VOIP)

	/* init MPP */
	ldr	r6, =RD_88F5181_VOIP_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181_VOIP_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181_VOIP_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181_VOIP_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0x000005F5
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x0000D000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_PRPMC)

	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF8FFC
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00006000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_MNG)

	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF8FFC
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00006000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_PEX_PCI)


	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0FFF
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00001000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done
         
#endif

        /* First Try : see if we have somthing on MV_BOARD_ID_EEPROM_OFFSET0*/
        
        mov     r5, #(0xff & (MV_BOARD_ID_EEPROM_OFFSET0 ))
        orr     r5, r5, #(0xff00 & (MV_BOARD_ID_EEPROM_OFFSET0))
        
        /*get_board_id*/
        
        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5

        bl      _i2cRead                /* result in r7 */

        and	 r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE0 
        bne	offset1

        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #1
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE1 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #2
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE2 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #3
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE3 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #5
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff

        
        cmp    r7, #DB_88F5181_5281_DDR1     
        beq	db_88f5181_5281_ddr1
        cmp    r7, #DB_88F5181_5281_DDR2     
        beq	db_88f5181_5281_ddr2
        cmp    r7, #DB_88F5X81_DDR2
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5X81_DDR1
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5182_DDR2
        beq	db_88f5182_ddr2
        cmp    r7, #DB_88F5181L_DDR2_2XTDM
        beq	db_88f5181L_ddr2
	cmp    r7, #DB_88W8660_DDR2
	beq	db_88w8660_ddr2        

offset1:
        
        /* Second Try : see if we have somthing on MV_BOARD_ID_EEPROM_OFFSET1*/
        
        mov     r5, #(0xff & (MV_BOARD_ID_EEPROM_OFFSET1))
        orr     r5, r5, #(0xff00 & (MV_BOARD_ID_EEPROM_OFFSET1))
        
        /* now indicate it is address that is bigger than 256 */
        orr     r5, r5, #0x80000000
        
        /*get_board_id*/
        
        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5

        bl      _i2cRead                /* result in r7 */

        and	 r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE0 
        bne	others

        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #1
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE1 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #2
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE2 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #3
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE3 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #5
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff

        
        cmp    r7, #DB_88F5181_5281_DDR1     
        beq	db_88f5181_5281_ddr1
        cmp    r7, #DB_88F5181_5281_DDR2     
        beq	db_88f5181_5281_ddr2
        cmp    r7, #DB_88F5X81_DDR2
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5X81_DDR1
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5182_DDR2
        beq	db_88f5182_ddr2
        cmp    r7, #DB_88F5181L_DDR2_2XTDM
        beq	db_88f5181L_ddr2
        cmp    r7, #DB_88W8660_DDR2
        beq	db_88w8660_ddr2
        
        b	others
        




db_88w8660_ddr2:

	/* init MPP */
	ldr	r6, =DB_88W8660_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88W8660_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
         
	/* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done


db_88f5181_5281_ddr1: /*old board*/

	/* init MPP */
	ldr	r6, =DB_88F5181_5281_DDR1_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         
         /* turn 7segment to val 1 - Set DevCS2- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x10464)
	ldr	r6, =0x000F1B11
	MV_REG_WRITE_ASM (r6, r1, 0x20060)
	ldr	r6, =0xF0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20064)
        
         
         ldr	r6, =0xF0000010 /* DevCS2 Default base address +0x10 */
         ldr   r6, [r6]
         
        /* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         #if 0
         ldr	r6, =0xF0000020 /* DevCS2 Default base address +0x20 */
         ldr   r6, [r6]
         #endif
         
	b	done
         
db_88f5181_5281_ddr2: /*old board*/

	/* init MPP */
	ldr	r6, =DB_88F5181_5281_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF3F3F 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00004000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
	/* turn Led to 2 */
	ldr	r6, =0x00008000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	
         
	b	done

db_88f5x81_ddrx:

	/* init MPP */
	ldr	r6, =DB_88F5X81_DDRX_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5X81_DDRX_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5X81_DDRX_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5X81_DDRX_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done

         
db_88f5182_ddr2:

	/* init MPP */
	ldr	r6, =DB_88F5182_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5182_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5182_DDR2_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
         
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done



db_88f5181L_ddr2:

	/* init MPP */
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done


others:

        /* If we didn't read a valid board ID then:
           if Orion2 B0 we will detect the board as new
           board else the U-Boot will detect it as old board */
        
        /* Read device ID  */
        MV_REG_READ_ASM(r6, r1, PEX_CFG_DIRECT_ACCESS(0,PEX_DEVICE_AND_VENDOR_ID))
        mov     r6, r6, LSR #16         /* r6 = r6 >> 16 */

	/* if Orion NAS default board is DB, rd must have special compilation flag */
        ldr     r1, =MV_5182_DEV_ID
        cmp     r1, r6
        beq     db_88f5182_ddr2

	/* if Orion Shark default board is DB, rd must have special compilation flag */
        ldr     r1, =MV_8660_DEV_ID
        cmp     r1, r6
        beq     db_88w8660_ddr2
        
        ldr     r1, =MV_5281_DEV_ID
        cmp     r1, r6
        bne     pre_orion2_b0_xxx

        /* Read REvision  */
        MV_REG_READ_ASM(r6, r1, PEX_CFG_DIRECT_ACCESS(0,PEX_CLASS_CODE_AND_REVISION_ID));
        ldr    r1, =0x000000FF                  /* Mask for calss ID */
        and    r6, r6, r1
        cmp    r6, #0
        beq    pre_orion2_b0_xxx
        
orion2_b0_xxx:

        b       db_88f5x81_ddrx

pre_orion2_b0_xxx:

        /* Get SDRAM Config value */
        MV_REG_READ_ASM (r6, r1, SDRAM_CONFIG_REG)
        
        tst     r6, #SDRAM_DTYPE_DDR2
        
        /* jump to ddr2 board */
        bne     db_88f5181_5281_ddr2
        
        /* if not ddr2 board then jump to ddr1 board */
        b       db_88f5181_5281_ddr1


done:
	mov	lr, r2	



#elif defined(MV_88F1181)

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	mov	r2, lr
	bl	_mvDramIfBasicInit 
	mov	lr, r2	

#endif

	/* All done by Integrator's boot monitor! */
	mov pc, lr
         



