/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#include <common.h>
#include "mvTypes.h"
#include "mvBoardEnvLib.h"
#include "mvCpuIf.h"
#include "mvCtrlEnvLib.h"
#include "mv_mon_init.h"
#include "mvDS1339.h"
#include "mvDebug.h"
#include "mvCpuArm.h"
#include "mvDevice.h"
#include "mvTwsi.h"
#include "mvEthPhy.h"
#if defined(MV_88F5181)

#if defined(MV_88F5182)
#include "mvXor.h"
#endif
#include "mvIdma.h"
#include "mvUsb.h"
#endif
#include "mvCpu.h"

#ifdef CONFIG_PCI
#   include <pci.h>
#endif
#include "mvPciRegs.h"

#include <asm/arch/vfpinstr.h>
#include <asm/arch/vfp.h>

void mv_cpu_init(void);

void print_mvBanner(void)
{
	printf("\n");
	printf("         __  __                      _ _\n");
	printf("        |  \\/  | __ _ _ ____   _____| | |\n");
	printf("        | |\\/| |/ _` | '__\\ \\ / / _ \\ | |\n");
	printf("        | |  | | (_| | |   \\ V /  __/ | |\n");
	printf("        |_|  |_|\\__,_|_|    \\_/ \\___|_|_|\n");
	printf(" _   _     ____              _\n");
	printf("| | | |   | __ )  ___   ___ | |_ \n");
	printf("| | | |___|  _ \\ / _ \\ / _ \\| __| \n");
	printf("| |_| |___| |_) | (_) | (_) | |_ \n");
	printf(" \\___/    |____/ \\___/ \\___/ \\__| ");
	if(enaMonExt())
		printf(" ** MONITOR **");
	else
		printf(" ** LOADER **"); 


	return;
}

void print_dev_id(void){
	static char boardName[30];

	mvBoardNameGet(boardName);
	
#if defined(MV_CPU_BE)
	printf("\n ** MARVELL BOARD: %s BE ",boardName);
#else
	printf("\n ** MARVELL BOARD: %s LE ",boardName);
#endif

    return;
}


#define CPU_MAIN_IRQ_MASK 0x20204
#define CPU_MAIN_FIQ_MASK 0x20208
#define CPU_END_POIN_MASK 0x2020c
void maskAllInt(void)
{
        /* mask all external interrupt sources */
        MV_REG_WRITE(CPU_MAIN_IRQ_MASK, 0);
        MV_REG_WRITE(CPU_MAIN_FIQ_MASK, 0);
        MV_REG_WRITE(CPU_END_POIN_MASK, 0);
}

/* init for the Master*/
void misc_init_r_dec_win(void)
{
    /* update all the windows BARS */
#ifdef MV_88F5181
    char *env;
    mvDmaInit();

	if ((DB_88F5181_DDR1_PRPMC != mvBoardIdGet()) &&
	    (DB_88F5181_DDR1_MNG != mvBoardIdGet()))
	{
		env = getenv("usb0Mode");
		if((!env) || (strcmp(env,"device") == 0) || (strcmp(env,"Device") == 0) )
		{
			printf("USB 0: device mode\n");	
			mvUsbInit(0, MV_FALSE);
		}
		else
		{
			printf("USB 0: host mode\n");	
			mvUsbInit(0, MV_TRUE);
		}
			
		
		if (mvCtrlUsbMaxGet() == 2)
		{
			env = getenv("usb1Mode");
			if((!env) || (strcmp(env,"device") == 0) || (strcmp(env,"Device") == 0) )
			{
				printf("USB 1: device mode\n");	
				mvUsbInit(1, MV_FALSE);
			}
			else
			{
				printf("USB 1: host mode\n");	
				mvUsbInit(1, MV_TRUE);
			}
				

		}

	}


#endif /* MV_88F5181 */
#if defined(MV_88F5182) && defined (MV_88F5181)
	mvXorInit();
#endif

    return;
}


/*
 * Miscellaneous platform dependent initialisations
 */

extern	MV_STATUS mvEthPhyRegRead(MV_U32 phyAddr, MV_U32 regOffs, MV_U16 *data);
extern	MV_STATUS mvEthPhyRegWrite(MV_U32 phyAddr, MV_U32 regOffs, MV_U16 data);

/* golabal mac address for yukon EC */
unsigned char yuk_enetaddr[6];
extern int interrupt_init (void);
extern void i2c_init(int speed, int slaveaddr);


int board_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;
	MV_TWSI_ADDR slave;
	unsigned int i;

	maskAllInt();
	/* must initialize the int in order for udelay to work */
	interrupt_init();
   
	slave.type = ADDR7_BIT;
	slave.address = 0;
	mvTwsiInit(CFG_I2C_SPEED, CFG_TCLK, &slave, 0);

 
	/* Init the Board environment module (device bank params init) */
	mvBoardEnvInit();

#ifdef MV_88F5181

	if ((DB_88F5181_5281_DDR2 == mvBoardIdGet())||
	    (DB_88F5181_DDR1_PEXPCI == mvBoardIdGet()) ||
	    (RD_88F5181_POS_NAS == mvBoardIdGet()) ||
	    (DB_88F5X81_DDR2 == mvBoardIdGet()) ||
	    (DB_88F5X81_DDR1 == mvBoardIdGet())||
	    (DB_88F5182_DDR2 == mvBoardIdGet())||
	    (RD_88F5182_2XSATA == mvBoardIdGet())||
	    (DB_88F5181L_DDR2_2XTDM == mvBoardIdGet()) ||
	    (DB_88W8660_DDR2 == mvBoardIdGet()) )
	{
		mvEthE1111PhyBasicInit(0);
	
	}else if (RD_88F5182_2XSATA3 == mvBoardIdGet())
	{
		mvEthE1116PhyBasicInit(0);

	}else if (DB_88F5181_5281_DDR1 == mvBoardIdGet())
	{
		mvEthE1011PhyBasicInit(0);

	}else if ((RD_88F5181_VOIP == mvBoardIdGet())|| (RD_88F5181L_VOIP_FE == mvBoardIdGet()))
	{
		mvEthE6063PhyBasicInit(0);

	}else if ((RD_88W8660_DDR1 == mvBoardIdGet()) || (RD_88W8660_AP82S_DDR1 == mvBoardIdGet()))
	{
		mvEthE6065_61PhyBasicInit(0);
	
	}else if (RD_88F5181L_VOIP_GE == mvBoardIdGet())
	{
		mvEthE6131PhyBasicInit(0);
	}


#endif /* MV_88F5181 */
   	/* Init the Controlloer environment module (MPP init) */
//	mvCtrlEnvInit(); joke-debug: remove it because it will power off the board.

	mvBoardDebug7Seg(3);

        /* Init the Controller CPU interface */
	mvCpuIfInit(); 
                                                                                                                                     
        /* arch number of Integrator Board */
        gd->bd->bi_arch_number = 526;
 
        /* adress of boot parameters */
        gd->bd->bi_boot_params = 0x00000100;

	/* relocate the exception vectors */
	for(i = 0; i < 0x100; i+=4)
	{
#if defined(RD_88F5182) && defined(MV_TINY_IMAGE)
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#elif defined(RD_88F5182_3) && defined(MV_TINY_IMAGE)        
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#else
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfff90000 +i );
#endif


	}

	/* i cache can work without MMU,
	   d cache can not work without MMU:
	 i cache already enable in start.S */

	mvBoardDebug7Seg(4);
	
	return 0;
}

void misc_init_r_env(void){
        char *env;
        char tmp_buf[10];
        unsigned int malloc_len;
                                                                                                                                               
        /* update the CASset env parameter */
        env = getenv("CASset");
        if(!env )
        {
#ifdef MV_MIN_CAL
                setenv("CASset","min");
#else
                setenv("CASset","max");
#endif
        }
        /* Monitor extension */
        env = getenv("enaMonExt");
        if(/* !env || */ ( (strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) ) )
                setenv("enaMonExt","yes");
        else
                setenv("enaMonExt","no");


        env = getenv("enaFlashBuf");
        if( ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("enaFlashBuf","no");
        else
                setenv("enaFlashBuf","yes");

	/* CPU streaming */
        env = getenv("enaCpuStream");
        if(!env || ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("enaCpuStream","no");
        else
                setenv("enaCpuStream","yes");

		if(mvCtrlModelGet() == MV_5281_DEV_ID) /* Orion 2 */
		{
			/* VFP */
			env = getenv("enaVFP");
			if (mvCtrlRevGet() == MV_5281_C0_REV)
			{
				if( env && ( ((strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) )))
						setenv("enaVFP","yes");
				else
						setenv("enaVFP","no");

			}
			else
			{
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaVFP","no");
				else
						setenv("enaVFP","yes");

			}
			
			

			if ((mvCtrlRevGet() == MV_5281_A0_REV) || 
				(mvCtrlRevGet() == MV_5281_C0_REV))
			{
				/* Write allocation */
				env = getenv("enaWrAllo");
				if( env && ( ((strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) )))
						setenv("enaWrAllo","yes");
				else
						setenv("enaWrAllo","no");

			}
			else if (mvCtrlRevGet() >= MV_5281_B0_REV) /* Orion 2 >= B0 */
			{
				/* Write allocation */
				env = getenv("enaWrAllo");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaWrAllo","no");
				else
						setenv("enaWrAllo","yes");

				/* ICache Prefetch */
				env = getenv("enaICPref");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaICPref","no");
				else
						setenv("enaICPref","yes");
		
		
				/* DCache Prefetch */
				env = getenv("enaDCPref");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaDCPref","no");
				else
						setenv("enaDCPref","yes");
			}
		}


        /* Malloc length */
        env = getenv("MALLOC_len");
        malloc_len =  simple_strtoul(env, NULL, 10) << 20;
        if(malloc_len == 0){
                sprintf(tmp_buf,"%d",CFG_MALLOC_LEN>>20);
                setenv("MALLOC_len",tmp_buf);}
         
        /* primary network interface */
        env = getenv("ethprime");

	if ((DB_88F5181_DDR1_PRPMC != mvBoardIdGet()) &&
	    (DB_88F5181_DDR1_MNG != mvBoardIdGet()))
	{
		if(!env) 
		{
			if( 	(DB_88W8660_DDR2 == mvBoardIdGet()) || 
				(RD_88W8660_DDR1 == mvBoardIdGet()) ||
				(RD_88W8660_AP82S_DDR1 == mvBoardIdGet()) ) 			
				setenv("ethprime","efast0");
			else
				setenv("ethprime","egiga0");
		}
	}
	else
	{
		if(!env)
			setenv("ethprime","SK98#0");
	}
 
        /* linux boot arguments */
        env = getenv("bootargs_root");
        if(!env)
                setenv("bootargs_root","root=/dev/nfs rw");
 
        env = getenv("bootargs_end");
        if(!env)
                setenv("bootargs_end",CFG_BOOTARGS_END);
 
        env = getenv("image_name");
        if(!env)
                setenv("image_name","uImage");
 
        env = getenv("standalone");
        if(!env)
                setenv("standalone","fsload 0x400000 $(image_name);setenv bootargs $(bootargs) root=/dev/mtdblock0 rw \
ip=$(ipaddr):$(serverip)$(bootargs_end); bootm 0x400000;");
                 
#if defined(DB_PRPMC) || defined(DB_MNG)
		env = getenv("vx_boot"); 
		if(!env)
				setenv("vx_boot","tftpboot $(default_load_addr) $(image_name);setenv bootargs sgi(0,0) host:VxWorks h=$(serverip) \
e=$(ipaddr):FFFF0000 u=anonymous pw=target; setenv bootaddr 0x700; bootvx $(default_load_addr);");

		env = getenv("dhcp_boot");
		if(!env)
				setenv("dhcp_boot","dhcp;setenv bootargs $(bootargs) $(bootargs_root) nfsroot=$(serverip):$(rootpath) \
ip=$(ipaddr):$(serverip)$(bootargs_end);  bootm $(default_load_addr);");
#endif /* DB_PRPMC || DB_MNG */

       /* Set boodelay to 3 sec, if Monitor extension are disabled */
        if(!enaMonExt()){
                setenv("bootdelay","3");
		setenv("disaMvPnp","no");
	}

	/* Disable PNP config of Marvel memory controller devices. */
        env = getenv("disaMvPnp");
        if(!env)
                setenv("disaMvPnp","no");

 
#ifdef CONFIG_DB88F5181
        
	/* MAC addresses */
        env = getenv("ethaddr");
        if(!env)
                setenv("ethaddr",ETHADDR);

	/* Signal the Linux wether to override the MAC address or to respect the Linux MAC. */
        env = getenv("overEthAddr");
        if(!env|| ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("overEthAddr","no");
        else
                setenv("overEthAddr","yes");


	if ((DB_88F5181_DDR1_PRPMC != mvBoardIdGet()) &&
	    (DB_88F5181_DDR1_MNG != mvBoardIdGet()))
	{

        /* USB Host */
        env = getenv("usb0Mode");

        if(!env)
		{
			if ((RD_88F5182_2XSATA == mvBoardIdGet())||
				(RD_88F5182_2XSATA3 == mvBoardIdGet())||
                		(RD_88F5181_POS_NAS == mvBoardIdGet())||
				(RD_88F5181L_VOIP_FE == mvBoardIdGet())||
				(RD_88F5181L_VOIP_GE == mvBoardIdGet())||
				(RD_88W8660_DDR1 == mvBoardIdGet())||
				(RD_88W8660_AP82S_DDR1 ==  mvBoardIdGet()) )
			{
				setenv("usb0Mode","host");

			} else setenv("usb0Mode","device");
		}

		if (mvCtrlUsbMaxGet() == 2)
		{
			env = getenv("usb1Mode");

			if(!env)
			{
				if ((RD_88F5182_2XSATA == mvBoardIdGet())||
					(RD_88F5182_2XSATA3 == mvBoardIdGet())||
                    			(RD_88F5181_POS_NAS == mvBoardIdGet()) 
					)
				{
					setenv("usb1Mode","host");

				}else setenv("usb1Mode","device");
			}

		}

		
	}
	else
	{
        env = getenv("yuk_ethaddr");
        if(!env)
                setenv("yuk_ethaddr",YUK_ETHADDR);

		{
			int i;

			char *tmp = getenv ("yuk_ethaddr");
			char *end;

			for (i=0; i<6; i++) {
				yuk_enetaddr[i] = tmp ? simple_strtoul(tmp, &end, 16) : 0;
				if (tmp)
					tmp = (*end) ? end+1 : end;

			}

		}


	}
#endif 
        return;
}

#ifdef BOARD_LATE_INIT
int board_late_init (void)
{
 /* in the RD_88F5181L_VOIP_FE and RD_88F5181L_VOIP_GE boards
    we use the phone indication leds for debug leds and we want
	to turn the leds off after U-Boot start
 */
 if (   (RD_88F5181L_VOIP_FE == mvBoardIdGet())||
	(RD_88F5181L_VOIP_GE == mvBoardIdGet()) 
	 )
 {
	mvBoardDebug7Seg(0);
 }
 return 0;
}
#endif

int misc_init_r (void)
{
	char name[15];
	char *env;
	volatile unsigned int temp;


	mvBoardDebug7Seg(5);



	/* set as 946 */
	env = getenv("cpuName");
	if(!env)
			setenv("cpuName","926");
	else
	{
		if (strcmp(env,"946") == 0)
		{
			/* set as 946 */
			unsigned int regVal;

			regVal = MV_REG_READ(CPU_CONFIG_REG);
			regVal |= CCR_MMU_DISABLED;
			MV_REG_WRITE(CPU_CONFIG_REG, regVal);
		}

	}

	mvCtrlModelRevNameGet(name);
	printf("\nSoc: %s\n",  name);

	mvCpuNameGet(name);
	printf("CPU: %s running @ %dMhz \n",  name,mvCpuPclkGet()/1000000);
	
	/* init special env variables */
	misc_init_r_env();

	mv_cpu_init();
	printf("SysClock = %dMhz , TClock = %dMhz \n\n", CFG_BUS_CLK/1000000, CFG_TCLK/1000000);

	if(enaMonExt()){
			printf("\n      Marvell monitor extension:\n");
			mon_extension_after_relloc();
	}
	printf("\n");		

	/* Init Debug module */
	mvDebugInit();

	/* init the units decode windows */
	misc_init_r_dec_win();


#ifdef CONFIG_PCI
        //pci_init();
#endif
	mvBoardDebug7Seg(6);

	if(mvCtrlModelGet() == MV_5281_DEV_ID) /* Orion 2 */
	{

		__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		if (temp & 0x10000000)
		{
			printf("CPU: Write allocate enabled\n");
		}
		else
		{
			printf("CPU: Write allocate Disabled\n");
		}
	}

#if defined(RD_88F5182_3)
	/* if (RD_88F5182_2XSATA3 == mvBoardIdGet()) */
	{
		#include "mvGpp.h"
		/* GPIO / Leds / and Power button handling */
			
		/* Every value is Zero */
		MV_REG_WRITE(GPP_DATA_OUT_REG(0),0);
	
		/* Clear Interrupt cause */
		MV_REG_WRITE(GPP_INT_CAUSE_REG(0),0);
	
		/* Enable interrupt as edge */
		MV_REG_BIT_SET(GPP_INT_MASK_REG(0),(1 << 6) );
	
		printf("\nPlease Press power button to continue ... \n");
		do
		{
			if ( MV_REG_READ(GPP_INT_CAUSE_REG(0)) & (1 << 6)) break;
		}while (1);


		/* Clear Interrupt cause */
		MV_REG_BIT_RESET(GPP_INT_CAUSE_REG(0),(1 << 6));

		/* Disable interrupt */
		MV_REG_BIT_RESET(GPP_INT_MASK_REG(0),(1 << 6) );
		
		/* SATA 0 power on */
		MV_REG_BIT_SET(GPP_DATA_OUT_REG(0),(1<<2));

		/* Insert delay between HDD0 power on and HDD1 power on to prevent power noise */
		udelay(1000000);

		/* SATA 1 power on */
		MV_REG_BIT_SET(GPP_DATA_OUT_REG(0),(1<<8));
	}
#endif /* #if defined(MV_88F5182) */

	mvBoardDebug7Seg(7);
	
	return 0;
}

MV_U32 mvTclkGet(void)
{
        DECLARE_GLOBAL_DATA_PTR;
                                                                                                                                               
        /* get it only on first time */
        if(gd->tclk == 0)
                gd->tclk = mvBoardTclkGet();
                                                                                                                                               
        return gd->tclk;
}
                                                                                                                                               
MV_U32 mvSysClkGet(void)
{
        DECLARE_GLOBAL_DATA_PTR;
                                                                                                                                               
        /* get it only on first time */
        if(gd->bus_clk == 0)
                gd->bus_clk = mvBoardSysClkGet();
                                                                                                                                               
        return gd->bus_clk;
}
 
#ifndef MV_TINY_IMAGE
/* exported for EEMBC */
MV_U32 mvGetRtcSec(void)
{
        MV_RTC_TIME time;
        mvRtcDS1339TimeGet(&time);
	return (time.minutes * 60) + time.seconds;
}
#endif

void reset_cpu(void)
{
	MV_REG_BIT_SET( CPU_RSTOUTN_MASK_REG , BIT2);
	MV_REG_BIT_SET( CPU_SYS_SOFT_RST_REG , BIT0);
}


void mv_cpu_init(void)
{
	char *env;
	volatile unsigned int temp;

	/*CPU streaming */
    if( (mvCtrlModelGet() == MV_5181_DEV_ID) ||
		(mvCtrlModelGet() == MV_5182_DEV_ID) ||
		(mvCtrlModelGet() == MV_8660_DEV_ID) ) /* orion 1 */
	{ 
		
			__asm__ __volatile__("mrc    p15, 0, %0, c1, c0, 0" : "=r" (temp):: "memory");

			env = getenv("enaCpuStream");
			if(!env || (strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0) )
			{
				printf("Orion 1 streaming disabled \n");
				temp &= 0xefffffff;
			}
			else
			{
				printf("Orion 1 streaming enabled \n");
				 temp |= 0xefffffff;
			}

			__asm__ __volatile__("mcr    p15, 0, %0, c1, c0, 0" : "=r" (temp):: "memory");
	}
	else if(mvCtrlModelGet() == MV_5281_DEV_ID) /* orion 2*/
	{ 
		
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");

			env = getenv("enaCpuStream");
			if(!env || (strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0) )
			{
				printf("Orion 2 streaming disabled \n");
				temp &= 0xdfffffff;
			}
			else
			{
				printf("Orion 2 streaming enabled \n");
				temp |= 0xdfffffff;
			}
				
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
	}

	if(mvCtrlModelGet() == MV_5281_DEV_ID){ /* Orion 2 */

		if (mvCtrlRevGet() == MV_5281_A0_REV) /* Orion 2 A0 */
		{
			env = getenv("enaVFP");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
			{
				/* init VFP to Run Fast Mode */
				printf("VFP initialized to Run Fast Mode.\n");
					temp = fmrx(FPSCR);
					temp |= (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO);
					fmxr(FPSCR, temp);

			}
			else
			{
				printf("VFP not initialized\n");

			}


		} else 	if (mvCtrlRevGet() >= MV_5281_B0_REV) /* Orion 2 >= B0 */
		{

			env = getenv("enaVFP");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
			{
				/* init and Enable VFP to Run Fast Mode */
				printf("VFP initialized to Run Fast Mode.\n");
				/* Enable */
				temp = FPEXC_ENABLE;
				fmxr(FPEXC, temp);

				/* Run Fast Mode */
				temp = fmrx(FPSCR);
				temp |= (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO);

				fmxr(FPSCR, temp);

			}
			else
			{
				printf("VFP not initialized\n");
				/* Disable */
				temp = fmrx(FPEXC);
				temp &= ~FPEXC_ENABLE;
				fmxr(FPEXC, temp);
			}

							
			/* DCache Pref  */
			env = getenv("enaDCPref");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))
			{
				MV_REG_BIT_SET( CPU_CONFIG_REG , CCR_DCACH_PREF_BUF_ENABLE);
			}
			if(env && ((strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0)))
            {
				MV_REG_BIT_RESET( CPU_CONFIG_REG , CCR_DCACH_PREF_BUF_ENABLE);
			}

			/* ICache Pref  */
			env = getenv("enaICPref");
            if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))
			{
				MV_REG_BIT_SET( CPU_CONFIG_REG , CCR_ICACH_PREF_BUF_ENABLE);
			}
			if(env && ((strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0)))
            {
				MV_REG_BIT_RESET( CPU_CONFIG_REG , CCR_ICACH_PREF_BUF_ENABLE);

			}

		}

		/* write allocate */
		env = getenv("enaWrAllo");
		if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
		{
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
			temp |= 0x10000000;
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		}
		else
		{
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
			temp &= 0xEFFFFFFF;
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		}

	}

}


#if (CONFIG_COMMANDS & CFG_CMD_NAND)

#include <linux/mtd/nand.h>

extern ulong nand_probe(ulong physadr);
extern struct nand_chip nand_dev_desc[CFG_MAX_NAND_DEVICE];

void nand_init(void)
{
	unsigned long totlen;
	unsigned long nflashBase;

	/* Check if NAND base is boot device */
    if (MV_REG_READ(DEV_NAND_CTRL_REG) & 0x1)
    {
        nflashBase = CFG_RESET_ADDRESS;
    }
    else
    {
        nflashBase = mvBoardGetDeviceBaseAddr(0, BOARD_DEV_NAND_FLASH);
    }
    
    totlen = nand_probe(nflashBase);
	printf ("%4lu MB\n", totlen >> 20);
}
#endif
