/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

/* FIXME ronen - get timer isn't working 4 PPC??? */

#include <common.h>
#include <command.h>
#include <config.h>
#include "mvFlash.h"
#include "mvDeviceRegs.h"
#include "mvBoardEnvSpec.h"

#define FLASH_ROM       0xFFFD       /* unknown flash type                   */
#define FLASH_RAM       0xFFFE       /* unknown flash type                   */
#define FLASH_MAN_UNKNOWN 0xFFFF0000
#define NL_HASHES_PER_LINE 65

/* #define DEBUG */
#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

void flashInfoCopy(flash_info_t *flash_info, MV_FLASH_INFO *pFlash);
MV_U32 getMvFlashInfoNum(flash_info_t *flash_info);
int flash_real_protect(flash_info_t *info, long sector, int prot);

flash_info_t	flash_info[CFG_MAX_FLASH_BANKS]; /* info for FLASH chips */
static MV_FLASH_INFO   mvFlashInfo[CFG_MAX_FLASH_BANKS];

/* return 0xFFFFFFFF in case didn't find a matching mvFlashInfo */
MV_U32	
getMvFlashInfoNum(flash_info_t *flash_info)
{
	MV_U32 i;

	DB(mvOsPrintf("%s\n", __FUNCTION__));
	if( flash_info->flash_id == FLASH_UNKNOWN )
	{
		DB(printf("%s : ERROR didn't find mvFlashInfo matching to flash_info_t.\n", __FUNCTION__));
		return 0xFFFFFFFF;
	}

	for (i = 0; i < CFG_MAX_FLASH_BANKS; i++)
	{
		if( (mvFlashBaseAddrGet(&mvFlashInfo[i]) == flash_info->start[0]) &&
			(mvFlashVenIdGet(&mvFlashInfo[i]) != FLASH_UNKNOWN) )
		{
			DB(printf("getMvFlashInfoNum found mvFlashInfo %d \n",i));
			return i;		
		}
		DB(mvOsPrintf(" %x %x \n",mvFlashBaseAddrGet(&mvFlashInfo[i]), mvFlashVenIdGet(&mvFlashInfo[i])));
	}

	DB(mvOsPrintf("%s(%d): ERROR didn't find mvFlashInfo matching to flash_info_t.\n", __FUNCTION__));

	return 0xFFFFFFFF;
}


/* make sure that #define CFG_FLASH_PROTECTION present in MV64xx.h */
 
int 
flash_real_protect(flash_info_t *info, long sector, int prot)
{
	MV_U32 s;
	s = getMvFlashInfoNum(info);
	if(s >= CFG_MAX_FLASH_BANKS)
	{
		DB(printf("flash_erase illegal mvFlashInfo \n")); 
		return 1;
	}
	if( mvFlashSecLockSet(&mvFlashInfo[s],sector,prot) != MV_OK)
		return 1; /* Write was not completed */

	info->protect[sector] = prot;
	return 0; /* write completed succefully */
}

void 	
flashInfoCopy(flash_info_t *flash_info, MV_FLASH_INFO *pFlash)
{
	MV_U32 i;
	if(mvFlashVenIdGet(pFlash) == FLASH_UNKNOWN)
	{
		flash_info->flash_id = FLASH_UNKNOWN;
		return;
	}		
	/* convert to U-Boot manufactor Id */
	flash_info->flash_id = ((mvFlashVenIdGet(pFlash) << 16) & FLASH_VENDMASK);
	/* convert to U-Boot flash Id */
	flash_info->flash_id |= (mvFlashDevIdGet(pFlash) & FLASH_TYPEMASK);
	
	/* other flash info parameters */
	flash_info->size = mvFlashSizeGet(pFlash);
	flash_info->sector_count = mvFlashNumOfSecsGet(pFlash);
	flash_info->portwidth = mvFlashBusWidthGet(pFlash);
	flash_info->chipwidth = mvFlashDevWidthGet(pFlash);

	/* sectors parameters */
	for(i = 0; i < mvFlashNumOfSecsGet(pFlash); i++)
	{
		flash_info->start[i] = mvFlashSecOffsGet(pFlash,i) + mvFlashBaseAddrGet(pFlash);
		flash_info->protect[i] = mvFlashSecLockGet(pFlash,i);
	} 

	return;
}

unsigned long
flash_init (void)
{

	MV_U32 i;
	unsigned long current_bank_size=0;
	unsigned long flash_size=0;
	unsigned long flashBanksNum =1;// mvBoardGetDevicesNumber(BOARD_DEV_NOR_FLASH);
	unsigned int base=0xff000000;	
	printf("Number of flash on board %d\n",flashBanksNum);
	flashBanksNum=2;//samsung flash has mutiple banks
	/* Init: no FLASHes known */
	for (i=0; i<CFG_MAX_FLASH_BANKS; ++i) {
		flash_info[i].flash_id = FLASH_UNKNOWN;
		mvFlashInfo[i].flashSpec.flashVen = FLASH_UNKNOWN;
	}
	for (i=0; i < flashBanksNum; ++i)
	{
#ifdef __FLASH_16M__
		mvFlashInfo[i].baseAddr = base;//mvBoardGetDeviceBaseAddr(i, BOARD_DEV_NOR_FLASH);
#else
		mvFlashInfo[i].baseAddr = 0xff800000;//mvBoardGetDeviceBaseAddr(i, BOARD_DEV_NOR_FLASH);
#endif
		mvFlashInfo[i].busWidth = 2;//mvBoardGetDeviceBusWidth(i, BOARD_DEV_NOR_FLASH)/8;
		mvFlashInfo[i].devWidth = 2;//mvBoardGetDeviceWidth(i, BOARD_DEV_NOR_FLASH)/8;

		if (mvFlashInfo[i].baseAddr == 0xffffffff) continue;

		current_bank_size = mvFlashInit(&mvFlashInfo[i]);

		flashInfoCopy(&flash_info[i], &mvFlashInfo[i]);

		printf("[%ldkB@%x] ", current_bank_size/1024, mvFlashInfo[i].baseAddr);		

		if (flash_info[i].flash_id == FLASH_UNKNOWN) {
			printf ("## Unknown FLASH at %08x: Size = 0x%08lx = %ld MB\n",
				mvFlashInfo[i].baseAddr, current_bank_size, current_bank_size<<20);
		}

		flash_size += current_bank_size;
		if(flash_info[i].flash_id!=0xec257e) break; //samsung k8q2815uqb id :0xec257e
		if(mvFlashInfo[i].baseAddr==0xff800000) break;
		base+=0x800000;
	}

	return flash_size;

}


/*-----------------------------------------------------------------------
 */
void
flash_print_info  (flash_info_t *info)
{
	MV_U32 s;
#if 1
	s = getMvFlashInfoNum(info);
	if(s >= CFG_MAX_FLASH_BANKS)
	{
		printf("missing or unknown FLASH type\n"); 
		return;
	}
#endif
	flashPrint(&mvFlashInfo[s]);

	return;
}

/*-----------------------------------------------------------------------
 */



int
flash_erase (flash_info_t *info, int s_first, int s_last)
{
	MV_U32 i,s;
	MV_U8 c = -1;
	
	DB(printf("%s: sectors %d - %d \n", __FUNCTION__, s_first, s_last));
	s = getMvFlashInfoNum(info);
	if(s >= CFG_MAX_FLASH_BANKS)
	{
		DB(printf("%s: illegal mvFlashInfo \n", __FUNCTION__)); 
		return 1;
	}
	printf("\n");

	for(i = s_first; i <= s_last; i++)
	{
		DB(printf("%s: calling mvFlashSecErase sector %d, base=%x, sec=%x\n", __FUNCTION__, i,mvFlashInfo[s].baseAddr, mvFlashInfo[s].sector[i].baseOffs));
		if(mvFlashSecErase(&mvFlashInfo[s],i) != MV_OK)
		{
		//	flash_print_info(info);
			return 1;
		}
                putc ('.');
                if (((i+1) % (NL_HASHES_PER_LINE)) == 0) 
		{
                        puts ("\n");
                }
	}
	puts("\n");

	return 0;
}

/*-----------------------------------------------------------------------
 * Copy memory to flash, returns:
 * 0 - OK
 * 1 - write timeout
 * 2 - Flash not erased
 */

int
write_buff (flash_info_t *info, uchar *src, ulong addr, ulong cnt)
{
	unsigned int s = 0;
    char *env;

	s = getMvFlashInfoNum(info);
	if(s >= CFG_MAX_FLASH_BANKS)
	{
		DB(printf("flash_erase illegal mvFlashInfo \n")); 
		return 1;
	}

	env = getenv("enaFlashBuf");
	if(( (strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) ))
	{
		if( mvFlashBlockWr(&mvFlashInfo[s],addr - mvFlashBaseAddrGet(&mvFlashInfo[s]) ,cnt,src) != cnt)
			return 1; /* Write was not completed */
	}
	else
	{
		if( mvFlashBlockUnbufWr(&mvFlashInfo[s],addr - mvFlashBaseAddrGet(&mvFlashInfo[s]) ,cnt,src) != cnt)
			return 1; /* Write was not completed */

	}


	return 0; /* write completed succefully */
}
 

