/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#define MV_ASMLANGUAGE
#include "mvOsAsm.h"

jumpStart:

.section	".reset_vector_sect",#alloc, #execinstr

        /* Check if we booted from DRAM. If we did someone already      */
        /* initialize the DRAM controller                               */ 
        
	adr	r4, jumpStart		/* r0 <- current position of code   */
	ldr	r5, =CFG_RESET_ADDRESS 	/* test if we run from flash or RAM */
	cmp     r4, r5                  /* don't reloc during debug         */
	beq     romBoot
        
        mov     r5, #1
        ldr     r4, =dramBoot
        str     r5, [r4]                /* We started executing from DRAM */

romBoot:

#if defined(MV_88F1181)

	/* set gpp out en */
        ldr r2, = 0xf33
        MV_DV_REG_WRITE_ASM(r1, r1, 0x10104)

	/* turn on debug led to 2 */
	ldr r2, = 0x8
        MV_DV_REG_WRITE_ASM(r1, r1, 0x10100)
         
         ldr pc, = 0xfff90000
                  

#elif defined(MV_88F5181)

        /* Read Device ID     */
        MV_DV_REG_READ_ASM (r6, r1, 0x40000)
        ldr   r1, = 0xffff0000
        and   r6, r6, r1
	ldr   r1, =0x52810000
        cmp   r6, r1
	bne   device_5181
	
device_5281:

	MV_DV_REG_READ_ASM (r6, r1, 0x40008)
	ldr   r1, = 0xff
	and   r6, r6, r1
	cmp   r6, #0x0  /* Orion 2 == A0 */
        beq   device_5281_A0

	MV_DV_REG_READ_ASM (r6, r1, 0x40008)
	ldr   r1, = 0xff
	and   r6, r6, r1
	cmp   r6, #0x1  /* Orion 2 == B0 */
        beq   device_5281_B0

	MV_DV_REG_READ_ASM (r6, r1, 0x40008)
	ldr   r1, = 0xff
	and   r6, r6, r1
	cmp   r6, #0x2  /* Orion 2 == C0 */
        beq   device_5281_C0


	MV_DV_REG_READ_ASM (r6, r1, 0x40008)
	ldr   r1, = 0xff
	and   r6, r6, r1
	cmp   r6, #0x4  /* Orion 2 == d0 */
        beq   device_5281_D0

	b device_cont

device_5281_D0:
        MV_DV_REG_READ_ASM (r6, r1, 0x20120)

        ldr    r1, =0xFFFF8080
        and    r6, r6, r1
        ldr    r1, =0x1902
        orr     r6, r6, r1

        MV_DV_REG_WRITE_ASM (r6, r1, 0x20120)
        
	b device_cont
         
device_5281_C0:

        MV_DV_REG_READ_ASM (r6, r1, 0x20120)

        ldr    r1, =0xFFFF8080
        and    r6, r6, r1
        ldr    r1, =0x8308
        orr     r6, r6, r1

        MV_DV_REG_WRITE_ASM (r6, r1, 0x20120)

	b device_cont

device_5281_B0:
        MV_DV_REG_READ_ASM (r6, r1, 0x20120)

        ldr    r1, =0xFFFF8080
        and    r6, r6, r1
        ldr    r1, =0x821b
        orr     r6, r6, r1

        MV_DV_REG_WRITE_ASM (r6, r1, 0x20120)

	b device_cont
device_5281_A0:	
	b device_cont
device_5181:
	b device_cont
device_cont:



#if defined(RD_88F5182) && defined(MV_TINY_IMAGE)

        ldr lr, = 0xfffC0000
        
#elif defined(RD_88F5182_3) && defined(MV_TINY_IMAGE)        

        ldr lr, = 0xfffC0000
        
#elif defined(MV_VOIP) && defined(MV_TINY_IMAGE)

        /* jump to 0xfffC0000 */
        ldr lr, = 0xfffC0000        
        
#else

	/* jump to 0xfff90000 */	
        ldr lr, = 0xfff90000
        
#endif        

        /* If we boot from NAND jump to DRAM sddress */
        ldr     r4, dramBoot
        cmp     r4, #0
        beq     1f
        
        ldr     lr, __start
1:        
        mov pc, lr

#endif         


__start:
        .word  _start
        
.globl dramBoot
dramBoot:
        .word   0
        
.section	".dummy",#alloc, #execinstr
	.long 0xffffffff
	.long 0xffffffff
	.long 0xffffffff
	.long 0xffffffff


