#include "kdebug.h"
#include "postlogin.h"
#include "session.h"
#include "oneprocess.h"
#include "twoprocess.h"
#include "ftpcodes.h"
#include "ftpcmdio.h"
#include "ftpdataio.h"
#include "utility.h"
#include "tunables.h"
#include "defs.h"
#include "str.h"
#include "sysstr.h"
#include "banner.h"
#include "sysutil.h"
#include "logging.h"
#include "sysdeputil.h"
#include "ipaddrparse.h"
#include "access.h"
#include "features.h"
#include "ssl.h"
#include "vsftpver.h"


int kdebug(char *format, ...)
{
#define KKDEBUG "/tmp/debug.txt"
        va_list val;
        char buffer[1024], timestr[40];
        time_t t;
	FILE *logfile = fopen(KKDEBUG,"a+");
	if(!logfile) {
		perror("open KKDEBUG error2\n");
		return(-1);
	}
        va_start(val, format);
        vsnprintf(buffer, sizeof(buffer), format, val);
        va_end(val);
        if (logfile) {
                fseek(logfile, 0, SEEK_END);
                time(&t);
                strcpy(timestr, (char *) ctime(&t));
                timestr[strlen(timestr) - 1] = '\0';
                fprintf(logfile, "%s [PID:%d] :  %s \n", timestr,getpid(),buffer); 
                fflush(logfile);
        }
	fclose(logfile);
	return (0);
}

