/* pidfile.c
 *
 * Functions to assist in the writing and removing of pidfiles.
 *
 * Russ Dill <Russ.Dill@asu.edu> Soptember 2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>

#include "debug.h"

int pidfile_acquire(char *pidfile)
{
	int pid_fd;
	if (pidfile == NULL) return -1;

	pid_fd = open(pidfile, O_CREAT | O_WRONLY, 0644);
	if (pid_fd < 0) {
		LOG(LOG_ERR, "Unable to open pidfile %s: %s\n",
		    pidfile, strerror(errno));
	} else {
		lockf(pid_fd, F_LOCK, 0);
	}
	
	return pid_fd;
}


void pidfile_write_release(int pid_fd)
{
	FILE *out;

	if (pid_fd < 0) return;

	if ((out = fdopen(pid_fd, "w")) != NULL) {
		fprintf(out, "%d\n", getpid());
		fclose(out);
	}
	lockf(pid_fd, F_UNLCK, 0);
	close(pid_fd);
}


void pidfile_delete(char *pidfile)
{
	if (pidfile) unlink(pidfile);
}


