/***************************************************************************
 *                  Sample HTTP calls for Cisco-Linksys                   *
 *                  ------------------------------------                   *
 *   begin                : Thu Mar 22 2007                                *
 *   copyright            : (C) 2007 by TZO                                *
 *   email                : mdf@tzo.com                                    *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <time.h>
#include <stdarg.h>
#include <errno.h>
#include "tzoupdate.h"
#include "PRO_file.h"
#include "LOG_log.h"
#include "flash.h"
#include "cgi_err.h"

//#define _DEBUG_
#define SOCKET_ERROR    -1
#define WSAEWOULDBLOCK	-1
#define TRUE            1
#define FALSE           0
#define INVALID_SOCKET	-1

#define TCP_SOCKET	1
#define UDP_SOCKET	2
#define MAX_MESSAGE_SIZE 6000

#define EXIT_OK				0
#define EXIT_TEMP_BLOCK		1
#define EXIT_EXPIRED		2
#define EXIT_FATAL			3
#define EXIT_CONFIG_ERROR	4
#define	EXIT_OBTAIN_WAN_IP_ERR	5
#define	EXIT_IP_EQUAL_ERR		6

#ifdef _LINKSYS_
	#define	ERRMSG_FILE		"/etc/cgi_msg"
	#define	DDNS_ERROR		"DDNS"
	#define	DDNS_UPDATE_OK			1	//TZO DDNS: Succeeded to update the IP Address.
	#define	DDNS_ACCOUNT_TMP_BLOCK	2	//TZO DDNS: The account has been blocked temporarily.
	#define	DDNS_ACCOUNT_EXPIRE		3	//TZO DDNS: The account has expired. The TZO DDNS function will be disabled. Please check your settings
	#define	DDNS_GET_CURR_IP_ERR	4	//TZO DDNS: Failed to get the IP Address.
	#define	DDNS_UPDATE_ERR			5	//TZO DDNS: Failed to update the IP Address.
	#define	DDNS_IP_EQUAL			6	//TZO DDNS: IP Address doesn't change, don't update.
	#define	DDNS_CHECK_WAN_IP		7	//TZO DDNS: Check the WAN IP Address for changes.
	#define	DDNS_AUTH_FAIL			8	//TZO DDNS: Authentication Failed. The TZO DDNS function will be disabled. Please check your settings.
	#define	DDNS_BLOCKED_UPDATES	9	//TZO DDNS: The Domain Name specified is blocked for update abuse. The TZO DDNS function will be disabled.
	#define	DDNS_BLOCKED_AGENT		10	//TZO DDNS: The User Agent that was sent has been blocked. The TZO DDNS function will be disabled.
	#define	DDNS_ACCOUNT_BLOCKED	11	//TZO DDNS: The account has been blocked. The TZO DDNS function will be disabled. Please check your settings.
	#define	DDNS_DOMAIN_BLOCKED		12	//TZO DDNS: The Domain Name specified is blocked because account is suspended by TZO. The TZO DDNS function will be disabled.
#endif

typedef struct
	{
	char * lpMem ;
	long Size ;
	long Ptr ;
	} MEMSTRUCT ;

#ifdef _LINKSYS_
	unsigned char TzoUpdateServerName[64] = {"linksys.rh.tzo.com"} ;
	unsigned char TzoEchoServerName[64] = {"linksys.echo.tzo.com"} ;
#else
	unsigned char TzoUpdateServerName[64] = {"rh.tzo.com"} ;
	unsigned char TzoEchoServerName[64] = {"echo.tzo.com"} ;
#endif
int DefaultHttpPort = 80 ;

/*
 * The User Agent, This should be modified for corporate usage
 */
#ifdef _LINKSYS_
	char TZO_UserAgentString[128] = {"Cisco-Linksys"} ;
#else
	char TZO_UserAgentString[128] = {"Default"} ;
#endif
/*
 *  This is the version of the release controlled by TZO
 */
#ifdef _LINKSYS_
	char TZO_VERSION[32] = {"NAS200-H1-Version34R"} ;
#else
	char TZO_VERSION[32] = {"1.0a"} ;
#endif
/*
 * These have been hardcoded o get you started
 */
char szGlobalTZOKey[65] = {0} ;
char szGlobalEmailAddress[65] = {0} ;
char szGlobalDomainName[65] = {0} ;
char szGlobalPort[10] = "80" ; // Alternate HTTP port 21333
int Verbose = 1 ;

#define SIZEOF_IP_ADDR 32

#define	TZO_RESULT_FILE	"/var/log/tzo_log"

void WriteTZOStatus(char *format, ...)
{
    va_list args;
	FILE *fp=NULL;
	char cmd_str[128]={0};
	
	sprintf(cmd_str, "/bin/date > %s 2>/dev/null", TZO_RESULT_FILE);
	system(cmd_str);	
	fp=fopen(TZO_RESULT_FILE, "at");
	if(!fp)
		return;
	va_start(args, format);
    vfprintf(fp, format, args);
    fputs("\n", fp);
    va_end(args);		
	fclose(fp);
}


int MemRelease(MEMSTRUCT * lpMemBlock) {
	if (lpMemBlock->lpMem)
		free(lpMemBlock->lpMem) ;
	lpMemBlock->lpMem = 0 ;
	lpMemBlock->Size = 0 ;
	lpMemBlock->Ptr = 0 ;

	return 1 ;
}


int MemCreate(MEMSTRUCT * lpMemBlock, long Size) {
	lpMemBlock->lpMem = malloc(Size) ;
	if (lpMemBlock->lpMem == 0)
		return 0 ;
	memset(lpMemBlock->lpMem,0,Size) ;
	lpMemBlock->Size = Size ;
	lpMemBlock->Ptr = 0 ;
	lpMemBlock->lpMem[0] = 0 ;

	return 1 ;
}


int EvalInt(char * lpMem, int * p, int Count) {
	int val = 0 ;

	while (*p < Count) {
		if (lpMem[*p] != ' ')
			break ;
		(*p) ++ ;
	}

	while (*p < Count) {
		if ((lpMem[*p] < '0') || (lpMem[*p] > '9'))
			break ;
		val = val * 10 + (lpMem[*p] - '0') ;
		(*p) ++ ;
	}

	(*p) ++ ;
	return val ;
}


int OpenConnectionByAddr(unsigned int IPAddress, unsigned short Port, int SocketType)	{
	struct sockaddr_in sin ;
	int err ;
	int RcvBufSize = MAX_MESSAGE_SIZE ;
	int NewSocket = 0 ;


	switch (SocketType)	{
		case UDP_SOCKET : {
			if ((NewSocket = socket(PF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET)
				return INVALID_SOCKET ;
			break ;
		}

		case TCP_SOCKET : {
			
			if ((NewSocket = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)
				return INVALID_SOCKET ;

			if ((err = setsockopt(NewSocket, SOL_SOCKET, SO_RCVBUF, (char *)&RcvBufSize, sizeof(int))) != 0) {
				close(NewSocket) ;
				return INVALID_SOCKET ;
			}

			sin.sin_family = AF_INET ;
			sin.sin_addr.s_addr = 0 ;
			sin.sin_port = 0 ;
			if ((err = bind(NewSocket, (struct sockaddr *) &sin, sizeof(sin))) != 0) {
				close(NewSocket) ;
				return INVALID_SOCKET ;
			}
			sin.sin_family = AF_INET ;
			sin.sin_addr.s_addr = IPAddress ;
			sin.sin_port = htons(Port) ;
			if ((err = connect(NewSocket, (struct sockaddr *) &sin, sizeof(sin))) != 0) {
				err = errno ;
				if (err == WSAEWOULDBLOCK)
					return NewSocket ;
				close(NewSocket) ;
				return INVALID_SOCKET ;
			}
			break ;
		}
	}
	return NewSocket ;
}


unsigned int FetchIPAddress(unsigned char * HostName) {
	struct hostent * lpHostEnt ;
	unsigned int IPAddress = 0 ;
	unsigned char * lpIPAddress = (unsigned char *)&IPAddress ;
	int i ;

	if ((IPAddress = inet_addr((char *)HostName)) != INADDR_NONE)
		return IPAddress ;
	if ((lpHostEnt = gethostbyname((char *)HostName)) == 0)	{
		if ((lpHostEnt = gethostbyname((char *)HostName)) == 0) {
			return 0 ;
		}
	}
	for (i=0; i<4; i++)
		lpIPAddress[i] = lpHostEnt->h_addr[i] ;
	return IPAddress ;
}


int SendToSocket(int Socket, char * lpRecord, int RecordSize) {
	int BytesSent ;
	int p = 0 ;

	while(p < RecordSize) {
		BytesSent = send(Socket, &lpRecord[p], RecordSize - p, 0) ;
		if (BytesSent == SOCKET_ERROR)
			return FALSE ;
		p += BytesSent ;
	}

	return TRUE ;
}


int FindStringInMem(char * str, char * lpMem, int Offset, int Count) {
	int len = strlen(str) ;
	int last = Count - len + 1 ;
	int i, j ;

	for (i=Offset; i<last; i++) {
		for (j=0; j<len; j++)
			if (lpMem[i + j] != str[j])
				break ;
		if (j == len)
			return i ;
	}

	return -1 ;
}


int ReadFromSocket(int Socket, MEMSTRUCT *lpMemStruct, unsigned int TimeOut)	{
	int p = 0 ;
	int BytesRead ;
	int ContentLength ;
	int mp ;
	time_t WaitTimer = time(NULL) + TimeOut ;
	unsigned short Result ;
	fd_set fSocketArray ;

	memset(&lpMemStruct->lpMem[0], 0, lpMemStruct->Size) ;
	lpMemStruct->Ptr = 0 ;

	while(time(NULL) < WaitTimer)	{
		struct timeval tv = {0,5} ;
		FD_ZERO(&fSocketArray) ;
		FD_SET(Socket, &fSocketArray) ;
		tv.tv_sec = 0 ;
		tv.tv_usec = 5 ;
		Result = select(Socket+1, &fSocketArray, NULL, NULL, &tv) ;

		if (Result == 0) {
			usleep(100) ;
			continue ;
		}

		if ((BytesRead = recv(Socket, &lpMemStruct->lpMem[p], lpMemStruct->Size-10, 0)) == SOCKET_ERROR)
			return 0 ;

		if (BytesRead == 0)
			return 1 ;

		lpMemStruct->lpMem[p + BytesRead] = 0 ;

		p += BytesRead ;

		lpMemStruct->Ptr = p ;

		if ((mp = FindStringInMem("Content-length: ", lpMemStruct->lpMem, 0, p)) < 0)
			if ((mp = FindStringInMem("Content-Length: ", lpMemStruct->lpMem, 0, p)) < 0)
				continue ;

		mp += strlen("Content-length: ") ;

		ContentLength = EvalInt(lpMemStruct->lpMem, &mp, p) ;

		if ((mp = FindStringInMem("\r\n\r\n", lpMemStruct->lpMem, 0, p)) < 0)
			continue ;

		mp += strlen("\r\n\r\n") ;

		if (p >= (ContentLength + mp))
			return 1 ;
	}

	return 0 ;
}


int AppendMem(int op, char * lpMem, char * str) {
	int l = strlen((char *)str) ;
	int i ;

	for (i=0; i<l; i++)
		lpMem[op++] = str[i] ;

	lpMem[op] = 0 ;
	return op ;
}


int FormHTTPRequest(unsigned char * WebHostName, char * FileName, char * lpMem, char * lpArgs) {
	int op = 0 ;
	char ts[512] ;

	sprintf(ts, "%s %s HTTP/1.0\r\n", (lpArgs[0] == 0) ? "GET" : "POST", FileName) ;
	op = AppendMem(op, lpMem, ts) ;

	sprintf(ts, "Host: %s\r\n", WebHostName) ;
	op = AppendMem(op, lpMem, ts) ;

	sprintf(ts, "User-Agent: TZO HTTP Update / Version %s [%s]\r\n", TZO_VERSION, TZO_UserAgentString) ;
	op = AppendMem(op, lpMem, ts) ;

	if (lpArgs[0]) {
		sprintf(ts, "Content-type: application/x-www-form-urlencoded\r\n") ;
		op = AppendMem(op, lpMem, ts) ;

		sprintf(ts, "Content-length: %d\r\n\r\n", strlen((char *)lpArgs)) ;
		op = AppendMem(op, lpMem, ts) ;

		op = AppendMem(op, lpMem, (char *)lpArgs) ;
	} else {
		sprintf(ts, "\r\n") ;
		op = AppendMem(op, lpMem, ts) ;
	}

	return op ;
}

int ShowDataBuf(char * Direction, char *szDataBuf) {
	int i ;
	
	printf("%s ", Direction) ;
	for (i = 0 ; i < strlen(szDataBuf) ; i++) {
		if (szDataBuf[i] == '\n')
			printf("\n%s ", Direction) ;
		else
			printf("%c", szDataBuf[i]) ;
	}
	printf("\n") ;
	return 1 ;
}


int TzoGetCurrentIP(unsigned char * szCurrentIPAddress) {
	int ServerSocket ;
	MEMSTRUCT DataBuf ;
	unsigned int ServerIPAddress ;
	char szMsg[1024];
	char log_msg[1][128]={{0}};
	int Loc = 0 ;

	szCurrentIPAddress[0] = 0 ;

	if ((MemCreate(&DataBuf, MAX_MESSAGE_SIZE)) == FALSE)  {
		//WriteTZOStatus("Internal error allocating memory.\n");
		return(ERR_MEMCREATE_FAILED) ;
	}

	if ((ServerIPAddress = FetchIPAddress(TzoEchoServerName)) == 0) {
		if (Verbose){
			printf("* Unable to fetch address to <%s>\n", TzoEchoServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_NO_IP,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to fetch IP Address of '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);
		}
		return(ERR_FETCHIPADDRESS_FAILED) ;
	}

	if ((ServerSocket = OpenConnectionByAddr(ServerIPAddress, DefaultHttpPort, TCP_SOCKET)) == INVALID_SOCKET) {
		if (Verbose){
			printf("* Unable to Open connection to <%s>\n", TzoEchoServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_CONN_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Fail to connect to '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);			
		}
		return(ERR_OPENCONNECTION_FAILED) ;
	}
	sprintf(szMsg, "/ip.shtml") ;
	DataBuf.Ptr = FormHTTPRequest(TzoEchoServerName, szMsg, DataBuf.lpMem, "") ;
	if (Verbose) {
		printf ("* Data sent to %s on %d\n", TzoEchoServerName, DefaultHttpPort) ;
		ShowDataBuf(">", DataBuf.lpMem) ;
	}

	if ((SendToSocket(ServerSocket, DataBuf.lpMem, DataBuf.Ptr)) == 0) {
		if (Verbose){
			printf("* Unable to send data to <%s>\n", TzoEchoServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_SEND_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to send data to '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);				
		}
		close(ServerSocket);
		return(ERR_SENDTOSOCKET_FAILED) ;
	}
	if ((ReadFromSocket(ServerSocket, &DataBuf,  15)) == 0) {
		if (Verbose){
			printf("* Unable to recieve data from <%s>\n", TzoEchoServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_READ_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to recieve data from '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);				
		}
		close(ServerSocket);
		return(ERR_READFROMSOCKET_FAILED) ;
	}
	close(ServerSocket) ;

	if (Verbose) {
		printf("* Data read from Echo Server \n") ;
		ShowDataBuf("<", DataBuf.lpMem) ;
	}

	if ((Loc = FindStringInMem("IPAddress:", DataBuf.lpMem, 0, DataBuf.Ptr)) >= 0) {
		int StartLoc = Loc + strlen("IPAddress:") ;
		int i, ii ;
		for (i = StartLoc, ii = 0 ; i < DataBuf.Ptr ; i++)
			szCurrentIPAddress[ii++] = DataBuf.lpMem[i] ;
		szCurrentIPAddress[ii] = 0 ;
	} else {
		if (Verbose){
			printf("* Bad packet data from <%s>\n", TzoEchoServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_BAD_PACKET,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Bad packet data from '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);				
		}
		return(ERR_BAD_PACKET_RETURNED);
	}
	MemRelease(&DataBuf) ;

	return(TRUE) ;
}


int TZOLogon(unsigned char *szKey, unsigned char *szEmail, unsigned char *szDomain, unsigned char * szCurrentIPAddress, char *szReturnBuffer) {
	int ServerSocket ;
	MEMSTRUCT DataBuf ;
	unsigned int ServerIPAddress ;
	char szMsg[1024], szServerReturnData[200] ;
	int Loc ;
	char log_msg[1][128]={{0}};
	
	if ((MemCreate(&DataBuf, MAX_MESSAGE_SIZE)) == FALSE)  {
		return(ERR_MEMCREATE_FAILED) ;	}

	if ((ServerIPAddress = FetchIPAddress(TzoUpdateServerName)) == 0) {
		if (Verbose){
			printf("** Unable to fetch address to <%s>\n", TzoUpdateServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_NO_IP,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to fetch IP Address of '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);
		}
		return(ERR_FETCHIPADDRESS_FAILED) ;
	}

	if ((ServerSocket = OpenConnectionByAddr(ServerIPAddress, DefaultHttpPort, TCP_SOCKET)) == INVALID_SOCKET) {
		if (Verbose){
			printf("** Unable to Open connection to <%s>\n", TzoUpdateServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_CONN_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Fail to connect to '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);	
		}
		return(ERR_OPENCONNECTION_FAILED) ;
	}

	sprintf(szMsg, "/webclient/tzoperl.html?TZOName=%s&Email=%s&TZOKey=%s&IPAddress=%s&system=tzodns&info=1", szDomain, szEmail, szKey, szCurrentIPAddress) ;

	DataBuf.Ptr = FormHTTPRequest(TzoUpdateServerName, szMsg, DataBuf.lpMem, "") ;

        if (Verbose) {
                printf("** Data Sent to %s on %d\n", TzoUpdateServerName, DefaultHttpPort) ;
		ShowDataBuf(">>", DataBuf.lpMem) ;
	}

	if ((SendToSocket(ServerSocket, DataBuf.lpMem, DataBuf.Ptr)) == 0) {
		if (Verbose){
			printf("** Unable to send data to <%s>\n", TzoUpdateServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_SEND_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to send data to '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);	
		}
		return(ERR_SENDTOSOCKET_FAILED) ;
	}

	if ((ReadFromSocket(ServerSocket, &DataBuf,  15)) == 0) {
		if (Verbose){
			printf("** Unable to read data from <%s>\n", TzoUpdateServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_READ_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Unable to recieve data from '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);	
		}
		return(ERR_READFROMSOCKET_FAILED) ;
	}

	if (Verbose) {
		printf("** Data read from Update Server \n") ;
		ShowDataBuf("<<", DataBuf.lpMem) ;
	}

	if ((Loc = FindStringInMem("\r\n\r\n", DataBuf.lpMem, 0, DataBuf.Ptr)) >= 0) {
		int StartLoc = Loc + strlen("\r\n\r\n") ;
		int i, ii ;
		for (i = StartLoc, ii = 0 ; i < DataBuf.Ptr ; i++)
			szServerReturnData[ii++] = DataBuf.lpMem[i] ;
		szServerReturnData[ii] = 0 ;
		if ((Loc = FindStringInMem("\r\n", szServerReturnData, 0, strlen(szServerReturnData))) >= 0) {
			StartLoc = Loc + strlen("\r\n") ;
			for (i = StartLoc, ii = 0 ; i < strlen(szServerReturnData) ; i++)
				szReturnBuffer[ii++] = szServerReturnData[i] ;
			szReturnBuffer[ii] = 0 ;
		}
	} else {
		if (Verbose){
			printf("** Bad packet data from <%s>\n", TzoUpdateServerName) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_BAD_PACKET,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Bad packet data from '%s'.");
			WriteTZOStatus(log_msg[0], TzoEchoServerName);	
		}
		return(ERR_BAD_PACKET_RETURNED);
	}

	close(ServerSocket) ;
	return atoi(szServerReturnData) ;
}

int ReadIPAddressFromFile(char *filename, char *szIpAddress) {
	int hFile ;
	szIpAddress[0] = 0 ;

	if ((hFile = open(filename, O_RDWR, 0640)) < 0){
#ifdef _DEBUG_		
		LOG_LogMsg ("DDNS",LOG_LEVEL_3,"TZO DDNS: Fail to open the file of storing current WAN IP.");	
#endif		
    	return 0 ;
    }

	read(hFile, szIpAddress, SIZEOF_IP_ADDR) ;

	close(hFile) ;
	return (1) ;
}

int WriteIPAddressToFile(char *filename, unsigned char *szIpAddress) {
	int hFile ;
	int ret=0;
	
	if ((hFile = open(filename, O_RDWR | O_CREAT | O_TRUNC, 0640)) < 0){
#ifdef _DEBUG_		
		LOG_LogMsg ("DDNS",LOG_LEVEL_3,"TZO DDNS: Fail to open the file to store current WAN IP.");
#endif					
    	return -1 ;
    }

	ret=write(hFile, szIpAddress, strlen((char *)szIpAddress)) ;
#ifdef _DEBUG_		
	if(ret<0)
		LOG_LogMsg ("DDNS",LOG_LEVEL_3,"TZO DDNS: Fail to write current WAN IP to file.");			
#endif
	close(hFile) ;
	return (0) ;
}

int IsTheFileOld(char * szFilename) {
	struct stat fInfo ;
	time_t ModTime ;
	time_t CurrentTime ;
	#define REFRESH_DAYS (28*24*60*60)

	stat(szFilename, &fInfo) ;

	ModTime = fInfo.st_mtime ;

	CurrentTime = time(NULL) ;

	if ((ModTime + REFRESH_DAYS) > CurrentTime) {
		if (Verbose)
			printf("* The file <%s> is up to date, do not force update...\n", szFilename) ;
		return (0) ;
	}

	if (Verbose)
		printf("* The file <%s> exist (but is older than 28 days); forcing update...\n", szFilename) ;
	return (1) ;
}

#define	DS_CONF_F "/etc/CGI_ds.conf"
#define	DEF_DS_CONF_F "/usr/local/CGI_ds.conf"
#define	IP_RECORD_FILE	"/etc/wan_ip"

int LockFile(void)
{
	int fd;
	fd = open("/tmp/tzo.lck",O_WRONLY|O_CREAT|O_EXCL,0666);
	if(fd == -1)
		return -1;
	close(fd);
	return 0;
}

void UnLockFile(void)
{
	unlink("/tmp/tzo.lck");
}

int main(int argc, char *argv[]) {
	unsigned char szCurrrentIpAddress[SIZEOF_IP_ADDR] ;
	unsigned char szLastIpAddress[SIZEOF_IP_ADDR] ;
	unsigned char szReturnBuffer[200] ;
	int ReturnVal;
	FILE *fh=NULL;
	char ddns_enable[6]={0};
	int ForceUpdate = 0 ;
	char log_msg[1][128]={{0}};
#ifdef _LINKSYS_
	char lversion[12]={0}, *p=NULL;
#endif

#ifndef _LINKSYS_
	int ddns_type=0;
#endif	
	if(LockFile())
		return -1;
	if(argc>1 && !strcmp(argv[1], "force"))
		ForceUpdate = TRUE ;
	memset(szCurrrentIpAddress,0,SIZEOF_IP_ADDR) ;
	memset(szLastIpAddress,0,SIZEOF_IP_ADDR) ;
	fh=fopen(DS_CONF_F,"rt");
	if(!fh){
		UnLockFile();
		return EXIT_FATAL;
	}
	PRO_GetStr("DDNS","ddns_enable",ddns_enable,4,fh);
#ifndef _LINKSYS_
	PRO_GetInt("DDNS","ddns_type",&ddns_type,fh);
#endif
	PRO_GetStr("DDNS","tzo_mail",szGlobalEmailAddress,64,fh);
	PRO_GetStr("DDNS","tzo_key",szGlobalTZOKey,64,fh);
#ifndef _LINKSYS_
	PRO_GetStr("DDNS","tzo_domain_name",szGlobalDomainName,64,fh);
#else
	PRO_GetStr("DDNS","tzo_domain",szGlobalDomainName,64,fh);
#endif	
	fclose(fh);
#ifndef _LINKSYS_
	if(strcmp(ddns_enable,"yes") || ddns_type!=1){//Not TZO
		UnLockFile();
		return EXIT_FATAL;
	}
#endif
#ifdef _LINKSYS_
	fh=fopen(DEF_DS_CONF_F,"r");
	if(fh){
		PRO_GetStr("network","version",version,12,fh);
		fclose(fh);	
		p=strrchr(version, '.');
		if(p){
			p++;	
		}		
	}
	if(p && strlen(p))
		strcat(TZO_VERSION, p);
	else
		strcat(TZO_VERSION, "51");
#endif
//	printf("TZO_VERSION=%s\n",TZO_VERSION);
//  printf("ForceUpdate=%d\n",ForceUpdate);
	if(strcmp(ddns_enable, "yes")){
		UnLockFile();
		return EXIT_FATAL;
	}
	remove(TZO_RESULT_FILE);
	DefaultHttpPort = atoi(szGlobalPort) ;
	if ((DefaultHttpPort != 80) && (DefaultHttpPort != 21333)) {
		printf("TZO ERROR : Port <%d> is invalid, port 80 and 21333 supported\n", DefaultHttpPort) ;
		PRO_GetMsgByIndex(DDNS_ERROR,DDNS_UPDATE_ERR,1,log_msg,ERRMSG_FILE);
		LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
		UnLockFile();
		return EXIT_FATAL ;
	}
	/*
	 * Get the current external WAN IP address.
	 */
	if (TzoGetCurrentIP(szCurrrentIpAddress) != TRUE) {
		PRO_GetMsgByIndex(DDNS_ERROR,DDNS_GET_CURR_IP_ERR,1,log_msg,ERRMSG_FILE);
		LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
		UnLockFile();
		return EXIT_OBTAIN_WAN_IP_ERR ;
	}
#ifdef _DEBUG_		
	sprintf(cmd_str, "TZO DDNS: Current WAN IP is %s\n",szCurrrentIpAddress);
	LOG_LogMsg ("DDNS",LOG_LEVEL_3,cmd_str);			
#endif	
	if (Verbose)
		printf("* Your Current Wan IP Address is <%s>\n", szCurrrentIpAddress) ;

	ReadIPAddressFromFile(IP_RECORD_FILE, (char *)szLastIpAddress) ;
#ifdef _DEBUG_		
	if(!strlen(szLastIpAddress))
		sprintf(cmd_str, "TZO DDNS: Last WAN IP is blank\n");
	else
		sprintf(cmd_str, "TZO DDNS: Last WAN IP is %s\n",szLastIpAddress);
	LOG_LogMsg ("DDNS",LOG_LEVEL_3,cmd_str);
#endif	
	if (strlen((char *)szLastIpAddress) == 0) {
		WriteIPAddressToFile(IP_RECORD_FILE, (unsigned char *)"testWrite");
	}
	else {
		/*
		 * Check the timestamp of the file and see if we should force an update, do this
		 * every 28 days as we are just trying to see if we expired...
		 */
		if (IsTheFileOld(IP_RECORD_FILE) == TRUE){
#ifdef _DEBUG_				
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,"TZO DDNS: File of storing WAN IP is too old, force do update.");
#endif						
			ForceUpdate = TRUE ;
		}
	}

	/*
	 * If we have not updated in over 28 days force an update to get expiration.
	 */
	if (!ForceUpdate) {                                                                                                     
		/*
		 * If the IP address returned from teh Echo Servers is the same IP Address that is in the
		 * the file, then we can assume that the IP addresses are the same.
		 */
		 
		if (strcmp((char *)szCurrrentIpAddress, (char *)szLastIpAddress) == 0) {
			if (Verbose)
				printf("* Your IP address %s has not changed\n",  szLastIpAddress) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_IP_EQUAL,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);		
			
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_IP_NO_CHANGE,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Your WAN IP address '%s' hasn't changed.");
			WriteTZOStatus(log_msg[0], szLastIpAddress);				
			UnLockFile();
			return EXIT_IP_EQUAL_ERR ;
		}
	}		
	/*
	 * Need to update the IP Address on the servers.
	 */
	switch (ReturnVal = TZOLogon(szGlobalTZOKey, szGlobalEmailAddress, szGlobalDomainName, szCurrrentIpAddress, (char *)szReturnBuffer)) {
		case UPDATE_SUCCESS :
		case UPDATE_NOCHANGE :
			if (Verbose)
				printf("* TzoLogon() : Success\n") ;
			WriteIPAddressToFile(IP_RECORD_FILE, szCurrrentIpAddress);
			if(ReturnVal==UPDATE_SUCCESS){
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_UPDATE_OK,1,log_msg,ERRMSG_FILE);
				LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);					
			}
			else{
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_IP_EQUAL,1,log_msg,ERRMSG_FILE);
				LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);					
			}
			if(ReturnVal==UPDATE_NOCHANGE){
				log_msg[0][0]=0;
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_IP_NO_CHANGE,1,log_msg,ERRMSG_FILE);
				if(!strlen(log_msg[0]))
					strcpy(log_msg[0], "Your WAN IP address '%s' hasn't changed.");
				WriteTZOStatus(log_msg[0], szCurrrentIpAddress);
				UnLockFile();
				return EXIT_IP_EQUAL_ERR ;
			}
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_UPDATE_OK,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The update succeeded, and the domain name has been updated.");
			WriteTZOStatus(log_msg[0]);			
			UnLockFile();
			break ;
		case ERR_ACCOUNT_TEMP_BLOCK :
			printf("TZO Warning : \n %s", szReturnBuffer) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_ACCOUNT_TMP_BLOCK,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_ACCOUNT_BLOCK_TMP,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The account has been blocked temporarily because of more than updates in less than a minute.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return EXIT_TEMP_BLOCK ;

		case ERR_BAD_AUTH:	//401, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_AUTH_FAIL,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_AUTH_ERR,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "Authentication failed.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return 	ERR_BAD_AUTH;
				
		case ERR_BLOCKED_UPDATES: //403, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_BLOCKED_UPDATES,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_DOMAIN_BLOCK_TMP,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The domain name specified is blocked for update abuse.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return 	ERR_BLOCKED_UPDATES;		
		
		case ERR_BLOCKED_AGENT: //405, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_BLOCKED_AGENT,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_AGENT_BLOCK,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The user agent that was sent has been blocked for not following specifications.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return 	ERR_BLOCKED_AGENT;
							
		case ERR_HOST_BLOCKED: //407, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_DOMAIN_BLOCKED,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_DOMAIN_BLOCK,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The domain name has been blocked.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return 	ERR_HOST_BLOCKED;							
									
		case ERR_ACCOUNT_BLOCKED: //415, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_ACCOUNT_BLOCKED,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_ACCOUNT_BLOCK,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The account has been blocked.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return 	ERR_BLOCKED_AGENT;
					
		case ERR_ACCOUNT_EXPIRED : //480, Need Disable
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_ACCOUNT_EXPIRE,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			PRO_SetStr("DDNS","ddns_enable","no",DS_CONF_F);
			flash_write_config(SYSCONF,MTD_CONFIG);	
			system("/bin/killall update_ddns 2>/dev/null");
			log_msg[0][0]=0;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_ACCOUNT_EXPIRE,1,log_msg,ERRMSG_FILE);
			if(!strlen(log_msg[0]))
				strcpy(log_msg[0], "The account has expired.");
			WriteTZOStatus(log_msg[0]);				
			UnLockFile();
			return EXIT_EXPIRED ;
			
		default :
			/*
			 * Fatal error
			 */
			//printf("TZO FATAL : \n %s", szReturnBuffer) ;
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_UPDATE_ERR,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);	
			if(ReturnVal==ERR_NO_HOST_EXIST){
				log_msg[0][0]=0;
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_DOMAIN_NOT_EXIST,1,log_msg,ERRMSG_FILE);
				if(!strlen(log_msg[0]))
					strcpy(log_msg[0], "The domain name specified does not exist.");
				WriteTZOStatus(log_msg[0]);					
			}
			else if(ReturnVal==ERR_BAD_HOST_NAME){
				log_msg[0][0]=0;
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_DOMAIN_ERR,1,log_msg,ERRMSG_FILE);
				if(!strlen(log_msg[0]))
					strcpy(log_msg[0], "The domain name specified is not a fully-qualified domain name.");
				WriteTZOStatus(log_msg[0]);					
			}
			else if(ReturnVal==ERR_HOST_MISMATCH){
				log_msg[0][0]=0;
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_DOMAIN_NOT_USER,1,log_msg,ERRMSG_FILE);
				if(!strlen(log_msg[0]))
					strcpy(log_msg[0], "The domain name specified exists, but not for the username specified.");
				WriteTZOStatus(log_msg[0]);					
			}
			//else if(ReturnVal==ERR_SYSTEM_TYPE)
			//	WriteTZOStatus("Bad System type.");
			//else if(ReturnVal==ERR_HOST_COUNT)
			//	WriteTZOStatus("Too many or too few hosts found.");
			//else if(ReturnVal==ERR_DNS_ERROR)
			//	WriteTZOStatus("DNS Error.");
			else if(ReturnVal>ERR_BAD_PACKET_RETURNED){
				log_msg[0][0]=0;
				PRO_GetMsgByIndex(DDNS_ERROR,DDNS_RESULT_UPDATE_FAIL,1,log_msg,ERRMSG_FILE);
				if(!strlen(log_msg[0]))
					strcpy(log_msg[0], "Failed to update the IP Address.");
				WriteTZOStatus(log_msg[0]);					
			}
			UnLockFile();		
			return EXIT_FATAL ;
	}
	UnLockFile();
	return EXIT_OK ;
}

/*
[DDNS]
Total=12
1=DDNS: Succeeded to update the IP Address.
2=DDNS: The account has been blocked temporarily.
3=DDNS: The account has expired. The DDNS function will be disabled. Please check your settings.
4=DDNS: Failed to get the IP Address.
5=DDNS: Failed to update the IP Address.
6=DDNS: IP Address doesn't change, don't update.
7=DDNS: Check the WAN IP Address for changes.
8=DDNS: Authentication Failed. The DDNS function will be disabled. Please check your settings.
9=DDNS: The Domain Name specified is blocked for update abuse. The DDNS function will be disabled.
10=DDNS: The User Agent that was sent has been blocked. The DDNS function will be disabled.
11=DDNS: The account has been blocked. The DDNS function will be disabled. Please check your settings.
12=DDNS: The Domain Name specified is blocked because account is suspended. The DDNS function will be disabled.
13=Unable to fetch IP Address of '%s'.
14=Unable to connect to '%s'.
15=Unable to send data to '%s'.
16=Unable to recieve data from '%s'.
17=Bad packet data from '%s'.
18=Your WAN IP address '%s' hasn't changed.
19=The update succeeded, and the domain name has been updated.
20=The account has been blocked temporarily because of more than updates in less than a minute.
21=Authentication failed.
22=The domain name specified is blocked for update abuse, please wait 1 minute.
23=The user agent that was sent has been blocked for not following specifications.
24=The domain name has been blocked.
25=The account has been blocked.
26=The account has expired.
27=The domain name specified does not exist.
28=The domain name specified is not a fully-qualified domain name.
29=The domain name specified exists, but not under the username specified.
30=Failed to update the IP Address.
*/
