/*
author: kylin 
* e-mail: kylin_kang@sdc.sercomm.com 
* gddemo.c
* Tue Jul 10 11:08:05 2007
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "gd.h"
#include "gdfontt.h"
#include "gdfonts.h"
#include "gdfontmb.h"
#include "gdfontl.h"
#include "gdfontg.h"

#include "thumbnail.h"

enum file_type{
	TYPE_NONE,
	TYPE_GIF,
	TYPE_JPEG,
	TYPE_PNG
};

int get_file_type (char *file_name); 

int CreateThumbFromFile (char *in_file, char *out_file, int maxsize, int type);

int IsImageFile(char *pFileName)
{
	int file_type=TYPE_NONE;
	int ret=0;

	if(!pFileName || !strlen(pFileName))
		return 0;
	if((file_type=get_file_type(pFileName))==TYPE_NONE)
		return 0;
		
	return 1;
}

int CreateThumb(char *pFileName, char *pThumbName)
{
	int file_type=TYPE_NONE;
	int ret=0;

	if(!pFileName || !strlen(pFileName))
		return -1;
	if((file_type=get_file_type(pFileName))==TYPE_NONE)
		return -1;
		
	ret=CreateThumbFromFile(pFileName, pThumbName, THUMBNAIL_SIZE, file_type);
	return ret;
}

int CreateThumbFromFile (char *in_file, char *out_file, int maxsize, int type)
{
	/* Input and output files */
	FILE *in=NULL;
	FILE *out=NULL;
	int old_x, old_y;
	int thumb_w, thumb_h;
	/* Input and output images */
	gdImagePtr im_in = NULL, im_out = NULL; //Pointer

{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"out_file: %s\n", out_file);
	fclose(ff);
}	
	out = fopen(out_file, "wb");
	if(!out){
		if(errno==EACCES || errno==ENOSPC)
			return -2;
		return -1;
	}
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}	
	/* Try to load demoin.png and paste it to the output imae */
	in = fopen(in_file, "rb");
	if (!in) {
		printf("Fail to open file '%s'\n", in_file);
		fclose(out);
		remove(out_file);
		return -1;
	} 
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}		
	switch (type) {
		case TYPE_GIF:
			printf("GIF Image\n");
			im_in = gdImageCreateFromGif (in);
			break;
		case TYPE_JPEG:
			printf("JPEG Image\n");
			im_in = gdImageCreateFromJpeg (in);
			break;
		case TYPE_PNG:
			printf("PNG Image\n");
			im_in = gdImageCreateFromPng (in);
			break;
		default: 
			printf("Not Image Format\n");
			fclose(out);
			remove(out_file);
			return -1;
	}
	fclose (in);
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}		
	if(!im_in){
		fclose(out);
		remove(out_file);
		return -1;
	}
	printf("Original File: X: %d Y: %d\n", gdImageSX(im_in), gdImageSY(im_in));
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}		
	old_x = gdImageSX(im_in);
	old_y = gdImageSY(im_in);
	if (old_x < maxsize && old_y < maxsize) {
		thumb_w = old_x;
		thumb_h = old_y;
	} else {
		thumb_w = (old_y > old_x) ? ((float)old_x/old_y*maxsize) : maxsize;
		thumb_h = (old_x > old_y) ? ((float)old_y/old_x*maxsize) : maxsize;
	}
	printf("Thumb File: X: %d Y: %d\n", thumb_w, thumb_h);
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}		
	/* Create output image, in true color */
	im_out = gdImageCreateTrueColor (thumb_w, thumb_h);
	if(!im_out){
		gdImageDestroy (im_in);
		fclose(out);
		remove(out_file);
	}
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}		
	/* Now copy, and magnify as we do so */
	gdImageCopyResampled (im_out, im_in, 0, 0, 0, 0, thumb_w, thumb_h, old_x, old_y); 

	switch (type) {
		case TYPE_GIF:
			gdImageGif(im_out, out);
			break;
		case TYPE_JPEG:
			gdImageJpeg(im_out, out, 90);
			break;
		case TYPE_PNG:
			gdImagePng(im_out, out);
			break;
		default:
			if(im_out)
				gdImageDestroy (im_out);
			if (im_in)
				gdImageDestroy (im_in);	
			fclose (out);	
			remove(out_file);
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}			
			return -1;
	}
{
	FILE *ff=NULL;
	
	ff=fopen("/dev/ttyS0","wt");
	fprintf(ff,"Line: %d\n", __LINE__);
	fclose(ff);
}	
	fclose (out);
	chmod(out_file, 0664);
	chown(out_file, 501, 501);
	if(im_out)
		gdImageDestroy (im_out);
	if (im_in)
		gdImageDestroy (im_in);
		
	return 0;
}

int get_file_type (char *file_name)
{
	int type = TYPE_NONE;
	char *p=NULL;
	
	p=strrchr(file_name, '.');
	if(!p || p==file_name+strlen(file_name)-1)
		return type;
	if (!strcasecmp(".jpg",p))
		type = TYPE_JPEG;
	else if (!strcasecmp(".png",p))
		type = TYPE_PNG;
	else if (!strcasecmp(".gif",p))
		type = TYPE_GIF;
	return type;
}

#if 0
int 
main (int argc, char **argv)
{
	int ret;
	int maxsize;

	if (argc < 3) {
		printf("Usage: %s <source image> <dest image> [maxsize] \n", argv[0]);
		exit(1);
	}
	
	if (argc == 4)
		maxsize = atoi(argv[3]);
	else
		maxsize = 30;

	printf("source_image: %s\n, dest_image: %s\n, maxsize: %d\n", argv[0], argv[1], argv[2]);

	ret = CreateThumbFromFile (argv[1], argv[2], maxsize, get_file_type(argv[1]));

	printf("ret: %d\n", ret);
	
	return(0);
}

#endif

