/* author: kylin 
* e-mail: kylin_kang@sdc.sercomm.com 
* tn.c
* 2007å¹?7æœ?7æ—?æ˜ŸæœŸäº?13æ—?3åˆ?6ç§?*/

#include <stdio.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <strings.h>
#include <fcntl.h>
#include <unistd.h>
#include <jpeglib.h>
#include <errno.h>
#include "thumbnail.h"
#include "constant.h"
#include "signal.h"
#ifndef errno
extern int errno; 
#endif

#if !HAVE_STRRCHR && HAVE_RINDEX
#define strrchr rindex
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif
#include <sys/stat.h>

#define MAXSIZE     2048                    /* Maximum size of thumbnail   */
#define MINSIZE     1                       /* Minimum size of thumbnail   */
#define DEFAULTSIZE 128                     /* Default size of thumbnail   */

#define GRAY 128

#define RSZ_AUTO   0
#define RSZ_WIDTH  1
#define RSZ_HEIGHT 2

unsigned char *outimage;                    /* The current thumbnail image */
unsigned char *palette;                     /* Global palette pointer      */
int            width;                       /* Original image width        */
int            height;                      /* Original image height       */
int            background;                  /* Index's background color    */
long           out_wide;                    /* Width of thumbnail image    */
long           out_high;                    /* Height of thumbnail image   */


/* resizepic.c */
static unsigned char *resizepic(unsigned char *thisimage, 
                                unsigned char *palr,
                                unsigned char *palg, 
                                unsigned char *palb,
                                int            currwidth, 
                                int            currheight,
                                int            maxsize,
                                int            which_dim);

/* readjpeg.c */
static unsigned char *read_JPEG_file(char *filename, unsigned char **palette);

/* writejpeg.c  */
static int write_JPEG_file(char *filename, 
                            int   outwidth,  
                            int   outheight, 
                            int   quality);

static int file_exists(const char *path); 
enum file_type{
	TYPE_NONE,
	TYPE_GIF,
	TYPE_JPEG,
	TYPE_PNG
};

/*
 * API for GIF graphics
*/
#include "gif_lib.h"

#define PROGRAM_NAME	"GifRSize"

#define MAX_SCALE	16.0			  /* Maximum scaling factor. */


/* Make some variables global, so we could access them faster: */
static double
    XScale = 0.5,
    YScale = 0.5;
static int
    XSize = 0,
    YSize = 0;

static void ResizeLine(GifRowType LineIn, GifRowType LineOut,
		      int InLineLen, int OutLineLen);
static int QuitGifError(GifFileType *GifFileIn, GifFileType *GifFileOut);
int CreateGIFThumbFromFile(const char *in_file, const char *out_file, int maxsize); 

/*End */

//int CreateJPEGThumbFromFile(char *in_file, const char *out_file, int maxsize); 

#define JPEG_TOOL_PATH	"/usr/sbin"
extern int IsFileJPEG(char *pSuffix);

#if 1
#define	JPEG_FORMAT	".jpg.jpeg.jpe."

int IsFileJPEG(char *pSuffix)
{
	char tmp_str[64]={0}, *p=NULL;
	int len=0,i=0;

	if(!pSuffix)
		return 0;
	p=strrchr(pSuffix, '.');
	if(!p)
		return 0;
	len=strlen(p);
	if(len > sizeof(tmp_str)-1)
		return 0;
	for(i=0;i<len;i++)
		tmp_str[i]=tolower(p[i]);
	tmp_str[i]='.';	
	tmp_str[i+1]=0;	
	if(strstr(JPEG_FORMAT, tmp_str))
		return 1;
	return 0;
}
#endif
int get_file_type (char *file_name)
{
	int type = TYPE_NONE;
	char *p=NULL;
	
	p=strrchr(file_name, '.');
	if(!p || p==file_name+strlen(file_name)-1)
		return type;
	if (IsFileJPEG(file_name))
		type = TYPE_JPEG;
	else if (!strcasecmp(".png",p))
		type = TYPE_PNG;
	else if (!strcasecmp(".gif",p))
		type = TYPE_GIF;
	return type;
}


int IsImageFile(char *pFileName)
{
	int file_type=TYPE_NONE;

	if(!pFileName || !strlen(pFileName))
		return 0;
	file_type=get_file_type(pFileName);
	if(file_type==TYPE_JPEG || file_type==TYPE_GIF)
		return 1;
		
	return 0;
}

static int LockFile(void)
{
	int fd;

	fd = open("/tmp/thumbnail.lck",O_WRONLY|O_CREAT|O_EXCL,0666);
	if(fd == -1)
		return -1;
	close(fd);
	return 0;
}

static void UnLockFile(void)
{
	unlink("/tmp/thumbnail.lck");
}

#define	JHEAD_PATH	"/usr/sbin/jhead"

#if 1
void StripSpace (char *pStr)
{
	int len = 0, i = 0;
	char *p=NULL;

	if (!pStr || !pStr[0])
		return;
	p = pStr;
	while (*p == ' ')
		p++;
	len=strlen(p);
	memmove (pStr, p, strlen (p));
	pStr[len]=0;
	len = strlen (pStr);
	len--;
	i = len;
	while (pStr[i] == ' ')
		i--;
	if (i != len)
		pStr[i + 1] = '\0';
	return;
}
#endif
int ReadPhotoResolution(char *pFileName, char *pResolution)
{
	char TmpFile[64]="/tmp/tmpfile.XXXXXX";	
	char buf[1024]={0}, *p=NULL;
	struct stat f_stat;
	FILE *fp=NULL;
	int fd;
	
	if(access(pFileName, F_OK))
		return -1;
	GetTmpFileName(TmpFile);	
	fd = mkstemp(TmpFile);
	if ( fd == -1)
	    return -1;
	close(fd);

	sprintf(buf, "%s '%s' > %s 2>/dev/null", JHEAD_PATH, pFileName, TmpFile);
	system(buf);
	if(stat(TmpFile, &f_stat) || !f_stat.st_size){
		remove(TmpFile);
		return -1;
	}
	fp=fopen(TmpFile, "rt");
	if(!fp){
		remove(TmpFile);
		return -1;
	}
	while(fgets(buf,sizeof(buf)-1, fp )){
		p=strrchr(buf, '\n');
		if(p)
			*p=0;		
		if(strstr(buf, "Resolution")==buf){//Resolution
			p=strchr(buf, ':');
			if(!p)
				break;
			*p++=0;
			StripSpace(p);
			strcpy(pResolution, p);
			break;
		}
	}
	fclose(fp);	
	remove(TmpFile);
	return 0;
}	

int CreateThumb(char *pFileName, char *pThumbName)
{
	int file_type=TYPE_NONE;
	int ret=0,num=0;
	char resolution[64]={0};
	
	if(!pFileName || !strlen(pFileName))
		return -1;
	while(LockFile()){
		num++;
		if(num>=1800){
			UnLockFile();
			break;
		}
		sleep(2);
	}		
	file_type=get_file_type(pFileName);
	if(file_type==TYPE_JPEG){
		ret = ReadPhotoResolution(pFileName, resolution);
		if(!ret)
			ret=CreateJPEGThumbFromFile(pFileName, pThumbName, resolution);
	}
	else if(file_type==TYPE_GIF)
		ret=CreateGIFThumbFromFile(pFileName, pThumbName, THUMBNAIL_SIZE);
	else{
		UnLockFile();
		return -1;	
	}
	if(!ret)
		chmod(pThumbName, 0664);
	UnLockFile();
	return ret;
}


static int file_exists(const char *path) { 
    struct stat buf;
 
    /* Crude check. If we can stat it successfully, we assume it exists. */
    /* Otherwise we return zero, meaning that this function can't tell. */

    if (0 == stat(path, &buf)) {
        return(1);
    } else {
        return(0);
    }
}
#if 1

#define JPEG_SMALL_WIDTH	120
#define	JPEG_SMALL_HEIGHT	90

/*get the reduce scale of the large and middle pic */
int GetPicScale(char *resolution)
{
	int width,higth,scale_i;
	float scale_w,scale_h,scale_f;
	char *p=NULL;
	if(!resolution)
		return -1;
	p=strchr(resolution, 'x');
	if(!p){
		return -1;
	}		
	*p=0;
	p++;
	width=atoi(resolution);
	higth=atoi(p);
	/* If picture is too small,  than don't need scale ,just copy it to thumbnail */
	if(width<=JPEG_SMALL_WIDTH && higth<=JPEG_SMALL_HEIGHT) {
		return 0;
	}
	scale_w=(float)width/JPEG_SMALL_WIDTH;
	scale_h=(float)higth/JPEG_SMALL_HEIGHT;
	scale_f=(scale_w>=scale_h)?scale_w:scale_h;
	scale_i=(int)scale_f;
	if(scale_f!=scale_i)
		scale_i+=1;
	return scale_i;
}

int AssignScale(int scale,char *d_scale,char *c_scale)
{
	if(scale<=0)
		return -1;
	switch(scale){
		case 1:
			strcpy(c_scale,"1/1");
			strcpy(d_scale,"1/1");
			break;
		case 2:
			strcpy(c_scale,"1/2");
			strcpy(d_scale,"1/1");
			break;
		case 3:
			strcpy(c_scale,"8/9");
			strcpy(d_scale,"3/8");
			break;
		case 4:
			strcpy(c_scale,"8/16");
			strcpy(d_scale,"4/8");
			break;
		case 5:
			strcpy(c_scale,"8/15");
			strcpy(d_scale,"3/8");
			break;
		case 6:
			strcpy(c_scale,"8/12");
			strcpy(d_scale,"2/8");
			break;
		case 7:
			strcpy(c_scale,"8/14");
			strcpy(d_scale,"2/8");
			 break;
		case 8:
			strcpy(c_scale,"8/16");
			strcpy(d_scale,"2/8");
			break;
		case 9:
			strcpy(c_scale,"8/9");
			strcpy(d_scale,"1/8");
			break;
		case 10:
			strcpy(c_scale,"8/10");
			strcpy(d_scale,"1/8");
			break;		
		case 11:
			strcpy(c_scale,"8/11");
			strcpy(d_scale,"1/8");
			break;
		case 12:
			strcpy(c_scale,"8/12");
			strcpy(d_scale,"1/8");
			break;
		case 13:
			strcpy(c_scale,"8/13");
			strcpy(d_scale,"1/8");
			break;
		case 14:
			strcpy(c_scale,"8/14");
			strcpy(d_scale,"1/8");
			break;
		case 15:
			strcpy(c_scale,"8/15");
			strcpy(d_scale,"1/8");
			break;
		case 16:
			strcpy(c_scale,"8/16");
			strcpy(d_scale,"1/8");
			break;
		default:
			strcpy(c_scale,"1/2");
			strcpy(d_scale,"1/8");
			break;
	}
	return 0;
}
int CreateJPEGThumbFromFile(char *in_file, const char *out_file, char *resolution) {
	int ret,scale=-1, large_file=0, fd=0;
	char cmdbuf[1024];
	char *pSrc=NULL;
	char d_scale[20],c_scale[20];
	char TmpFile[64]="/tmp/tmpfile.XXXXXX";	
	
	if (file_exists(out_file)) {
		//fprintf(stderr, "File %s already exists.\n", out_file);
		return 0;
	}
try_again:	
	strcpy(TmpFile, "/tmp/tmpfile.XXXXXX");
	GetTmpFileName(TmpFile);	
	fd = mkstemp(TmpFile);
	if ( fd == -1)
	    return -1;
	close(fd);
	if(large_file)
		pSrc=out_file;
	else
		pSrc=in_file;
	ret = ReadPhotoResolution(pSrc, resolution);
	if(ret){
		remove(TmpFile);
		remove(out_file);
		return -1;	
	}
	scale=GetPicScale(resolution);
	if(scale<0){
		remove(TmpFile);
		remove(out_file);
		return -1;	
	}
	if(scale==0) {
		if(pSrc!=out_file){
			sprintf(cmdbuf, "/bin/cp -af '%s' '%s' 2>/dev/null", pSrc, out_file);
			ret=system(cmdbuf);
			if(ret){
				remove(TmpFile);
				remove(out_file);
				return -1;	
			}
		}
		remove(TmpFile);
		return 0;
	}
	if(scale>16){
		large_file=1;	
		scale=16;
	}
	else 
		large_file=0;
	ret=AssignScale(scale,d_scale,c_scale);
	if(ret){
		remove(TmpFile);
		remove(out_file);
		return -1;	
	}
#if 1		
	errno=0;
	signal(SIGCHLD,SIG_DFL);
	sprintf(cmdbuf, JPEG_TOOL_PATH"/djpeg -scale %s '%s' > %s 2>/dev/null", d_scale, pSrc, TmpFile);
	ret=system(cmdbuf);
	if(ret){
		remove(TmpFile);
		remove(out_file);
		return -1;
	}	
	sprintf(cmdbuf, JPEG_TOOL_PATH"/cjpeg -scale %s '%s' '%s' 2>/dev/null",c_scale,TmpFile,out_file);
	//printf("cmdbuf==%s\n",cmdbuf);
#else
	sprintf(cmdbuf, JPEG_TOOL_PATH"/djpeg -scale %s '%s' | "JPEG_TOOL_PATH"/cjpeg -scale %s > '%s' 2>/dev/null", d_scale, pSrc, c_scale,out_file);
	//printf("cmdbuf==%s\n",cmdbuf);
#endif	
	ret=system(cmdbuf);
	if(ret){
		remove(TmpFile);
		remove(out_file);
		return -1;
	}		
	remove(TmpFile);
	if(large_file)
		goto try_again;
	return 0;
	
}

#else
int CreateJPEGThumbFromFile(char *in_file, const char *out_file, int maxsize) {

    int xsiz = 0;                          /* Total output image xsize    */
    int ysiz = 0;                          /* Total output image ysize    */
    unsigned char *bigimage   = NULL;      /* Pointer to current image    */
    unsigned char *palrgb     = NULL;      /* Pointer to image palette    */
    int  size = DEFAULTSIZE;               /* Size of thumbnail image.    */
    int  opt_flag_quality   = 0;
    int  opt_flag_stdout    = 0;
    int  opt_flag_verbose   = 0;
    int  opt_quality;                      /* JPEG Quality                */
    int  opt_rsz_dim = RSZ_AUTO;           /* Dimension to resize. 0,1,2  */
    char *imgfile       = NULL;            /* Output filename             */
	int ret=0;
	
	size = maxsize;
	imgfile = (char *)out_file;
    if (!opt_flag_quality) opt_quality = 70;

	if (file_exists(imgfile)) {
		//fprintf(stderr, "Skipping: %s: File exists\n", imgfile);
		return 0;
	}

	/* Get a pointer to the big image or NULL on error */
	bigimage=read_JPEG_file((char *)in_file, &palette);
	if (NULL == bigimage) {
		//fprintf(stderr, "read_JPEG_file: Error\n");
		return -1;
	}

	palrgb=palette;
	/* If picture is too small,  than do not convert ,just copy it to thumbnail */
	if (width < size && height < size) {
		char cmdbuf[1024];
		
		free(bigimage);
		snprintf(cmdbuf, sizeof(cmdbuf), "/bin/cp -af '%s' '%s' 2>/dev/null", in_file, out_file);
		ret=system(cmdbuf);
		if(ret)
			return -1;
		return 0;
	}
	/* Returns a pointer to the resized image or NULL on error */
	outimage = resizepic(bigimage, palrgb, palrgb+256, palrgb+512,
						 width, height, size, opt_rsz_dim);
	xsiz = out_wide;
	ysiz = out_high;

	if(outimage == NULL) {
		if(bigimage)
			free(bigimage);
		return -1;
	}
	if ((xsiz < MINSIZE) && (ysiz < MINSIZE)) {
		;////	 fprintf(stderr, "thumbnail too small...\n");
	}

	free(palrgb);
	free(bigimage);
	
	if (! opt_flag_stdout) { 
		if (opt_flag_verbose) { 
			//printf("%s",imgfile);
			//if (opt_flag_verbose > 1)
			//	printf(" %dx%d",xsiz,ysiz);
			//printf("\n");
		}
		ret=write_JPEG_file(imgfile,xsiz,ysiz,opt_quality);
		free(outimage);
	}
	else { 
		ret=write_JPEG_file(NULL,xsiz,ysiz,opt_quality);
	}

	return ret;
}


unsigned char *resizepic(unsigned char *image, 
                         unsigned char *palr,
                         unsigned char *palg, 
                         unsigned char *palb,
                         int currwidth, int currheight,
                         int maxsize,
                         int resize_dim)
{
    register int   a, b, x, yp, yw;
             long  y, sw, sh, lastyp;
             int   c, pixwide, pixhigh;
    unsigned char *rline;
             int   tmp, tr, tg, tb, tn;
             int   xypos;

    if (!resize_dim) {    /* The resize dimension wasn't provided... */
        if (currwidth <= currheight) { /* Picture is square or portraity */
            resize_dim = RSZ_HEIGHT;

        } else {                       /* Picture is landscapey */
            resize_dim = RSZ_WIDTH;
        }
    }

        switch(resize_dim) {
            case RSZ_HEIGHT:
                sh = maxsize;
                sw = (int)( (maxsize * ((double)currwidth)) / 
                                       ((double)currheight) );
                break;
            case RSZ_WIDTH:
                sw = maxsize;
                sh = (int)( (maxsize * ((double)currheight)) / 
                                       ((double)currwidth) );
                break;
            default:
                /* WE SHOULD NEVER GET HERE! */
                sw = sh = 0;
                break;
        }
    
    /* This is a kludge. */
    if (sw == 0) sw += 1;
    if (sh == 0) sh += 1;

    out_wide = sw; 
    out_high = sh;
    
    /* Reserve the amount of memory we will need. */
    rline = calloc(1, sw * sh * 3);
    if (rline == NULL) {
        return NULL;
    }

    for (x=0; x < (sw*sh*3); x++) {
        rline[x] = GRAY;
    }

    if (currwidth > sw) {  /* It has been reduced. */
        lastyp  = -1;
        pixhigh = (int)( ((float)currheight) / ((float)sh) + 0.5 );
        pixwide = (int)( ((float)currwidth)  / ((float)sw) + 0.5 );
        pixhigh++;
        pixwide++;
        for(y=0; y < currheight; y++) {
            yp = (y * sh) / currheight;
            if (yp != lastyp) {
                yw = (y * currwidth);

                /* we try to resample a bit. get that pentium RSN :) */
                for (x=0; x < currwidth; x++,yw++) {
                    tr = 0;
                        tg = 0;
                        tb = 0;
                        tn = 0;
                    for (b=0; (b < pixhigh) && (y+b < currheight); b++) {
                        for (a=0; (a < pixwide) && (x+a < currwidth); a++) {
                            tmp = *(image+yw+a+b*currwidth);
                            tr  += palr[tmp];
                            tg  += palg[tmp];
                            tb  += palb[tmp];
                            tn++;
                        }
                    }

                    xypos = 3*(((x*sw)/currwidth)+yp*sw);
                    tr /= tn; 
                    tg /= tn;
                    tb /= tn;
                    rline[xypos]   = tr;
                    rline[xypos+1] = tg;
                    rline[xypos+2] = tb;
                }
                lastyp = yp;
            }
        }
    } else {     /* we just leave it the same size */

        out_wide = currwidth; 
        out_high = currheight; 
        for (y=0; y < currheight; y++) {
            for (x=0; x < currwidth; x++) {
                c = image[y*currwidth+x];
                rline[3*(y*currwidth+x)]   = palr[c];
                rline[3*(y*currwidth+x)+1] = palg[c];
                rline[3*(y*currwidth+x)+2] = palb[c];
            }
        }
    }

    return rline;
}

/* write_JPEG_file -- Writes the global image "outimage" to a file. */

int write_JPEG_file(char *filename, int outwidth, int outheight, int quality)
{
    struct jpeg_compress_struct cinfo;
    struct jpeg_error_mgr       jerr;
    FILE     *out;
    JSAMPROW row_pointer[1];    /* pointer to JSAMPLE row[s]          */
    int      row_stride;        /* physical row width in image buffer */

    /* Step 1: Allocate and initialize JPEG compression object. */

    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_compress(&cinfo);

    /* Step 2: Specify data destination. */

        if (filename) {
            out = fopen(filename,"wb");
            if (out == NULL) {
                //fprintf(stderr,"can't open %s\n",filename);
                return -1;
            }
        } else {
            out = stdout;
        }
    jpeg_stdio_dest(&cinfo,out);

    /* Step 3: set parameters for compression */

    cinfo.image_width      = outwidth;  /* image width and height, in pix */
    cinfo.image_height     = outheight;
    cinfo.input_components = 3;         /* # of color components per pix  */
    cinfo.in_color_space   = JCS_RGB;   /* colorspace of input image      */

    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo,quality,FALSE);

    /* Step 4: Start compressor */

    jpeg_start_compress(&cinfo,TRUE);

    /* Step 5: while (scan lines remain to be written) */

    row_stride = outwidth * 3;    /* JSAMPLEs per row in image_buffer */

    while (cinfo.next_scanline < cinfo.image_height) {
        row_pointer[0] = &outimage[cinfo.next_scanline*row_stride];
        jpeg_write_scanlines(&cinfo,row_pointer,1);
    }

    /* Step 6: Finish compression */

    jpeg_finish_compress(&cinfo);
    fclose(out);

    /* Step 7: release JPEG compression object */

    jpeg_destroy_compress(&cinfo);
	return 0;
}



struct my_error_mgr {
    struct jpeg_error_mgr pub;  /* "public" fields      */
    jmp_buf setjmp_buffer;      /* for return to caller */
};
typedef struct my_error_mgr * my_error_ptr;

static void my_error_exit(j_common_ptr cinfo)
{
    char buf[JMSG_LENGTH_MAX]={0};
	
    my_error_ptr myerr=(my_error_ptr) cinfo->err;
    (*cinfo->err->format_message)(cinfo,buf);
    longjmp(myerr->setjmp_buffer, 1);
}

unsigned char *read_JPEG_file(char *filename, unsigned char **palette)
{
    FILE *infile;
    struct jpeg_decompress_struct cinfo;
    struct my_error_mgr jerr;
    int row_stride;
    unsigned char *image;
    unsigned char *pal;
    int f;
    unsigned char *ptr;

    image = NULL;

    if (((*palette) = (unsigned char *)calloc(1,768))==NULL) {
        return NULL;
    }

    pal = *palette;
    if (NULL == (infile=fopen(filename,"rb"))) {
        return NULL;
    }

    cinfo.err = jpeg_std_error(&jerr.pub);
    jerr.pub.error_exit = my_error_exit;

    if (setjmp(jerr.setjmp_buffer)) {
        jpeg_destroy_decompress(&cinfo);
        fclose(infile);
        free(pal);
        return NULL;
    }

    /* Now we can initialize the JPEG decompression object. */
    jpeg_create_decompress(&cinfo);
    jpeg_stdio_src(&cinfo,infile);
    jpeg_read_header(&cinfo,TRUE);
    /* setup parameters for decompression */
    cinfo.dct_method=JDCT_ISLOW;
    cinfo.quantize_colors=TRUE;
    cinfo.desired_number_of_colors=256;
    cinfo.two_pass_quantize=TRUE;
    /* Fix to greys if greyscale. (required to read greyscale JPEGs) */
    if (cinfo.jpeg_color_space == JCS_GRAYSCALE) {

        cinfo.out_color_space = JCS_GRAYSCALE;
        cinfo.desired_number_of_colors = 256;
        cinfo.quantize_colors = FALSE;
        cinfo.two_pass_quantize = FALSE;

        for(f=0;f<256;f++) { 
            pal[f]=pal[256+f]=pal[512+f]=f;
        }
    }

    width = cinfo.image_width;
    height = cinfo.image_height;

	//printf("width: %d, height: %d\n", width, height);

    image = (unsigned char *)calloc(1,width*height);
    if (image==NULL) {
        //printf("Out of memory");
        longjmp(jerr.setjmp_buffer,1);
    }

    if (!jpeg_start_decompress(&cinfo)) {
        jpeg_destroy_decompress(&cinfo);
        fclose(infile);
        free(pal);
        return NULL;
	}
    /* read the palette (if greyscale, this has already been done) */
    if (cinfo.jpeg_color_space != JCS_GRAYSCALE) {

        for (f=0; f<cinfo.actual_number_of_colors; f++) {
            pal[    f]=cinfo.colormap[0][f];
            pal[256+f]=cinfo.colormap[1][f];
            pal[512+f]=cinfo.colormap[2][f];
        }
    }

    ptr = image; 
    row_stride = width;

    /* read the image */
    while (cinfo.output_scanline<height) {
        jpeg_read_scanlines(&cinfo, &ptr, 1);
        ptr += row_stride;
    }
    jpeg_finish_decompress(&cinfo);
    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
    return image;
}
#endif
//GIF APIs
int CreateGIFThumbFromFile(const char *in_file, const char *out_file, int maxsize) {
    int	i, iy, last_iy, l, t, w, h, ExtCode,
	ImageNum = 0,
	SizeFlag = FALSE,
	ScaleFlag = FALSE,
	XScaleFlag = FALSE,
	YScaleFlag = FALSE;
    double Scale, y;
    GifRecordType RecordType;
    GifByteType *Extension;
    GifRowType LineIn, LineOut;
    GifFileType *GifFileIn = NULL, *GifFileOut = NULL;

	SizeFlag = 1;
	XSize = THUMBNAIL_SIZE;
	YSize = THUMBNAIL_SIZE;
	ScaleFlag = 0;
	Scale = 0.0;
	XScaleFlag = 0;
	YScaleFlag = 0;

	if ((GifFileIn = DGifOpenFileName(in_file)) == NULL)
	    return(QuitGifError(GifFileIn, GifFileOut));

	XSize = (GifFileIn->SHeight > GifFileIn->SWidth) ? ( (float)GifFileIn->SWidth/GifFileIn->SHeight * maxsize) : maxsize;
	YSize = (GifFileIn->SWidth > GifFileIn->SHeight) ? ((float)GifFileIn->SHeight / GifFileIn->SWidth * maxsize) : maxsize;

	XScale = XSize / ((double) GifFileIn->SWidth);
	YScale = YSize / ((double) GifFileIn->SHeight);

    /* As at this time we know the Screen size of the input gif file, and as */
    /* all image(s) in file must be less/equal to it, we can allocate the    */
    /* scan lines for the input file, and output file. The number of lines   */
    /* to allocate for each is set by ScaleDown & XScale & YScale:	     */
    LineOut = (GifRowType) malloc(XSize * sizeof(GifPixelType));
    LineIn = (GifRowType) malloc(GifFileIn->SWidth * sizeof(GifPixelType));

	/* Open output file */
	if  ((GifFileOut = EGifOpenFileName(out_file, 0)) == NULL)
		return(QuitGifError(GifFileIn, GifFileOut));
    /* And dump out its new scaled screen information: */
    if (EGifPutScreenDesc(GifFileOut, XSize, YSize,
	GifFileIn->SColorResolution, GifFileIn->SBackGroundColor,
	GifFileIn->SColorMap) == GIF_ERROR)
		return(QuitGifError(GifFileIn, GifFileOut));

    /* Scan the content of the GIF file and load the image(s) in: */
    do {
		if (DGifGetRecordType(GifFileIn, &RecordType) == GIF_ERROR)
		    return(QuitGifError(GifFileIn, GifFileOut));
	
		switch (RecordType) {
		    case IMAGE_DESC_RECORD_TYPE:
			if (DGifGetImageDesc(GifFileIn) == GIF_ERROR)
			    return(QuitGifError(GifFileIn, GifFileOut));
			/* Put the image descriptor to out file: */
			l = (int) (GifFileIn->Image.Left * XScale + 0.5);
			w = (int) (GifFileIn->Image.Width * XScale + 0.5);
			t = (int) (GifFileIn->Image.Top * YScale + 0.5);
			h = (int) (GifFileIn->Image.Height * YScale + 0.5);
			if (l < 0) l = 0;
			if (t < 0) t = 0;
			if (l + w > XSize) w = XSize - l;
			if (t + h > YSize) h = YSize - t;
			/* If picture is too small,  than do not convert ,just copy it to thumbnail */
			if (GifFileIn->Image.Width < maxsize && GifFileIn->Image.Height < maxsize) {
				char cmdbuf[1024]={0};
				int ret=0;
		
			    if(strlen(in_file)+strlen(out_file)+64>=sizeof(cmdbuf))
			    	return -1;
				DGifCloseFile(GifFileIn);
				EGifCloseFile(GifFileOut);			    	
				sprintf(cmdbuf, "/bin/cp -af '%s' '%s' 2>/dev/null", in_file, out_file);
				ret=system(cmdbuf);
				if(ret)
					return -1;
				return 0;
			}	
			if (EGifPutImageDesc(GifFileOut, l, t, w, h,
			    GifFileIn->Image.Interlace,
			    GifFileIn->Image.ColorMap) == GIF_ERROR)
			    return(QuitGifError(GifFileIn, GifFileOut));
	
			if (GifFileIn->Image.Interlace) {
				return(QuitGifError(GifFileIn, GifFileOut));
			    GIF_EXIT("Cannt resize interlaced images - use GifInter first.");
			}
			else {
			    GifQprintf("\n%s: Image %d at (%d, %d) [%dx%d]:     ",
				PROGRAM_NAME, ++ImageNum,
				GifFileOut->Image.Left, GifFileOut->Image.Top,
				GifFileOut->Image.Width, GifFileOut->Image.Height);
	
			    for (i = GifFileIn->Image.Height, y = 0.0, last_iy = -1;
				 i-- > 0;
				 y += YScale) {
				if (DGifGetLine(GifFileIn, LineIn,
						GifFileIn->Image.Width) == GIF_ERROR)
				    return(QuitGifError(GifFileIn, GifFileOut));
	
				iy = (int) y;
				if (last_iy < iy && last_iy < YSize) {
				    ResizeLine(LineIn, LineOut,
					       GifFileIn->Image.Width, GifFileOut->Image.Width);
	
				    for (;
					 last_iy < iy && last_iy < GifFileOut->Image.Height - 1;
					 last_iy++) {
					GifQprintf("\b\b\b\b%-4d", last_iy + 1);
					if (EGifPutLine(GifFileOut, LineOut,
							GifFileOut->Image.Width) ==
									    GIF_ERROR)
					    return(QuitGifError(GifFileIn, GifFileOut));
				    }
				}
			    }
	
			    /* If scale is not dividable - dump last lines: */
			    while (++last_iy < GifFileOut->Image.Height) {
				GifQprintf("\b\b\b\b%-4d", last_iy);
				if (EGifPutLine(GifFileOut, LineOut,
						GifFileOut->Image.Width) == GIF_ERROR)
				    return(QuitGifError(GifFileIn, GifFileOut));
			    }
			}
			break;
		    case EXTENSION_RECORD_TYPE:
			/* Skip any extension blocks in file: */
			if (DGifGetExtension(GifFileIn, &ExtCode, &Extension) == GIF_ERROR)
			    return(QuitGifError(GifFileIn, GifFileOut));
			if (EGifPutExtension(GifFileOut, ExtCode, Extension[0],
								Extension) == GIF_ERROR)
			    return(QuitGifError(GifFileIn, GifFileOut));
	
			/* No support to more than one extension blocks, so discard: */
			while (Extension != NULL) {
			    if (DGifGetExtensionNext(GifFileIn, &Extension) == GIF_ERROR)
					return(QuitGifError(GifFileIn, GifFileOut));
			}
			break;
		    case TERMINATE_RECORD_TYPE:
			break;
		    default:		    /* Should be traps by DGifGetRecordType. */
			break;
		}
    }while (RecordType != TERMINATE_RECORD_TYPE);
    
    if (DGifCloseFile(GifFileIn) == GIF_ERROR)
		return(QuitGifError(GifFileIn, GifFileOut));
    if (EGifCloseFile(GifFileOut) == GIF_ERROR)
		return(QuitGifError(GifFileIn, GifFileOut));

    free(LineOut);
    free(LineIn);

    return 0;
}

/******************************************************************************
* Close both input and output file (if open), and exit.			      *
******************************************************************************/
static int QuitGifError(GifFileType *GifFileIn, GifFileType *GifFileOut)
{
    PrintGifError();
    if (GifFileIn != NULL)
    	DGifCloseFile(GifFileIn);
    if (GifFileOut != NULL) EGifCloseFile(GifFileOut);
		return(EXIT_FAILURE);
}
/******************************************************************************
* Line resizing routine - scale given lines as follows:			      *
* Scale (by pixel duplication/elimination) from InLineLen to OutLineLen.      *
******************************************************************************/
static void ResizeLine(GifRowType LineIn, GifRowType LineOut,
		      int InLineLen, int OutLineLen)
{
    int i, ix, last_ix;
    double x;

    OutLineLen--;

    for (i = InLineLen, x = 0.0, last_ix = -1; i-- > 0; x += XScale, LineIn++){
		ix = (int) x;
		for (; last_ix < ix && last_ix < OutLineLen; last_ix++)
			*LineOut++ = *LineIn;
    }

    /* Make sure the line is complete. */
    for (LineIn--; last_ix < OutLineLen; last_ix++)
		*LineOut++ = *LineIn;

}
//End
#if 0
int main(int argc, char *argv[])
{
	char thumb_path[256]={0};
	int ret=0;
	
	if(argc<2)
		return -1;
	sprintf(thumb_path, "THUMBNAIL_%s", argv[1]);
	
	ret=CreateThumb(argv[1], thumb_path);
	printf("ret=%d\n",ret);
	
	return ret;
}
#endif

