#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/hdreg.h>
#include <sys/fcntl.h>
#include <sys/types.h>
#include <string.h>
#include <stdarg.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#include "atacmds.h"
#include "ataprint.h"
#include "extern.h"
#include "knowndrives.h"
#include "scsicmds.h"
#include "scsiprint.h"
#include "smartctl.h"
#include "utility.h"

extern const char *atacmds_c_cvsid, *ataprint_c_cvsid, *knowndrives_c_cvsid, *scsicmds_c_cvsid, *scsiprint_c_cvsid, *utility_c_cvsid;

// This is a block containing all the "control variables".  We declare
// this globally in this file, and externally in other files.
smartmonctrl *con=NULL;
void pout(char *fmt, ...){
  va_list ap;
  
  // initialize variable argument list 
  va_start(ap,fmt);
  if (con->veryquietmode){
    va_end(ap);
    return;
  }

  // print out
  vprintf(fmt,ap);
  va_end(ap);
  fflush(stdout);
  return;
}

/*  void prints help information for command syntax */
void Usage1 (void){
  printf("Usage: changemode [options] device\n\n");
  printf("====SHOW INFORMATION OPTIONS =====\n\n");
#ifdef HAVE_GETOPT_LONG
  printf(
"  -h, -?, --help, --usage\n"
"         Display this help and exit\n\n"
"  -m VALUE, --mode VALUE\n"
"         VALUE: <UDMA_0|UDMA_1|UDMA_2|UDMA_3|UDMA_4|UDMA_5\n"
"                |UDMA_6|UDMA_7|PIO_0|PIO_1|PIO_2|PIO_3|PIO_4>\n"
"         Change XFER speed of the HDD.\n\n"
  );
#else
  printf(
"  -h, -?    Display this help and exit\n"
"  -V        Print version information\n"
"  -m <UDMA_0|UDMA_1|UDMA_2|UDMA_3|UDMA_4|UDMA_5\n"
"		|UDMA_6|UDMA_7|PIO_0|PIO_1|PIO_2|PIO_3|PIO_4>  The speed mode\n\n"
  );
#endif
}

unsigned char tryata=0,tryscsi=1;
unsigned char mode = 0;
char pMode[24]={0};
int smartcommandhandler(int device, smart_command_set command, int select, char *data);
#define MV_ATA_TRANSFER_UDMA_0                  0x40
#define MV_ATA_TRANSFER_UDMA_1                  0x41
#define MV_ATA_TRANSFER_UDMA_2                  0x42
#define MV_ATA_TRANSFER_UDMA_3                  0x43
#define MV_ATA_TRANSFER_UDMA_4                  0x44
#define MV_ATA_TRANSFER_UDMA_5                  0x45
#define MV_ATA_TRANSFER_UDMA_6                  0x46
#define MV_ATA_TRANSFER_UDMA_7                  0x47
#define MV_ATA_TRANSFER_PIO_SLOW                0x00
#define MV_ATA_TRANSFER_PIO_0                   0x08
#define MV_ATA_TRANSFER_PIO_1                   0x09
#define MV_ATA_TRANSFER_PIO_2                   0x0A
#define MV_ATA_TRANSFER_PIO_3                   0x0B
#define MV_ATA_TRANSFER_PIO_4                   0x0C
/*      Takes command options and sets features to be run */    
void ParseOpts1(int argc, char** argv){
  int optchar;
  int badarg;
  int captive;
  extern char *optarg;
  extern int optopt, optind, opterr;
  // Please update getvalidarglist() if you edit shortopts
  const char *shortopts = "h?V:m:";
#ifdef HAVE_GETOPT_LONG
//  char *arg;
  // Please update getvalidarglist() if you edit longopts
  struct option longopts[] = {
    { "help",            no_argument,       0, 'h' },
    { "usage",           no_argument,       0, 'h' },
    { "version",         no_argument,       0, 'V' },
    { "device",          required_argument, 0, 'd' },
    { "mode",          	 required_argument, 0, 'm' },
    { 0,                 0,                 0, 0   }
  };
#endif
  
  memset(con,0,sizeof(*con));
  con->testcase=-1;
  opterr=optopt=0;
  badarg = captive = FALSE;
  
  // This miserable construction is needed to get emacs to do proper indenting. Sorry!
  while (-1 != (optchar = 
#ifdef HAVE_GETOPT_LONG
        getopt_long(argc, argv, shortopts, longopts, NULL)
#else
        getopt(argc, argv, shortopts)
#endif
        )){
    switch (optchar){
    case 'm':
        if(strlen(optarg)<sizeof(pMode))
        	strcpy(pMode, optarg);
      break;
    case 'h':
    case '?':
    default:
      Usage1();
      exit(0);  
    } // closes switch statement to process command-line options
    }  
}

int ataSendSpeed(int device )
{ 
	if (smartcommandhandler(device, SEND_SPEED, mode, NULL)){
		syserror("Error Send speed command failed");
		return -1;
	}
	return 0;
}


/* Main Program */
int main (int argc, char **argv)
{
	int fd,retval=0;
	char *device;
	smartmonctrl control;
	int dev_type, flags;

	// define control block for external functions
	con=&control;
	
	if(argc<2){
		Usage1();	
		exit(-1);
	}
	// Part input arguments
	ParseOpts1(argc,argv);

	device = argv[argc-1];
	dev_type = guess_linux_device_type(device);
	if (GUESS_DEVTYPE_SCSI == dev_type) {
		flags = O_RDWR | O_NONBLOCK;
		tryscsi = 1;
	} else { /* treat "don't know" case as an ATA device as well */
		flags = O_RDONLY | O_NONBLOCK;
		tryata = 1;
	}
	// open device - SCSI devices are opened (O_RDWR | O_NONBLOCK) so the
	// scsi generci device can be used (needs write permission for MODE
	// SELECT command) plus O_NONBLOCK to stop open hanging if media not
	// present (e.g. with st).
	fd = open(device, flags);
	if (fd<0) {
	    char errmsg[256];
	    snprintf(errmsg,256,"Open device: %s failed",argv[argc-1]);
	    errmsg[255]='\0';
	    syserror(errmsg);
	    return FAILDEV;
	}
    
    con->ismvsata = 0;
    retval = scsiPrintMain(device, fd);
    if (con->ismvsata)
    {   
    	if(!strcmp(pMode, "UDMA_0"))
    		mode=MV_ATA_TRANSFER_UDMA_0;
    	else if(!strcmp(pMode, "UDMA_1"))
    		mode=MV_ATA_TRANSFER_UDMA_1;
    	else if(!strcmp(pMode, "UDMA_2"))
    		mode=MV_ATA_TRANSFER_UDMA_2;
    	else if(!strcmp(pMode, "UDMA_3"))
    		mode=MV_ATA_TRANSFER_UDMA_3;
    	else if(!strcmp(pMode, "UDMA_4"))
    		mode=MV_ATA_TRANSFER_UDMA_4;
    	else if(!strcmp(pMode, "UDMA_5"))
    		mode=MV_ATA_TRANSFER_UDMA_5;
    	else if(!strcmp(pMode, "UDMA_6"))
    		mode=MV_ATA_TRANSFER_UDMA_6; 
    	else if(!strcmp(pMode, "UDMA_7"))
    		mode=MV_ATA_TRANSFER_UDMA_7;   
    	else if(!strcmp(pMode, "PIO_0"))
    		mode=MV_ATA_TRANSFER_PIO_0; 
    	else if(!strcmp(pMode, "PIO_1"))
    		mode=MV_ATA_TRANSFER_PIO_1; 
    	else if(!strcmp(pMode, "PIO_2"))
    		mode=MV_ATA_TRANSFER_PIO_2; 
    	else if(!strcmp(pMode, "PIO_3"))
    		mode=MV_ATA_TRANSFER_PIO_3;  
     	else if(!strcmp(pMode, "PIO_4"))
    		mode=MV_ATA_TRANSFER_PIO_4; 
    	else {
        	Usage1();
        	return FAILCMD;
    	}
		if (ataSendSpeed(fd)) {
			printf("Change mode Failed.\n\n");
		}
		else
			printf("Speed change command was sent.\n");
    }
    else
    {
        Usage1();
        return FAILCMD;
    }

  return retval;
}

