# We need include diff.mk for we want to add some marco to CFLAGS
include $(TOPDIR)/diff.mk
#---------------------------------------------------
#                COMPILE OPTIONS
#---------------------------------------------------
# You should NOT use ':=' for we should not expand this variable until we use it.
#ECHO_CMD         =  @echo $@;
#CROSS_COMPILE   :=  xscale_be-
#CROSS_COMPILE   :=  arm-linux-
#CROSS_COMPILE   :=  arm-linux-gnueabi-
CROSS_COMPILE   :=  $(TOPDIR)/../arm-linux-gnueabi/bin/arm-linux-gnueabi-

CC               =  $(ECHO_CMD)$(CROSS_COMPILE)gcc
CPP             :=  $(CROSS_COMPILE)cpp
CXX             :=  $(CROSS_COMPILE)g++
CXXCPP            :=  $(CROSS_COMPILE)g++ -E
ifeq ($(CROSS_COMPILE), arm-linux-)
LD              :=  $(CROSS_COMPILE)ld -EB
else
LD              :=  $(CROSS_COMPILE)ld
endif
AS              :=  $(CROSS_COMPILE)as
AR              :=  $(CROSS_COMPILE)ar
STRIP           :=  $(CROSS_COMPILE)strip
RANLIB          :=  $(CROSS_COMPILE)ranlib
OBJCOPY         :=  $(CROSS_COMPILE)objcopy
OBJDUMP         :=  $(CROSS_COMPILE)objdump

export CC CPP CXX LD AS AR STRIP RANLIB OBJCOPY OBJDUMP

#---------------------------------------------------
# CFLAGS
#---------------------------------------------------

CFLAGS      :=
CFLAGS      +=      -D$(MODULE_NAME)
#---------------------------------------------------
# We should warning all messages
#---------------------------------------------------
CFLAGS		+=  -Wall

CFLAGS		+=      -Os    

#---------------------------------------------------
# Globe functinos define
#---------------------------------------------------
ifeq ($(NO_PRINTER), 1)
    CFLAGS  +=      -DNO_PRINTER
else
    ifeq ($(USB_PRINTER), 1)
        CFLAGS +=   -DUSB_PRINTER
    endif
    ifeq ($(PARELLEL_PRINTER), 1)
        CFLAGS +=   -DPARAELLEL_PRINTER
    endif
endif
ifeq ($(_QUOTA_), 1)
    CFLAGS  +=      -D_QUOTA_
endif
ifeq ($(_FTP_), 1)
    CFLAGS  +=      -D_FTP_
endif
ifeq ($(_SSL_SUPPORT_), 1)
    CFLAGS  +=      -D_SSL_SUPPORT_
endif
ifeq ($(_NTP_SUPPORT_), 1)
    CFLAGS  +=      -D_NTP_SUPPORT_
endif

ifeq ($(_DDNS_SUPPORT_), 1)
    CFLAGS  +=      -D_DDNS_
endif 

ifeq ($(_RECYCLE_BIN_SUPPORT_), 1)
    CFLAGS  +=      -D__RECYCLE_BIN__
endif

ifeq ($(_WEB_STATION_SUPPORT_), 1)
    CFLAGS +=      -D__WEB_STATION__
endif

ifeq ($(_FTP_BACKUP_SUPPORT_), 1)
    CFLAGS  +=      -D__FTP_BACKUP__
endif

ifeq ($(_USB_COPY_SUPPORT_), 1)
    CFLAGS  +=      -D__USB_COPY__
endif

CFLAGS += -D__USE_UNICODE__ -D_FTPS_ 

ifeq ($(MODULE_NAME), NR65S)
	CFLAGS += -D_LIST_ALL_PUBLIC_SH_
	CFLAGS += -D__HTTP_ACCESS_CONTROL__
	ifeq ($(VENDOR_NAME), LEVEL_ONE)
		CFLAGS += -D__MULTIPLE_LANGUAGE__
	endif
	CFLAGS+=-D__SELECT_FOLDER_FOR_SHARE__
else
	_TWO_BAY_HDD_   		:=      0
	ifeq ($(VENDOR_NAME), neutral)
#		CFLAGS += -D_LIST_ALL_PUBLIC_SH_
#		CFLAGS += -D__HTTP_ACCESS_CONTROL__
		CFLAGS+=-D__SELECT_FOLDER_FOR_SHARE__
	endif	
endif


CFLAGS +=-D_LEVELONE_
CFLAGS +=-D_LOG_DOWN_TASK_

ifeq ($(_FLASH_32M_SUPPORT_), 1)
	CFLAGS  +=      -D__FLASH_32M__
else
	ifeq ($(_FLASH_16M_SUPPORT_), 1)
	    CFLAGS  +=      -D__FLASH_16M__
	endif
endif

ifeq ($(USE_EXT2), 1)
    CFLAGS  +=      -D__EXT2_FILESYSTEM__
endif

ifeq ($(_AFP_SUPPORT_), 1)
    CFLAGS  +=      -D_AFP_SUPPORT_
endif

ifeq ($(_PHOTO_ALBUM_SUPPORT_), 1)
    CFLAGS  +=      -D_PHOTO_ALBUM_
endif

ifeq ($(_SSH_SERVER_SUPPORT_), 1)
    CFLAGS  +=      -D_SSH_SERVER_
endif

#---------------------------------------------------
# We use this flags to build depence files which extend filename is ".d"
#---------------------------------------------------
CFLAGS          +=  -MD

CFLAGS          +=  -DEMBED #-O2

#---------------------------------------------------
#                KERNEL PATH
#---------------------------------------------------
K_PATH          := $(TOPDIR)/../linux-2.6.12
K_INC_PATH      := $(K_PATH)/include

#---------------------------------------------------
#                COMMON PATH
#---------------------------------------------------
COMM_LIB_PATH   := $(TOPDIR)/library/lib
COMM_INC_PATH   := $(TOPDIR)/include

#---------------------------------------------------
#                TARGET PATH
#---------------------------------------------------

# RAMDISK path
RAMDISK_DIR     :=  $(TOPDIR)/../ramdisk

# Target path
T_SBIN          := $(RAMDISK_DIR)/sbin
T_BIN           := $(RAMDISK_DIR)/bin
T_USR           := $(RAMDISK_DIR)/usr
T_USBIN         := $(RAMDISK_DIR)/usr/sbin
T_UBIN          := $(RAMDISK_DIR)/usr/bin


T_ETC           := $(RAMDISK_DIR)/etc.default
T_HOME          := $(RAMDISK_DIR)/home

T_LIB           := $(RAMDISK_DIR)/lib

T_SHARE         := $(RAMDISK_DIR)/share
T_ULIB		:= $(RAMDISK_DIR)/usr/lib

