#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <errno.h>
#include "util.h"

int GetLineFromFile(char **lbuf,FILE *fp)
{
	int	c,sz=128;
	char	*p,*buf;
	buf=(char *) malloc(sz);
	if(!buf){
	    *lbuf=NULL;
	    return 1;
	}    
	p=buf;
	while ((c=fgetc(fp)) != '\n' && c!=EOF) {
		if (p-buf ==sz-2) {
			buf=(char *) realloc(buf, sz*2);
			if(!buf){
				*lbuf=NULL;
				return 1;
			}    
			p=buf+sz-2;
			sz*=2;
		}
		*p++=c;
	}
	if(c=='\n')
	     *p++=c;
	if (c==EOF &&p==buf) {
		free(buf);
		*lbuf=NULL;
		return 1;
	}
	*p++='\0';
	*lbuf = buf;
	return 0;
}
#define MAX_KEY_LEN   64
#define MAX_SECTION_LEN 64

int FSH_GetStr(char *sect, char *key, char *val, int size, FILE* fp)
{
	char *buf;
	char item[MAX_KEY_LEN+2],section[MAX_SECTION_LEN+3];
	int find_sect=0,len=0,len1=0;

	if (val==NULL || fp==NULL || key==NULL)
		return -1;
	if(sect!=NULL){
		if(sect[0]!='['||sect[strlen(sect)-1]!=']')	
			sprintf(section,"[%s]",sect);
		else
			strcpy(section,sect);
		rewind(fp);
		len=strlen(section);
		while(!GetLineFromFile(&buf,fp)){
			if(!strncmp(buf,section,len)){
				find_sect=1;
				free(buf);
				break;
			}
			free(buf);
		} 
	}
	else
		find_sect=0;
	if(!find_sect)
		rewind(fp);
	sprintf(item,"%s=",key);
	len=strlen(item);
	while(!GetLineFromFile(&buf,fp)){
		if(buf[0]=='['){
			free(buf);
			break; // end of section
		}
		if(!strncasecmp(buf,item,len)){
			len1=strlen(buf);
			len1--;
			while(buf[len1]==0x0d || buf[len1]==0x0a)
				buf[len1--]='\0';
			if (strlen(buf+len)>size)
				buf[len+size]=0;
			strcpy(val,buf+len);
			free(buf);
			return 0;
		}
		free(buf);
	}
	return -1;
}

#define	FSH_SHARE_CONF	"/etc/share.info"
#define	FSH_WIN_SHARE_CONF	"/etc/win_share.info"
#define MAX_LEN   312
int PRO_2sect(char *sect, FILE *fp)
{
   char buf[MAX_LEN],sec[MAX_KEY_LEN],*p;
   int  ln;

   p = strstr(sect,"\n");
   if (p)
      *p = 0;
   if (sect[0] != '[')
   {
      sprintf(sec,"[%s]",sect);
      p = sec;
   }
   else
      p = sect;
   rewind(fp);
   ln = strlen(p);
   while(fgets(buf,sizeof(buf),fp))
   {
      if (buf[0] != '[')
         continue;
      if (strncmp(buf,p,ln)==0)
         return 0;
   }
   return 1;
}

int PRO_GetStrLen(char *sect, char *key, FILE* fp)
{
   char buf[MAX_LEN];      /* a line read from ini file */
   char k[MAX_KEY_LEN];  /*  key=...  */
   int n,i,c;

   if (fp==NULL || key==NULL)
      return -1;

   if (sect) {
      if (PRO_2sect(sect,fp) != 0) // section not found
         return -1;
   } else
      rewind(fp);

   sprintf(k,"%s=",key);
   n=strlen(k);
   while(fgets(buf,n+1,fp)) //only read n bytes
   {
      if (strcasecmp(buf,k)==0) { //find the key
         i=0;
         c=fgetc(fp);
         while(c!='\n'&&c!=EOF)
         {
         	i++;
         	c=fgetc(fp);         
         }
         return i;
      }
      if (buf[0]=='[')
         break;  /* end of the exact section */
      if (strlen(buf)==n && buf[n-1]!='\n')
         while(fgetc(fp)!='\n');     //read the rest of this line
   } //while
   return 0;
}

int GetShareInfo(sh_info * pSh)
{
	char *buf=NULL, *p, *q,*share_file=NULL;
	FILE *fh;
	int len,ret=-1,win_share=0;

	if(!pSh)
		return(-1);
	if(access(FSH_WIN_SHARE_CONF, F_OK))
		creat(FSH_WIN_SHARE_CONF,0644);	
	share_file=FSH_SHARE_CONF;
next:	
	fh = fopen (share_file, "r");
	if (!fh){
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}
		return -1;
	}
	len = PRO_GetStrLen (NULL, pSh->name, fh);
	if (len <= 0){
		fclose (fh);
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}		
		goto err;
	}
	len = len + 1;
	buf = (char *) malloc (len);
	if (!buf){
		fclose (fh);
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}		
		ret=-1;
		goto err;
	}
	memset (buf, 0, len);
	FSH_GetStr(NULL, pSh->name, buf, len, fh);
	fclose (fh);
	if (!buf){
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}	
		goto err;
	}
	q = buf;
	p = strchr (q, ':');
	if (!p || p[1] == '\n' || p[1] == '\r'){
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}	
		goto err;
	}
	*p = 0;
	pSh->conflict = atoi (q);
	q = p + 1;
	p = strchr (q, ':');
	if (!p || p[1] == '\n' || p[1] == '\r'){
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}	
		goto err;
	}
	*p = 0;
	pSh->hard_index = atoi (q);
	q = p + 1;
	p = strchr (q, ':');
	if (!p || p[1] == '\n' || p[1] == '\r'){
		if(!win_share){
			share_file=FSH_WIN_SHARE_CONF;
			win_share=1;
			goto next;
		}	
		goto err;
	}
	*p = 0;
	strcpy (pSh->comment, q);
	q = p + 1;
	p = strchr (q, ':');
	if (p)
		*p = 0;
	strcpy (pSh->dir, q);
	free (buf);

	return 0;
err:
	if(buf)
		free(buf);
	return ret;
}
