/* author: kylin 
* e-mail: kylin_kang@sdc.sercomm.com 
* gddemo.c
* Tue Jul 10 11:08:05 2007
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "gd.h"
#include "gdfontt.h"
#include "gdfonts.h"
#include "gdfontmb.h"
#include "gdfontl.h"
#include "gdfontg.h"

#define TYPE_GIF 1
#define TYPE_JPEG 2
#define TYPE_PNG 3

int get_file_type (const char *file_name); 

int 
main (int argc, char **argv)
{
	int ret;
	int maxsize;

	if (argc < 3) {
		printf("Usage: %s <source image> <dest image> [maxsize] \n", argv[0]);
		exit(1);
	}
	
	if (argc == 4)
		maxsize = atoi(argv[3]);
	else
		maxsize = 30;

	printf("source_image: %s\n, dest_image: %s\n, maxsize: %d\n", argv[0], argv[1], argv[2]);

	ret = create_thumb (argv[1], argv[2], maxsize, get_file_type(argv[1]));

	printf("ret: %d\n", ret);
	
	exit(0);
}

int
create_thumb (const char *in_file, const char *out_file, int maxsize, int type)
{
	/* Input and output files */
	FILE *in;
	FILE *out;
	int old_x, old_y;
	int thumb_w, thumb_h;
	/* Input and output images */
	gdImagePtr im_in = 0, im_out = 0;

	/* Try to load demoin.png and paste it to the output imae */
	in = fopen(in_file, "rb");
	if (!in) {
		printf("Can't load source image;\n");
		exit(1);
	} 

	switch (type) {
		case TYPE_GIF:
			printf("gif image\n");
			im_in = gdImageCreateFromGif (in);
			break;
		case TYPE_JPEG:
			printf("jpeg image\n");
			im_in = gdImageCreateFromJpeg (in);
			break;
		case TYPE_PNG:
			printf("png image\n");
			im_in = gdImageCreateFromPng (in);
			break;
		default: 
			printf("unknown image\n");
			return -1;
	}

	fclose (in);
	printf("in file: X: %d Y: %d\n", gdImageSX(im_in), gdImageSY(im_in));

	old_x = gdImageSX(im_in);
	old_y = gdImageSY(im_in);
	if (old_x < maxsize && old_y < maxsize) {
		thumb_w = old_x;
		thumb_h = old_y;
	} else {
		thumb_w = (old_y > old_x) ? (old_x/old_y*maxsize) : maxsize;
		thumb_h = (old_x > old_y) ? ((float)old_y/old_x*maxsize) : maxsize;
	}
	printf("out file: X: %d Y: %d\n", thumb_w, thumb_h);

	/* Create output image, in true color */
	im_out = gdImageCreateTrueColor (thumb_w, thumb_h);

	/* Now copy, and magnify as we do so */
	gdImageCopyResampled (im_out, im_in, 0, 0, 0, 0, thumb_w, thumb_h, old_x, old_y); 

	out = fopen(out_file, "wb");
	switch (type) {
		case TYPE_GIF:
			gdImageGif(im_out, out);
			break;
		case TYPE_JPEG:
			gdImageJpeg(im_out, out, 90);
			break;
		case TYPE_PNG:
			gdImagePng(im_out, out);
			break;
		default:
			return -1;
	}
	fclose (out);
	gdImageDestroy (im_out);
	if (im_in)
		gdImageDestroy (im_in);
	
	exit(0);
}



int 
get_file_type (const char *file_name) {
	int type = 0;

	if (!strcasecmp(".jpg",&file_name[strlen(file_name)-4]))
		type = TYPE_JPEG;
	else if (!strcasecmp(".png",&file_name[strlen(file_name)-4]))
		type = TYPE_PNG;
	else if (!strcasecmp(".gif",&file_name[strlen(file_name)-4]))
		type = TYPE_GIF;
	else
		type = 0;

	return type;
}

/*
 *
			if (!strcmp(file_type, "file") && 
					( !strcasecmp(".jpg",&file_name[strlen(file_name)-4]) || 
					  !strcasecmp(".png",&file_name[strlen(file_name)-4]) ||
					  !strcasecmp(".gif",&file_name[strlen(file_name)-4])) )
 */
