#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <syslog.h>
#include <unistd.h>
#include "parser.h"
#include "cgi-lib.h"
#include "html-lib.h"
#include "PRO_file.h"
#include "cgi_err.h"

//extern process_tab     ProcTab[];
//extern int  ProcNum;
#define LineLength      256
static keyfun_tab *KeyFunTab = NULL;
static arrayfun_tab *ArrayFunTab = NULL;

    
//---------------------------------------------------------------
// purpose: get get function index by key
// input: key  - function key
//---------------------------------------------------------------
int GetArrayFunIndex(char *key) 
{
    int i;
    if (ArrayFunTab == NULL)
	return -1;
    for (i = 0; ArrayFunTab[i].key; i++) {
	if (strcmp(key, ArrayFunTab[i].key) == 0)
	    return (i);
    }				/* endfor */
    return (-1);
}


//-----------------------------------------------------
// purpose: get array variable items
// input: name - variable name
// output: *buf - variable items
//         *msg - error index
//         err_sec - error message section name
// return: 0 - successful
// Note: caller must free the buffer buf
//-----------------------------------------------------
int GetArrayItem(char *name, char **buf, int *msg_idx, char err_sec[128]) 
{
    int i, ccode;
    i = GetArrayFunIndex(name);
    if (i >= 0) {
	ccode = (*ArrayFunTab[i].fun) (buf, msg_idx, err_sec);
	return (ccode);
    }
    *buf = 0;
    return (0);
}


//---------------------------------------------------------------
// purpose: get get function index by key
// input: key  - function key
//---------------------------------------------------------------
int GetKeyFunIndex(char *key) 
{
    int i;
    for (i = 0; KeyFunTab[i].key; i++) {
	if (strcmp(key, KeyFunTab[i].key) == 0)
	    return (i);
    }				/* endfor */
    return (-1);
}
int html_parser(char *fname, keyfun_tab * funtab, arrayfun_tab * arytab,
		  char *msg, LIST * head) 
{
    FILE * fh;
    char tmp[LineLength], tmp0[LineLength];
    char msg1[1][128] = { {0} };
    char *newstr, *val;
    char token1 = '/', token2 = '@', token3 = '#';
    char err_sec[128];
    unsigned int len = 0, len0;
    int i = 0, update = 0, ch,prev_ch=-1;
    int find1 = 0, ccode = 0, msg_idx = 0;
    memset(&msg1, 0, sizeof(msg1));
    fh = fopen(fname, "rt");
    if (fh == NULL) {
	PRO_GetMsgByIndex(COMMON_ERR, FileNotFoundErr, 1, msg1,
			   ERRMSG_FILE);
	cgi_err(msg1[0], "");
	return (1);
    }
    KeyFunTab = funtab;
    ArrayFunTab = arytab;

   if(strstr(fname,".xml"))
   	{
   		fprintf(stdout, "Cache-Control: max-age=0\r\n");
    	mime_header("text/xml");    	
    }
   else
   	{
    	if(strstr(fname,"home.htm"))
    		fprintf(stdout, "Cache-Control: max-age=0\r\n");
    	
    mime_header("text/html");
    }
          
    while ((ch = fgetc(fh)) != EOF) {
	newstr = 0;
	ccode = 0;
	if (!find1) {
	    switch (ch) {
	    case '/':
		ch = fgetc(fh);
		if (ch != token1) {
		    fputc(token1, stdout);
		    if (ch == EOF)
			goto exit_1;
		    fputc(ch, stdout);
		}
		
		else {		//find "//"
		    ch = fgetc(fh);
		    if (ch == token2) {	//fine "//@" array function token
			memset(tmp, 0, sizeof(tmp));
			len = 0;
			while ((ch = fgetc(fh)) != EOF) {
			    if (ch == token3)
				break;
			    tmp[len++] = ch;
			    if (len >= (LineLength - 1))	//exceed buffer size ignore it
				break;
			}
			if (ch == token3) {
			    tmp[len] = 0;
			    len0 = 0;
			    ccode =
				GetArrayItem(tmp, &newstr, &msg_idx,
					     err_sec);
			    if (ccode) {
				if (!msg || !msg[0])
				    PRO_GetMsgByIndex(err_sec, msg_idx, 1,
						       msg1, ERRMSG_FILE);
				goto xx;	//no items just continue
			    }
			    if (newstr)
				len0 = strlen(newstr);
			    fwrite(newstr, sizeof(char), len0, stdout);
			}
			
			else {	//EOF or exceed buffer size
			    tmp[len++] = token3;
			    fwrite("//@", sizeof(char), 3, stdout);
			    fwrite(tmp, sizeof(char), len, stdout);
			} if (newstr) {
			    free(newstr);
			    newstr = 0;
			}
		    }
		    
		    else {	//ch!=token2
			fwrite("//", sizeof(char), 2, stdout);
			fputc(ch, stdout);
		    } goto xx;
		}
		break;
	    case '@':		//@
				if(prev_ch<0x7F){
		memset(tmp, 0, sizeof(tmp));
		tmp[0] = ch;
		len = 1;
		find1 = 1;
		break;
				}
	    default:
		fputc(ch, stdout);
		break;
	    }
	xx:
			prev_ch=ch;
			continue;
	}
	else {			//find1
	    if (len >= (LineLength - 1)) {
		ccode = HtmlStrTooLarge;
		msg_idx = HtmlStrTooLarge;
		goto exit_0;
	    }
	    tmp[len++] = ch;
	    while (ch != token3) {
		ch = fgetc(fh);
		if (ch == EOF)
		    break;
		tmp[len++] = ch;
		if (len >= (LineLength - 1))	//exceed buffer size ignore it
		    break;
	    }
	    if (ch == token3) {
		len--;
		tmp[len] = 0;
		newstr = 0;
		tmp0[0] = 0;
		len0 = 0;
		if (strcmp(tmp + 1, "message") == 0) {	//error message
		    if (msg && msg[0])
			fwrite(msg, sizeof(char), strlen(msg), stdout);
		    
		    else if (msg1[0][0])
			fwrite(msg1[0], sizeof(char), strlen(msg1[0]),
				stdout);
		    goto ss;
		}
		val = find_val(head, tmp + 1);
		if (val) {	// is hidden variable
		    if (!update)
			i = GetKeyFunIndex(tmp + 1);
		    
		    else
			i = -1;
		}
		
		else
		    i = GetKeyFunIndex(tmp + 1);
		if (i < 0) {
		  ignore:if (head)
			val = find_val(head, tmp + 1);
		    
		    else
			val = 0;
		    if (!val)
			goto con0;
		    strcpy(tmp0, val);	//send back the val client post
		    goto ss;
		}
		if (KeyFunTab[i].getfun == NULL)
		    goto ignore;
		ccode =
		    (*(KeyFunTab[i].getfun)) (tmp0, &newstr, &msg_idx,
					      err_sec);
		if (ccode) {
		    if (!msg || !msg[0])
			PRO_GetMsgByIndex(err_sec, msg_idx, 1, msg1,
					   ERRMSG_FILE);
		    goto con0;
		}
	      ss:if (newstr)
		    len0 = strlen(newstr);
		
		else
		    len0 = strlen(tmp0);
		if (newstr)
		    fwrite(newstr, sizeof(char), len0, stdout);
		
		else
		    fwrite(tmp0, sizeof(char), len0, stdout);
	    }
	    
	    else {		//EOF or exceed buffer size
		fwrite(tmp, sizeof(char), len, stdout);
		if (ch == EOF)
		    goto exit_1;
	    }
	  con0:if (newstr) {
		free(newstr);
		newstr = 0;
	    }
	    find1 = 0;
	}			//else !find1
    }
    goto exit_1;
  exit_0:strcpy(err_sec, COMMON_ERR);
  exit_1:if (ccode) {
	PRO_GetMsgByIndex(err_sec, msg_idx, 1, msg1, ERRMSG_FILE);
	cgi_err(msg1[0], "");
    }
    if (newstr)
	free(newstr);
    fclose(fh);
    return (ccode);
}


