#ifndef __VOLUME_H__
#define __VOLUME_H__

#if 1
#define DSK_1_NAME	"/dev/sda" // IDE0 master
#define DSK_2_NAME	"/dev/sdb" // IDE0 master
#define DSK_3_NAME	"/dev/sdc" // IDE0 master
#define DSK_4_NAME	"/dev/sdd" // IDE0 master
#else
#define DSK_1_NAME	"/dev/hda" // IDE0 master
#define DSK_2_NAME	"/dev/hdc" // IDE0 master
#define DSK_3_NAME	"/dev/hdb" // IDE0 master
#define DSK_4_NAME	"/dev/hdd" // IDE0 master
#endif

#define DSK_1		0 // 
#define DSK_2		1 //
#define DSK_3		2 //
#define DSK_4		3 //

#define DSK_USB_	2 // USB HDD
#define DSK_FLASH	3 // Flash Disk

#define	DSK_VOL		4	//LVM or RAID 0 or RAID 1


#define	MD_DEV		"/dev/md"
#define	MD_CONF		"/etc/mdadm.conf"
#define DS_CONF_F	"/etc/CGI_ds.conf"
#define	DEV_RAID	"/dev/md0"
#define	DEV_LVM		"/dev/LVM/lv0"
#define	VG_NAME		"LVM"
#define	LV_NAME		"lv0"

#define	DEV_RAID_1	"/dev/md1"
#define	DEV_LVM_1	"/dev/LVM1/lv1"
#define	VG_NAME_1	"LVM1"
#define	LV_NAME_1	"lv1"

#define	ADD_DISK1_RAID1_FLAG	"/var/raid1_add_disk1"
#define	ADD_DISK2_RAID1_FLAG	"/var/raid1_add_disk2"

#define	VOL_STATUS			"/etc/status.volume"
#define	DISK_SN				"/etc/sn_%s"  
#define	ADD_LVM_FLAG		"/tmp/add_lvm"  
#define	MD_STATUS_TMP_FILE	"/tmp/raid.status"
#define	LVM_STATUS_TMP_FILE	"/tmp/lvm.status"
#define	PROC_MDSTAT			"/proc/mdstat"
#define	MODE_STANDALONE	1
#define	MODE_LVM		2
#define	MODE_RAID0		3
#define	MODE_RAID1		4

//Error Code
#define	MODE_CHANGE_FAIL	1	//Error: Fail to change disk mode.
#define	ERR_DISK_BUSY		2	//Error: Disk is busy, cannot change disk mode. 
#define	MODE_TO_SINGLE		3	//Disk mode is changed to Single Disk.
#define	MODE_TO_LVM			4	//Disk mode is changed to LVM.
#define	MODE_TO_RAID0		5	//Disk mode is changed to RAID 0
#define	MODE_TO_RAID1		6	//Disk mode is changed to RAID 1.

#define	NO_DISK1_FOR_RAID0		7	//Error: Disk 1 doesn't exist, cannot change to RAID 0 mode.
#define	NO_DISK2_FOR_RAID0		8	//Error: Disk 2 doesn't exist, cannot change to RAID 0 mode.
#define	NO_DISK1_FOR_RAID1		9	//Error: Disk 1 doesn't exist, cannot change to RAID 1 mode.
#define	NO_DISK2_FOR_RAID1		10	//Error: Disk 2 doesn't exist, cannot change to RAID 1 mode.

#define	DISK1_PART_ERR			11	//Error: Fail to partition Disk 1, cannot change disk mode. 
#define	DISK2_PART_ERR			12	//Error: Fail to partition Disk 2, cannot change disk mode. 
#define	MODE_RESET_FAIL			13	//Error: Fail to reset disk mode. 
#define	CREATE_LVM_DEV_ERR		14	//Error: Fail to create LVM device, cannot change disk mode. 
#define	CREATE_RAID0_DEV_ERR	15	//Error: Fail to create RAID 0 device, cannot change disk mode. 
#define	CREATE_RAID1_DEV_ERR	16	//Error: Fail to create RAID 1 device, cannot change disk mode. 
#define	MODE_SETTING_ERR		17	//Error: Fail to save settings of disk mode.
#define	ADD_DISK1_TO_RAID1		18	//Error: Add Disk 1 into RAID 1.
#define	ADD_DISK2_TO_RAID1		19	//Error: Add Disk 2 into RAID 1.
#define	ADD_DISK1_TO_LVM		20	//Error: Add Disk 1 into LVM.
#define	ADD_DISK2_TO_LVM		21	//Error: Add Disk 2 into LVM.
#define	LVM_RESET_OK			22	//Logic Volume has been resetted successfully.
#define	NO_DISK_FOR_LVM			23	//Error: No disk exist, cannot change to LVM mode.
#define	NEED_REMOVE_INTERNAL_DISK			24	//Please remove the internal disks first.

/*
[harddisk]
disk_mode=  //1-Standalone, 2-LVM, 3-RAID 0, 4-RAID 1
raid_status=
*/

typedef struct vol_status{
	int vol_st;//0-Clean, 1-Rebuilding, 2-Degraded, 3-Failed
	int vol_fault;
	int rebuid_source; //1-Disk 1, 2-Disk 2
	char recover_percent[16];
}VOLUME_STATUS;

int GetDiskMode(void);
int SaveDiskMode(int mode);
int VOL_UnmountVol(int old_one, int web);
int VOL_StopSWAP(int old_one);
int DelRAID();
int DelLVM();
int StopMode(int old_one, int web);
int StopLVM();
int StopMDDev();
int VOL_Partion(int mode, int disk_no);
int UpdateMDConf(char *pDev, char *pArray, int del);//del: 1-Just delete it. 0-Update it.
int CreateMDConf(void);
int CreateLVMDev();
int CreateMDDev(int mode);
int ChangeDiskMode(int old_one, int new_one, int web);
int IsRAIDDisk(char *disk_name);
int IsLVMDisk(char *disk_name);
int RecordDiskSN(int disk_num);
void RecordAllDiskSN(void);
void SetupVolumes(void);
int AddLVMDisk(int disk_no);
int GetMDStatus(VOLUME_STATUS *pVolSt);
int IsRebuilding(void);
int GetRemovedDisk(int md_no);
int AddRAIDDisk(void);
void StartProcess(int web);
void StopProcess(int web);
int CheckLVMDisks(void);
int CheckRAID0Disks(void);
int CheckRAID1Disks(void);
int NoDiskSN(void);
void RestoreVolSettings(void);
#endif

