#ifndef _USER_DISK_QUOTA_H_
#define _USER_DISK_QUOTA_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <crypt.h>
#include <unistd.h>
#include <pwd.h>
#include <time.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/quota.h>
#include <linux/xqm.h>
#include <mntent.h>
#include <linux/unistd.h>
#include <constant.h>

#define BIG_UINT  unsigned long long

typedef struct _LINUX_DISK_QUOTA {
	BIG_UINT bsize;
	BIG_UINT hardlimit; /* In bsize units. */
	BIG_UINT softlimit; /* In bsize units. */
	BIG_UINT curblocks; /* In bsize units. */
	BIG_UINT ihardlimit; /* inode hard limit. */
	BIG_UINT isoftlimit; /* inode soft limit. */
	BIG_UINT curinodes; /* Current used inodes. */
} LINUX_DISK_QUOTA;

typedef struct mem_dqblk {
        __u32 dqb_bhardlimit;   /* absolute limit on disk blks alloc */
        __u32 dqb_bsoftlimit;   /* preferred limit on disk blks */
        qsize_t dqb_curspace;   /* current used space */
        __u32 dqb_ihardlimit;   /* absolute limit on allocated inodes */
        __u32 dqb_isoftlimit;   /* preferred inode limit */
        __u32 dqb_curinodes;    /* current # allocated inodes */
        time_t dqb_btime;       /* time limit for excessive disk use */
        time_t dqb_itime;       /* time limit for excessive inode use */
} mem_dqblk;

#define ZERO_STRUCT(x) memset((char*)&(x),0,sizeof(x))
int usr_disk_quotas(char *pDev, int uid,BIG_UINT *bsize,BIG_UINT *dused, BIG_UINT *dsize);
unsigned long long UserFreeSpace(char *pUser, char *pDev);

#endif
