#ifndef _SYSTEM_H_
#define _SYSTEM_H_
#include "constant.h"

#define 	SERVERNAME_LEN     	FSH_MaxSererNameLen
#define 	SERVERCOMMENT_LEN  	48
#define 	VERSION_LEN	   		12
#define 	HARDWARE_ID_LEN    	32
#define 	HARDWARE_ADD_LEN  	24
#define 	IPADDRESS	   		15
#define 	SYS_TIME_LEN	   	5	// 00:00 length
#define 	AMPM_LEN	   		2	// am/pm length

#define SYS_OK                      0
#define OPENFILEERR          	1	//Fail to open file
#define PROFILEGETERROR       	2	//Fail to get value from config ile
#define PROFILESETERROR        	3	//Fail to set value to config file
#define COMMANDRUNERR         	4	//Fail to run command
#define CHECKENTRYERROR      	5	//Input data error
#define WRITECRONTABERR       	6	//Fail to write /etc/crontab

typedef struct sys_time {
    int t_timezone;
    int sys_month;
    int sys_day;
    int sys_year;
    int sys_hour;
    int sys_min;
    char sys_ampm[AMPM_LEN + 1];
} sys_time;			//system time structure

typedef struct sys_info {
    char server_name[SERVERNAME_LEN + 1];
    char server_comment[SERVERCOMMENT_LEN + 1];
    char server_default_name[SERVERNAME_LEN + 1];
    char ds_sw_version[VERSION_LEN + 1];
    char ds_hardware_id[HARDWARE_ID_LEN + 1];
    char ds_hardware_address[HARDWARE_ADD_LEN + 1];
    char ds_ipaddress[IPADDRESS + 1];
} sys_info;

typedef struct log_ser_info {
    char log_ser_en[5];
    char log_ser_ip[IPADDRESS + 1];
} log_ser_info;

typedef struct sys_schedule {
    int weekday_action;
    char weekday_time[SYS_TIME_LEN + 1];
    int satday_action;
    char satday_time[SYS_TIME_LEN + 1];
    int sunday_action;
    char sunday_time[SYS_TIME_LEN + 1];
} sys_schedule;

typedef struct shutdown_schl {
    int action;			// shutdown/reboot
    int date;			//0-None, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday,
    //6-Saturday, 7-Sunday, 8-weekdays
    int hour;			//24 hour
    int minute;
} shutdown_schl;

typedef struct sys_setup {
    int delay_action;		//2,1,0  shutdown/reboot/none
    int delay;			//delay minutes: Type, integer
} sys_setup;			//system shutdown(reboot) structure

#ifdef __RECYCLE_BIN__
typedef struct recycle_schl {
    int enable;			// 0-Disabled, 1-Enabled
    int date;			//0-EveryDay, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 6-Saturday, 7-Sunday, 8-Weekdays
    int hour;			//24 hour
    int minute;
} recycle_schl;

int ReadRecycleBinConf(recycle_schl *info);
int SaveRecycleBinConf(recycle_schl *info);
int SaveRecycleBinClearSchl(recycle_schl *info);
#endif
#define MAX_SERVER_LEN		128

typedef struct ntp{
	char	ntp_enable[4];
	char	ntp_server[MAX_SERVER_LEN+1];
	char	ntp_server_type[16];//default, specify
	int		ntp_list;			//0,1,2...
	int		hour;		//  0~12
	int 	minute;		//	0~59
	int 	ampm;		//0: am, 1: pm
	int	interval; 	//1: 1 hour, 2: 2 hour, 4: 4 hour, 8: 8 hour, 12: 12 hour, 24: 24 hour	
	int	change;		//0: change, 1: no change
}ntp_info;

#ifdef _DDNS_
typedef struct ddns_info{
	char	ddns_enable[4];
	int		ddns_type;//0-DynDNS, 1-TZO
	char	tzo_mail[48+1];
	char	tzo_key[64+1];
	char	tzo_domain_name[64+1];
	
	char	dyn_account[48+1];
	char	dyn_pass[48+1];
	int		dyn_flavor;//0-Dynamic,1-Static,2-Custom
	char	dyn_domain_name[64+1];
	int		update_interval;
	int	change;		//0: change, 1: no change
}ddns_info;
#endif

#ifdef _MULTI_LANG_
typedef struct multi_lang_info{
	char lang_name[3];      // "en", "tc" and etc...
}multi_lang_info;
#endif

/**************************************************/
//      NOTE:This function will read system time  //
//      information from config files.            //
//      input:  NONE                              //
//      output: p       point to the structure    //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int ReadSYSTime(sys_time * p);

/**************************************************/
//      NOTE:This function will read system       //
//      general information from config files.    //
//      input:  NONE                              //
//      output: p       point to the structure    //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int ReadSYSInfo(sys_info * p);

/**************************************************/
//      NOTE:This function will read system shut  //
//      schedule information from config files.   //
//      input:  NONE                              //
//      output: p       point to the structure    //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int ReadSYSSchl(sys_schedule * p);

/**************************************************/
//      NOTE:This function will read system       //
//      setup information from config files.      //
//      input:  NONE                              //
//      output: p       point to the structure    //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int ReadSYSShut(sys_setup * p);

/**************************************************/
//      NOTE:This function will save system       //
//      time information to config files.         //
//      input:  p       system time information   //
//                      saved here.               //
//              flag    save type:1-timezone      //
//                                2-time          //
//                                0-both          //
//      output: NONE                              //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int SaveSYSTime(sys_time * p, int flag);

/**************************************************/
//      NOTE:This function will save system shut  //
//      schedule information to config files.     //
//      input:  p       system time information   //
//                      saved here.               //
//      output: NONE                              //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int SaveSYSSchl(sys_schedule * p);

/**************************************************/
//      NOTE:This function will save system       //
//      setup information to config files.        //
//      input:  p       system setup information  //
//                      saved here.               //
//      output: NONE                              //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int SaveSYSShut(sys_setup * p);

/**************************************************/
//      NOTE:This function will do reboot or      //
//      shutdown action after some time according //
//      to config files.                          //
//      input:  NONE                              //
//      output: NONE                              //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int DelayAction(void);

/**************************************************/
//      NOTE:This function will check the server  //
//      name and comment, Save them if they are   //
//      changed.                                  //
//      input:server_name     point to the name   //
//            server_comment  point to the comment//
//      output: NONE                              //
//      return: 0       success                   //
//              1       failure                   //
/**************************************************/
int SaveServerNameComment(char *server_name, char *server_comment);

int Read_Schl_Shutdown(shutdown_schl * shutdown_schl);
int Add_Schl_Shutdown(shutdown_schl * shutdown_schl, int action);
int saveTZ(sys_time * p);

int ReadLogSerInfo(log_ser_info * p);
int SaveLogSerInfo(log_ser_info * p);
int ReadNTPConf(ntp_info *info);
int SaveNTPConf(ntp_info *info);
int SaveNTPSchl(ntp_info *info);
#ifdef _DDNS_
int SaveDDNSConf(ddns_info *info);
int ReadDDNSConf(ddns_info *info);
int ResetDDNSConf(ddns_info *info);
#endif

int StopUPnP(void);
int ResetUPnP(void);

#define REMOTE_INPUTPARM_ERR		7
#define REMOTE_VALUE_ERR			8
#define	REMOTE_IPAddrBlankErr		9	//the IP Address is blank.
#define	REMOTE_IPAddrErr			10	//The IP Address is invalid.
#endif
