#ifndef __NFS_H__
#define __NFS_H__

#include "constant.h"
#include "share.h"
#define	NFS_EXPORTS	"/etc/exports"

//Settings in /etc/CGI_ds.conf
/*
 *
[NFS]
share=host:mask:readonly
 *
 */
 
typedef struct nfs_conf{
	int enable;
}NFS_CONF;

typedef struct nfs_sh{
	char sh_name[FSH_MaxShareLen+1];
	char host_ip[FSH_MaxIPLen+1];
	int mask;
	int readonly;
	struct nfs_sh *pNext;
}NFS_SH;

void FreeNFSShList(NFS_SH *pList);
int ReadNFSShares(NFS_SH **ppList);
int UpdateNFSShare(NFS_SH *pConf);
int CheckNFSShare(NFS_SH *pConf);
int AddNFSShare(NFS_SH *pConf);
int DelNFSShare(NFS_SH *pConf);
int SaveNFSConf(NFS_CONF *pConf);
int ReadNFSConf(NFS_CONF *pConf);
int UpdateNFSConf(sh_list *pList);
void ResetNFSShares();
int IsNFSEnabled(void);
#endif

