#ifndef _LIBBACKUP_H_
#define _LIBBACKUP_H_

#include "constant.h"

#define	MAX_JOB_NAME_LEN	20
#define	MAX_FS_NAME_LEN		128
#define	MAX_FD_NAME_LEN		255
#define	MAX_AMPM_LEN		2
#define	MAX_JOB_NUM			20
#define	MAX_RUNNING_JOB		5
#define	BACKUP_CONF			"/etc/backup_sh.conf"
#define DS_CONF				"/etc/CGI_ds.conf"

#define	BACKUP_CMD			"/usr/sbin/backup"
#ifdef __FTP_BACKUP__
#define	FTP_BACKUP_CMD		"/usr/sbin/ftp_backup"
#endif

#define	BACKUP_TMPDIR		"/mnt/backup"

#define DIRECTION_N2F		0
#define	DIRECTION_F2N		1

#define ACTION_COPY			1
#define ACTION_UPDATE 		2
#define	ACTION_SYNC			3

/*****

[job_name]
//job_owner=		//owner of the job
job_mode=		//1,2,3	1-copy,2-update,3,sync
direction=		//0:NAS->FILE SERVER	1:FILE SERVER->NAS.
s_share=		//a share name
d_fs=			//dest file server
d_auth=			//Need Authentication?
d_username=		//user name
d_userpass=		//user password
d_folder=		//dest share/floder
schl_en=		//0,1	0-disable,1-enable
//	when schl_en=1
*	schl_day=	//1,2,3,4,5,6.7,8(weekdays),9(every day...)
*	schl_hour=	//1-12
*	schl_min=	//0-59
*	schl_ampm=	//am/pm
//
*******/

//#define	JOB_OWNER		"job_owner"
#define	JOB_MODE			"job_mode"

#ifdef __FTP_BACKUP__
#define	JOB_PROTO			"job_proto"
#define	JOB_FTP_MODE		"job_ftp_mode"
#define	JOB_FTP_SSL			"job_ftp_ssl"
#define	JOB_FTP_PORT		"job_ftp_port"
#endif

#define	JOB_DIRECTION		"job_direction"
#define	JOB_S_SHARE			"s_share"
#define	JOB_SH_FOLDER		"sh_folder"
#define	JOB_D_FS			"d_fs"
#define	JOB_D_AUTH			"d_auth"
#define	JOB_D_USERNAME		"d_username"
#define	JOB_D_USERPASS		"d_userpass"
#define	JOB_FOLDER			"d_folder"

#define	JOB_SCHL_EN			"schl_en"
#define	JOB_SCHL_DAY	"schl_day"
#define	JOB_SCHL_HOUR	"schl_hour"
#define	JOB_SCHL_MIN	"schl_min"
#define	JOB_SCHL_AMPM	"schl_ampm"


typedef struct sh_backup
{
	char job_name[MAX_JOB_NAME_LEN+1];
//	char job_owner[FSH_MaxUserLen+1];
	int job_mode;
#ifdef __FTP_BACKUP__
	int	job_proto;//0-CIFS,1-FTP
	int ftp_mode;//0-Port,1-Passive
	int ftp_port;//21,1024-65535
	int ftp_ssl;//0-Disabled,1-Enabled
#endif
	int job_direction;
	char s_share[FSH_MaxShareLen+1];
	char sh_folder[MAX_FD_NAME_LEN+1];
	char d_fs[MAX_FS_NAME_LEN+1];
	int auth;
	char d_username[36+1];
	char d_userpass[FSH_MaxWINPassLen+1];
	char d_folder[MAX_FD_NAME_LEN+1];
	
	int schl_en;
	int schl_day;
	int schl_hour;
	int schl_min;
	char schl_ampm[MAX_AMPM_LEN+1];
	struct sh_backup *next;
}sh_backup;

typedef struct backup_info
{
	char job_name[MAX_JOB_NAME_LEN+1];
	int job_mode;
#ifdef __FTP_BACKUP__
//	char job_owner[FSH_MaxUserLen+1];
	int	job_proto;//0-CIFS,1-FTP
	int ftp_mode;//0-Port,1-Passive
	int ftp_port;//21,1024-65535
	int ftp_ssl;//0-Disabled,1-Enabled
#endif
	int job_direction;
	char s_share[FSH_MaxShareLen+1];
	char sh_folder[MAX_FD_NAME_LEN+1];
	char d_fs[MAX_FS_NAME_LEN+1];
	int auth;
	char d_username[36+1];
	char d_userpass[FSH_MaxWINPassLen+1];
	char d_folder[MAX_FD_NAME_LEN+1];
}backup_info;


typedef struct usb_backup_info
{
	char usb_dest[MAX_FD_NAME_LEN+1];
	int backup_method;//1-Full, 2-Incremental
}usb_backup_info;


int GetBackupList(sh_backup **,int *);
int GetBackupInfo(backup_info *pInfo);
int AddABackup(sh_backup *);
int UpdateABackup(char *,sh_backup *);
int UpdateBackup(char *pName,sh_backup *pBackup);
int DelABackup(char *);
int NumOfBackupJobs(void);
char *transf(char *path,char flag);
int DoBackup(char *);
void StopBackupJob(char *pName);
void FreeBackupList(sh_backup *);

int NumofRunningJob(void);
int IsBackupExist(char *);
int IsShareBackuping(char *pShare);
int IsBackupDoing(char *pName);
int SchlAddBackup(sh_backup *pBackup);
int SchlDelBackup(char *job_name);
void StopAllJob(void);
void StopUSBJob(char *pPrefix);
#define WINDOW_MODE		1
#define	LINUX_MODE		0
int InternalJob(char *pServer);
char *transf(char *path,char flag);
int SaveUSBBackupInfo(usb_backup_info *pInfo);
int ReadUSBBackupInfo(usb_backup_info *pInfo);
void StartUSBCopyProcess(void);
void StopUSBCopyProcess(void);

#define ERR_OPENFILE		1
#define	ERR_READFILE		2
#define	ERR_MEMALLOC		3
#define	ERR_EXIST			4
#define	ERR_NOT_EXIST		5
#define	ERR_JOB_MODE		6
#define	ERR_JOB_SCHL		7
#define	ERR_JOB_PATH		8
#define	ERR_JOB_DAY			9
#define	ERR_JOB_HOUR		10
#define	ERR_JOB_MIN			11
#define	ERR_JOB_AMPM		12
#define	ERR_WRITEFILE		13
#define	ERR_MAX_JOB			14
#define	ERR_JOB_NAME		15
#define ERR_LOOP			16
#define ERR_JOB_JOBNAME		17
#define	ERR_JOB_HOSTNAME	18
#define	ERR_JOB_USERNAME	19
#define	ERR_JOB_BUSY			20
#define	ERR_FULL_SCHL			21
#define	ERR_DUP_SERVER			22
#define ERR_SH_FOLDER			23
#define	ERR_DUP_FOLDER			24
#define ERR_JOB_RUNNING			25
#define	ERR_SRC_DEST_LOOP		26
#ifdef __FTP_BACKUP__
#define	ERR_JOB_PROTO			27
#define	ERR_FTP_MODE			28
#define	ERR_FTP_SSL				29
#define	ERR_FTP_PORT			30
#endif
#define	INIT_BACK_SLASH_ERR				31	//Error: User name cannot begins or ends with character '\'.
#define	MANY_BACK_SLASH_ERR				32	//Error: Only one character '\' can be used in user name. 
#define	LONG_ACCOUNT_ERR				33	//Error: The user name is too long. 
#define	LONG_ACCOUNT_ERR_1				34	//Error: The domain name or the user name is too long. 
#define	USB_STORE_FOLDER_ERR			35	//Error: The stored folder of USB Backup doesn't exist.
#define	USB_STORE_INTERNAL_ERR			36	//Error: The stored folder of USB Backup must be in Internal Disk.

#endif
