#ifndef _HARDDISK_API_H_
#define _HARDDISK_API_H_
#include "constant.h"

#define ACTION_DEL    	                0
#define ACTION_ADD		        1
#define ACTION_BACKUP                   2
#define ACTION_NOBACKUP                 3
#define ACTION_CLEAR                    4
#define ACTION_READ                     5
#define	NAS200_FLAG	".linksys"


#define DSK_PARTITION_LEN		10	//partition name
#define DSK_XFS				1	//filesystem xfs
#define DSK_EXT2			2	//filesystem ext2
#define DSK_VFAT			3	//filesystem vfat
#define DSK_TYPE_LEN			30	//harddisk type name

#define DSK_STAT_NONE                   0
#define DSK_STAT_UMOUNT                 1
#define DSK_STAT_FDISKING	       	 	2
#define DSK_STAT_SCANNING               3
#define DSK_STAT_READY                  3	

#define HD_ACT_SPIN_ENABLE		0
#define HD_ACT_SPIN_DISABLE		1
#define HD_ACT_PWR_ENABLE		2

#define DSK_CHK_NONE			0
#define DSK_CHK_ERROR			1
#define DSK_CHK				2

#define	DSK_OK				0	// OK
#define	DSK_NO_DISK			-1
#define	DSK_ERR_TYPR		-2	// Incorrect partition type

#define	HD_SMART_DISK_FAIL			1
#define	HD_SMART_DISK_OK			0
#define	HD_SMART_DISK_NA			-1
#define	HD_SMART_NOT_SUPPORTED		-2
#define	HD_SMART_NOT_ENABLED		-3
#define DSK_ERROR					1


typedef struct  partition_info {
        unsigned long long   total_size;     /** unit is K bytes **/
        unsigned long long   usage_size;     /** unit is K bytes **/
        unsigned long long   free_size;      /** unit is K bytes **/
        unsigned long 	free_percent;
} partition_info;

typedef struct dsk_info {
	char	dsk_type[DSK_TYPE_LEN];	 // type of the hard disk.
	unsigned long	dsk_cylinders;   // cylinders of the hard disk.
	unsigned long	dsk_heads;    	 // heads of the hard disk
	unsigned long	dsk_sectors;  	 // sectors of the hard disk
	unsigned long long	dsk_size;      	 // hard disk size in bytes
} dsk_info;

typedef struct hd_scan_schl {
    int action;			// 0-None,1-Check error,2-Not check error;
    int date;			//0-None, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday,
    //6-Saturday, 7-Sunday, 8-weekdays
    int hour;			//24 hour
    int minute;
} hd_scan_schl;

typedef struct hd_smt_schl {
    int action;			// smart type
    int date;			//0-None, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 
    //6-Saturday, 7-Sunday, 8-weekdays
    int hour;			//24 hour
    int minute;
} hd_smt_schl;

typedef struct hd_defrag_schl {
    int action;			// defrag type
    int date;			//0-None, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 
    //6-Saturday, 7-Sunday, 8-weekdays
    int hour;			//24 hour
    int minute;
} hd_defrag_schl;

typedef struct hd_idle_hdd {
    int idle_hdd;
} hd_idle_hdd;

#define	MAX_USB_PARTS	10
#define	FILE_SYS_STR_LEN		32
#define	SH_FOLDER_LEN		20
typedef struct usb_disk{
	char 				disk_name[16];		//
	char				mode_type[DSK_TYPE_LEN];	 // type of the hard disk.
	unsigned long long	total_size;      	 // hard disk size in KB
	int					part_num[MAX_USB_PARTS];
	char				file_system[MAX_USB_PARTS][FILE_SYS_STR_LEN];
	char				shared_folder[MAX_USB_PARTS][SH_FOLDER_LEN+1];
	unsigned long long	part_total_size[MAX_USB_PARTS];
	unsigned long long	part_free_size[MAX_USB_PARTS];
}USB_DISK;

#define	MAX_PARTITIONS	4	
typedef struct usb_partition
{
	int part_enable[MAX_PARTITIONS];//0-Not Enabled, 1-Enabled
	unsigned long part_size[MAX_PARTITIONS];//MB
	int part_all_left[MAX_PARTITIONS]; //0-Not Enabled, 1-Enabled. If 1, then ignore left partitions
	int disk_num;
}USB_PARTITION;


#define 	MAX_SCHLSCAN_NUM	7
#define 	MAX_SCHLSMT_NUM		7
extern char *hd_name[];
extern char *mnt_name[];
int Add_Schl_Scandisk(int number,hd_scan_schl scan_shl[],int d_no,int act_type);
int DSK_DetectAndMountDisk(int valid_num[DSK_NUM],int nvalid_num[DSK_NUM]);
int DSK_DetectSysDisk(int valid_num[DSK_NUM], int nvalid_num[DSK_NUM]);
int DSK_Format(int nDskNum);
int DSK_GetDiskStatus(int nDskNum, int *status, int *details);
int DSK_GetDskInfo(int nDskNum, dsk_info * pDskInfo);
int DSK_GetIdleHD(hd_idle_hdd * pIdle);
int DSK_MountDisk(int nDskNum, char *mount_point, int partition);
int DSK_Partion(int nDskNum);
int DSK_PartitionAndFormat(int nDskNum);
int DSK_ScanDisk(int action, int scan_method, int nDskNum,int delaytime, int  *result);
int DSK_Schl_ScanDisk(int act_type, int schl_num, hd_scan_schl scan_shl[], int NDskNum);
int DSK_SetDiskOptions(int action, int delaytime, int nDskNum);
int DSK_SetIdleHD(hd_idle_hdd * pIdle);
int DSK_Swap(int nDskNum);
int DSK_UnmountDisk(int nDskNum, int partition);
int DSK_UpdateSysDiskInfo(int action, int hditem, int partition);
int PartitionInfo(int nDskNum, struct partition_info *nptr);
int Read_Schl_Scandisk(int number, hd_scan_schl scan_shl[], char *i_name);
int CheckFlashPart(void);
int DSK_Schl_Backup(int act_type, int schl_num, hd_scan_schl backup_shl[]);

int CheckHDDFreeSize(char *pMount);
int CheckPartition(char *hdname);
int CheckHDDMounted(char *pMount);
int FirstAvaibleVolume(void);//Return: -1=No, 1=Disk 1, 2=Disk 2, ...
int FirstAvaibleVolume_1(void);//Return: >=1 Disk exist, =<0 No Disk
int DSK_GetVolInfo (int nDskNum, dsk_info *pDskInfo);
int DSK_Schl_DiskSmartChk(int act_type, int schl_num, hd_smt_schl smt_schl[], int NDskNum);
int getDeviceCount(int *dev_status);
int DSK_Format_Individual(int hd_index);
unsigned long long GetPartitionSize(int nDskNum);
int ReadDiskSmart(int smart_status[2]);
int CheckDiskSmart(int disk_no);
int GetUSBDiskStatus(USB_DISK *pStatus, int usb_no);
int PartitionAndFormatUSBDisk(struct usb_partition *part);
int CheckDevMounted(char *pDev);
int CheckStrangeDevMounted(char *pDev);
int GetUSBcylinder(int disk_no, char *buf);
int GetUSBHeads(int disk_no, char *buf);
int GetUSBSectors(int disk_no, char *buf);
void ResetHDDIdle(void);
int GetCodePage (void);
int ST_fstab(void);
#endif
