#ifndef _FTP_H_
#define _FTP_H_
#include "constant.h"

#ifdef __SERCOMM_MEDIA_SERVER__
#define	MEDIA_SERVER_PID	"/var/run/media_server.pid"
#define	MEDIA_SCAN_PID		"/var/run/media_scan.pid"
#endif

#define MAX_UPNP_NAME_LEN	32
#define MAX_AV_PATH_LEN		256
#define	FOLDER_NUM			4
typedef struct upnp_av{
	int		upnp_av;
	char	upnp_name[MAX_UPNP_NAME_LEN+1];
	int		upnp_av_folder[FOLDER_NUM];
	char	upnp_av_share[FOLDER_NUM][FSH_MaxShareLen+1];
	char	upnp_av_path[FOLDER_NUM][MAX_AV_PATH_LEN+1];	
	int 	content_type[FOLDER_NUM];
	int		content_scan;
	int		code_page;
	int		device_port;
	char	fw_version[12];
	unsigned long scan_interval;
}UPNP_AV;

typedef struct itune{
	int		itune;
	char	itune_name[MAX_UPNP_NAME_LEN+1];
	char	itune_path[MAX_AV_PATH_LEN+1];	
}ITUNE;

typedef struct broad{
	int		broad;
	char	broad_name[MAX_UPNP_NAME_LEN+1];
	int		broad_port;
	char	broad_path[MAX_AV_PATH_LEN+1];	
	char	play_method[12];		
}BROAD;

#ifdef _PHOTO_ALBUM_
#define	THUMBNAIL_PREFIX	"Thumbnail_"
#define	THUMBNAIL_MED_PREFIX	"Thumbnail_MED_"
#define	DESCRIPT_PREFIX			"Description_"
#define	THUMB_FOLDER		".Thumb_DB"

typedef struct album_conf
{
	int album_enable;
	char album_path[256];
	char background_music_path[256];
}ALBUM_CONF;

int ReadPhotoAlbumConf(ALBUM_CONF *pConf);
int SavePhotoAlbumConf(ALBUM_CONF *pConf);
void ResetPhotoAlbum(ALBUM_CONF *pConf);

#define	MAX_ALBUM_USER_NUM	32
#define	ALBUM_USER_CONF	"/etc/album_user.conf"

typedef struct album_user{
	char name[FSH_MaxUserLen+1];
	char pass[FSH_MaxPassLen+1];
	char comment[FSH_MaxCommentLen+1];
	int info_change;
	int disabled;
	struct album_user *pNext;
}ALBUM_USER;

void de_dotdot( char* file );
int GetAllAlbumUsers(ALBUM_USER **ppList);
void FreeAlbumUserList(ALBUM_USER *pList);
int NumOfAlbumUser(void);
int AlbumUserExist(char *szUser);
int UpdateAlbumUser(char *szUser, ALBUM_USER *pNewUser);
int DelAlbumUser(char *szUser);
int AddAlbumUser(ALBUM_USER *pUserInfo);
int GetAlbumUserInfo(ALBUM_USER *pUserInfo);
int RightOfFolderOnAlbumUser(char *szUser, char *szFolder);
int DelFolderFromAlbumUser(char *szUser, char *szFolder);
int AddFolderToAlbumUser(char *szUser, char *szFolder, int right);
int UpdateAlbumUserConf(char *current_folder);
int CheckAlbumThumbFiles(char *szFolder);
#endif

#ifdef _SSH_SERVER_
typedef struct ssh_conf
{
	int ssh_enable;
	int ssh_port;
}SSH_CONF;

int ReadSSHConf(SSH_CONF *pconf);
int SaveSSHConf(SSH_CONF *pconf);
int ResetSSH(void);
#endif

typedef struct ftp_conf{
    int ftp_server;
    int ftp_change;
    int ftp_anon;
    int ftp_lang;
    int ftp_port;
    int ftp_data_port;
#ifdef _FTP_SERVER_PASSIVE_PORTS_
    int ftp_passive_ports_fix;	//0-Default, 1-Spedified
    int passive_port_min;
    int passive_port_max;
#endif
#ifdef _FTPS_    
    int ftp_ssl;
#endif    
	int ftp_bandwidth;//Unit: KB/s
}FTP_SERVER;

int ReadFTPConf(FTP_SERVER *pconf);
int SaveFTPConf(FTP_SERVER *pconf);
 int ResetFTP(void);
int ResetBroadcast(void);
int ResetUPnPAV(int fast_scan);
int ResetItune(void);
int StopMediaProcess(int hard_index, char *sh_prefix, int disable);
void StartMediaProcess(int num);
int ReadiTuneConf(ITUNE *pConf);
int SaveiTuneConf(ITUNE *pConf);

int ReadBroadConf(BROAD *pConf);
int SaveBroadConf(BROAD *pConf);

int ReadUPnPAVConf(UPNP_AV *pConf);
int SaveUPnPAVConf(UPNP_AV *pConf);
int StripShareAndFolder(char *pSrc, char *pShare, char *pDir, int checkonly);
void ResetUPnPAV2Def(void);
void StopAllMedia(void);
void StopAllMedia1(void);
#ifdef __SERCOMM_MEDIA_SERVER__
void StopUPnPDaemon(UPNP_AV *pAVConf, int del_db);
void ScanUPnPAVServer(void);
void ReloadUPnPAVServerIP(void);
#endif

#ifdef __WEB_STATION__

#define HTTPD_CONF_S		"/usr/local/apache2/conf/httpd.conf"
#define HTTPD_CONF			"/etc/web_station/httpd.conf"
#define MYSQLD_CONF			"/etc/web_station/my.cnf"
#define PHP_INI				"/etc/web_station/php.ini"
#define PHP_INI_DEF			"/etc/web_station/php.ini.def"
#define SSMTP_CONF			"/etc/ssmtp/ssmtp.conf"

#define	MAX_WEB_STATION_PATH_LEN	255
#define	MAX_WEB_STATION_SMTP_SERVER_LEN	128
#define	MAX_WEB_STATION_SMTP_USER_LEN	48
#define	MAX_WEB_STATION_SMTP_PASS_LEN	32


typedef struct WebStationConf {
	char root_path[MAX_WEB_STATION_PATH_LEN+1];
	int httpd_enable;
	int httpd_port;
	int mysqld_enable;
	int mysqld_remote;
	int mysqld_port;
	int reg_global;
	int smtp_auth;
	char smtp_server[MAX_WEB_STATION_SMTP_SERVER_LEN+1];
	char smtp_user[MAX_WEB_STATION_SMTP_USER_LEN+1];
	char smtp_pass[MAX_WEB_STATION_SMTP_PASS_LEN+1];
} WebStationConf;

int ReadWebStationConf(WebStationConf *pConf);
int SaveWebStationConf(WebStationConf *pConf);
int ResetWebStationConf(WebStationConf *pConf);
#endif
void RemoveDBOKFlag(void);
void CheckPhotoAlbum(int hard_index);
#endif
