#ifndef	__DISK_TABLE_H__
#define	__DISK_TABLE_H__

#include <sys/types.h>

#include <errno.h>
#include <unistd.h>

#ifndef __KERNEL__
#define	__KERNEL__
#endif

#if defined(__GNUC__) || defined(HAS_LONG_LONG)
typedef long long       ext2_loff_t;
#else
typedef long            ext2_loff_t;
#endif

//extern ext2_loff_t ext2_llseek (unsigned int, ext2_loff_t, unsigned int);
#ifdef __linux__

	#ifdef HAVE_LLSEEK
		#include <syscall.h>
	#else	/* HAVE_LLSEEK */
	
		#if defined(__alpha__) || defined(__ia64__)
		
		#define my_llseek lseek
		
		#else
			#include <linux/unistd.h>	/* for __NR__llseek */
			
			static int _llseek (unsigned int, unsigned long,
					   unsigned long, ext2_loff_t *, unsigned int);
			
			static _syscall5(int,_llseek,unsigned int,fd,unsigned long,offset_high,
					 unsigned long, offset_low,ext2_loff_t *,result,
					 unsigned int, origin)
			

		
		#endif /* __alpha__ */
	
	#endif	/* HAVE_LLSEEK */



#else /* !linux */

ext2_loff_t ext2_llseek (unsigned int fd, ext2_loff_t offset,
			 unsigned int origin)
{
	aa
	if ((sizeof(off_t) < sizeof(ext2_loff_t)) &&
	    (offset >= ((ext2_loff_t) 1 << ((sizeof(off_t)*8) -1)))) {
		errno = EINVAL;
		return -1;
	}
	return lseek (fd, (off_t) offset, origin);
}

#endif 	/* linux */


#define DEFAULT_SECTOR_SIZE	512
#define MAX_SECTOR_SIZE	2048
#define SECTOR_SIZE	512	/* still used in BSD code */
#define MAXIMUM_PARTS	60

#define ACTIVE_FLAG     0x80

#define EXTENDED        0x05
#define WIN98_EXTENDED  0x0f
#define LINUX_PARTITION 0x81
#define LINUX_SWAP      0x82
#define LINUX_NATIVE    0x83
#define LINUX_EXTENDED  0x85

#define IS_EXTENDED(i) \
	((i) == EXTENDED || (i) == WIN98_EXTENDED || (i) == LINUX_EXTENDED)

#define SIZE(a)	(sizeof(a)/sizeof((a)[0]))




enum failure {  usage, usage2, ioctl_error,unable_to_open, 
                      unable_to_read, unable_to_seek,
	      unable_to_write, out_of_memory
};

enum action {fdisk, require, try_only, create_empty};

struct geom {
	unsigned int heads;
	unsigned int sectors;
	unsigned int cylinders;
};

#define	MAX_MOUNT_VOL	10
#define		PROC_FLASH_1		"/proc/flash_sdc"
#define		PROC_FLASH_2		"/proc/flash_sdd"
#define		PROC_FLASH_3		"/proc/flash_sde"
#define		PROC_FLASH_4		"/proc/flash_sdf"
#define		PROC_FLASH_5		"/proc/flash_sdg"
#define		PROC_FLASH_6		"/proc/flash_sdh"
#define		PROC_FLASH_7		"/proc/flash_sdi"
#define		PROC_FLASH_8		"/proc/flash_sdj"
#define		PROC_FLASH_9		"/proc/flash_sdk"

#define		PROC_HDD_1		"/proc/hdd_sdc"
#define		PROC_HDD_2		"/proc/hdd_sdd"
#define		PROC_HDD_3		"/proc/hdd_sde"
#define		PROC_HDD_4		"/proc/hdd_sdf"
#define		PROC_HDD_5		"/proc/hdd_sdg"
#define		PROC_HDD_6		"/proc/hdd_sdh"
#define		PROC_HDD_7		"/proc/hdd_sdj"
#define		PROC_HDD_8		"/proc/hdd_sdj"
#define		PROC_HDD_9		"/proc/hdd_sdk"

struct dev_list{
	char hdd_flag[16];
	char flash_flag[16];
	char hdd_eject_flag[24];
	char flash_eject_flag[24];
	char media_flag[32];
	char dev_name[16];
	char share_name[12];
	char reformat_flag[24];
	int	mounts;
	int bad_dev;
};

int DSK_MountUserDisk(struct dev_list *devices, int dev_no, int *total_mounts);
int DSK_UnmountUserDisk(char *share_name, int dev_no);
int isUserDisk(char *disk_name);
void InitDev(struct dev_list *devices, int num);
int CheckCardReaderDev(int *total_mounts);
int get_free_space(char *mount_point,char* type,unsigned long *size,int *percent, unsigned long *total);
int get_userdisk_detail(char *mount_point,char *type,unsigned long *size,unsigned long *cylinders,unsigned long *heads,unsigned long *sectors);
int get_userdisk_type(int disk_no,char* type);
int get_userdisk_info(char dev_name[16],unsigned long *size,unsigned long *cylinders,unsigned long *heads,unsigned long *sectors);
int IsRAIDDisk(char *disk_name);
int IsLVMDisk(char *disk_name);
int get_table(char* disk_device,int *table,int *partitionCount_x);
#endif

