#ifndef __CGI_ERR_H__
#define __CGI_ERR_H__

//Message Files
#define		ERRMSG_FILE		"/etc/cgi_msg"
#define		ERRMSG_FILE_UTF8		"/etc/cgi_msg_utf8"
#define		SYSMSG_FILE		"/etc/sys_msg"
#define		DISKSTATUS_FILE	"/etc/disk.status"

//Section Names
#define		COMMON_ERR							"CGI_COMMON"
#define		BACKUP_ERR							"BACKUP_CGI"
#define		ACTION								"ACTION"
#define		AM_PM								"AM_PM"
#define		BACKUP_MSG							"BACKUP_MSG"
#define		CHANGE_PASS							"CHANGE_PASS"
#define		CAMERA_ERR							"CAMERA_ERR"
#define		DELAY_ACTION                           	"DELAY_ACTION"
#define		DAYS_MSG                                "DAYS_MSG"
#define		DISK_NAME                               "DISK_NAME"
#define		DISK_NUMBER                             "DISK_NUMBER"
#define		DISK_TYPE                               "DISK_TYPE"
#define		GROUP_ERR                               "GROUP_ERR"
#define		HD_LIST                                 DISK_NAME
#define		LANGUAGE                                "LANGUAGE"
#define		MONTH                                   "MONTH"
#define		PRINTER_STATUS                          "PRINTER_STATUS"
#define		SCANDISK_STATUS                         "SCANDISK_STATUS"
#define		SERVER_STATUS                           "SERVER_STATUS"
#define		SETUP_ERR                               "SETUP_ERR"
#define		SHARE_ERR                               "SHARE_ERR"
#define		SHOW_DEFRAG                             "SHOW_DEFRAG"
#define		SHOW_PREPARE                            "SHOW_PREPARE"
#define		SHOW_SCANDISK                           "SHOW_SCANDISK"
#define		SHOW_SMART                              "SMART"
#define		SHUTDOWN_HDD                            "SHUTDOWN_HDD"
#define		SYSTEM_LOG                              "SYSTEM_LOG"
#define		TELNET_STATUS                           "TELNET_STATUS"
#define		TIMEZONE                                "TIMEZONE"
#define		UPGRADE_STATUS                          "UPGRADE_STATUS"
#define		USER_ERR                                "USER_ERR"
#define		WEB_SHARE                               "WEB_SHARE"
#define		DISK_SPACE                              "DISK_SPACE"
#define		NTP_SECTION                             "NTP_MSG"
#define		MESSAGES                             	"MESSAGES"                                     
#define		DISK_MODE								"DISK_MODE"
#define		DOWNLOAD								"DOWNLOAD"       
#define		FOLDER_BROWSE							"FOLDER_BROWSE"         
#define		BACKUP_SEC								"BACKUP"           
#define		DDNS_ERROR								"DDNS"
#define		USB_COPY_SEC							"USB_COPY_SEC"
#define		DISK									"DISK"
#define		PHOTO_ALBUM								"PHOTO_ALBUM"
#define		DISK_MSG								"DISK"

//------------- Message Index-------------

//[ACTION]                                      
#define		SCANNING                                1
#define		UPGRAGING                               2
#define		PREPARING                               3
#define		SMARTING                                4
#define		BACKUPING                               5
#define		DEFRAGING                               6
#define		MOVING                                  7
#define		NoHardDisk                              8
#define		REBUILDING_NO_SCAN						11
#define		REBUILDING_NO_SMART						12
#define		INTERNAL_DISK_NOT_READY					13                                          
#define		MODE_CHANGING							14
                                             
//[AM_PM]                                       
#define		Am                                      1
#define		Pm                                      2
                                                
//[BACKUP_MSG]                                  
#define		NO_HARDDISK                             1
#define		HD_INVALID                              2
#define		BACKUPSTART                             3
#define		BACKUPCOMPLETED                         4
#define		UPGRADINGWARNING                        5
#define		PREPARINGWARNING                        6
#define		SMARTINGWARNING                         7
#define		SCANNINGWARNING                         8
#define		DEFRAGINGWARNING                        9
#define		MOVINGWARNING                           10
                                                        
//[CHANGE_PASS]                                         
#define		ChangeSuccess                           1
#define		InvailName                              2
#define		OldPasswdWrong                          3
#define		VerifyPasswdFail                        4

//[COMMON_ERR]
#define			UnknownErr                              1
#define			HtmlStrTooLarge                         2
#define         HtmlTooLarge                            3
#define         IllegalIP                               4
#define         IllegalVal                              5
#define         MemErr                                  6
#define         PostFunErr                              7
#define         ProcErr                                 8
#define         ReadFileErr                             9
#define         OpenFileErr                             10
#define         FileNotFoundErr                         11
#define         SaveFileErr                             12
#define         SaveOK                                  13
#define         DecodeErr                               14
#define         NoDiskSpaceErr                          15
#define         USBAccessing                            16

//[DELAY_ACTION]
#define         None                                    1
#define         Reboot                                  2
#define         Shutdown                                3

//[DAYS_MSG]
#define         EVERYMONDAY                             1
#define         EVERYTUESDAY                            2
#define         EVERYWEDNESDAY                          3
#define         EVERYTHURSDAY                           4
#define         EVERYFRIDAY                             5
#define         EVERYSATURDAY                           6
#define         EVERYSUNDAY                             7
#define         EVERYDAY                                8
#define         NEVER                                   9

//[DISK_NUMBER]
#define         Disk1                                   1

//[DISK_TYPE]
#define         HAVE_NO_DISK                            1
#define         DISK_READY                              2
#define         DISK_NOT_PREPARED                       3
#define			DISK_READY_GB							4
#define			DISK_READY_MB							5
#define			DISK_NA									6
#define			DISK_UNKNOWN							7

//[GROUP_ERR]
#define         GetGroupListErr                         1
#define         GetGroupNumErr                          2
#define         GetGrpShareErr                          3
#define         GetGrpMemberErr                         4
#define         AddGrpMembersErr                        5
#define         DelGrpMembersErr                        6
#define         AddGrpSharesErr                         7
#define         DelGrpSharesErr                         8
#define         AddGroupErr                             9
#define         DelGroupErr                             10
#define         UpdateGroupErr                          11
#define         DelReservedGrpErr                       12
#define         RenReservedGrpErr                       13
#define         IllegalGrpCharErr                       14
#define         ExistedGroupErr                         15
#define         TooManyGroupErr                         16
#define         DelGrpReservedUsrErr                    17
#define         DelDefaultGrpErr                        18
#define         ChangeAdminGrpErr                       19
#define         ChangeUSBShareErr                       20

//[HD_LIST]
#define         NoDisk                                  1
#define         PrimaryDisk                             2
#define         SecondaryDisk                           3
#define         VOLUME_RAID0                           	4
#define         VOLUME_RAID1                           	5
#define         VOLUME_LVM                           	6
#define			USB_NAME_1								7
#define			SEPARATE_DISK							8
#define			SEPARATE_DISK_1							9
#define			DISK_1_PUB								10
#define			DISK_2_PUB								11
#define			INTERNAL_DISK							12
#define                        PUBLIC_DATA	13
#define         NONE                                    1
#define         FIRST                                   2
#define         SECOND                                  3
#define         BOTH                                    4
                                    
//[LANGUAGE]
#define         Language437                             1
#define         Language737                             2
#define         Language850                             3
#define         Language852                             4
#define         Language861                             5
#define         Language866                             6
#define         Language932                             7
#define         Language936                             8
#define         Language949                             9
#define         Language950                             10

//[MONTH]
#define         Jan                                     1
#define         Feb                                     2
#define         Mar                                     3
#define         Apr                                     4
#define         May                                     5
#define         Jun                                     6
#define         Jul                                     7
#define         Aug                                     8
#define         Sep                                     9
#define         Oct                                     10
#define         Nov                                     11
#define         Dec                                     12

//[PRINTER_STATUS]
#define         OnLine                                  1
#define         OffLine                                 2
#define         PaperPrinterErr                         3
#define         OpenPortfail                            4
#define         LseekFail                               5
#define         Unknown                                 6
#define         OpenSpoolDirFail                        7
#define         UsingLPRPrinter                         8

//[SCANDISK_STATUS]
#define         CannotScan                              1
#define         ScandiskStopped                         2
#define         ScandiskTerminated                      3   
#define         ScandiskCompletedNoError                4
#define         PrepareErr                              5
#define         PrepareOk                               6
#define         ScanNoEnoughSpace                       7
#define			NoEnoughSpace							7

#define		SCANDISK_STR								8
#define		FORMAT_STR									9

//[SERVER_STATUS]
#define         UnavailableBusy                         1
#define         Unavailable                             2               
#define         Available                               3
                                                        
//[SETUP_ERR]                                           
#define         READ_TCPIP_ERR                          1
#define         READ_DHCP_ERR                           2
#define         READ_SAMBA_ERR                          3
#define         READ_SYSINFO_ERR                        4               
#define         READ_SYSTIME_ERR                        5               
#define         READ_NOTIFY_ERR                         6
#define         READ_SYSSCHL_ERR                        7               
#define         READ_SYSSHUT_ERR                        8               
#define         READ_IDLEHD_ERR                         9
#define         READ_DISKNO_ERR                         10
#define         READ_DISKINFO_ERR                       11              
#define         READ_PRATITION_ERR                      12              
#define         READ_DISKSTATUS_ERR                     13              
#define         READ_PRINTER_ERR                        14              
#define         READ_PNINTERSTATUS_ERR                  15              
                                                                        
#define         SAVE_TCPIP_ERR                          16
#define         SAVE_DHCP_ERR                           17
#define         SAVE_SAMBA_ERR                          18
#define         SAVE_SERVERNAME_ERR                     19
#define         SAVE_SYSTIME_ERR                        20
#define         SAVE_NOTIFY_ERR                         21
#define         SAVE_SYSSCHL_ERR                        22
#define         SAVE_SYSSHUT_ERR                        23
#define         SAVE_IDLEHD_ERR                         24
                                                        
#define         INPUT_ERR                               25
#define         RUN_DEAMON_ERR                          26
                                                        
#define         SAVE_IP_BLANK                           27
#define         SAVE_IP_INVALID                         28
#define         SAVE_MASK_BLANK                         29
#define         SAVE_MASK_INVALID                       30
#define         SAVE_GW_INVALID                         31
#define         SAVE_DNS1_INVALID                       32
#define         SAVE_DNS2_INVALID                       33
#define         SAVE_DNS3_INVALID                       34
#define         SAVE_DHCP_START_INVALID                 35
#define         SAVE_DHCP_END_INVALID                   36
#define         SAVE_DHCP_BLANK                         37
#define         SAVE_DHCP_RANGE                         38
#define         SERVER_NAME_ERR                         39
#define         SERVER_NAME_BLANK                       40
#define         SERVER_NAME_NUM                         41
#define         SERVER_NAME_DBCS                        52
                                                        
#define         SERVER_COMMENT_ERR                      42
#define         SERVER_COMMENT_DBCS                     52
            
#define         WORKGROUP_ERR                           43
#define         WORKGROUP_BLANK                         44
#define         WORKGROUP_DBCS                          52
                                                        
#define         PRN_NAME_ERR                            45
#define         PRN_NAME_BLANK                          46
#define         PRN_NAME_DBCS                           52

#define         WINS_IP_BLANK                           47
#define         WINS_IP_ERR                             48
            
#define         EMAIL_ADDR_FORMAT                       49
#define         EMAIL_ADDR_ERR                          50
#define         EMAIL_ADDR_DBCS                         52
                                                        
#define         EMAIL_SUBJ_ERR                          51
#define         EMAIL_SUBJ_DBCS                         52
            
#define         INVALID_PORT_NUM                        53
#define         PORT_RANGE_ERR                          54
#define         SAVE_WEB_ERR                            55
#define         PORT_RESERVED_ERR                       56
            
#define         SAVE_GUEST_ERR                          57
#define         SAVE_PRINTER_ERR                        58
            
#define         READ_SHUT_SCHL_ERR                      59
#define         SAVE_SHUT_SCHL_ERR                      60
                                                        
#define         READ_RESTART_SCHL_ERR                   61
#define         SAVE_RESTART_SCHL_ERR                   62
            
#define         SAVE_FTP_SERVER_ERR                     63
#define         SAVE_UPNP_ERR                           64
#define         SAVE_HTTPS_ERR                          65
            
#define         READ_NTP_ERR                            66
#define         SAVE_NTP_ERR                            67

#define		ILLEGAL_UPNP_NAME			68
#define		ILLEGAL_BROAD_NAME			69

#define		ILLEGAL_ITUNE_PORT			70
#define		ILLEGAL_UPNP_PORT			71
#define		ILLEGAL_BROAD_PORT			72

#define		BLANK_ITUNE_NAME			73
#define		BLANK_ITUNE_PORT			74
#define		NO_ITUNE_SHARE				75

#define		BLANK_BROAD_NAME			76
#define		BLANK_BROAD_PORT			77
#define		NO_BROAD_SHARE				78
#define		BAD_UPNP_AV_PATH			79
#define		BAD_BROADCAST_PATH			80
#define		BAD_ITUNE_PATH				81
#define		ILLEGAL_ITUNE_NAME			82

#define		INVALID_SMTP_PORT_NUM		90
#define		SMTP_PORT_RANGE_ERR			91

#define		BAD_UPNP_AV_PATH_1			92
#define		BAD_UPNP_AV_PATH_2			93
#define		BAD_UPNP_AV_PATH_3			94
#define		BAD_UPNP_AV_PATH_4			95
#define		HTTP_PORT_RESERVED_ERR		96	//Error: Specified HTTP Port Number has been used by another service.
#define		SMTP_PORT_RESERVED_ERR		97	//Error: Specified SMTP Port Number has been used by another service.
#define		FTP_PORT_RESERVED_ERR		98	//Error: Specified FTP Port Number has been used by another service.
#define		TEST_MAIL_FAIL				99	//Test mail failed to be sent to E-Mail Address (%d).
#define		TEST_MAIL_OK				100	//Test mail was sent to E-Mail Address (%d).
#define		READ_DDNS_ERR				101	//Error: Fail to read settings of DDNS.
#define		SAVE_DDNS_ERR				102	//Error: Fail to write settings of DDNS.
#define		SAVE_RECYCLE_ERROR			103	//Error: Fail save settings of "Recycle Bin".

#define		BAD_BROADCAST_PATH_1		104
#define		BAD_ITUNE_PATH_1			105


#define		BAD_PHOTO_ALBUM_PATH		106
#define		BAD_PHOTO_ALBUM_PATH_1		107

#define		BAD_ALBUM_MUSIC_PATH		108
#define		BAD_ALBUM_MUSIC_PATH_1		109

#define		INVALID_FTP_CONTROL_PORT_NUM	110	//Error: Illegal character or characters in the FTP Control Port.
#define		INVALID_FTP_DATA_PORT_NUM		111	//Error: Illegal character or characters in the FTP Data Port.
#define		FTP_CONTROL_PORT_RANGE_ERR		112	//Error: FTP Control Port must be 21 or between 1024 and 65535.
#define		FTP_DATA_PORT_RANGE_ERR			113	//Error: FTP Data Port must be 20 or between 1024 and 65535.
#define		FTP_CONTROL_PORT_RESERVED_ERR	114	//Error: Specified FTP Control Port has been used by another service.
#define		FTP_DATA_PORT_RESERVED_ERR		115	//Error: Specified FTP Data Port has been used by another service.

#define		INVALID_PASSIVE_START_PORT_NUM		116	//Error: Illegal character or characters in the Start Port of Port Range of Passive Mode.
#define		INVALID_PASSIVE_END_PORT_NUM		117	//Error: Illegal character or characters in the End Port of Port Range of Passive Mode.
#define		FTP_PASSIVE_START_PORT_RANGE_ERR	118	//Error: Start Port of Port Range of Passive Mode must be between 1024 and 65535.
#define		FTP_PASSIVE_END_PORT_RANGE_ERR		119	//Error: End Port of Port Range of Passive Mode must be between 1024 and 65535.
#define		FTP_PASSIVE_PORT_RANGE_ERR			120	//Error: Port Range of Passive Mode must be include 50 ports at least.

#define		SSH_ENABLED_STATUS				125 //SSH Server is enabled and port is %d.
#define		SSH_DISABLED_STATUS				126 //SSH Server is disabled.
#define		SSH_DISABLE_FAIL				127 //Failed to disable SSH Server.
#define		SSH_ENABLED_FAIL				128 //Failed to enable SSH Server.

//#define		BAD_PHOTO_ALBUM_PATH_NTFS		130		//Error: Selected Cont is readonly, cannot 

//[SHARE_ERR]
#define         GetShareListErr                         1
#define         GetShareNumErr                          2
#define         GetShareGrpErr                          3
#define         AddShareErr                             4
#define         UpdateShareErr                          5
#define         DelShareErr                             6
#define         AddShareGrpsErr                         7
#define         DelShareGrpsErr                         8
#define         DelReservedShErr                        9
#define         RenReservedShErr                        10
#define         ExistedShareErr                         11
#define         IllegalShareCharErr                     12
#define         IllegalShareCommCharErr                 13
#define         IllegalShareDirCharErr                  14
#define         FolderSharedErr                         15
#define         ShareDirTooLongErr                      16
#define         NameReservedErr                         17
#define         TooManyShareErr                         18
#define         ModHDDShareErr                          19
#define         DelDefaultShErr                         20
#define         DISK2IsFlashErr                         22
#define         CHANGE_DEF_SH_GRP                       23
#define         BAD_SHARE_LOCATION                       24

//[SHOW_DEFRAG]
#define         NoDefragInProgress                      1
#define         DefragCompleted                         2
#define         DefragTerminated                        3
#define         DefragInProgress                        4
#define         DefragNA                                5
#define         DefragError                             6
#define         DefragAborted                           7

//[SHOW_PREPARE]
#define         DiskNotInstall                          1
#define         DiskNotPrepared                         2
#define         DiskPrepared                            3
#define         DiskPrepareInProgress                   4
#define         DiskPrepareError                        5
#define			DiskNA									6
#define			FORMAT_USB_FAIL							7
#define			FORMAT_USB_OK							8
#define			FORMAT_EJECT_USB						9
#define			FORMAT_USB_BUSY						10
#define			USB_EJECTED								11
//[SHOW_SCANDISK]
#define         ShowScandiskNA                          1
#define         ShowNoScanInProgress                    2
#define         ShowScandiskCompleted                   3
#define         ShowScandiskTerminated                  4
#define         ShowScandiskInProgress                  5

#if 0
//[SHOW_SMART]
#define         ShowSmartNA                             1
#define         ShowSmartNotTested                      2
#define         ShowSmartTestOk                         3
#define         ShowSmartErrors                         4
#define         ShowSmartTesting                        5
#endif
//[SHUTDOWN_HDD]
#define         Never                                   1
#define         Idle10m                                 2
#define         Idle30m                                 3
#define         Idle1h                                  4
#define         Idle2h                                  5

//[SYSTEM_LOG]
#define         LOG_REBOOT                              1
#define         LOG_SHUTDOWN                            2
#define         LOG_RESTORE                             3

//[TELNET_STATUS]
#define         TelnetEnabled                           1
#define         TelnetDisabled                          2
#define         EnableTelnet                            3
#define         DisableTelnet                           4

//[TIMEZONE]
#define         TimeZone0                               1
#define         TimeZone1                               2
#define         TimeZone2                               3
#define         TimeZone3                               4
#define         TimeZone4                               5
#define         TimeZone5                               6
#define         TimeZone6                               7
#define         TimeZone7                               8
#define         TimeZone8                               9
#define         TimeZone9                               10
#define         TimeZone10                              11
#define         TimeZone11                              12
#define         TimeZone12                              13
#define         TimeZone13                              14
#define         TimeZone14                              15
#define         TimeZone15                              16
#define         TimeZone16                              17
#define         TimeZone17                              18
#define         TimeZone18                              19
#define         TimeZone19                              20
#define         TimeZone20                              21
#define         TimeZone21                              22
#define         TimeZone22                              23
#define         TimeZone23                              24
#define         TimeZone24                              25
#define         TimeZone25                              26
#define         TimeZone26                              27
#define         TimeZone27                              28
#define         TimeZone28                              29
#define         TimeZone29                              30
#define         TimeZone30                              31
#define         TimeZone31                              32
#define         TimeZone32                              33
#define         TimeZone33                              34
#define         TimeZone34                              35
#define         TimeZone35                              36
#define         TimeZone36                              37
#define         TimeZone37                              38
#define         TimeZone38                              39
#define         TimeZone39                              40
#define         TimeZone40                              41
#define         TimeZone41                              42
#define         TimeZone42                              43
#define         TimeZone43                              44
#define         TimeZone44                              45
#define         TimeZone45                              46
#define         TimeZone46                              47
#define         TimeZone47                              48
#define         TimeZone48                              49
#define         TimeZone49                              50
#define         TimeZone50                              51
#define         TimeZone51                              52
#define         TimeZone52                              53
#define         TimeZone53                              54
#define         TimeZone54                              55
#define         TimeZone55                              56
#define         TimeZone56                              57
#define         TimeZone57                              58
#define         TimeZone58                              59
#define         TimeZone59                              60
#define         TimeZone60                              61
#define         TimeZone61                              62
#define         TimeZone62                              63

//[UPGRADE_STATUS]
#define         UpgradingNow                            1
#define         Uploading                               2
#define         Uploading100                            3
#define         ErrorInUpgrading                        4
#define         BadFileName                             5       
#define         UpgradeOK                               6
#define         RestoreOk                               7
#define         RestartServer                           8
#define         UploadFile                              9
#define         SystemBusy                              10
#define         UploadNoEnoughSpace                     11
#define			BAD_RESTORE_FILE		12
#define			RESTORE_DEFAULT_ERR		13
#define			RESTORE_DEFAULT_OK		14

//[USER_ERR]
#define         GetUserListErr                          1
#define         GetUserNumErr                           2
#define         GetUserGroupSErr                        3
#define         AddUserToGrpsErr                        4
#define         DelUserFromGrpsErr                      5
#define         AddUserErr                              6
#define         DelUserErr                              7
#define         UpdateUserErr                           8
#define         DelReservedUserErr                      9
#define         RenReservedUserErr                      10
#define         IllegalUserCharErr                      11
#define         IllegalCommCharErr                      12
#define         ExistedUserErr                          13
#define         TooManyUserErr                          14
#define         DelUsrReservedGrpErr                    15
#define         GuestUserErr                            16
#define         UserPassErr                             17
#define         IllegalQuotaCharErr                     18
#define         SpaceErr                                19
#define         ChangeDriverErr                         20
#define         NestyShareErr                           21
#define         SameDestShareExistErr                   22
#define         SameGroupExistErr                       23
#define         SameShareExistErr                       24
#define         RenameUserName                          25
#define         NestyDestShareErr                       26

//[WEB_SHARE]
#define         DirTooLong                              1
#define         DirNotExist                             2
#define         TYPE_FOLDER                             3
#define         TYPE_SHARE                              4
#define         TYPE_FILE                               5
#define         IMAGE_ALT                               6
#define         BADUSER                                 7

//[NTP_SECTION]
#define		MEMORY_ERR                                      1       //No more memory
#define		RESOLVE_HOST_ERR                                2       //get host failed
#define		OPEN_SOCKET_ERR                                 3       //socket failed
#define		BIND_SOCKET_ERR                                 4       //can't bind the socket to the NTP port
#define		SET_NONBLOCKING_ERR                             5       //set non-blocking failed
#define		ADJUST_TIME_ERR                                 6       //no suitable server found for synchronization
#define		NO_SERVER_ERR                                   7       //No servers found
#define		SYNC_FAIL                                       8       //Sync fal 
#define		SYNC_OK                                         9
#define		NTP_NOT_ENABLE                                  10
#define		SERVER_ILLEGAL_CHAR                             11

     

//[DISKSTATUS]                            
#define         DISKSTATUS                              "status"
#define         SCAN_STATUS1                            "scandisk_1"
#define         SCAN_STATUS2                            "scandisk_2"
#define			SCAN_STATUS3							"scandisk_3"
#define         SMART_STATUS1                           "smart_1"
#define         SMART_STATUS2                           "smart_2"
#define         DEFRAG_STATUS1                          "defrag_1"
#define         DEFRAG_STATUS2                          "defrag_2"
#define         UNDO                                    0
#define         DOING                                   1
#define         COMPLETED                               2
#define         SCAN_ERROR                              3
#define         TERMINATED                              4
                                          
                                          
//------------- Error message index in     sys_msg  file -------------
//[DISK_SPACE]                            
#define         DSK_STATFS_ERR                          1
#define         DSK_OPEN_FILE_ERR                       2
#define         DSK_WRITE_FILE_ERR                      3
#define         DSK_ALMOST_FULL                         4
#define         DSK_DISK_FULL                           5
                                          

//[CAMERA_ERR]
#define		READ_CAMERA_ERR			1
#define		DETECT_ERR				2
#define		SAVE_ERR				3


#define		NO_HARDDISK						1
#define		HD_INVALID						2
#define		BACKUPSTART						3
#define		BACKUPCOMPLETED					4
#define		UPGRADINGWARNING				5
#define		PREPARINGWARNING				6
#define		SMARTINGWARNING					7
#define		SCANNINGWARNING					8
#define		DEFRAGINGWARNING				9
#define		MOVINGWARNING	                10


#define		NoHardDisk				8
#define		BACKUPING				5
#define		MOVING					7
#define		DRIVEBACKUPING			10

//[MESSAGES]
#define		MODEL_NAME	1
#define		STRING_USER				2
#define		MESSAGE_NEVER			3
#define		MESSAGE_TO_OTHER		4
#define		MESSAGE_OTHER_TO		5
#define		MESSAGE_WAITING			6
#define		MESSAGE_RUNNING			7
#define		MESSAGE_IDLE			8
#define		MESSAGE_NO_DISK			9
#define		MESSAGE_TOTAL_SPACE		10
#define		MESSAGE_FREE_SPACE		11
#define		MESSAGE_CAPACITY		12
#define		MESSAGE_TO_UPPER_FOLDER	13
#define		MESSAGE_BAD_AUTH		14
#define		MESSAGE_PERM_DENIED		15
#define		MESSAGE_URL_NOT_FOUND	16
#define		MESSAGE_UNUSUAL_ERROR	17
#define		MESSAGE_BAD_REQUEST_ERROR	18
#define		MESSAGE_TEST_MAIL			19
#define		MESSAGE_EJECTED				20
#define		MESSAGE_BUTTON_START		21
#define		MESSAGE_BUTTON_STOP			22
#define		MESSAGE_GO_BACK				23
#define		MESSAGE_FILES				24
#define		MESSAGE_MANAGEMENT			25

#define		MESSAGE_MANAGE_BUSY_ERROR	26
#define		MESSAGE_PHOTO_ALBUM			26
#define		MESSAGE_DOWN_MANAGER		27

#define		MESSAGE_BYTES				28
#define		MESSAGE_USED_BY_RAID1		29
#define		MESSAGE_USED_BY_RAID0		30
#define		MESSAGE_USED_BY_LVM			31
#define		MESSAGE_USED_BY_SEPARATE	32
#define		MESSAGE_USED_BY_RAID1_SOURCE		33
#define		MESSAGE_USED_BY_RAID1_TARGET		34

#define	MESSAGE_NOT_USABLE				35
#define	MESSAGE_MIRROR_RAID1			36
#define	MESSAGE_MUL_LVM					37
#define	MESSAGE_STRIP_RAID0				38

#define	MESSAGE_SCAN_IN_PROGRESS		39
#define	MESSAGE_REBUILD_1TO2			40

#define	MESSAGE_REBUILD_2TO1			41
#define	MESSAGE_REBUILD_2SMALL			42
#define	MESSAGE_REBUILD_1SMALL			43

#define	MESSAGE_CHANGED					44
#define	MESSAGE_REMOVED					45
#define	MESSAGE_DISK_STATUS				46
#define	MESSAGE_ADD_DISK1_TO_LVM		47
#define	MESSAGE_ADD_DISK2_TO_LVM		48
#define	MESSAGE_NOT_READY				49
#define	MESSAGE_RESET_MODE_BUTTON		50
#define	MESSAGE_RESET_MODE_WARNING		51
#define	MESSAGE_RESET_MODE				52

#define	MESSAGE_ROTATE_MINOR90			53
#define	MESSAGE_ROTATE_PLUS90			54
#define	MESSAGE_ZOOM_IN					55
#define	MESSAGE_ZOOM_OUT				56
#define	MESSAGE_PLAY					57
#define	MESSAGE_PAUSE					58
#define	MESSAGE_SAVE					59
#define	MESSAGE_PRINT					60
#define	MESSAGE_BACK					61
#define	MESSAGE_SORT_BY_NAME			62
#define	MESSAGE_SORT_BY_SIZE			63
#define	MESSAGE_SORT_BY_DATE			64
#define	MESSAGE_NEW_FOLDER				65
#define	MESSAGE_SELECT_ALL				66
#define	MESSAGE_UNSELECT_ALL			67
#define	MESSAGE_DELETE					68
#define	MESSAGE_PREVIOUS_PIC			69
#define	MESSAGE_NEXT_PIC				70
#define	MESSAGE_PREVIOUS_PAGE			71
#define	MESSAGE_NEXT_PAGE				72

//[SHOW_SMART]
#define		SMART_NOT_SUPPORTED			1
#define		SMART_NOT_ENABLED			2
#define		SMART_FAILED				3
#define		SMART_OK					4
#define		SMART_LOG_NOT_ENABLED		5
#define		SMART_LOG_NOT_SUPPORTED		6
#define		SMART_LOG_NOT_FAILED		7
#define		SMART_LOG_NOT_FOUND			8
#define		SMART_LOG_OK				9
#define		SMART_NOT_TEST				10
#define		SMART_NO_DISK				11
#define		SMART_DISK_1_ON_GOING		12	//S.M.A.R.T.: Disk 1 is already being tested.
#define		SMART_DISK_2_ON_GOING		13	//S.M.A.R.T.: Disk 2 is already being tested.
   
//[FOLDER_BROWSE]    
#define		ARCHIVE_NO_NAME				1	//Please specify the name of New Folder.
#define		ARCHIVE_FOLDER_EXISTS		2	//New Folder already exists.
#define		ARCHIVE_CREATE_FOLDER_ERR	3	//Fail to create the New Folder.        
#define		ARCHIVE_CREATE_FOLDER_OK	4	//Folder has been created successfully.    

//[DOWNLOAD]
#define ERR_OPENFILE			1	//Error: Faill to open configuration file.
#define	ERR_READFILE			2	//Error: Faill to read configuration file.
#define	ERR_MEMALLOC			3	//Error: Out of memory.
#define	ERR_EXIST				4	//Error: Task of the same URL already exist, cannot add it.
#define	ERR_NOT_EXIST			5	//Error: Task does't exist.
#define	ERR_DOWN_WRITEFILE		6	//Error: Faill to write configuration file.
#define	ERR_PERM				7	//Error: Permission denied.
#define	ERR_MAX_JOBS			8	//Error: Maxmium tasks reach, cannot add more.
#define	ERR_ILLEGAL_SUBDIR		9	//Error: Illegal character or characters in the subdiretory.
#define	ERR_DOWN_DISABLED		10	//Error: Download Manager is disabled.
#define	ERR_BAD_URL				11	//Error: Bad URL.
#define	ERR_BAD_TARGET			12	//Error: Bad format of destination.
#define	ERR_BAD_TORRENT			13	//Error: The .torrent file is bad.
#define	ERR_DOWN_TORRENT_FAIL	14	//Error: Fail to download the torrent file.
        
#define	TASK_STAT_WAITING				15	//Waiting     
#define	TASK_STAT_FAILED				16	//Failed
#define	TASK_STAT_PAUSED				17	//Paused
#define	TASK_STAT_FINISHED				18	//Done
#define	TASK_STAT_TRANSFERING			19	//Transferring
#define	TASK_STAT_CONNECTING			20	//Connecting
#define	TASK_STAT_CONNECTED				21	//Connected
#define	TASK_STAT_HASING				22	//Hashing


#define	DOWN_TASK_START				23	//Download Manager: Task '%s' started.
#define	DOWN_TASK_STOP				24	//Download Manager: Task '%s' was stopped.
#define	DOWN_TASK_FAILED			25	//Download Manager: Task '%s' failed.
#define	DOWN_TASK_FIN				26	//Download Manager: Task '%s' finished.

#define	DOWN_TASK_WITH_FILE_START	27	//Download Manager: Task '%s' with filename '%s' started.
#define	DOWN_TASK_WITH_FILE_STOP	28	//Download Manager: Task '%s' with filename '%s' was stopped.
#define	DOWN_TASK_WITH_FILE_FAILED	29	//Download Manager: Task '%s' with filename '%s' failed.
#define	DOWN_TASK_WITH_FIN			30	//Download Manager: Task '%s' with filename '%s' finished.

#define	ERR_DOWN_QUOTA_LIMIT		31	//Error: Cannot add the task. Disk quota exceeds.
#define	ERR_DOWN_NO_SPACE			32	//Error: Cannot add the task. No enought free disk space exists.
#define	ERR_DOWN_LARGE_FILE			33	//Error: Cannot add the task. The .torrent file includes one file that exceeds FAT filesystem's single file limit(<=4GB).
#define	DOWN_MANAGER_EXIT			34
#define	DOWN_MANAGER_START			35


//[BACKUP]
#define BACKUP_SUCC    			1
#define SMBMOUNT_ERR   			2

#define READFILE_ERR   			3 
#define WRITEFILE_ERR   		4

#define SDIR_ERR    			5
#define DDIR_ERR    			6 

#define SFILE_ERR    			7
#define DFILE_ERR    			8 

#define RM_ERR    				9
#define RMDIR_ERR   			10
#define RMFILE_ERR   			11

#define BACKUP_START   			12
#define SCANDISK_ERR  			13
#define UPGRADE_ERR    			14
#define PREPARE_ERR    			15
#define ERASE_ERR    			16

#define PERMISSION_DENIED		17
#define	NO_SPACE				18
#define	CONN_LOST				19
#define	TOO_MANY_ERR			20
#define	TOO_MANY_RUNNING_JOB	21
#define	NO_HDD					22
#define	NO_FLASH				23
#define	BACKUP_TERM				24

#define	JOB_AUTH_FAIL				25		//FTP Backup: Error occurs in job '%s', fail to login.
#define	JOB_CONN_FAIL				26		//FTP Backup: Error occurs in job '%s', fail to connect to the FTP server.
#define	JOB_ENTER_DIR_FAIL			27	//FTP Backup: Error occurs in job '%s', fail to enter folder '%s'.
#define	JOB_CRE_DIR_FAIL			28	//FTP Backup: Error occurs in job '%s', fail to create folder '%s'.
#define	JOB_LOCAL_DIR_NOT_EXIST		29	//FTP Backup: Error occurs in job '%s', folder '%s' doesn't exist.
#define	JOB_DOWN_FILE_FAIL			30	//FTP Backup: Error occurs in job '%s', fail to download file '%s'.
#define	JOB_UP_FILE_FAIL			31	//FTP Backup: Error occurs in job '%s', fail to upload file '%s'.

//DDNS
#define	DDNS_UPDATE_OK			1	//TZO DDNS: Succeeded to update the IP Address.
#define	DDNS_ACCOUNT_TMP_BLOCK	2	//TZO DDNS: The account has been blocked temporarily.
#define	DDNS_ACCOUNT_EXPIRE		3	//TZO DDNS: The account has expired. The TZO DDNS function will be disabled. Please check your settings
#define	DDNS_GET_CURR_IP_ERR	4	//TZO DDNS: Failed to get the IP Address.
#define	DDNS_UPDATE_ERR			5	//TZO DDNS: Failed to update the IP Address.
#define	DDNS_IP_EQUAL			6	//TZO DDNS: IP Address doesn't change, don't update.
#define	DDNS_CHECK_WAN_IP		7	//TZO DDNS: Check the WAN IP Address for changes.
#define	DDNS_AUTH_FAIL			8	//TZO DDNS: Authentication Failed. The TZO DDNS function will be disabled. Please check your settings.
#define	DDNS_BLOCKED_UPDATES	9	//TZO DDNS: The Domain Name specified is blocked for update abuse. The TZO DDNS function will be disabled.
#define	DDNS_BLOCKED_AGENT		10	//TZO DDNS: The User Agent that was sent has been blocked. The TZO DDNS function will be disabled.
#define	DDNS_ACCOUNT_BLOCKED	11	//TZO DDNS: The account has been blocked. The TZO DDNS function will be disabled. Please check your settings.
#define	DDNS_DOMAIN_BLOCKED		12	//TZO DDNS: The Domain Name specified is blocked because account is suspended by TZO. The TZO DDNS function will be disabled.
#define	DDNS_RESULT_NO_IP				13
#define	DDNS_RESULT_CONN_ERR			14
#define	DDNS_RESULT_SEND_ERR			15
#define	DDNS_RESULT_READ_ERR			16
#define	DDNS_RESULT_BAD_PACKET			17
#define	DDNS_RESULT_IP_NO_CHANGE		18
#define	DDNS_RESULT_UPDATE_OK			19
#define	DDNS_RESULT_ACCOUNT_BLOCK_TMP	20
#define	DDNS_RESULT_AUTH_ERR			21
#define	DDNS_RESULT_DOMAIN_BLOCK_TMP	22
#define	DDNS_RESULT_AGENT_BLOCK			23
#define	DDNS_RESULT_DOMAIN_BLOCK		24
#define	DDNS_RESULT_ACCOUNT_BLOCK		25
#define	DDNS_RESULT_ACCOUNT_EXPIRE		26
#define	DDNS_RESULT_DOMAIN_NOT_EXIST	27
#define	DDNS_RESULT_DOMAIN_ERR			28
#define	DDNS_RESULT_DOMAIN_NOT_USER		29
#define	DDNS_RESULT_UPDATE_FAIL			30

//USB_COPY_SEC
#define	USB_COPY_START		1	//Copy Button: Backup started.
#define	USB_COPY_END		2	//Copy Button: Backup ended.
#define	USB_COPY_NO_SPACE	3	//Copy Button: No disk space left in internal disk.
#define	USB_COPY_FILE_ERR	4	//Copy Button: Failed to copy file '%s'.
#define	USB_COPY_FOLDER_ERR	5	//Copy Button: Failed to copy folder '%s'.
#define	USB_COPY_SPACE_NO_ENOUGH	6	//Copy Button: No enough free space exists in internal disk, backup cannot proceed.
#define	USB_COPY_TARGET_NOT_EXIST	7
#define	USB_COPY_TERMINATED			8	//

//DISK
#define	NO_DISK				1
#define	DISK_EJECTED		2

//PHOTO_ALBUM
#define	ALBUM_NEW_FOLDER				1
#define	ALBUM_FILE_NOT_EXIST			2
#define	ALBUM_FILE_ALREADY_EXIST		3
#define	ALBUM_DISABLED					4
#define	ALBUM_PER_DENIED				5
#define	ALBUM_FOLDER_NOT_EXIST			6

//DISK
#define HDD_1_REMOVED	1	//Disk 1 was removed.
#define	HDD_2_REMOVED	2	//Disk 2 was removed.
#define	HDD_1_ATTACHED	3	//Disk 1 was attached.
#define	HDD_2_ATTACHED	4	//Disk 2 was attached.
#define	HDD_1_FAILED	5	//Disk 1 failed.
#define	HDD_2_FAILED	6	//Disk 2 failed.

#endif                            
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
                                          
