/*
Copyright (C) 2003-2004 Narcis Ilisei

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* 
	Small cmd line program useful for maintaining an IP address in a Dynamic DNS system.
	
	Author: Narcis Ilisei
	Date: April 2003
	
	History:
		May 1 2003 - project begin.
			- intendend to be used only with dyndns.org service
		May 8 2003 - ver. 0.9
			- first version - hard coded parameters
		May 18 2003 : ver. 0.95
			- cmd line option parsing added.
        June 2003
            - pSOS support added.
            - no DNS lookup supported -> IPs of the server as parameters			
        November 2003 
            - makefile review
            - DBG print modified  
		History not updated anymore. See readme.  		
*/
#define MODULE_TAG "INADYN: "
#include "debug_if.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "errorcode.h"
#include "dyndns.h"
#include "cgi_err.h"
#include "PRO_file.h"
#include "LOG_log.h"

int LockFile(void)
{
	int fd;
	fd = open("/tmp/tzo.lck",O_WRONLY|O_CREAT|O_EXCL,0666);
	if(fd == -1)
		return -1;
	close(fd);
	return 0;
}

void UnLockFile(void)
{
	unlink("/tmp/tzo.lck");
}

/* MAIN - Dyn DNS update entry point.*/
int inadyn_main(int argc, char* argv[])
{
	RC_TYPE rc = RC_OK;
	DYN_DNS_CLIENT *p_dyndns = NULL;
	char log_msg[1][128]={{0}};
	
	if(LockFile())
		return -1;	
	do
	{
		/* create DYN_DNS_CLIENT object	*/
		rc = dyn_dns_construct(&p_dyndns);
		if (rc != RC_OK)
		{
			PRO_GetMsgByIndex(DDNS_ERROR,DDNS_UPDATE_ERR,1,log_msg,ERRMSG_FILE);
			LOG_LogMsg ("DDNS",LOG_LEVEL_3,log_msg[0]);				
			break;
		}    
		rc = dyn_dns_main(p_dyndns, argc, argv);
	}
	while(0);

	/* end of program */
	if (rc != 0)
	{
		//print_help_page();
		/* log error*/	
		DBG_PRINTF((LOG_WARNING,"W:" MODULE_TAG "Main: Error '%s' (0x%x).\n", errorcode_get_name(rc), rc));
	}
	
	/* destroy DYN_DNS_CLIENT object*/
	rc = dyn_dns_destruct(p_dyndns);
	if (rc != RC_OK)
	{
		DBG_PRINTF((LOG_WARNING,"W:" MODULE_TAG "Main: Error '%s' (0x%x) in dyn_dns_destruct().\n", errorcode_get_name(rc), rc));
	}
	 
	os_close_dbg_output();
	UnLockFile();
	return (int) rc;

}

