#ifndef _CONSTANT_H_
#define _CONSTANT_H_
#include "fsh_err.h"
   
#define DSK_NUM                                     5

#define	SATA_DISK_1									0
#define	SATA_DISK_2									(SATA_DISK_1+1)
#define	USB_DISK_1									(SATA_DISK_2+1)
#define	USB_DISK_2									(USB_DISK_1+1)
#define FIRST_DSK                                   SATA_DISK_1
#define SECOND_DSK                                  SATA_DISK_2

#define MAX_ATTACH_DEV								2 //Maximum Number of Supported USB Devices

/*-------------------------------------------------------------------------------------------*/
#define DSK_TYPE_SATA								0                           /* SATA HDD */
#define DSK_TYPE_USB								1                           /* USB HDD */

/*----------------------------------------------------------*/
#define DISK1_PUB_NAME      "DISK (Public Data)"
#define DISK2_PUB_NAME      "Public Data"
//"USB FLASH/HDD"
/*----------------------------------------------------------*/

/* 
 * normal mode means we will save config file to this HDD,
 * while share mode means we ONLY share the partitions in this HDD.
 */
#define DSK_MODE_NORMAL                             0
#define DSK_MODE_SHARE                              1
/*-------------------------------------------------------------------------------------------*/
#define DSK1_MODE                                   DSK_MODE_NORMAL
#define DSK2_MODE                                   DSK_MODE_SHARE

/*-------------------------------------------------------------------------------------------*/

/*
 * For historical reason, we should combine these two values
 *  
 *  Disk is not installed                   :       valid    ==   VALID_NOT_READY
 *                                                  invalid  ==   INVALID_NO_DISK
 *
 *  Disk is installed but not ready to use  :       valid    ==   VALID_NOT_READY
 *                                                  invalid  ==   INVALID_INSTALLED
 *
 *  Disk is ready to use                    :       valid    ==   VALID_READY
 *                                                  invalid  ==   INVALID_NO_DISK
 *
 *  Disk is in backup mode                  :       valid    ==   VALID_BACKUP
 *                                                  invalid  ==   INVALID_NO_DISK
 */
#define VALID_NOT_READY                             0
#define VALID_READY                                 1
#define VALID_BACKUP                                2

#define INVALID_NO_DISK                             0
#define INVALID_INSTALLED                           1

#define SWAP_SIZE                                   262144          //K (256M)

#define LINE_SIZE                                   256
#define FSH_MaxUser                                 255
#define FSH_MaxGroup                                255
#define FSH_MaxShare                                255
#define	FSH_MaxWINPassLen							128
                                                  
#define FSH_MaxUserLen                              20
#define FSH_MaxShareLen                             20
#define FSH_MaxGroupLen                             20
#define FSH_MaxCommentLen                           48
#define FSH_MaxDirLen                               256
#define FSH_MaxPassLen                              15
#define FSH_MaxIPLen                                16
#define FSH_MaxSererNameLen                         20
#define FSH_MaxWorkGroupLen                         16
#define FSH_MaxZoneLen                              32
#define FSH_MaxPrinterLen                           20
#define FSH_MaxEnableLen                            4                       //"yes","no"
#define FSH_DefaultCodePage                         437
#define FSH_ADMINISTRATOR_GID                       500
#define FSH_EVERYONE_GID                            501
                                                    
#define FSH_ADMIN_UID                               500
#define FSH_GUEST_UID                               501
#define FSH_ADMINISTRATOR_UID                       502

#define	HIDDEN_FILE_FOLDERS							"/.AppleDB/.AppleDouble/.AppleDesktop/.DS_Store/:2eDS_Store/Network Trash Folder/Temporary Items/$AttrDef/$BadClus/$Bitmap/$Boot/$Extend/$LogFile/$MFT/$MFTMirr/$Secure/$UpCase/$Volume/lost+found/System Volume Information/.Thumb_DB/"

#define	FSH_ILLEGAL_SERVER_NAME_CHAR				"\"/\\[]:;|=.,+*?<> '`()#$%"
#define	FSH_ILLEGAL_SERVER_COMM_CHAR				"|:,\\'\""
#define FSH_ILLEGAL_ZONE_CHAR                       "\\]/\">[<.:;,|=+?`'"
#define FSH_ILLEGAL_WG_CHAR                         "\"/\\[]:;|=.,+*?<>"
#define FSH_ILLEGAL_PRINTER_CHAR                    "/\\[]:;|=., +*?<>'`\""
#define FSH_SPECIAL_CHAR                            "\"$\\`"
#define	FSH_MEDIA_SERVICE_NAME_CHAR					"\"/\\[]:;|=,+*?<>`()#$%"
#define	ILLEGAL_USER_CHAR							"\"/\\[]:;|=.,+*?<>'`"
#define	ILLEGAL_USER_COMM_CHAR						"|\\:\",\'"
#define	ILLEGAL_GROUP_CHAR							"\"/\\[]:;|=.,+*?<>'`$%@"
#define	ILLEGAL_SHARE_CHAR							"\"/\\[]:;|=.,+*?<>'`$%@"	// ###1 start
#define	ILLEGAL_FOLDER_CHAR							"\\:*?\"<>|'`"
#define	ILLEGAL_SHARE_COMM_CHAR						"\\:,|\'\""
#define	BACKUP_ILL_JOBNAME_CHAR						"`~!@#$%^&*()+=\\{}[];:'\",/<>?"
#define	BACKUP_ILL_HOSTNAME_CHAR					"`~!@#$%^&*()+=\\{}[];:'\",./<>?"
#define	BACKUP_ILL_USER_CHAR						"\"/[]:;|=,+*?<>'`"
#define	BACKUP_ILL_FOLDER_CHAR						":*?\"<>|'`"
#ifdef __FTP_BACKUP__
#define	BACKUP_ILL_FTP_SERVER_CHAR					"`~!#$%^&*()+=\\{}[];:'\",./<>?"
#endif		
#define	ILLEGAL_EMAIL_ADDR_CHAR						"\"/\\[]:;|=,+*?<>'`"
#define	ILLEGAL_EMAIL_SUBJECT_CHAR					"\"/\\[]:;|=.,+*?<>'`"
#define ILLEGAL_NTP_SERVER_CHAR						"\"/\\[]:;|=,+*?<>'`"
			
#define FLAG                                        ".ns65"

#define FSH_DEV_HD1                                 "/dev/sda"
#define FSH_DEV_HD2                                 "/dev/sdb" 
#define FSH_DEV_HD3                                 "/dev/sdc" 
#define FSH_DEV_HD4                                 "/dev/sdd" 
                                                    
#define FSH_MNT_ROOT                                "/harddisk"
#define FSH_HD1_NAME                                "volume_1"
#define FSH_HD2_NAME                                "volume_2"
#define FSH_USB1_NAME                                "volume_3"
#define FSH_USB2_NAME                                "volume_4"
#define FSH_DATA_NAME                               "data"
#define FSH_CONF_NAME                               "conf"

#define FSH_FLASH_SHARE			"FLASH"
#define FSH_HARD_SHARE			"HDD"
#define	FSH_WIN_SHARE_CONF		"/etc/win_share.info"
#define FSH_USER_SMB_CONF		"/etc/samba/user_smb.conf"

#define FSH_NFS_CONF			"/etc/nfs.info"
                                         
#define FSH_MNTHD1                                  FSH_MNT_ROOT"/"FSH_HD1_NAME              /* /harddisk/hd~2           */
#define FSH_MNTHD1_DATA                             FSH_MNTHD1"/"FSH_DATA_NAME               /* /harddisk/hd~2/data      */
#define FSH_MNTHD1_CONF                             FSH_MNTHD1"/"FSH_CONF_NAME               /* /harddisk/hd~2/conf      */
#define FSH_MNTHD1_SHARE_CONF                       FSH_MNTHD1_CONF"/share/share.info"       /* /harddisk/hd~2/conf/share/share.info */
#define FSH_MNTHD1_SMB_CONF                         FSH_MNTHD1_CONF"/share/smb.conf"         /* /harddisk/hd~2/conf/share/smb.conf */
#define FSH_MNTHD1_MAGIC                            FSH_MNTHD1_CONF"/"FLAG                   /* /harddisk/hd~2/conf/.g2_flag  */
#define FSH_MNTHD1_SHARE_SPOOL                      FSH_MNTHD1_CONF"/share/spool"                 /* /harddisk/hd~2/share/spool  */
#define FSH_MNTHD1_WEB_STATION                      FSH_MNTHD1_DATA"/web_station"
                                                    
#define FSH_MNTHD2                                  FSH_MNT_ROOT"/"FSH_HD2_NAME              /* /harddisk/hd~3         */
#define FSH_MNTHD2_DATA                             FSH_MNTHD2"/"FSH_DATA_NAME               /* /harddisk/hd~3/data    */
#define FSH_MNTHD2_CONF                             FSH_MNTHD2"/"FSH_CONF_NAME               /* /harddisk/hd~3/conf    */
#define FSH_MNTHD2_SHARE_CONF                       FSH_MNTHD2_CONF"/share/share.info"       /* /harddisk/hd~3/conf/share/share.info */
#define FSH_MNTHD2_SMB_CONF                         FSH_MNTHD2_CONF"/share/smb.conf"         /* /harddisk/hd~3/conf/share/smb.info */
#define FSH_MNTHD2_MAGIC                            FSH_MNTHD2"/"FLAG                        /* /harddisk/hd~3/.g2_flag */
#define FSH_MNTHD2_SHARE_SPOOL                      FSH_MNTHD2_CONF"/share/spool"                 /* /harddisk/hd~3/share/spool  */

#define FSH_MNTHDVOL_SHARE_SPOOL                     "/harddisk/volume_5/conf/share/spool"                 /* /harddisk/hd~3/share/spool  */

#define	FSH_MNT_PREFIX			FSH_MNT_ROOT"/volume_%d"
#define FSH_DISK_1_FLAG			FSH_MNT_ROOT"/"FSH_HD1_NAME"/"FSH_CONF_NAME"/"FLAG
#define FSH_DISK_2_FLAG			FSH_MNT_ROOT"/"FSH_HD2_NAME"/"FSH_CONF_NAME"/"FLAG
#define FSH_VOL_1_FLAG			"/harddisk/volume_5/conf/"FLAG

#define TMPFILE_MODE			"/tmp/tmpfile.XXXXXX"

#define FSH_TMP_MODE			FSH_MNT_PREFIX"/"FSH_CONF_NAME"/"TMPFILE_MODE
#define FSH_DISK_1_TMP			FSH_MNT_ROOT"/"FSH_HD1_NAME"/"FSH_CONF_NAME"/"TMPFILE_MODE
#define FSH_DISK_2_TMP			FSH_MNT_ROOT"/"FSH_HD2_NAME"/"FSH_CONF_NAME"/"TMPFILE_MODE
#define FSH_VOL_1_TMP			"/harddisk/volume_5/conf/tmp/tmpfile.XXXXXX"

#define	DOWNLOAD_FOLDER			FSH_MNT_PREFIX"/"FSH_CONF_NAME"/downloads"
#define	TORRENT_FOLDER			DOWNLOAD_FOLDER"/torrent"                                                  


#define AFPD_NAME				    "afpd.conf"
#define AFP_NAME				    "AppleVolumes.conf"
#define FSH_AFPD_CONF				    "/etc/netatalk/"AFPD_NAME
#define FSH_AFP_CONF				    "/etc/netatalk/"AFP_NAME

#define LOG_FILE                                    "/var/log/server.log"
#define DISK_1_LOG_FILE								FSH_MNTHD1_CONF"/server.log"
#define DISK_2_LOG_FILE								FSH_MNTHD2_CONF"/server.log"
#define	DISK_VOL_LOG_FILE							"/harddisk/volume_5/conf/server.log"                                                    
#define FSH_SMB_CONF                                "/etc/samba/smb.conf"
#define FSH_DISK_GROUP_INFO                         "/etc/usrgrp.info"
#define FSH_SHARE_CONF                              "/etc/share.info"
#define FSH_SHARE_CONF_NAME                         "share.info"
#define FSH_NETWORK_SEC                             "network"
#define FSH_SYS_PASSWD                              "/etc/passwd"
#define FSH_SMB_PASSWD                              "/etc/samba/smbpasswd"
#define FSH_WEB_PASSWD                              "/home/httpd/html/Management/.htpasswd"
#define FSH_SYS_GROUP                               "/etc/group"
#define FSH_DS_CONF_FILE                            "/etc/CGI_ds.conf"
#define FSH_DEF_DS_CONF_FILE                        "/usr/local/CGI_ds.conf"
#define FSH_QUOTA_TMPFILE                           "/tmp/edquota.tmp"
#define FSH_XINETD_FTP_CONF                         "/usr/local/xinetd.d/ftp"
#define FSH_INETD_CONF                              "/etc/inetd.conf"
#define FSH_PASSWD_SALT                             "sc"
#define FSH_EVERYONE_GRP                            "everyone"
#define FSH_SPOOL                                   "/var/spool"
#define FSH_SHARE_SPOOL                             "/var/spool/print"
#define FSH_SHARE_BAK_CONF                          "/usr/local/share.info.1"
                                                    
#define FSH_ADMIN_GRP                               "administrators"
#define FSH_ADMINISTRATOR_USER                      "admin"
#define FSH_ADMINISTRATOR_PASSWD                    ""
#define FSH_GUEST_USER                              "guest"
#define FSH_HDD_SHARE                               "ADMIN"
#define FSH_PUBLIC_SHARE                            "DISK"
#define FSH_FLASH_SHARE                             "FLASH"
#define FSH_DEFAULT_PASS                            "zGf8Ikl50e3aPM"
#define FSH_RESERVED_SHARE1                         FSH_HDD_SHARE
#define FSH_RESERVED_SHARE2                         FSH_PUBLIC_SHARE

#define FSH_THTTPD_HDD                              "HDD"
#define FSH_THTTPD_USB_FLASH                        "SHARE"

#define FSH_MNT_DIR_HDD                             "harddisk"
#define FSH_MNT_DIR_USB_FLASH                       "share"

//Backup file flag
#define fPass                                       1                               //passwd
#define fGrp                                        2                               //group
#define fShare                                      4                               //share.info
#define fUser                                       8                               //usrgrp.info
#define fSmb                                        0x10                            //smb.conf
#define fSmbPass                                    0x20                            //smbpasswd
#define fWebPass                                    0x40                            //.htpasswd
#define fGroups                                     (fGrp|fUser|fShare|fSmb)
#define fUsers                                      (fPass|fGrp|fUser|fSmbPass)
#define fShares                                     (fSmb|fShare)

#define UID_Start                                   2000
#define GID_Start                                   2000


/* Network Default */
#define DEF_NET_IPADDR                              "192.168.0.100"
#define DEF_NET_NETMASK                             "255.255.255.0"
#define DEF_NET_BOOTPROTO                           "static"

#define DEF_NAME_PREFIX                             "GNS2000_"
#define DEF_NAME_LEN                                (strlen(DEF_NAME_PREFIX)+6)	    /* default server name length: SCxxxxxx */
#define DEF_SMB_WORKGROUP                           "workgroup"     /* default value */
#define DEF_SMB_PRINTERNAME_LEN                     (DEF_NAME_LEN)             /* SCxxxxxx_p1 */
#define DEF_SMB_PRINTERNAME                         "lp"
#define DEF_SMB_CODEPAGE                            "437"           /* English */
#define DEF_SMB_RESOLVEORDER                        "wins bcast"

/* FLASH SIZE (MB) */
#define BIN_SIZE                                    16

#define CASE_SENSITIVE                              0
#define CASE_INSENSITIVE                            1

#endif /* _CONSTANT_H_ */

