# diff.mk for multi-oem-modules
# MODULE_NAME and VENDOR_NAME must be defined in diff.h

#MODULE_NAME		:=      NS65
MODULE_NAME     	:=      NR65S

#Only for NR65S
VENDOR_NAME		:=    	LEVEL_ONE

# Ramdisk size ( KBytes )
#---------------------------------------------------
RAMDISK_SIZE        :=  15360

#---------------------------------------------------
# Globle functions define
#---------------------------------------------------

#NO_PRINTER				:=	1
#_FLASH_32M_SUPPORT_		:=	1
#_RAM_128M_SUPPORT_		:=	1

_QUOTA_         		:=	1
_FTP_           		:=	1
_SSL_SUPPORT_			:=	1
_NTP_SUPPORT_			:=	1
_FLASH_16M_SUPPORT_		:=	0
_RAM_64M_SUPPORT_		:=	0
_DOWN_MANAGER_			:=	1
_WEB_STATION_SUPPORT_	:=	0
_ONE_USB_PORT_			:=	0
_PHOTO_ALBUM_SUPPORT_	:=  0
_AFP_SUPPORT_			:=  0
_USB_LED_GPIO4_			:=	0
_DDNS_SUPPORT_			:=	0
_RECYCLE_BIN_SUPPORT_	:=	0
_USB_COPY_SUPPORT_		:=	0
_SSH_SERVER_SUPPORT_	:=	0
_MULTI_LANG_SUPPORT_ 	:=	1

ifeq ($(MODULE_NAME), NR65S)
	_TWO_BAY_HDD_   		:=	1
	_RAM_64M_SUPPORT_		:=	1
	_FLASH_16M_SUPPORT_		:=	1
	_RECYCLE_BIN_SUPPORT_	:=	1
	
	ifeq ($(VENDOR_NAME), LEVEL_ONE)
		_PHOTO_ALBUM_SUPPORT_	:=	1
		_DDNS_SUPPORT_			:=	1
		_USB_COPY_SUPPORT_		:=	1
		_AFP_SUPPORT_			:=	1
	endif
	
else
	_TWO_BAY_HDD_   		:=	0
	_USB_LED_GPIO4_			:=	1
	_RECYCLE_BIN_SUPPORT_		:=	1
endif

_FTP_BACKUP_SUPPORT_	:=	0

#---------------------------------------------------
# Printer interface
#---------------------------------------------------
USB_PRINTER				:=          1
#PARALLEL_PRINTER		:=          1

#---------------------------------------------------
# File System
#---------------------------------------------------
USE_EXT2				:=          0


