.\"
.\" "$Id: lpadmin.man,v 1.1.1.1 2007-05-25 09:36:02 jick_nan Exp $"
.\"
.\"   lpadmin man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2002 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH lpadmin 8 "Common UNIX Printing System" "23 January 2001" "Easy Software Products"
.SH NOM
lpadmin \- Configure les imprimantes et classes d'imprimantes de CUPS
.SH SYNOPSIS
.B lpadmin
[ -E ] [ -h
.I serveur
] \-d
.I destination
.br
.B lpadmin
[ -E ] [ -h
.I serveur
] \-p
.I imprimante
.I option(s)
.br
.B lpadmin
[ -E ] [ -h
.I serveur
] \-x
.I destination
.SH DESCRIPTION
\fIlpadmin\fR configure les imprimantes et classes d'imprimantes de CUPS.
Il est galement utilis pour dfinir l'imprimante ou classe d'imprimante
par dfaut.
.LP
Lorsque l'option \fI-E\fR est spcifie avant les options \fI-d\fR, \fI-p\fR,
ou \fI-x\fR, la communication avec le serveur est crypte.
.LP
La premire mthode d'utilisation de la commande dfinit l'imprimante ou la classe
par dfaut. Les impressions futures demandes par les
commandes \fIlp(1)\fR ou \fIlpr(1)\fR utiliseront cette destination sauf avis
contraire de l'utilisateur.
.LP
La seconde mthode configure une imprimante. Les options disponibles
sont dcrites plus loin.
.LP
La troisime mthode supprime l'imprimante ou classe
\fIdestination\fR. Tous les travaux d'impression en attente sont supprims,
et les travaux en cours d'impression sont arrts.
.SH OPTIONS DE CONFIGURATION
Les options suivantes sont reconnues par la commande \fIlpadmin\fR\ :
.TP 5
\-c \fIclasse\fR
.br
Ajoute l'imprimante \fIimprimante\fR  la classe \fIclasse\fR. Si la classe
n'existe pas encore, elle est cre automatiquement.
.TP 5
\-i \fIinterface\fR
.br
Cre un script d'interface System V pour l'imprimante. Cette option ne
peut tre utilise en mme temps que \fI\-P\fR (fichier PPD) et est destine
au support des imprimantes de base.
.TP 5
\-m \fImodle\fR
.br
Dfinit un script d'interface System V ou un fichier PPD  utiliser.
.TP 5
\-o \fIname=value\fR
.br
Dfinit une option PPD ou serveur pour une imprimante. La liste des options
PPD peut tre obtenu en utilisant la commande \fIlptions -l\fR.
.TP 5
\-o \fIjob-k-limit=valeur\fR
.br
Dfinit les quotas par utilisateur en kilo-octets. La valeur est un nombre
entier de kilo-octets (valant 1024 octets).
.TP 5
\-o \fIjob-page-limit=valeur\fR
.br
Dfinit les quotas par utilisateur en nombre de pages. La valeur est un nombre
entier de pages pouvant tre imprimes. Les recto-verso comptent pour deux
pages.
.TP 5
\-o \fIjob-quota-period=valeur\fR
.br
Dfinit les quotas par utilisateur en impressions par intervalle de temps. La
valeur est un nombre entier dfinissant le nombre de secondes entre chaque
impression. Une journe contient 86400 secondes.
.TP 5
\-r \fIclasse\fR
.br
Supprime \fIl'imprimante\fR de la \fIclasse\fR. Si la classe d'imprimante devient
vide, celle-ci est supprime.
.TP 5
\-u \fIallow:user,user\fR
\-u \fIdeny:user,user\fR
\-u \fIallow:all\fR
\-u \fIdeny:none\fR
.br
Dfinit les accs par utilisateur sur une imprimante. Les deux dernires expressions
suppriment les contrles d'accs par utilisateur.
.TP 5
\-v \fIdevice-uri\fR
.br
Dfinit l'attribut \fIdevice-uri\fR de la file d'attente de l'imprimante. Si \fIdevice-uri\fR
est un nom de fichier, il est converti automatiquement en la forme \fBfile:/fichier/nom\fR.
.TP 5
\-D \fIinfo\fR
.br
Dfinit une description de l'imprimante.
.TP 5
\-E
.br
Active l'imprimante et lui fait accepter les travaux d'impression. Ceci peut
galement tre effectu en lanant les commandes \fIaccept(8)\fR et \fIenable(8)\fR
sur l'imprimante.
.TP 5
\-L \fIlieufR
.br
Dfinit le lieu de l'imprimante.
.TP 5
\-P \fIfichier-ppd\fR
.br
Dfinit le fichier PPD (Postscript Printer Description)  utiliser avec cette
imprimante. Si cette option est spcifie, elle annule l'option \fI-i\fR
(script d'interface).
.SH COMPATIBILIT
Contrairement au systme d'impression System V, CUPS permet des noms d'imprimantes
contenant tout caractre imprimable sauf ESPACE et TABULATION. De plus, les noms
d'imprimante et de classe ne sont pas sensibles  la casse. De plus, la version
CUPS peut demander un mot de passe, suivant la configuration du systme,  la
diffrence de la version System V qui demande le mot de passe root.
.SH LIMITATIONS
La version CUPS de \fIlpadmin\fR ne reconnat pas toutes les options de configuration
disponibles dans les versions System V ou Solaris.
.SH VOIR AUSSI
accept(8), cancel(1), disable(8), enable(8), lp(1), lpstat(1), reject(8),
CUPS Software Administrators Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2002 Easy Software Products, Tous droits rservs.
.SH TRADUCTION
Gilles QUERRET <gilles.querret@nerim.net>
.\"
.\" End of "$Id: lpadmin.man,v 1.1.1.1 2007-05-25 09:36:02 jick_nan Exp $".
.\"

